<div class="wrap">
    <h1 class="wp-heading-inline"><?php echo esc_html(__('Salesloo', 'salesloo')); ?></h1>

    <hr class="wp-header-end">

    <form>
        <input type="hidden" name="page" value="salesloo" />
        <div class="salesloo-filter">
            <div class="box">
                <?php
                \salesloo_field_daterangepicker([
                    'label'        => '',
                    'name'         => 'date',
                    'direction'    => 'column',
                    'class'        => 'large-text',
                    'date_options' => [
                        'maxDate' => date('Y/m/d'),
                    ],
                    'value' => ''
                ]);
                ?>
            </div>

            <div class="box">
                <?php
                $options = [
                    'all' => 'Al Product'
                ];

                foreach ($products as $product) {
                    $options[$product->ID] = $product->title;
                }

                \salesloo_field_select([
                    'label'    => '',
                    'name'     => 'product',
                    'required' => true,
                    'options'  => $options,
                    'value'     => isset($_GET['product']) ? intval($_GET['product']) : 'all',
                    'direction' => 'column',
                    'style' => 'width: 100%'
                ]);
                ?>
            </div>

            <div class="box">
                <input type="submit" class="button large-text" value="Filter" style="margin-bottom: 40px;">
            </div>
        </div>
    </form>

    <div class="salesloo-cards">
        <div class="card">
            <label><?php _e('Total All Leads', 'salesloo'); ?></label>
            <div><?php echo $order->leads; ?></div>
        </div>

        <div class="card">
            <label><?php _e('Total All Sales', 'salesloo'); ?></label>
            <div><?php echo $order->sales; ?></div>
        </div>

        <div class="card">
            <label><?php _e('Total All Refunded', 'salesloo'); ?></label>
            <div><?php echo $order->refund; ?></div>
        </div>

        <div class="card">
            <label><?php _e('Total All Cancelled', 'salesloo'); ?></label>
            <div><?php echo $order->cancel; ?></div>
        </div>
    </div>

    <div class="salesloo-cards">
        <div class="card">
            <label><?php _e('Total Income', 'salesloo'); ?></label>
            <div><?php echo salesloo_convert_money($order->order_total); ?></div>
        </div>

        <div class="card">
            <label><?php _e('Total Net Income', 'salesloo'); ?></label>
            <div><?php echo salesloo_convert_money($net_income); ?></div>
        </div>

        <div class="card">
            <label><?php _e('Total Refunded', 'salesloo'); ?></label>
            <div><?php echo salesloo_convert_money($order->order_refund); ?></div>
        </div>
    </div>

    <div class="salesloo-cards">
        <div class="card">
            <label><?php _e('Total All Commissions', 'salesloo'); ?></label>
            <div><?php echo salesloo_convert_money($commissions->total); ?></div>
        </div>

        <div class="card">
            <label><?php _e('Total Pending Commissions', 'salesloo'); ?></label>
            <div><?php echo salesloo_convert_money($commissions->pending); ?></div>
        </div>

        <div class="card">
            <label><?php _e('Total Paid Commissions', 'salesloo'); ?></label>
            <div><?php echo salesloo_convert_money($commissions->paid); ?></div>
        </div>

        <div class="card">
            <label><?php _e('Total Unpaid Commissions', 'salesloo'); ?></label>
            <div><?php echo salesloo_convert_money($commissions->unpaid); ?></div>
        </div>
    </div>
</div>