<div class="wrap">
    <h1 class="wp-heading-inline"><?php echo esc_html(__('Commissions', 'salesloo')); ?></h1>
    <a href="#TB_inline?height=800&amp;width=600&amp;inlineId=examplePopup1" title="Pay Commission" class="thickbox page-title-action"><?php _e('Pay Commission', 'salesloo'); ?></a>

    <hr class="wp-header-end">
    <table class="form-table" role="presentation">
        <tbody>
            <tr class="user-user-login-wrap">
                <th><label><?php _e('Username', 'salesloo'); ?></label></th>
                <td><?php echo salesloo_data('affiliate')->user_login; ?></td>
            </tr>

            <tr class="user-first-name-wrap">
                <th><label><?php _e('Fisrt Name', 'salesloo'); ?></label></th>
                <td><?php echo salesloo_data('affiliate')->first_name; ?></td>
            </tr>

            <tr class="user-last-name-wrap">
                <th><label><?php _e('Last Name', 'salesloo'); ?></label></th>
                <td><?php echo salesloo_data('affiliate')->last_name; ?></td>
            </tr>

            <tr class="user-nickname-wrap">
                <th><label><?php _e('Email', 'salesloo'); ?></label></th>
                <td><?php echo salesloo_data('affiliate')->user_email; ?></td>
            </tr>
        </tbody>
    </table>

    <form>
        <input type="hidden" name="page" value="salesloo-commission" />
        <div class="salesloo-filter">
            <div class="box">
                <?php
                \salesloo_field_daterangepicker([
                    'label'        => '',
                    'name'         => 'date',
                    'direction'    => 'column',
                    'class'        => 'large-text',
                    'date_options' => [
                        'maxDate' => date('Y/m/d'),
                    ],
                    'value' => ''
                ]);
                ?>
            </div>

            <div class="box">
                <?php
                $options = [
                    'all' => 'Al Product'
                ];

                foreach ($list_table->get_products() as $product) {
                    $options[$product->slug] = $product->title;
                }

                \salesloo_field_select([
                    'label'    => '',
                    'name'     => 'product',
                    'required' => true,
                    'options'  => $options,
                    'value'     => '',
                    'direction' => 'column',
                    'style' => 'width: 100%'
                ]);
                ?>
            </div>

            <div class="box">
                <input type="submit" class="button large-text" value="Filter" style="margin-bottom: 40px;">
            </div>
        </div>
    </form>

    <div class="salesloo-cards">
        <div class="card">
            <label><?php _e('Total All Commissions', 'salesloo'); ?></label>
            <div><?php echo salesloo_convert_money($list_table->get_total_commissions()->total); ?></div>
        </div>

        <div class="card">
            <label><?php _e('Total Pending Commissions', 'salesloo'); ?></label>
            <div><?php echo salesloo_convert_money($list_table->get_total_commissions()->pending); ?></div>
        </div>

        <div class="card">
            <label><?php _e('Total Paid Commissions', 'salesloo'); ?></label>
            <div><?php echo salesloo_convert_money($list_table->get_total_commissions()->paid); ?></div>
        </div>

        <div class="card">
            <label><?php _e('Total Unpaid Commissions', 'salesloo'); ?></label>
            <div><?php echo salesloo_convert_money($list_table->get_total_commissions()->unpaid); ?></div>
        </div>
    </div>

    <form method="get" action="">
        <?php $list_table->views(); ?>
        <?php $list_table->display();
        ?>
    </form>
</div>