import ApexCharts from 'apexcharts'
export default function(Alpine) {

    Alpine.directive('apexchart', (el, { modifiers, expression }, { evaluateLater, effect }) => {

        let getSource = evaluateLater(expression)
        let options = {
            series: [],
            noData: {
                text: 'Loading',
            },
            chart: {
                type: 'area',
                stacked: false,
                height: 350,
                zoom: {
                    enabled: false
                },
                animations: {
                    enabled: true,
                    easing: 'easeinout',
                    speed: 800,
                    animateGradually: {
                        enabled: true,
                        delay: 150
                    },
                    dynamicAnimation: {
                        enabled: true,
                        speed: 350
                    }
                }
            },
            dataLabels: {
                enabled: false
            },
            stroke: {
                width: [1, 1, 1],
                curve: 'smooth'
            },
            markers: {
                size: 5,
            },
            legend: {
                position: 'top',
                horizontalAlign: 'center',
                offsetX: 10
            }
        };
        const chart = new ApexCharts(el, options);
        chart.render();

        effect(() => {
            chart.updateOptions(options);
            getSource(option => {
                let newOptions = {...options, ...option }
                chart.updateOptions(newOptions);
            })
        })
    });

    Alpine.magic('post', () => {
        return function(url, body) {
            return fetch(url, {
                    method: 'post',
                    body: JSON.stringify(body),
                    headers: {
                        'Content-Type': 'application/json'
                    },
                })
                .then(response => {
                    if (response.status >= 200 && response.status <= 299) {
                        return response.json();
                    } else {
                        return response.json().then(error => {
                            throw error;
                        });
                    }
                })
                .then(response => {
                    return response
                })
        };
    });

    Alpine.magic('get', () => {
        return (url) => {
            return fetch(url)
                .then(response => {
                    if (response.status >= 200 && response.status <= 299) {
                        return response.json();
                    } else {
                        return response.json().then(error => {
                            throw error;
                        });
                    }
                })
                .then(response => {
                    return response
                })
        };
    });

    Alpine.magic('copy', (el, { Alpine }) => subject => {
        if (navigator.clipboard && window.isSecureContext) {
            navigator.clipboard.writeText(subject);
        } else {
            let textArea = document.createElement("textarea");
            textArea.value = subject;
            textArea.style.position = "fixed";
            textArea.style.left = "-999999px";
            textArea.style.top = "-999999px";
            document.body.appendChild(textArea);
            textArea.focus();
            textArea.select();
            document.execCommand('copy');
            textArea.remove();
        }
    });
}