(function(global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
        typeof define === 'function' && define.amd ? define(factory) :
        (global = typeof globalThis !== 'undefined' ? globalThis : global || self, (global.AlpineSaleslooMagicHelpers = global.AlpineSaleslooMagicHelpers || {}, global.AlpineSaleslooMagicHelpers.index = factory()));
}(this, (function() {
    'use strict';

    var checkForAlpine = function checkForAlpine() {
        if (!window.Alpine) {
            throw new Error('[Salesloo Magic Helpers] Alpine is required for the salesloo magic helpers to function correctly.');
        }
    };

    var AlpineSaleslooState = {
        store(name, state) {
            if (!this.stores[name]) {
                this.stores[name] = state
            }
            return this.stores[name];
        },
        stores: {},
        subscribers: [],
        start: function start() {
            checkForAlpine();

            const self = this;

            this.stores = new Proxy(this.stores, {
                get: (target, key, receiver) => {
                    if (Object.is(receiver, this.stores) && ['get', 'set', 'toggle', 'call', 'clear'].includes(key)) {
                        return this[key].bind(this)
                    }

                    return Reflect.get(target, key, receiver)
                },
                set: (target, key, value, receiver) => {

                    target[key] = value;

                    self.subscribers.filter(el => !!el.__x).forEach(el => {
                        el.__x.updateElements(el);
                    });

                    return true;
                }
            });

            Alpine.addMagicProperty('state', el => {

                if (!self.subscribers.includes(el)) {
                    self.subscribers.push(el)
                }

                return self.stores;
            });
        }
    };

    var alpine$0 = window.deferLoadingAlpine || function(callback) {
        return callback();
    };

    window.deferLoadingAlpine = function(callback) {
        AlpineSaleslooState.start();
        alpine$0(callback);
    };

    AlpineSaleslooState.store('modal', false);


    /**
     * this magic method modified from https://github.com/ryangjchandler/alpine-clipboard
     */

    var AlpineSaleslooClipboard = {
        start: function start() {
            checkForAlpine();
            Alpine.addMagicProperty('copy', function() {
                return function(target) {
                    var value = target;

                    if (typeof value === 'function') {
                        value = value();
                    } else if (typeof value !== 'string') {
                        try {
                            value = JSON.stringify(value);
                        } catch (e) {
                            console.warn(e);
                        }
                    }

                    var container = document.createElement('textarea');
                    container.value = value;
                    container.setAttribute('readonly', '');
                    container.style.cssText = 'position:fixed;pointer-events:none;z-index:-9999;opacity:0;';
                    document.body.appendChild(container);

                    if (navigator.userAgent && navigator.userAgent.match(/ipad|ipod|iphone/i)) {
                        container.contentEditable = true;
                        container.readOnly = true;
                        var range = document.createRange();
                        range.selectNodeContents(container);
                        var selection = window.getSelection();
                        selection.removeAllRanges();
                        selection.addRange(range);
                        container.setSelectionRange(0, 999999);
                    } else {
                        container.select();
                    }

                    try {
                        document.execCommand('copy');
                        let message = '<span class="font-light italic inline">"' + value + '"</span> <span class="inline ml-2">has copied</span>';
                        this.$alert.success = message;
                    } catch (e) {
                        console.warn(err);
                        this.$alert.warning = 'Failed to copy';
                    }

                    document.body.removeChild(container);
                };
            });
        }
    };

    var alpine$1 = window.deferLoadingAlpine || function(callback) {
        return callback();
    };

    window.deferLoadingAlpine = function(callback) {
        AlpineSaleslooClipboard.start();
        alpine$1(callback);
    };

    var AlpineSaleslooFetch = {
        start: function start() {
            checkForAlpine();
            Alpine.addMagicProperty('fetch', function() {
                return function(options) {
                    return fetch(options.url, {
                            method: options.method ? options.method : 'get',
                            body: JSON.stringify(options.data),
                            headers: {
                                'Content-Type': 'application/json'
                            },
                        })
                        .then(response => {
                            if (response.status >= 200 && response.status <= 299) {
                                return response.json();
                            } else {
                                return response.json().then(error => {
                                    throw error;
                                });
                            }
                        })
                        .then(response => {
                            if ('message' in response) {
                                this.$alert.success = response.message;
                            }
                            return response
                        })
                        .catch((error) => {
                            if ('message' in error) {
                                this.$alert.warning = error.message;
                            }
                            throw error;
                        });
                };
            });
        }
    };

    var alpine$2 = window.deferLoadingAlpine || function(callback) {
        return callback();
    };

    window.deferLoadingAlpine = function(callback) {
        AlpineSaleslooFetch.start();
        alpine$2(callback);
    };

    var AlpineSaleslooAlert = {
        stores: {},
        subscribers: [],
        start: function start() {
            checkForAlpine();

            const self = this;
            this.stores = new Proxy(this.stores, {
                get: (target, key) => {
                    return target[key];
                },
                set: (target, key, value) => {

                    target[key] = value;

                    self.subscribers.filter(el => !!el.__x).forEach(el => {
                        el.__x.updateElements(el);
                    });

                    setTimeout(function() {
                        target[key] = '';
                        self.target = target;

                        self.subscribers.filter(el => !!el.__x).forEach(el => {
                            el.__x.updateElements(el);
                        });
                    }, 5000);

                    return true;
                }
            });

            Alpine.addMagicProperty('alert', el => {

                if (!self.subscribers.includes(el)) {
                    self.subscribers.push(el)
                }

                return self.stores;
            });
        }
    };

    var alpine$3 = window.deferLoadingAlpine || function(callback) {
        return callback();
    };

    window.deferLoadingAlpine = function(callback) {
        AlpineSaleslooAlert.start();
        alpine$3(callback);
    };

    var AlpineSaleslooConfirm = {

        start: function start() {
            checkForAlpine();

            Alpine.addMagicProperty('confirm', () => {

                return function(message, callback) {

                    let template = document.getElementById('template-confirm').content.cloneNode(true);

                    template.querySelector('p').innerHTML = message;

                    document.body.appendChild(template);

                    let confirm = document.getElementById('confirm');
                    confirm.querySelector('#confirm-no').onclick = () => {
                        document.body.removeChild(confirm);
                        return;
                    }

                    confirm.querySelector('#confirm-yes').onclick = () => {
                        callback();
                        document.body.removeChild(confirm);
                        return;
                    }
                }
            });
        }
    };

    var alpine$4 = window.deferLoadingAlpine || function(callback) {
        return callback();
    };

    window.deferLoadingAlpine = function(callback) {
        AlpineSaleslooConfirm.start();
        alpine$4(callback);
    };

    var AlpineSaleslooChartLine = {
        data: {},

        start: function start() {
            checkForAlpine();

            Alpine.addMagicProperty('chartline', () => {

                return function(id, label, datasets) {

                    try {

                        if (!window.Chart) {
                            throw new Error('[Salesloo Magic Helpers] Chart js is required for the salesloo magic helpers chartline to function correctly.');
                        }

                        new Chart(id, {
                            type: "line",
                            data: {
                                labels: label,
                                datasets: datasets,
                            },
                            layout: {
                                padding: {
                                    right: 10
                                }
                            },
                            options: {
                                legend: {
                                    display: true,
                                    labels: {
                                        fontColor: '#ffffff'
                                    }
                                },
                                scales: {
                                    yAxes: [{
                                        ticks: {
                                            fontColor: "rgba(255, 255, 255, 1)",
                                        },
                                        gridLines: {
                                            display: false,
                                        },
                                    }],
                                    xAxes: [{
                                        ticks: {
                                            fontColor: "rgba(255, 255, 255, 1)",
                                        },
                                        gridLines: {
                                            color: "rgba(255, 255, 255, .2)",
                                            borderDash: [5, 5],
                                            zeroLineColor: "rgba(255, 255, 255, .2)",
                                            zeroLineBorderDash: [5, 5]
                                        },
                                    }]
                                }
                            }
                        });
                    } catch (error) {
                        console.warn(error);
                    }

                }
            });
        }
    };

    var alpine$5 = window.deferLoadingAlpine || function(callback) {
        return callback();
    };

    window.deferLoadingAlpine = function(callback) {
        AlpineSaleslooChartLine.start();
        alpine$5(callback);
    };

    var AlpineSaleslooDatePicker = {
        data: {},

        start: function start() {
            checkForAlpine();

            Alpine.addMagicProperty('date', () => {
                return function(element, options) {

                    try {
                        if (!window.flatpickr) {
                            throw new Error('[Salesloo Magic Helpers] flatpickr js is required for the salesloo magic helpers date picker to function correctly.');
                        }
                        flatpickr(element, options);
                    } catch (error) {
                        console.warn(error);
                    }
                }
            });
        }
    };

    var alpine$6 = window.deferLoadingAlpine || function(callback) {
        return callback();
    };

    window.deferLoadingAlpine = function(callback) {
        AlpineSaleslooDatePicker.start();
        alpine$6(callback);
    };

    var AlpineSaleslooChartDoughnut = {
        data: {},

        start: function start() {
            checkForAlpine();

            Alpine.addMagicProperty('chartdoughnut', () => {

                return function(id, label, datasets) {

                    try {

                        if (!window.Chart) {
                            throw new Error('[Salesloo Magic Helpers] Chart js is required for the salesloo magic helpers chartpie to function correctly.');
                        }

                        new Chart(id, {
                            type: "doughnut",
                            data: {
                                labels: label,
                                datasets: datasets,
                            },
                            options: {
                                legend: {
                                    display: true,
                                    position: 'bottom',
                                    labels: {
                                        boxWidth: 20,
                                        textAlign: 'left'
                                    }
                                },
                            }
                        });
                    } catch (error) {
                        console.warn(error);
                    }

                }
            });
        }
    };

    var alpine$7 = window.deferLoadingAlpine || function(callback) {
        return callback();
    };

    window.deferLoadingAlpine = function(callback) {
        AlpineSaleslooChartDoughnut.start();
        alpine$7(callback);
    };

    var AlpineSaleslooModal = {

        start: function start() {
            checkForAlpine();

            Alpine.addMagicProperty('modal', () => {

                return function(title, content) {
                    this.$state.modal = {
                        title: title,
                        content: content,
                        show: true
                    }
                }
            });
        }
    };

    var alpine$8 = window.deferLoadingAlpine || function(callback) {
        return callback();
    };

    window.deferLoadingAlpine = function(callback) {
        AlpineSaleslooModal.start();
        alpine$8(callback);
    };

    var AlpineSaleslooGet = {
        start: function start() {
            checkForAlpine();
            Alpine.addMagicProperty('get', function() {
                return function(url) {
                    return fetch(url)
                        .then(response => {
                            if (response.status >= 200 && response.status <= 299) {
                                return response.text();
                            } else {
                                return response.json().then(error => {
                                    throw error;
                                });
                            }
                        })
                        .then(response => {
                            return response
                        })
                        .catch((error) => {
                            if ('message' in error) {
                                this.$alert.warning = error.message;
                            }
                            throw error;
                        });
                };
            });
        }
    };

    var alpine$9 = window.deferLoadingAlpine || function(callback) {
        return callback();
    };

    window.deferLoadingAlpine = function(callback) {
        AlpineSaleslooGet.start();
        alpine$9(callback);
    };


    var index = {
        AlpineSaleslooState: AlpineSaleslooState,
        AlpineSaleslooClipboard: AlpineSaleslooClipboard,
        AlpineSaleslooFetch: AlpineSaleslooFetch,
        AlpineSaleslooAlert: AlpineSaleslooAlert,
        AlpineSaleslooConfirm: AlpineSaleslooConfirm,
        AlpineSaleslooChartLine: AlpineSaleslooChartLine,
        AlpineSaleslooDatePicker: AlpineSaleslooDatePicker,
        AlpineSaleslooChartDoughnut: AlpineSaleslooChartDoughnut,
        AlpineSaleslooModal: AlpineSaleslooModal,
        AlpineSaleslooGet: AlpineSaleslooGet,
    }

    return index;

})));