<?php
$attributes = '';
if ($args['id']) {
    $attributes .= ' id="' . $args['id'] . '" ';
}

if ($args['multiple']) {
    $attributes .= ' multiple="multiple"';
}

if ($args['name']) {
    $multiple = $args['multiple'] ? '[]' : '';
    $attributes .= ' name="' . $args['name'] . $multiple . '" ';
}

if ($args['class']) {
    $attributes .= ' class="regular-text ' . $args['class'] . '" ';
} else {
    $attributes .= ' class="regular-text" ';
}

if ($args['style']) {
    $attributes .= ' style="' . $args['style'] . '" ';
}
if ($args['required']) {
    $attributes .= ' required';
}


if ($args['select2_options']) {
    $attributes .= ' data-options=\'' . json_encode($args['select2_options']) . '\'';
}

$conditional = salesloo_field_get_conditional_data($args);

$value = (array)$args['value'];

?>
<div class="salesloo-field <?php echo $args['direction']; ?>" <?php echo implode(' ', $conditional); ?>>
    <div class="salesloo-field-label" style="width: 100%">
        <label><?php echo $args['label']; ?></label>
    </div>
    <div class="salesloo-field-input">
        <div class="salesloo-field__select2">
            <?php echo $args['before']; ?>
            <select <?php echo $attributes; ?>>
                <?php
                if (count($args['options']) > 0) {
                    foreach ((array)$args['options'] as $val => $label) {
                        $checked = '';
                        if (in_array($val, $value)) {
                            $checked = ' selected="selected"';
                        }
                        if ($val) {
                            echo '<option value="' . $val . '"' . $checked . '>' . $label . '</option>';
                        }
                    }
                }
                ?>
            </select>
            <?php echo $args['after']; ?>
        </div>
        <p class="description"><?php echo $args['description']; ?></p>
    </div>
</div>