<?php

$SelectedUser = unserialize( $emails->sendmail_to );
$SelectedUser = srp_check_is_array( $SelectedUser ) ? $SelectedUser : array();
$Sendmailto   = ( '1' == $emails->sendmail_options ) ? true : in_array( $user_id, $SelectedUser );
if ( ! $Sendmailto ) {
	return;
}

global $unsublink2;
if ( 'yes' == get_user_meta( $user_id, 'unsub_value', true ) ) {
	return;
}

$WMPLLang   = empty( get_user_meta( $user_id, 'rs_wpml_lang', true ) ) ? 'en' : get_user_meta( $user_id, 'rs_wpml_lang', true );
$UserInfo   = get_userdata( $user_id );
$subject    = RSWPMLSupport::fp_wpml_text( 'rs_template_' . $emails->id . '_subject', $WMPLLang, $emails->subject );
$SiteURl    = '<a href=' . site_url() . '>' . site_url() . '</a>';
$PointsData = new RS_Points_Data( $user_id );
$Points     = $PointsData->get_available_points();
if ( empty( $Points ) ) {
	return;
}

$minimumuserpoints = empty( $emails->minimum_userpoints ) ? 0 : $emails->minimum_userpoints;
if ( $Points < $minimumuserpoints ) {
	return;
}

if ( '1' == $emails->rsmailsendingoptions ) {
	$PointsInOrder    = earned_points_from_order( $order_id );
	$PointsInTemplate = ( empty( $emails->earningpoints ) ? 0 : $emails->earningpoints );
	if ( $PointsInOrder < $PointsInTemplate ) {
		return;
	}
} else if ( '2' == $emails->rsmailsendingoptions ) {
	$PointsInOrder    = redeem_points_from_order( $order_id );
	$PointsInTemplate = ( empty( $emails->redeemingpoints ) ? 0 : $emails->redeemingpoints );
	if ( $PointsInOrder < $PointsInTemplate ) {
		return;
	}
} else if ( '4' == $emails->rsmailsendingoptions ) {
	$earned_points_in_order    = get_points_for_pp_from_order_meta( $order_id );
	$redeemed_points_in_order  = redeem_points_from_order( $order_id );
	if ( ! empty( $earned_points_in_order ) && ( 'redeeming' == $email_type )) {
		return;
	} else if ( empty( $earned_points_in_order ) && ( 'earning' == $email_type ) ) {
		return;
	}
}

$referral_url      = '' != get_option( 'rs_referral_link_site_referral_url' ) ? get_option( 'rs_referral_link_site_referral_url' ) : site_url();
$site_referral_url = 'yes' == get_option( 'rs_restrict_referral_points_for_same_ip' ) ? esc_url_raw(
	add_query_arg(
		array(
			'ref' => $UserInfo->user_login,
			'ip'  => base64_encode( get_referrer_ip_address() ),
		),
		$referral_url
	)
) : esc_url_raw( add_query_arg( array( 'ref' => $UserInfo->user_login ), $referral_url ) );
$site_referral_url = 'yes' == get_option( 'rs_referral_activated' ) ? '<a href=' . $site_referral_url . '>' . $site_referral_url . '</a>' : '';
$CurrencyValue     = currency_value_for_available_points( $user_id );
$wpnonce           = wp_create_nonce( 'rs_unsubscribe_' . $user_id );
$unsublink         = esc_url_raw(
	add_query_arg(
		array(
			'userid' => $user_id,
			'unsub'  => 'yes',
			'nonce'  => $wpnonce,
		),
		site_url()
	)
);
$unsublink         = '<a href=' . $unsublink . '>' . $unsublink . '</a>';
$message           = RSWPMLSupport::fp_wpml_text( 'rs_template_' . $emails->id . '_message', $WMPLLang, $emails->message );
$message           = str_replace( '{rssitelink}', $SiteURl, $message );
$message           = str_replace( '{rsfirstname}', $UserInfo->user_firstname, $message );
$message           = str_replace( '{rslastname}', $UserInfo->user_lastname, $message );
$message           = str_replace( '{rspoints}', $Points, $message );
$message           = str_replace( '{site_referral_url}', $site_referral_url, $message );
$message           = str_replace( '{rs_points_in_currency}', $CurrencyValue, $message );
if ( '1' == $emails->rsmailsendingoptions ) {
	$message = str_replace( array( '{rs_earned_points}', '{order_id}' ), array( $PointsInOrder, $order_id ), $message ) ;
	$subject = str_replace( array( '{rs_earned_points}', '{order_id}' ), array( $PointsInOrder, $order_id ), $subject ) ;   
} else if ('2' == $emails->rsmailsendingoptions) {
	$message = str_replace( array( '{rs_redeemed_points}', '{order_id}' ), array( $PointsInOrder, $order_id ), $message );
	$subject = str_replace( array( '{rs_redeemed_points}', '{order_id}' ), array( $PointsInOrder, $order_id ), $subject );
} else if ('4' == $emails->rsmailsendingoptions) {
	$earned_points    = earned_points_from_order( $order_id );
	$redeemed_points    = redeem_points_from_order( $order_id );
	$message = str_replace( array( '{rs_earned_points}', '{order_id}' ), array( $earned_points, $order_id ), $message ) ;
	$message = str_replace( array( '{rs_redeemed_points}', '{order_id}' ), array( $redeemed_points, $order_id ), $message );
	$subject = str_replace( array( '{rs_earned_points}', '{order_id}' ), array( $earned_points, $order_id ), $subject ) ;
	$subject = str_replace( array( '{rs_redeemed_points}', '{order_id}' ), array( $redeemed_points, $order_id ), $subject );
}
$levelname         = earn_level_name( $user_id );
$message           = str_replace( '[rs_my_current_earning_level_name]', $levelname, $message );
$nextlevelname     = points_to_reach_next_earn_level( $user_id );
$message           = str_replace( '[rs_next_earning_level_points]', $nextlevelname, $message );
$message           = do_shortcode( $message ); // shortcode feature
$unsublink2        = str_replace( '{rssitelinkwithid}', $unsublink, get_option( 'rs_unsubscribe_link_for_email' ) );
add_filter( 'woocommerce_email_footer_text', 'srp_footer_link' );
ob_start();
wc_get_template( 'emails/email-header.php', array( 'email_heading' => $subject ) );
echo do_shortcode( $message );
wc_get_template( 'emails/email-footer.php' );
$woo_temp_msg = ob_get_clean();
$headers      = "MIME-Version: 1.0\r\n";
$headers     .= "Content-Type: text/html; charset=UTF-8\r\n";
if ( 'local' == $emails->sender_opt ) {
	FPRewardSystem::$rs_from_email_address = $emails->from_email;
	FPRewardSystem::$rs_from_name          = $emails->from_name;
}
add_filter( 'woocommerce_email_from_address', 'rs_alter_from_email_of_woocommerce', 10, 2 );
add_filter( 'woocommerce_email_from_name', 'rs_alter_from_name_of_woocommerce', 10, 2 );
if ( 1 == get_option( 'rs_select_mail_function' ) ) {
	if ( mail( $UserInfo->user_email, $subject, $woo_temp_msg, $headers ) ) {
		if ( '1' == $emails->mailsendingoptions ) {
			$order->update_meta_data( 'rsearningtemplates' . $emails->id, '1' );
		}
	}
} else {
	$mailer = WC()->mailer();
	$mailer->send( $UserInfo->user_email, $subject, $woo_temp_msg, $headers );
	if ( '1' == $emails->mailsendingoptions ) {
		$order->update_meta_data( 'rsearningtemplates' . $emails->id, '1' );
	}
}
$order->save();
remove_filter( 'woocommerce_email_from_address', 'rs_alter_from_email_of_woocommerce', 10, 2 );
remove_filter( 'woocommerce_email_from_name', 'rs_alter_from_name_of_woocommerce', 10, 2 );
FPRewardSystem::$rs_from_email_address = false;
FPRewardSystem::$rs_from_name          = false;
