<?php
if( ! defined( 'ABSPATH' ) ) {
	exit();
}
?>

<div id="reviews" class="rx_review_summery_block">

	<div class="rx-reviewbox">

		<div class=" rx-flex-grid-container">
            <div class="rx-flex-grid-50 rx_recommended_wrapper">
                <div class="rx-temp-rating ">
                    <div class="rx_average_rating">
                        <div class="rx-temp-rating-number">
                            <h1><?php echo esc_html( $rx_count_total_rating_avg ); ?></h1><h3>/<?php esc_html_e('5', 'reviewx');?></h3>
                        </div>
                        <div class="rx-temp-rating-star">
                            <?php echo reviewx_show_star_rating( $rx_count_total_rating_avg ); ?>
                        </div>
                    </div>
                    <div class="rx-temp-total-rating-count">
                        <p><?php echo sprintf("Based on %d rating(s)", $rx_total_rating_count ); ?></p>
                    </div>
                </div>

                <?php if( $allow_recommendation == 1 ) { ?>
                    <hr>
                    <div class="rx_recommended_box">
                        <div class="rx_recommended_icon_box">
                            <div class="rx_recommended_icon">
                                <img src="<?php echo esc_url( plugins_url( '/', __FILE__ ) . '../../../resources/assets/storefront/images/recommendation_icon.png' ); ?>">
                            </div>
                        </div>
                        <div class="rx_recommended_box-right">
                            <p class="rx_recommended_box_content"><span class="rx_recommended_box_heading"><?php echo reviewx_product_recommendation_count( get_the_ID() ); ?></span><?php esc_html_e( 'Customer(s) recommended this item', 'reviewx' ); ?></p>
                        </div>
                    </div>
                <?php } ?>
            </div>

			<!-- Start review chart 55 -->
			<div class="rx-flex-grid-50 stfn_rate rx_rating_graph_wrapper">
				<div class="rx-horizontal flat rx-graph-style-2">
                    <?php
						foreach ( $cri as $key => $single_criteria ) {
                            //if (array_key_exists($key, $criteria_arr)) {
                                $percentage = intval( round( ($criteria_arr[$key] / $criteria_count[$key])*100/5 ) );
							?>
							<div class="progress-bar">
								<span class="progress-bar-t"><?php echo esc_html( str_replace( '-', ' ', $single_criteria ) ); ?></span>
								<div class="progress-track">
									<div class="progress-fill"  style="<?php echo esc_attr( $review_criteria_bar_color[$inc] ); ?>">
										<?php if( $percentage > 0 ) : ?>
										<span><?php echo intval( round( ($criteria_arr[$key] / $criteria_count[$key])*100/5 ) ); ?>%</span>
										<?php  else: ?>
											<span>100%</span>
										<?php endif; ?>
									</div>
								</div>
							</div>
					<?php
                        //}
					}
				?>
				</div>
			</div>

		</div>

	</div>

</div>