<?php
/**
 * Display single product reviews (comments)
 *
 * @package WooCommerce 3.8.1
 * @version 1.0.0
 * @author WPDevelopers
 */

    if ( ! defined( 'ABSPATH' ) ) {
        exit;
    }

    global $product;
    $settings                   = \ReviewX\Controllers\Admin\Core\ReviewxMetaBox::get_metabox_settings();
    $review_per_page            = $settings->review_per_page;

    //prepare review title
    $rx_wc_Reviews_title        = '';
    $count                      = $product->get_review_count();
    if ( $count && wc_review_ratings_enabled() ) {
        $reviews_title          = sprintf( esc_html( _n( '%1$s review for %2$s', '%1$s reviews for %2$s', $count, 'reviewx' ) ), esc_html( $count ), '<span>' . get_the_title() . '</span>' );
        $rx_wc_Reviews_title    = apply_filters( 'woocommerce_reviews_title', $reviews_title, $count, $product );
    } else {
        $rx_wc_Reviews_title    = esc_html__( 'Reviews', 'reviewx' );
    }
?>
<div class="rx-flex-grid-container">
    <div class="rx-flex-grid-100">
        <h2 class="woocommerce-Reviews-title">
            <?php print $rx_wc_Reviews_title; ?>
        </h2>
    </div>
</div>
<?php
    /**
     * Include product rating summery template
     */
    if( have_comments() ) {
        //Load review graph, pie chart template
        echo apply_filters( 'rx_load_review_graph_template', 1 );
    }

    //Load review template
    echo apply_filters( 'rx_load_review_templates', 1 );
        
?>