<?php
if( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Admin notice if WooCommerce is missing
 * @return void
 */
function reviewx_woocommerce_missing_wc_notice() {
    $reviewx_notice = sprintf(
        __( 'ReviewX requires WooCommerce to be installed and active to working properly. %s', 'reviewx' ),
        '<a href="' . esc_url( admin_url( 'plugin-install.php?s=WooCommerce&tab=search&type=term' ) ) . '">' . __( 'Please click on this link and install WooCommerce', 'reviewx' ) . '</a>'
    );
    printf( '<div class="error notice notice-warning is-dismissible"><p style="padding: 5px 0">%s</p></div>', $reviewx_notice );
}

/**
 * Thing need to process once the reviewx plugin activation is done and loaded.
 * @return void
 */
add_action( 'admin_init', 'reviewx_get_started' );

function reviewx_get_started() {
    if ( is_admin() && current_user_can( 'activate_plugins' ) &&  ! is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
		add_action( 'admin_notices', 'reviewx_woocommerce_missing_wc_notice' );
	}
}

/**
 * Thing need to process once the reviewx plugin activation is done and loaded.
 * @return void
 */
add_filter( 'plugin_action_links_' . REVIEWX_BASENAME, 'reviewx_admin_settings_link', 10, 2 );

function reviewx_admin_settings_link( $links ) {

    if( class_exists('WooCommerce') ) { 
        $settings_url = add_query_arg( array('page'=> 'reviewx-settings'), admin_url( 'admin.php' ) );              
        $links[] = '<a href="'.esc_url($settings_url).'">'.esc_html__('Settings', 'reviewx' ).'</a>';
        $links[] = '<a href="'.esc_url('https://reviewx.io/docs').'">' . __( 'Docs', 'reviewx' ) . '</a>';
        if( !class_exists('ReviewXPro') ) {
            $links[] = '<a href="'.esc_url('https://reviewx.io/upgrade/reviewx-pro').'" style="color: #d30c5c;font-weight: bold;">' . __( 'Upgrade to Pro', 'reviewx' ) . '</a>';
        }
    }
    return $links;    
}

/**
 * Show review descending order
 * @return array
 */
add_filter( 'comments_array', 'reviewx_reverse_comments' );

function reviewx_reverse_comments( $comments ) {
    return array_reverse( $comments );
}

/**
 * Function for count recommended number
 * @param $post_id
 * @return array|object|null 
 *
 */
function reviewx_product_recommendation_count( $post_id ) {

    global $wpdb;
    $rx_comment 		        = $wpdb->prefix  . 'comments';
    $rx_commentmeta 		    = $wpdb->prefix  . 'commentmeta';
    $recommended_query = $wpdb->get_results( $wpdb->prepare(
        "SELECT $rx_commentmeta.meta_value FROM $rx_commentmeta
		INNER JOIN $rx_comment
		ON $rx_commentmeta.comment_id = $rx_comment.comment_ID
		WHERE $rx_commentmeta.meta_key = 'reviewx_recommended'
		AND $rx_commentmeta.meta_value = 1
		AND $rx_comment.comment_post_ID = %d
		AND $rx_comment.comment_approved = 1", $post_id ) );

    return count( $recommended_query );

}

/**
 * Return total recommendation value
 * @param $post_id
 * @return array|object|null
 */
function reviewx_product_recommendation_count_meta( $post_id ) {

    global $wpdb;
    $rx_comment 		        = $wpdb->prefix  . 'comments';
    $rx_commentmeta 		    = $wpdb->prefix  . 'commentmeta';
    $recommended_query = $wpdb->get_results( $wpdb->prepare(
        "SELECT $rx_commentmeta.meta_value FROM $rx_commentmeta
                    INNER JOIN $rx_comment
                    ON $rx_commentmeta.comment_id = $rx_comment.comment_ID
                    WHERE $rx_commentmeta.meta_key = 'reviewx_rating'
                    AND $rx_comment.comment_post_ID = %d
                    AND $rx_comment.comment_approved = 1", $post_id ) );

    return $recommended_query;

}

/**
 * Comment auto approve
 * @param $approved
 * @return int
 */
add_filter( 'pre_comment_approved', 'reviewx_filter_pre_comment_approved', 10, 2 );

function reviewx_filter_pre_comment_approved( $approved, $commentdata ) {
    return $approved;
}

/**
 * Show review star rating
 * @param $get_rating_meta
 * @return $total_point_star
 */
function reviewx_show_star_rating( $get_rating_meta ) {

    $settings         = \ReviewX\Controllers\Admin\Core\ReviewxMetaBox::get_metabox_settings();
    $total_rating_inc = intval($get_rating_meta);
    $total_point_star = '';

    for( $m = 0; $m < $total_rating_inc; $m++ ) {

        $rating_symbol = '';
        $rating_svg_symbol = "<svg version='1.1' id='Layer_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px'
                                 viewBox='0 0 100 100' style='width: 14px; height: 14px' xml:space='preserve'>
                                <style type='text/css'>
                                    .rx_avg_star_color{fill:#FFAF22;}
                                </style>
                                <path class='rx_avg_star_color' d='M100,39.3c0-1.5-1.1-2.4-3.4-2.8l-30.2-4.4L52.9,4.8c-0.8-1.6-1.7-2.5-2.9-2.5c-1.2,0-2.2,0.8-2.9,2.5
                                    L33.5,32.1L3.4,36.5C1.1,36.9,0,37.8,0,39.3c0,0.8,0.5,1.8,1.5,2.9l21.9,21.3l-5.2,30c-0.1,0.6-0.1,1-0.1,1.2c0,0.8,0.2,1.6,0.6,2.1
                                    c0.4,0.6,1,0.9,1.9,0.9c0.7,0,1.5-0.2,2.4-0.7l27-14.2L77,97c0.8,0.5,1.6,0.7,2.4,0.7c1.6,0,2.5-1,2.5-3c0-0.5,0-0.9-0.1-1.2
                                    l-5.2-30l21.8-21.3C99.5,41.1,100,40.2,100,39.3z'/>
                                </svg>";
        $rating_symbol = $rating_svg_symbol;
        $total_point_star .= $rating_symbol;

    }

    if( preg_match( '/^\d+\.\d+$/',($get_rating_meta) ) ) {

        $rating_symbol              = '';
        $rating_svg_symbol          = "<svg version='1.1' id='Layer_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px'
                                             viewBox='0 0 100 100' style='width: 14px; height: 14px' xml:space='preserve'>
                                        <style type='text/css'>
                                            .rx_avg_star_color{fill:#FFAF22;}
                                        </style>
                                        <path class='rx_avg_star_color' d='M100,39.3c0-1.5-1.1-2.4-3.4-2.8l-30.2-4.4L52.9,4.8c-0.8-1.6-1.7-2.5-2.9-2.5c-1.2,0-2.2,0.8-2.9,2.5
                                            L33.5,32.1L3.4,36.5C1.1,36.9,0,37.8,0,39.3c0,0.8,0.5,1.8,1.5,2.9l21.9,21.3l-5.2,30c-0.1,0.6-0.1,1-0.1,1.2c0,0.8,0.2,1.6,0.6,2.1
                                            c0.4,0.6,1,0.9,1.9,0.9c0.7,0,1.5-0.2,2.4-0.7l27-14.2L77,97c0.8,0.5,1.6,0.7,2.4,0.7c1.6,0,2.5-1,2.5-3c0-0.5,0-0.9-0.1-1.2
                                            l-5.2-30l21.8-21.3C99.5,41.1,100,40.2,100,39.3z M68.3,60.7L72.7,86L50,74.1V16.2l11.4,23l25.4,3.7L68.3,60.7z'/>
                                        </svg>";
        $rating_symbol = $rating_svg_symbol;
        $total_point_star .= $rating_symbol;
        $total_rating_inc +=1;

    }

    for( $l= 0; $l<(5-$total_rating_inc);  $l++ ) {

        $rating_symbol              = '';
        $rating_svg_symbol          = "<svg version='1.1' id='Layer_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px'
                                             viewBox='0 0 100 100' style='width: 14px; height: 14px' xml:space='preserve'>
                                        <style type='text/css'>
                                            .rx_avg_star_color{fill:#FFAF22;}
                                        </style>
                                        <g>
                                            <path class='rx_avg_star_color' d='M100,39.3c0-1.5-1.1-2.4-3.4-2.8l-30.2-4.4L52.9,4.8c-0.8-1.6-1.7-2.5-2.9-2.5c-1.2,0-2.2,0.8-2.9,2.5
                                                L33.5,32.1L3.4,36.5C1.1,36.9,0,37.8,0,39.3c0,0.8,0.5,1.8,1.5,2.9l21.9,21.3l-5.2,30c-0.1,0.6-0.1,1-0.1,1.2
                                                c0,0.8,0.2,1.6,0.6,2.1c0.4,0.6,1,0.9,1.9,0.9c0.7,0,1.5-0.2,2.4-0.7l27-14.2L77,97c0.8,0.5,1.6,0.7,2.4,0.7c1.6,0,2.5-1,2.5-3
                                                c0-0.5,0-0.9-0.1-1.2l-5.2-30l21.8-21.3C99.5,41.1,100,40.2,100,39.3L100,39.3z M68.3,60.7L72.7,86L50,74.1L27.3,86l4.4-25.3
                                                L13.3,42.9l25.4-3.7l11.4-23l11.4,23l25.4,3.7L68.3,60.7z M68.3,60.7'/>
                                        </g>
                                        </svg>";
        $rating_symbol = $rating_svg_symbol;
        $total_point_star .= $rating_symbol;

    }

    return $total_point_star;

}

/**
 * This function for AJAX colling for review filter
 * @param $POST
 * @return void
 */
add_action( 'wp_ajax_rx_sorting', 'reviewx_filter_review' );
add_action( 'wp_ajax_nopriv_rx_sorting', 'reviewx_filter_review' );

add_filter( 'rx_load_filter_review_template', 'rx_load_filter_review_template' );

function reviewx_filter_review() {

    check_ajax_referer( 'special-string', 'security' );
    $orderby_value  = sanitize_text_field( $_POST['selected'] );
    $orderby_id     = sanitize_text_field( $_POST[ 'rx_product_id' ] );
    switch ( $orderby_value ) {
        case "photo":
            $args = array(
                'post_type'         => 'product',
                'orderby'           => 'date',
                'post_id'           => $orderby_id,
                'meta_query'        => array(
                    array(
                        'key'       => 'reviewx_attachments',
                        'value'     => array( '', array(), serialize( array() ) ),
                        'compare'   => 'NOT IN'
                    )
                    ),
                'tag' => 'photo'
            ); 
			
            apply_filters( 'rx_load_filter_review_template', $args );

        break;
		
		case "video":
            $args = array(
                'post_type' => 'product',
                'orderby' => 'date',
                'post_id' => $orderby_id,
                'meta_query' => array(
                    array(
                        'key' => 'reviewx_video_url',
                        'value' => '',
                        'compare' => 'NOT IN'
                    )
                ),
                'tag' => 'video'
            );
            apply_filters( 'rx_load_filter_review_template', $args );

		break;

        case "text":
            if( class_exists('ReviewXPro') ) {
                $args = array(
                    'post_type' => 'product',
                    'orderby'   => 'date',
                    'post_id'   => $orderby_id,
                    'meta_query'  => array(
                        array(
                            'relation' => 'AND',
                            array(
                                'key'   => 'reviewx_attachments',
                                'compare' => 'NOT EXISTS'
                            ),
                            array(
                                'key'   => 'reviewx_video_url',
                                'compare' => 'NOT EXISTS'
                            ),
                        ),
                    ),                   
                    'tag' => 'text'
                );
            } else {
                $args = array(
                    'post_type' => 'product',
                    'orderby'   => 'date',
                    'post_id'   => $orderby_id,
                    'meta_query' => array(
                        array(
                            'key'   => 'reviewx_attachments',
                            'compare' => 'NOT EXISTS'
                        ),
                    ),
                    'tag' => 'text'
                );
            }
			
            apply_filters( 'rx_load_filter_review_template', $args );
			
        break;

        case "rating":
            $args = array(
                'post_type'         => 'product',
                'post_id'           => $orderby_id,
                'meta_query'        => array(
                    'meta_value'    => array(
                        'key'       => 'rating',
                        'value'     => 5,
                        'compare'   => '<='
                    ),
                ),
                'orderby'           => array(
                    'meta_value'    => 'DESC'
                ),
                'tag' => 'rating'
            );            
            apply_filters( 'rx_load_filter_review_template', $args );
        break;

        default:
            $args = array(
                'post_type'         => 'product',
                'orderby'           => 'date',
                'post_id'           => $orderby_id,
                'tag'               => 'recent'
            );            
            apply_filters( 'rx_load_filter_review_template', $args );
        break;
    }
    wp_die();

}

/**
 * This function load html template
 * @param $args
 * @return void
 */
function rx_load_filter_review_template( $args ) {

    if( ! class_exists('ReviewXPro_Features') ) {

        $settings        = \ReviewX\Controllers\Admin\Core\ReviewxMetaBox::get_metabox_settings();
        $template_style  = $settings->template_style;
        $rx_elementor_template      = get_option( 'rx_template_type' );

        //Check elementor template 
        if( ! empty($rx_elementor_template) ) {

            switch ( $rx_elementor_template ) {
                case 'template_style_two':
                    include REVIEWX_PARTIALS_PATH . 'storefront/single-review/filter/style-two.php';
                break;
                default:
                    include REVIEWX_PARTIALS_PATH . 'storefront/single-review/filter/style-one.php';
            }	

        } else {
            //Serve local template	
            switch ( $template_style ) {
                case 'template_style_two':
                    include REVIEWX_PARTIALS_PATH . 'storefront/single-review/filter/style-two.php';
                break;
                default:
                    include REVIEWX_PARTIALS_PATH . 'storefront/single-review/filter/style-one.php';
            }

        }
    
        reviewx_review_filter_query_html( $args );
    }

}

/**
 * Handle the default star rating in the backend
 * @param none
 * @return void
 */
add_action( 'add_meta_boxes' , 'rx_remove_meta_boxes', 40 );

function rx_remove_meta_boxes() {
    remove_meta_box('woocommerce-rating','comment','normal', 'high' ); 
}

/**
 * Count total reviewer
 * @param $post_id
 * @return int
 */
function rx_total_reviewer_free( $post_id ) {

    global $wpdb;
    $rx_comment_table = $wpdb->prefix . 'comments';
    $data = $wpdb->get_results( $wpdb->prepare( "SELECT DISTINCT comment_author_email  FROM $rx_comment_table WHERE comment_post_ID = %d AND comment_parent = %d", $post_id, 0 ) );
    if( $data && count($data) ) {
        return count($data);
    }
    return 0; 

}

/**
 * Before my order navigation
 * @param none
 * @return void
 */
add_action('woocommerce_before_account_navigation', 'rx_add_class_before_navigation');
function rx_add_class_before_navigation() { ?>
	<div class="rx-woocommerce-myaccount-navigation">
<?php }

/**
 * After my order navigation 
 * @param none
 * @return void
 */
add_action('woocommerce_after_account_navigation', 'rx_add_class_after_navigation');
function rx_add_class_after_navigation() {
	?>
	</div>
	<?php
}

/**
 * Comment note modify
 * @param array
 * @return void
 */
add_filter( 'comment_form_defaults', 'rx_pre_comment_text' );
function rx_pre_comment_text( $arg ) {
  $arg['comment_notes_before'] = sprintf('<p class="comment-notes">%s</p>',sprintf('<span id="email-notes">%s</span>',__( 'Your email address will not be published.', 'reviewx' ), '' ));
  return $arg;
}

/**
 * Save review post per page
 * @param array
 * @return void
 */
add_filter( 'admin_init', 'rx_set_screen_options' );
function rx_set_screen_options() {
    if ( isset( $_POST['wp_screen_options'] ) && is_array( $_POST['wp_screen_options'] ) ) {
        check_admin_referer( 'screen-options-nonce', 'screenoptionnonce' );

        $user = wp_get_current_user();
		if ( ! $user ) {
			return;
        }
        
        $option = $_POST['wp_screen_options']['option'];
        $value  = $_POST['wp_screen_options']['value'];
        
        if ( sanitize_key( $option ) != $option ) {
			return;
        }

        update_user_meta( $user->ID, $option, $value );
    }
}

/**
 * Call cron function to recalculate rating averag
 * @param none
 * @return void
 */

use ReviewX\Controllers\Admin\Email\EmailSettings;
use ReviewX\Controllers\Admin\Rating\ReCalculateReviewRating;
register_activation_hook(REVIEWX_FILE, 'rx_call_cron_function' );
function rx_call_cron_function(){
    
    global $wpdb;
    $table_name = $wpdb->prefix . 'reviewx_process_jobs';
    $args = [
        'post_type' => 'product',
        'type'  	=> 'review',
    ];
    $reviews = get_comments($args);

    if( count($reviews) < 15 ) {

        foreach( $reviews as $rx ) {
            $wpdb->insert( $table_name, array( 'process_name' => 're_calculate_review', 'process_meta' => $rx->comment_ID ), array( '%s', '%d' ) );
        }

        wp_clear_scheduled_hook( 'rx_process_re_calculate' );
        if ( ! wp_next_scheduled( 'rx_process_re_calculate' ) ) {
            wp_schedule_single_event( time() + 120, 'rx_process_re_calculate' );
        }

    } else {

        wp_clear_scheduled_hook( 'rx_collect_review_id' );
        if ( ! wp_next_scheduled( 'rx_collect_review_id' ) ) {             
            wp_schedule_single_event( time() + 120, 'rx_collect_review_id' );
        } 
    }

}

add_action('rx_reminder_email_dispatch_scheduled', 'scheduled_email_dispatching');

function scheduled_email_dispatching($args) {
    (new EmailSettings())->sendScheduleEmail($args);
}

/**
 * Collect all review id
 * @param none
 * @return void
 */
add_action( 'rx_collect_review_id', 'collect_all_reviews_id' );
function collect_all_reviews_id(){
    
    global $wpdb;
    $table_name = $wpdb->prefix . 'reviewx_process_jobs';
    $args = [
        'post_type' => 'product',
        'type'  	=> 'review',
    ];
    $reviews = get_comments($args);

    foreach( $reviews as $rx ) {
        $wpdb->insert( $table_name, array( 'process_name' => 're_calculate_review', 'process_meta' => $rx->comment_ID ), array( '%s', '%d' ) );
    }    

    //Rating average calculation is here
    wp_clear_scheduled_hook( 'rx_process_re_calculate' );
    if ( ! wp_next_scheduled( 'rx_process_re_calculate' ) ) {
        wp_schedule_single_event( time() + 120, 'rx_process_re_calculate' );
    } 
}

/**
 * Calculate rating average
 * @param none
 * @return void
 */
add_action( 'rx_process_re_calculate', 'process_review_recalculation' );
function process_review_recalculation(){
    
    global $wpdb;
    $table_name         = $wpdb->prefix . 'reviewx_process_jobs';
    $sql                = $wpdb->prepare("SELECT * FROM $table_name");
    $reviews            = $wpdb->get_results($sql); 
    foreach( $reviews as $rx ) {
        (new ReCalculateReviewRating())->handleAction($rx->process_meta, true);
        $wpdb->delete( $table_name, array( 'id' => $rx->id ) );        
    }

}

/**
 * Check video type
 * @param string
 * @return void
 */
function rx_edit_review_determine_video_url_type( $url ){

    $yt_rx = '/^((?:https?:)?\/\/)?((?:www|m)\.)?((?:youtube\.com|youtu.be))(\/(?:[\w\-]+\?v=|embed\/|v\/)?)([\w\-]+)(\S+)?$/';
    $has_match_youtube = preg_match($yt_rx, $url, $yt_matches);

    $vm_rx = '/(https?:\/\/)?(www\.)?(player\.)?vimeo\.com\/([a-z]*\/)*([‌​0-9]{6,11})[?]?.*/';
    $has_match_vimeo = preg_match($vm_rx, $url, $vm_matches);

    //Then we want the video id which is:
    if($has_match_youtube) {
        $video_id = $yt_matches[5]; 
        $type = 'youtube';
    }
    elseif($has_match_vimeo) {
        $video_id = $vm_matches[5];
        $type = 'vimeo';
    }
    else {
        $video_id = 0;
        $type = 'none';
    }

    $data['video_id'] = $video_id;
    $data['video_type'] = $type;

    return $data;
    
}

/**
 * WP User Avatar Uploader compability
 * @param string
 * @return void
 */
add_filter('media_view_settings', 'rx_media_view_settings', 10, 2);
function rx_media_view_settings($settings) {
    if( class_exists('WP_User_Avatar') ){
        global $post, $wpua_is_profile;
        $wpua_is_profile = 1; 
        // Get post ID so not to interfere with media uploads
        $post_id = is_object($post) ? $post->ID : 0;
        // Don't use post ID on front pages if there's a WPUA uploader
        $settings['post']['id'] = (!is_admin() && $wpua_is_profile == 1) ? 0 : $post_id;
    }    
    return $settings;
}
