<?php
function reviewx_settings_args(){
    return apply_filters( 'rx_builder_tabs', array(
        'source_tab' => array(
            'title'         => __('Criteria', 'reviewx'),
            'icon'          => '',
            'sections'      => apply_filters('rx_source_tab_sections', array(

                'repeat_field' => array(
                    'title'  => __('Product Review Criteria', 'reviewx'),
                    'fields' => array(
                        'review_criteria' => array(
                            'type'  => 'repeat-field',                                
                        ),
                    
                    )
                ),
            )
        )
        ),
        'content_tab' => array(
            'title'         => __('Settings', 'reviewx'),
            'icon'          => '',
            'sections'      => apply_filters('rx_content_tab_sections', array(

                'order_status' => array(
                    'title'  => __('Enable Order Status', 'reviewx'),
                    'fields' => array(
                        'pending_payment' => array(
                            'type'        => 'checkbox',
                            'label'       => __('Pending Payment' , 'reviewx'),
                        ),
                        'processing' => array(
                            'type'        => 'checkbox',
                            'label'       => __('Processing' , 'reviewx'),
                            // 'default'     => 1,
                        ),
                        'on_hold' => array(
                            'type'        => 'checkbox',
                            'label'       => __('On Hold' , 'reviewx'),
                        ),
                        'completed' => array(
                            'type'        => 'checkbox',
                            'label'       => __('Completed' , 'reviewx'),
                            // 'default'     => 1,
                        ),
                        'cancelled' => array(
                            'type'        => 'checkbox',
                            'label'       => __('Cancelled' , 'reviewx'),
                        ),
                        'refunded' => array(
                            'type'        => 'checkbox',
                            'label'       => __('Refunded' , 'reviewx'),
                        ),
                        'failed' => array(
                            'type'        => 'checkbox',
                            'label'       => __('Failed' , 'reviewx'),
                        ),
                    )
                ),

                'allow_utilities' => array(
                    'title'  => __('Other Settings', 'reviewx'),
                    'fields' => array(
                        'allow_img' => array(
                            'heading' => __( 'Image Review', 'reviewx' ),
                            'label'  => __('Allow customers to upload the image with review', 'reviewx'),
                            'type'  => 'switcher',
                        ), 
                        'allow_recommendation' => array(
                            'heading' => __('Recommendation', 'reviewx' ),
                            'label' => __('Allow customers to recommend the products', 'reviewx'),
                            'type'  => 'switcher',
                        ),                             
                        'allow_video' => array(
                            'heading' => __('Allow Video', 'reviewx' ),
                            'label' => __('Allow customers to link the video with review', 'reviewx'),
                            'type'  => 'switcher',
                        ),
                        'allow_anonymouse' => array(
                            'heading' => __('Allow Anonymous Review', 'reviewx' ),
                            'label' => __('Allow customer to give review anonymously', 'reviewx'),
                            'type'  => 'switcher',
                        ),
                        'allow_share_review' => array(
                            'heading' => __( 'Review Share', 'reviewx' ),
                            'label' => __('Allow customer to share review to the social media', 'reviewx'),
                            'type'  => 'switcher',
                        ),
                        'allow_like_dislike' => array(
                            'heading' => __( 'Enable Helpful Feature', 'reviewx' ),
                            'label' => __('Allow customer to react on the review', 'reviewx'),
                            'type'  => 'switcher',
                        ),
                        'disable_auto_approval' => array(
                            'heading' => __('Disable Review Auto Approval', 'reviewx'),
                            'label' => __('Disable review auto approval', 'reviewx'),
                            'type'  => 'switcher',
                            'default'	=> 1
                        ),  
                        'allow_review_title' => array(
                            'heading' => __('Review Title', 'reviewx'),
                            'label' => __('Enable/disable the review title field', 'reviewx'),
                            'type'  => 'switcher',
                            'default'	=> 1
                        ),                           
                        'allow_multiple_review' => array(
                            'is_pro' => true,
                            'heading' => __('Enable Multiple Review', 'reviewx'),
                            'label' => __('Enable/disable mulitiple review', 'reviewx'),
                            'type'  => 'switcher',                                
                        ),                                                
                        'review_per_page' => array(
                            'heading' => __( 'Pagination for review', 'reviewx' ),
                            'label' => __('Display review per page', 'reviewx'),
                            'type'  => 'number',
                            'default'	=> 10                                
                        ),                            
                    )
                ),                   
            ))
        ),
        'design_tab' => array(
            'title'      => __('Design', 'reviewx'),
            'icon'       => '',
            'sections'   => apply_filters('rx_design_tab_sections', array(

                'radio_button' => array(
                    'title'  => __('Graph Style', 'reviewx'),
                    'fields' => array(
                        'graph_style' => array(
                            'type' => 'theme',
                            'priority'=> 4,
                            'default'=>'graph_style_default',                            
                            'options'=> apply_filters( 'rx_colored_themes', array(
                                'graph_style_default'   => esc_url( REVIEWX_ADMIN_URL . 'assets/images/themes/graph_style-1.png' ),
                                'graph_style_one'       => esc_url( REVIEWX_ADMIN_URL . 'assets/images/themes/graph_style-2.png' ),
                                // 'graph_style_two'       => array(
                                //     'is_pro'            => true,
                                //     'source'            => REVIEWX_ADMIN_URL . 'assets/images/themes/graph_style-3.png'
                                // ),
                                'graph_style_three'       => array(
                                    'is_pro'            => true,
                                    'source'            => esc_url( REVIEWX_ADMIN_URL . 'assets/images/themes/graph_style-4.png' )
                                ),                                                                                                          
                            ) )
                        ),
                    )
                ),

                'review_type' => array(
                    'title'  => __('Photo Review Style', 'reviewx'),
                    'fields' => array(
                        'review_style' => array(
                            'type' => 'theme',
                            'priority'=> 6,
                            'default'=>'review_style_default',                          
                            'options'=> apply_filters( 'rx_photo_review_style', array(
                                'review_style_default' => esc_url( REVIEWX_ADMIN_URL . 'assets/images/themes/photo-style.png' ),
                                'review_style_one'     => esc_url( REVIEWX_ADMIN_URL . 'assets/images/themes/photo-style-2.png' ),
                            ) )
                        ),
                    )
                ),

                'template_style' => array(
                    'title'  => __('Template Style', 'reviewx'),
                    'fields' => array(
                        'template_style' => array(
                            'type' => 'theme',
                            'priority'=> 6,
                            'default'=>'template_style_one',
                            'options'=> apply_filters( 'rx_template_style_style', array(
                                'template_style_one'     => esc_url( REVIEWX_ADMIN_URL . 'assets/images/themes/template-style-1.png' ),
                                'template_style_two'     => esc_url( REVIEWX_ADMIN_URL . 'assets/images/themes/template-style-2.png' ),
                            ) )
                        ),
                    )
                ),                    

                'rating_type' => array(
                    'title'  => __('Product Rating Type', 'reviewx'),
                    'fields' => array(
                    'rating_style' => array(
                            'type'                  => 'theme',
                            'priority'              => 5,
                            'default'               => 'rating_style_one',                           
                            'options'               => apply_filters('rx_product_rating_type', array(
                            'rating_style_one'      => esc_url( REVIEWX_ADMIN_URL . 'assets/images/themes/rating_style-1.png' ),
                            'rating_style_two'      => array(
                                'is_pro'            => true,
                                'source'            => esc_url( REVIEWX_ADMIN_URL . 'assets/images/themes/rating_style-2.png' ),
                                'title'             => __( 'We calculate the average rating  from this like-dislike  rating & will display as a star rating in individual review', 'reviewx' ),
                                
                            ),    
                            'rating_style_three'   => array(
                                'is_pro'           => true,
                                'source'           => esc_url( REVIEWX_ADMIN_URL . 'assets/images/themes/rating_style-3.png' ),
                                'title'            => __( 'We calculate the average rating  from this happy-sad  rating & will display as a star rating in individual review', 'reviewx' ),
                            ),                                                              
                            )),
                        ),                            
                    )
                ),

                'color_edit' => array(
                    'title'  => __('Theme Color', 'reviewx'),
                    'fields' => array(
                        'color_theme' => array(
                            'type'  => 'colorpicker',
                            'default' => '#2f4fff ',                           
                        ),
                    
                    )
                ),

                'icon_upload' => array(
                    'title'  => __('Shop Icon', 'reviewx'),
                    'fields' => array(
                        'color_theme' => array(
                            'type'  => 'media',                             
                        ),                           
                    )
                ),                
            ))
        ),
        'display_tab' => array(
            'title'         => __('Overview', 'reviewx'),
            'icon'          => '',
            'sections'      => apply_filters('rx_display_tab_sections', array(
                'image' => array(
                    'title'    => __('Setting Preview', 'reviewx'),
                    'priority' => 100,
                    'fields'   => array(
                        'show_default_image'  => array(
                            'type'      => 'preview',
                            'label'     => '',
                            'priority'	=> 5,
                        ),
                        
                    )
                ),
                
            ))
        ),               
    ));
}
?>