<?php
function reviewx_quick_setup_args() {
    return array(
        'id'           => 'rx_metabox_wrapper',
        'title'        => __('ReviewX - Advanced Multi-criteria Rating & Reviews for WooCommerce', 'reviewx'),
        'object_types' => array( 'reviewx' ),
        'context'      => 'normal',
        'priority'     => 'high',
        'show_header'  => false,
        'tabnumber'    => true,
        'layout'       => 'horizontal',
        'tabs'         => apply_filters( 'rx_builder_quick_setup_tabs', array(
            'source_tab' => array(
                'title'         => __('Criteria', 'reviewx'),
                'icon'          => '',
                'sections'      => apply_filters('rx_source_tab_sections', array(

                        'repeat_field' => array(
                            'title'  => __('Product Review Criteria', 'reviewx'),
                            'fields' => array(
                                'review_criteria' => array(
                                    'type'  => 'repeat-field',
                                ),

                            )
                        ),
                    )
                )
            ),
            'content_tab' => array(
                'title'         => __('Settings', 'reviewx'),
                'icon'          => '',
                'sections'      => apply_filters('rx_content_tab_sections', array(

                    'order_status' => array(
                        'title'  => __('Enable Order Status', 'reviewx'),
                        'fields' => array(
                            'pending_payment' => array(
                                'type'        => 'checkbox',
                                'label'       => __('Pending Payment' , 'reviewx'),
                            ),
                            'processing' => array(
                                'type'        => 'checkbox',
                                'label'       => __('Processing' , 'reviewx'),
                                // 'default'     => 1,
                            ),
                            'on_hold' => array(
                                'type'        => 'checkbox',
                                'label'       => __('On Hold' , 'reviewx'),
                            ),
                            'completed' => array(
                                'type'        => 'checkbox',
                                'label'       => __('Completed' , 'reviewx'),
                                // 'default'     => 1,
                            ),
                            'cancelled' => array(
                                'type'        => 'checkbox',
                                'label'       => __('Cancelled' , 'reviewx'),
                            ),
                            'refunded' => array(
                                'type'        => 'checkbox',
                                'label'       => __('Refunded' , 'reviewx'),
                            ),
                            'failed' => array(
                                'type'        => 'checkbox',
                                'label'       => __('Failed' , 'reviewx'),
                            ),
                        )
                    ),

                    'allow_utilities' => array(
                        'title'  => __('Other Settings', 'reviewx'),
                        'fields' => array(                              
                            'allow_img' => array(
                                'heading' => __('Image Review', 'reviewx'),
                                'label'  => __('Allow customers to upload the image with review', 'reviewx'),
                                'type'  => 'switcher',
                                'default'	=> 1
                            ),
                            'allow_recommendation' => array(
                                'heading' => __('Recommendation', 'reviewx'),
                                'label' => __('Allow customers to recommend the products', 'reviewx'),
                                'type'  => 'switcher',
                                'default'	=> 1
                            ),
                            'allow_video' => array(
                                'is_pro' => true,
                                'heading' => __('Allow Video', 'reviewx'),
                                'label' => __('Allow customers to link the video with review', 'reviewx'),
                                'type'  => 'switcher',
                                'disabled' => true
                            ),
                            'allow_anonymouse' => array(
                                'is_pro' => true,
                                'heading' => __('Allow Anonymous Review', 'reviewx'),
                                'label' => __('Allow customer to give review anonymously', 'reviewx'),
                                'type'  => 'switcher',
                                'disabled' => true
                            ),
                            'allow_share_review' => array(
                                'is_pro' => true,
                                'heading' => __('Review Share', 'reviewx'),
                                'label' => __('Allow customer to share review to the social media', 'reviewx'),
                                'type'  => 'switcher',
                                'disabled' => true
                            ),
                            'allow_like_dislike' => array(
                                'is_pro' => true,
                                'heading' => __('Enable Like', 'reviewx'),
                                'label' => __('Allow customer to react on the review', 'reviewx'),
                                'type'  => 'switcher',
                                'disabled' => true
                            ),
                            'disable_auto_approval' => array(
                                'is_pro' => true,
                                'heading' => __('Review Auto Approval', 'reviewx'),
                                'label' => __('Enable/disable the review auto-approval', 'reviewx'),
                                'type'  => 'switcher',
                                'default'	=> 1
                            ),  
                            'allow_review_title' => array(
                                'heading' => __('Review Title', 'reviewx'),
                                'label' => __('Enable/disable the review title field', 'reviewx'),
                                'type'  => 'switcher',
                                'default'	=> 1
                            ), 
                            'allow_multiple_review' => array(
                                'is_pro' => true,
                                'heading' => __('Enable Multiple Review', 'reviewx'),
                                'label' => __('Enable/disable mulitiple review', 'reviewx'),
                                'type'  => 'switcher', 
                                'disabled' => true                               
                            ),                                                                                                               
                            'review_per_page' => array(
                                'heading' => __('Pagination for review', 'reviewx'),
                                'label' => __('Display review per page', 'reviewx'),
                                'type'  => 'number',
                                'default'	=> 10
                            ),
                        )
                    ),
                ))
            ),
            'design_tab' => array(
                'title'      => __('Design', 'reviewx'),
                'icon'       => '',
                'sections'   => apply_filters('rx_design_tab_sections', array(

                    'radio_button' => array(
                        'title'  => __('Graph Style', 'reviewx'),
                        'fields' => array(
                            'graph_style' => array(
                                'type' => 'theme',
                                'priority'=> 4,
                                'default'=>'graph_style_two_free',
                                'options'=> apply_filters( 'rx_colored_themes', array(
                                    'graph_style_two_free'  => esc_url(assets('admin/images/themes/graph_style-5.png')),
                                    'graph_style_default'   => esc_url(assets('admin/images/themes/graph_style-1.png')),
                                    'graph_style_one'       => esc_url(assets('admin/images/themes/graph_style-2.png')),                                    
                                    // 'graph_style_two'       => array(
                                    //     'is_pro'            => true,
                                    //     'source'            => esc_url(assets('admin/images/themes/graph_style-3.png'))
                                    // ),
                                    'graph_style_three'     => array(
                                        'is_pro'            => true,
                                        'source'            => esc_url(assets('admin/images/themes/graph_style-4.png'))
                                    ),                                                                                                          
                                  ) )
                            ),
                        )
                    ),

                    'review_type' => array(
                        'title'  => __('Photo Review Style', 'reviewx'),
                        'fields' => array(
                            'review_style' => array(
                                'type' => 'theme',
                                'priority'=> 6,
                                'default'=>'review_style_default',
                                'options'=> apply_filters( 'rx_photo_review_style', array(
                                    'review_style_default' => esc_url(assets('admin/images/themes/photo-style.png')),
                                    'review_style_one'     => esc_url(assets('admin/images/themes/photo-style-2.png')),
                                ) )
                            ),
                        )
                    ),

                    'template_style' => array(
                        'title'  => __('Template Style', 'reviewx'),
                        'fields' => array(
                            'template_style' => array(
                                'type' => 'theme',
                                'priority'=> 6,
                                'default'=>'template_style_one',
                                'options'=> apply_filters( 'rx_template_style_style', array(
                                    'template_style_one'     => esc_url(assets('admin/images/themes/template-style-1.png')),
                                    'template_style_two'     => esc_url(assets('admin/images/themes/template-style-2.png')),
                                ) )
                            ),
                        )
                    ),

                    'rating_type' => array(
                        'title'  => __('Product Rating Type', 'reviewx'),
                        'fields' => array(
                            'rating_style' => array(
                                'type'                  => 'theme',
                                'priority'              => 5,
                                'default'               => 'rating_style_one',
                                'options'               => apply_filters('rx_product_rating_type', array(
                                    'rating_style_one'    => esc_url(assets('admin/images/themes/rating_style-1.png')),
                                    'rating_style_two'    => array(
                                        'is_pro'            => true,
                                        'source'            => esc_url(assets('admin/images/themes/rating_style-2.png')),
                                        'title'            => __( 'We calculate the average rating  from this like-dislike  rating & will display as a star rating in individual review', 'reviewx' ),

                                    ),
                                    'rating_style_three'     => array(
                                        'is_pro'           => true,
                                        'source'           => esc_url(assets('admin/images/themes/rating_style-3.png')),
                                        'title'             => __( 'We calculate the average rating  from this happy-sad  rating & will display as a star rating in individual review', 'reviewx' ),
                                    ),
                                )),
                            ),
                        )
                    ),

                    'color_edit' => array(
                        'title'  => __('Theme Color', 'reviewx'),
                        'fields' => array(
                            'color_theme' => array(
                                'type'  => 'colorpicker',
                                'default' => '#2f4fff ',
                            ),

                        )
                    ),
                  
                ))
            ),
            'email_tab' => array(
                'title'      => __('Email', 'reviewx'),
                'icon'       => '',
                'sections'   => apply_filters('rx_design_tab_sections', array(
                    'image' => array(
                        'title'    => __('Send Email To Customers To Remind About The Review', 'reviewx'),
                        'priority' => 100,
                        'fields'   => array(
                            'email_subject'  => array(
                                'type'      => 'email_subject',
                                'label'     => '',
                                'priority'	=> 5,
                                'default'   => __('Your Feedback Means a Lot to Us! | [SHOP_NAME]', 'reviewx' )
                            ),
                            'email_editor'  => array(
                                'type'      => 'editor',
                                'label'     => '',
                                'priority'	=> 6,
                                'default'   => '<table class="body" style="border-collapse: collapse; border-spacing: 0; vertical-align: top; mso-table-lspace: 0pt; mso-table-rspace: 0pt; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; height: 100% !important; width: 100% !important; min-width: 100%; -moz-box-sizing: border-box; -webkit-box-sizing: border-box; box-sizing: border-box; -webkit-font-smoothing: antialiased !important; -moz-osx-font-smoothing: grayscale !important; background-color: #f1f1f1; color: #444; font-family: Helvetica,Arial,sans-serif; font-weight: normal; padding: 0; margin: 0; text-align: left; font-size: 14px; mso-line-height-rule: exactly; line-height: 140%;" border="0" width="100%" cellspacing="0" cellpadding="0"><tbody><tr style="padding: 0; vertical-align: top; text-align: left;"><td class="body-inner wp-mail-smtp" style="word-wrap: break-word; -webkit-hyphens: auto; -moz-hyphens: auto; hyphens: auto; border-collapse: collapse !important; vertical-align: top; mso-table-lspace: 0pt; mso-table-rspace: 0pt; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; color: #444; font-family: Helvetica,Arial,sans-serif; font-weight: normal; padding: 0; margin: 0; font-size: 14px; mso-line-height-rule: exactly; line-height: 140%; text-align: center;" align="center" valign="top"><table class="container" style="border-collapse: collapse; border-spacing: 0; padding: 0; vertical-align: top; mso-table-lspace: 0pt; mso-table-rspace: 0pt; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; width: 600px; margin: 0 auto 30px auto; text-align: inherit;" border="0" cellspacing="0" cellpadding="0"><tbody><tr style="padding: 0; vertical-align: top; text-align: left;"><td class="content" style="word-wrap: break-word; -webkit-hyphens: auto; -moz-hyphens: auto; hyphens: auto; border-collapse: collapse !important; vertical-align: top; mso-table-lspace: 0pt; mso-table-rspace: 0pt; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; color: #444; font-family: Helvetica,Arial,sans-serif; font-weight: normal; margin: 0; text-align: left; font-size: 14px; mso-line-height-rule: exactly; line-height: 140%; background-color: #ffffff; padding: 60px 75px 45px 75px; border-right: 1px solid #ddd; border-bottom: 1px solid #ddd; border-left: 1px solid #ddd; border-top: 3px solid #809eb0;" align="left" valign="top"><div class="success"><p class="text-large" style="-ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; color: #444; font-family: Helvetica,Arial,sans-serif; font-weight: normal; padding: 0; text-align: left; mso-line-height-rule: exactly; line-height: 140%; margin: 0 0 15px 0; font-size: 14px;">'.__('Hey [CUSTOMER_NAME],', 'reviewx').'</p><p class="text-large" style="-ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; color: #444; font-family: Helvetica,Arial,sans-serif; font-weight: normal; padding: 0; text-align: left; mso-line-height-rule: exactly; line-height: 140%; margin: 0 0 15px 0; font-size: 14px;">'.__('Thank you for purchasing items from the [SHOP_NAME]. We love to know your experiences with the product(s) that you recently purchased.', 'reviewx').'</p><p class="text-large" style="-ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; color: #444; font-family: Helvetica,Arial,sans-serif; font-weight: normal; padding: 0; text-align: left; mso-line-height-rule: exactly; line-height: 140%; margin: 0 0 15px 0; font-size: 14px;">'.__('You can browse a list of orders from your account page and can submit your feedback based on multiple criteria that we specially designed for you. To browse your orders: [MY_ORDERS_PAGE]', 'reviewx').'</p><p class="text-large" style="-ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; color: #444; font-family: Helvetica,Arial,sans-serif; font-weight: normal; padding: 0; text-align: left; mso-line-height-rule: exactly; line-height: 140%; margin: 0 0 15px 0; font-size: 14px;">'.__('[ORDER_DATE] you placed the order [ORDER_ID]', 'reviewx').'</p><p class="text-large" style="-ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; color: #444; font-family: Helvetica,Arial,sans-serif; font-weight: normal; padding: 0; text-align: left; mso-line-height-rule: exactly; line-height: 140%; margin: 0 0 15px 0; font-size: 14px;">'.__('[ORDER_ITEMS]','').'</p><p class="text-large" style="-ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; color: #444; font-family: Helvetica,Arial,sans-serif; font-weight: normal; padding: 0; text-align: left; mso-line-height-rule: exactly; line-height: 140%; margin: 0 0 15px 0; font-size: 14px;">'.__('Your feedback means a lot to us! Thanks for being a loyal [SHOP_NAME] customer.', 'reviewx').'</p><p class="text-large" style="-ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; color: #444; font-family: Helvetica,Arial,sans-serif; font-weight: normal; padding: 0; text-align: left; mso-line-height-rule: exactly; line-height: 140%; margin: 0 0 15px 0; font-size: 14px;">'.__('Regards,', 'reviewx').'</p><p class="text-large" style="-ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; color: #444; font-family: Helvetica,Arial,sans-serif; font-weight: normal; padding: 0; text-align: left; mso-line-height-rule: exactly; line-height: 140%; margin: 0 0 15px 0; font-size: 14px;">'.__('Team [SHOP_NAME]', 'reviewx').'</p></div><h6>'.__('If you want to unsubscribe this email please go to this [UNSUBSCRIBE_LINK]', 'reviewx').'</h6></td></tr></tbody></table></td></tr></tbody></table>'
                            ), // Default email content
                            'email_preset_placeholder'  => array(
                                'type'      => 'email_presets',
                                'label'     => '',
                                'priority'	=> 7,
                            ),
                            'send_test_email' => array(
                                'type'      => 'send_test_email',
                                'label'     => '',
                                'priority'  => 8,
                            ),
                        )
                    ),
                ))
            ),
            'display_tab' => array(
                'title'         => __('Finalize', 'reviewx'),
                'icon'          => '',
                'sections'      => apply_filters('rx_display_tab_sections', array(
                    'image' => array(
                        'title'    => __('Great Job!', 'reviewx'),
                        'desc'    => __('Your multi criteria based review system is ready to use!', 'reviewx'),
                        'desc1'    => __('Before finishing quick setup you can double-check following of your enabled features.', 'reviewx'),
                        'priority' => 100,
                        'fields'   => array(
                            'show_default_image'  => array(
                                'type'      => 'preview',
                                'label'     => '',
                                'priority'	=> 5,
                            ),

                        )
                    ),

                ))
            ),
        ))
    );
}