<?php

namespace ReviewX\Services\Clocky;

class Clocky
{
	const DEFAULT_FORMAT = 'y-m-d';

	const SUPPORTED_FORMATS = [
		'y-m-d',
		'y-m-d h:i:s'
	];

	private $date;

	/**
	 * @param $date
	 * @param $format
	 * @return bool
	 */
	public static function isValid($date, $format)
	{
		$date = \DateTime::createFromFormat($date,$format);

		// i have no idea if it works.
		if($date && $date->format($format) === $date) {
			return $date->format($format);
		}
		return false;
	}

	/**
	 * @param $date
	 * @param string $format
	 * @param bool $silent
	 * @return bool
	 * @throws \Exception
	 */
	public static function format($date, $format = self::DEFAULT_FORMAT,$silent = true)
	{
		$date = self::isValid($date,$format);

		if(! $date) {
			if($silent) {
				return null;
			}
			throw new \Exception(__('Invalid date.', 'reviewx'));
		}

		if(! in_array($format,self::SUPPORTED_FORMATS)) {
			if($silent) {
				return null;
			}
			throw new \Exception(__('Unsupported format.', 'reviewx'));
		}

		return $date;
	}

}