<?php

namespace ReviewX\Controllers\Admin\Core;

use ReviewX\Controllers\Controller;

/**
 * Class ReviewxMetaBox
 * @package ReviewX\Controllers\Admin\Core
 */
class ReviewxMetaBox extends Controller
{

    public static $args;
    public static $prefix = 'rx_option_';
    public static $object_types;
    public $defaults = array(
        'id'            => '',
        'title'         => '',
        'object_types'  => array(),
        'context'       => 'normal',
        'priority'      => 'low',
        'show_header'   => true,
        'prefix'        => ''
    );

    /**
     * This function is responsible for get all metabox arguments
     *
     * @return array
     */
    public static function get_args()
    {
        if( ! function_exists( 'reviewx_metabox_args' ) ) {
            require_once REVIEWX_INCLUDE_PATH . 'admin/metabox-helper.php';
        }
        do_action( 'rx_before_metabox_load' );
        return reviewx_metabox_args();
    }

    /**
     * @return array
     */
    public static function get_builder_args()
    {
        if( ! function_exists( 'reviewx_builder_args' ) ) {
            require_once REVIEWX_INCLUDE_PATH . 'admin/builder-helper.php';
        }

        do_action( 'rx_before_builder_load' );
        return reviewx_builder_args();
    }

    /**
     * @return array
     */
    public static function get_quick_setup_args()
    {
        if( ! function_exists( 'reviewx_quick_setup_args' ) ) {
            require_once REVIEWX_INCLUDE_PATH . 'admin/builder-quick-setup.php';
        }

        do_action( 'rx_before_builder_load' );
        return reviewx_quick_setup_args();
    }

    /**
     * @return array
     */
    public static function get_review_email_args()
    {
        if( ! function_exists( 'reviewx_review_email_args' ) ) {
            require_once REVIEWX_INCLUDE_PATH . 'admin/builder-review-email.php';
        }

        do_action( 'rx_before_builder_load' );
        return reviewx_review_email_args();
    }

    /**
     * @param string $key
     * @param array $field
     * @param string $value
     * @param null $idd
     * @param bool $is_pro
     */
    public static function render_meta_field( $key = '', $field = [], $value = '', $idd = null, $is_pro = false )
    {
        $attrs = '';
        $name      = self::$prefix . $key;
        $id        = self::get_row_id( $key );
        $file_name = isset( $field['type'] ) ? $field['type'] : '';

        if( 'template' === $file_name ) {
            $default = isset( $field['defaults'] ) ? $field['defaults'] : [];
        } else {
            $default = isset( $field['default'] ) ? $field['default'] : '';
        }

        if( empty( $value ) ) {
            if( get_option( "_{$name}" ) ) {
                $value = get_option( "_{$name}" );           
            } else {  

                $value = $default;

                if( $name == 'rx_option_allow_img' && self::rx_exists_option( '_rx_option_allow_img' ) == false ) {
                    $value = $default;
                } else if( $name == 'rx_option_allow_img' && self::rx_exists_option_blank_value( '_rx_option_allow_img' ) == '' ) {                    
                    $value = get_option( "_{$name}" );
                } 
                
                if( $name == 'rx_option_allow_recommendation' && self::rx_exists_option( '_rx_option_allow_recommendation' ) == false ) {
                    $value = $default;
                } else if( $name == 'rx_option_allow_recommendation' && self::rx_exists_option_blank_value( '_rx_option_allow_recommendation' ) == '' ) {
                    $value = get_option( "_{$name}" );
                }

                if( $name == 'rx_option_disable_auto_approval' && self::rx_exists_option( 'rx_option_disable_auto_approval' ) == false ) {
                    $value = get_option( "_{$name}" );
                }

                if( $name == 'rx_option_allow_review_title' && self::rx_exists_option( '_rx_option_allow_review_title' ) == false ) {
                    $value = $default;
                } else if( $name == 'rx_option_allow_review_title' && self::rx_exists_option_blank_value( '_rx_option_allow_review_title' ) == '' ) {
                    $value = get_option( "_{$name}" );
                }

                if( class_exists('ReviewXPro') ) {

                    if( $name == 'rx_option_allow_video' && self::rx_exists_option( '_rx_option_allow_video' ) == false ) {
                        $value = 1;
                    } else if( $name == 'rx_option_allow_video' && self::rx_exists_option_blank_value( '_rx_option_allow_video' ) == '' ) {                   
                        $value = get_option( "_{$name}" );
                    }

                    if( $name == 'rx_option_allow_anonymouse' && self::rx_exists_option( '_rx_option_allow_anonymouse' ) == false ) {
                        $value = 1;
                    } else if( $name == 'rx_option_allow_anonymouse' && self::rx_exists_option_blank_value( '_rx_option_allow_anonymouse' ) == '' ) { 
                        $value = get_option( "_{$name}" );
                    }  
                    
                    if( $name == 'rx_option_allow_share_review' && self::rx_exists_option( '_rx_option_allow_share_review' ) == false ) {
                        $value = 1;
                    } else if( $name == 'rx_option_allow_share_review' && self::rx_exists_option_blank_value( '_rx_option_allow_share_review' ) == '' ) { 
                        $value = get_option( "_{$name}" );
                    } 
                    
                    if( $name == 'rx_option_allow_like_dislike' && self::rx_exists_option( '_rx_option_allow_like_dislike' ) == false ) {
                        $value = 1;
                    } else if( $name == 'rx_option_allow_like_dislike' && self::rx_exists_option_blank_value( '_rx_option_allow_like_dislike' ) == '' ) { 
                        $value = get_option( "_{$name}" );
                    }
                    
                    if( $name == 'rx_option_allow_multiple_review' && self::rx_exists_option( '_rx_option_allow_multiple_review' ) == false ) {
                        $value = 1;
                    } else if( $name == 'rx_option_allow_multiple_review' && self::rx_exists_option_blank_value( '_rx_option_allow_multiple_review' ) == '' ) { 
                        $value = get_option( "_{$name}" );
                    }                     

                }

            }        
        }

        $default_attr = is_array( $default ) ? json_encode( $default ) : $default;

        if( ! empty( $default_attr ) ) {
            $attrs .= ' data-default="' . esc_attr( $default_attr ) . '"';
        }

        $class  = 'rx-meta-field';
        $row_class = self::get_row_class( $file_name );

        if( isset( $field['toggle'] ) && in_array( $file_name, array( 'checkbox', 'select', 'toggle', 'theme', 'adv_checkbox' ) ) ) {
            $attrs .= ' data-toggle="' . esc_attr( json_encode( $field['toggle'] ) ) . '"';
        }

        if( isset( $field['hide'] ) && $file_name == 'select' ) {
            $attrs .= ' data-hide="' . esc_attr( json_encode( $field['hide'] ) ) . '"';
        }

        if( isset( $field['tab'] ) && $file_name == 'select' ) {
            $attrs .= ' data-tab="' . esc_attr( json_encode( $field['tab'] ) ) . '"';
        }

        include REVIEWX_PARTIALS_PATH . 'admin/field-display.php';
    }


    /**
     * @param string $key
     * @param array $field
     * @param string $value
     * @param null $idd
     * @param bool $is_pro
     */
    public static function render_meta_field_email_setting( $key = '', $field = [], $value = '', $idd = null, $is_pro = false )
    {
        $attrs = '';
        $name      = self::$prefix . $key;
        $id        = self::get_row_id( $key );
        $file_name = isset( $field['type'] ) ? $field['type'] : '';

        if( 'template' === $file_name ) {
            $default = isset( $field['defaults'] ) ? $field['defaults'] : [];
        } else {
            $default = isset( $field['default'] ) ? $field['default'] : '';
        }

        if( empty( $value ) ) {
            if( get_option( "_{$name}" ) ) {
                $value = get_option( "_{$name}" );
            } else {
                $value = $default;
            }
        }

        $default_attr = is_array( $default ) ? json_encode( $default ) : $default;

        if( ! empty( $default_attr ) ) {
            $attrs .= ' data-default="' . esc_attr( $default_attr ) . '"';
        }

        $class  = 'rx-meta-field';
        $row_class = self::get_row_class( $file_name );

        if( isset( $field['toggle'] ) && in_array( $file_name, array( 'checkbox', 'select', 'toggle', 'theme', 'adv_checkbox' ) ) ) {
            $attrs .= ' data-toggle="' . esc_attr( json_encode( $field['toggle'] ) ) . '"';
        }

        if( isset( $field['hide'] ) && $file_name == 'select' ) {
            $attrs .= ' data-hide="' . esc_attr( json_encode( $field['hide'] ) ) . '"';
        }

        if( isset( $field['tab'] ) && $file_name == 'select' ) {
            $attrs .= ' data-tab="' . esc_attr( json_encode( $field['tab'] ) ) . '"';
        }

        include REVIEWX_PARTIALS_PATH . 'admin/email-setting-field-display.php';
    }

    public static function rx_exists_option( $arg ) {

        global $wpdb;
        $db_options = $wpdb->prefix.'options';
        $sql_query  = 'SELECT * FROM ' . $db_options . ' WHERE option_name LIKE "' . $arg . '"';
        $results    = $wpdb->get_results( $sql_query, OBJECT );
        if ( count( $results ) === 0 ) {
            return false;
        } else {
            return true;
        }

    }  
    
    public static function rx_exists_option_blank_value( $arg ) {

        global $wpdb;
        $db_options = $wpdb->prefix.'options';
        $sql_query  = 'SELECT * FROM ' . $db_options . ' WHERE option_name LIKE "' . $arg . '"';
        $results    = $wpdb->get_results( $sql_query, OBJECT );
        if ( count( $results ) === 0 ) {
            return false;
        } else {
            return $results[0]->option_value;
        }

    }    

    /**
     * Get the row id ready
     *
     * @param string $key
     * @return string
     */
    public static function get_row_id( $key )
    {
        return str_replace( '_', '-', self::$prefix ) . $key;
    }

    /**
     * Get the row class
     *
     * @param $file
     * @return string
     */
    public static function get_row_class( $file )
    {
        $prefix = str_replace( '_', '-', self::$prefix );

        switch( $file ) {
            case 'group':
                $row_class = $prefix .'group-row';
                break;
            case 'colorpicker':
                $row_class = $prefix .'colorpicker-row';
                break;
            case 'message':
                $row_class = $prefix . 'info-message-wrapper';
                break;
            case 'theme':
                $row_class = $prefix . 'theme-field-wrapper';
                break;
            default :
                $row_class = $prefix . $file;
                break;
        }

        return $row_class;
    }

    /**
     * @param string $prefix
     * @return mixed|void
     */
    public static function get_metabox_fields( $prefix = '' )
    {
        $args = self::get_args();
        $tabs = $args['tabs'];

        $new_fields = [];

        foreach( $tabs as $tab ) {
            $sections = $tab['sections'];
            foreach( $sections as $section ) {
                $fields = $section['fields'];
                foreach( $fields as $id => $field ) {
                    if( array_key_exists('disabled', $field) && !class_exists('ReviewXPro') ) {
                        continue;
                    }
                    $new_fields[ $prefix . $id ] = $field;
                }
            }
        }

        return apply_filters('rx_meta_fields', $new_fields );
    }

    /**
     * Email settings 
     *
     * @param string $prefix
     * @return void
     */
    public static function get_metabox_review_email_fields( $prefix = '' )
    {
        $args = self::get_review_email_args();
        $tabs = $args['tabs'];

        $new_fields = [];

        foreach( $tabs as $tab ) {
            $sections = $tab['sections'];
            foreach( $sections as $section ) {
                $fields = $section['fields'];
                foreach( $fields as $id => $field ) {
                    $new_fields[ $prefix . $id ] = $field;
                }
            }
        }

        return $new_fields;
    }

    /**
     * Save data
     * @param $posts
     */
    public static function save_data( $posts , $form)
    {
        $mapFields = [
            'settings' => self::get_metabox_fields(),
            'quick_setup' => self::get_metabox_fields(),
            'review_email' => self::get_metabox_review_email_fields()
        ];

        $prefix       = self::$prefix;
        $fields       = $mapFields[$form];
        $data         = [];
        $new_settings = new \stdClass();

        foreach ( $fields as $name => $field ) {

            $field_id   = $prefix . $name;
            $value      = '';

            if ( isset( $posts[$field_id] ) ) {
                $value = \ReviewX_Helper::sanitize_field( $field, $posts[$field_id] );
            } else {
                if ( 'checkbox' == $field['type'] ) {
                    $value = '0';
                }
            }

            update_option( "_{$field_id}", $value );
            $data[ "_{$field_id}" ] = $new_settings->{ $name } = $value;
        }

        if ($posts['rx_builder_from_where'] == "settings") {
            update_option( '_rx_builder_current_tab', $posts['rx_builder_current_tab'] );
        }

        if ($posts['rx_builder_from_where'] == "quick_setup") {
            update_option( '_rx_builder_quick_setup', $posts['rx_builder_current_tab'] );
        }

    }

    /**
     * Get all the meta settings of a notification post
     *
     * @return \stdClass
     */
    public static function get_metabox_settings()
    {
        $fields     = self::get_metabox_fields();
        $prefix     = self::$prefix;
        $settings   = new \stdClass();

        foreach ( $fields as $name => $field ) {
            $field_id   = $prefix . $name;
            $default    = isset( $field['default'] ) ? $field['default'] : '';

            if( isset( $field['type'] ) && $field['type'] == 'template' ) {
                $default    = isset( $field['defaults'] ) ? $field['defaults'] : [];
            }

            if ( get_option( "_{$field_id}" ) ) {
                $value  = get_option( "_{$field_id}" );
            } else {
                $value  = $default;
            }

            $settings->{$name} = $value;
        }

        $settings->{"review_criteria_color"} = get_option( '_rx_option_review_criteria_color' );

        return $settings;
    }

    /**
     * @param $prod_id
     * @param $user_id
     * @param $order_id
     * @return bool
     */
    public static function check_already_reviewed( $prod_id, $user_id, $order_id )
    {
        if ( isset($prod_id) && isset($user_id) ){
            global $wpdb;

            $rx_comment 	    = $wpdb->prefix . 'comments';
            $rx_commentmeta 	= $wpdb->prefix . 'commentmeta';


            $data = $wpdb->get_results( $wpdb->prepare(
                "SELECT DISTINCT $rx_commentmeta.meta_value FROM $rx_commentmeta 
						INNER JOIN $rx_comment 
						ON $rx_commentmeta.comment_id = $rx_comment.comment_ID 
						WHERE $rx_commentmeta.meta_key = 'reviewx_order' 
						AND $rx_commentmeta.meta_value = %d 
						AND $rx_comment.comment_post_ID = %d 
						AND $rx_comment.user_id = %d",
					    //AND ($rx_comment.comment_approved = 1 OR $rx_comment.comment_approved = 0)",
                $order_id, $prod_id, $user_id
            ) );

            if( $data && !empty(current($data)->meta_value) ){
                return true;
            }
        }

        return false;
    }

    /**
     * @param $order_id
     * @param $prod_id
     * @param $user_id
     * @return int
     */
    public static function retrieve_review_id( $order_id, $prod_id, $user_id )
    {
        if ( isset($order_id) && isset($prod_id) && isset($user_id) ) {
            global $wpdb;
            $rx_comment 	    = $wpdb->prefix . 'comments';
            $rx_commentmeta 	= $wpdb->prefix . 'commentmeta';

            $data = $wpdb->get_results( $wpdb->prepare(
                "SELECT DISTINCT $rx_commentmeta.comment_id FROM $rx_commentmeta 
                        INNER JOIN $rx_comment 
                        ON $rx_commentmeta.comment_id = $rx_comment.comment_ID 
                        WHERE $rx_commentmeta.meta_key = 'reviewx_order' 
                        AND $rx_commentmeta.meta_value = %d 
                        AND $rx_comment.comment_post_ID = %d 
                        AND $rx_comment.user_id = %d",
                $order_id, $prod_id, $user_id
            ) );
            if( $data && !empty($data[0]->comment_id) ) {
                return $data[0]->comment_id;
            }
        }
        return 0;
    }
}