<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @since      1.0.0
 *
 */

namespace ReviewX\Controllers\Admin\Core;

use ReviewX\Constants\LockForm;
use ReviewX\Controllers\Admin\Criteria\CriteriaController;
use ReviewX\Controllers\Admin\Email\Editor;
use ReviewX\Controllers\Admin\Email\EmailSettings;
use ReviewX\Controllers\Admin\Email\ReminderEmail;
use ReviewX\Controllers\Controller;
use ReviewX\Modules\OptimisticLock;
use ReviewX\Controllers\Admin\Core\ReviewxMetaBox;
use WC_Order;

if( ! defined( 'ABSPATH' ) ) {
    exit;
}

if( ! class_exists( 'ReviewxAdmin' ) ) {
    /**
     * Class ReviewxAdmin
     * @package ReviewX\Controllers\Admin\Core
     */
    class ReviewxAdmin extends Controller
    {

        /**
         * The ID of this plugin.
         *
         * @since    1.0.0
         * @access   private
         * @var      string    $plugin_name    The ID of this plugin.
         */
        private $plugin_name;

        /**
         * The type.
         *
         * @since    1.0.0
         * @access   public
         * @var string the post type of reviewx.
         */
        public $type = 'reviewx';

        /**
         * Metabox
         *
         * @since    1.0.0
         * @access   public
         * @var string metabox.
         */
        public $metabox;

        /**
         * The plugin option
         *
         * @since    1.0.0
         * @access   public
         * @var string option.
         */
        public static $prefix = 'rx_option_';

        /**
         * The plugin settings
         *
         * @since    1.0.0
         * @access   public
         * @var string settings.
         */
        public static $settings;

        /**
         * The version of this plugin.
         *
         * @since    1.0.0
         * @access   private
         * @var      string    $version    The current version of this plugin.
         */
        private $version;

        /**
         * Initialize the class and set its properties.
         *
         * @since    1.0.0
         * @param      string    $plugin_name       The name of this plugin.
         * @param      string    $version    The version of this plugin.
         */
        public function __construct( $plugin_name, $version )
        {
            $this->plugin_name 	= $plugin_name;
            $this->version 		= $version;

            add_action( 'wp_ajax_save_current_tab', array( $this, 'save_current_tab') );
            add_action( 'wp_ajax_nopriv_save_current_tab', array( $this, 'save_current_tab') );

            add_action( 'wp_ajax_save_review_email_current_tab', array( $this, 'save_review_email_current_tab') );
            add_action( 'wp_ajax_nopriv_save_review_email_current_tab', array( $this, 'save_review_email_current_tab') );            

            add_action( 'wp_ajax_save_quick_setup_current_tab', array( $this, 'save_quick_setup_current_tab') );
            add_action( 'wp_ajax_nopriv_save_quick_setup_current_tab', array( $this, 'save_quick_setup_current_tab') );

            add_action( 'wp_ajax_save_setting_tab', array( $this, 'save_setting_tab') );
            add_action( 'wp_ajax_nopriv_save_setting_tab', array( $this, 'save_setting_tab') );
            
            add_action( 'wp_ajax_rx_send_email', array( $this, 'sendEmail') );

            add_action( 'admin_head', array( $this, 'load_admin_custom_css') );

        }

        /**
         * Register the stylesheets for the admin area.
         *
         * @since    1.0.0
         * @param $hook
         */
        public function admin_enqueue_styles( $hook )
        {

            // if( 'toplevel_page_reviewx-settings' != $hook ) {
            //     return;
            // }

            // wp_enqueue_style( 'wp-color-picker' );
            wp_enqueue_style( $this->plugin_name . '-sweetalert', assets('admin/css/sweetalert2.min.css'), array(), $this->version, 'all' );
            wp_enqueue_style( $this->plugin_name . '-magnific-popup', assets('admin/css/magnific-popup.css'), array(), $this->version, 'all' );
            wp_enqueue_style( $this->plugin_name . '-admin_style', assets('admin/css/rx-admin_style.css'), array(), $this->version, 'all' );
            wp_enqueue_style( $this->plugin_name, assets('admin/css/reviewx-admin.css'), array(), $this->version, 'all' );
        }

        /**
         * * Register the JavaScript for the admin area.
         * @since    1.0.0
         * @param $hook
         */
        public function admin_enqueue_scripts( $hook )
        {
            $is_enable = (
            ! in_array($hook, [
                'toplevel_page_reviewx-settings',
                'reviewx_page_reviewx-all',
                'reviewx_page_reviewx-quick-setup',
            ])
            );

            if( $is_enable ){
                return;
            }

            wp_enqueue_media();
            wp_enqueue_script( 'wp-color-picker' );
            wp_enqueue_script( 'jquery-ui-core' );
            wp_enqueue_script( 'jquery-ui-sortable' );
            wp_enqueue_script( $this->plugin_name . '-sweetalert2-js', assets('admin/js/sweetalert2.all.min.js'), array( 'jquery' ), $this->version, true );
//            wp_enqueue_script( $this->plugin_name . '-canvasjs-js', assets('admin/js/canvasjs.min.js'), array( 'jquery' ), $this->version, true );
            wp_enqueue_script( $this->plugin_name . '-magnific-popup-js', assets('admin/js/jquery.magnific-popup.min.js'), array( 'jquery' ), $this->version, true );
            wp_enqueue_script( $this->plugin_name . '-admin-script', assets('admin/js/reviewx-admin.js'), array( 'jquery' ), $this->version, true );
            $js_filter = apply_filters( 'reviewx_js_filter', array(
                'ajax_admin_url' 			=>  admin_url('admin-ajax.php'),
                'rx_review_text_error' 		=> __( 'Review can\'t be empty', 'reviewx' ),
                'rx_rating_satisfaction' 	=> __( 'Please rate your satisfaction', 'reviewx' ),
                'review_success_title'		=> __( 'Success', 'reviewx' ),
                'review_success_msg'		=> __( 'Settings saved successfully!', 'reviewx' ),
                'review_sending_msg'		=> __( 'Sent successfully!', 'reviewx' ),
                'review_failed_title'		=> __( 'Error', 'reviewx' ),
                'review_failed_msg'			=> __( 'Settings saved fail!', 'reviewx' ),
                'rx_name_error'				=> __( 'Name can\'t be empty', 'reviewx' ),
                'rx_email_error'			=> __( 'Email can\'t be empty', 'reviewx' ),
                'rx_invalid_email_error'	=> __( 'Invalid email', 'reviewx' ),
                'rx_setting_sending'	    => __( 'Sending...', 'reviewx' ),
                'rx_setting_saving'	        => __( 'Saving...', 'reviewx' ),
                'rx_save_setting'	        => __( 'Save', 'reviewx' ),
                'rx_before_email_sent'      => __( 'Save & Send Email', 'reviewx' ),
                'already_review_msg'		=> __( 'This email has already given review on this product', 'reviewx' ),
                'rx_criteria_error'         => __( 'Your product review criteria field is empty', 'reviewx' ),
                'rx_finalize_title'			=> __( 'Good job!', 'reviewx' ),
                'rx_finalize_msg'         	=> __( 'Setup is Complete.', 'reviewx' ),
                'rx_remidner_title'	        => __( 'Warning!', 'reviewx' ),
                'rx_remidner_msg'	        => __( 'A review reminder email will be sent out to your customers for their unreviewed order items.', 'reviewx' ),  
                'rx_btn_cancel_next'	    => __( 'Cancel', 'reviewx' ),
                'rx_btn_email_sent'         => __( 'Send Email', 'reviewx' ),  
                'rx_test_email_title'       => __( 'Test Mail', 'reviewx' ),
                'rx_test_email_message'     => __( 'Test mail sent successfully!', 'reviewx' ),
                'rx_test_email_valid'       => __( 'Email is invalid!', 'reviewx' ), 
                'rx_mail_sent_msg'		    => __( 'Mail Sent successfully!', 'reviewx' ),                               
            ) );
            wp_localize_script( $this->plugin_name . '-admin-script', 'ajax_admin', $js_filter );

        }

        /**
         * Admin Menu Page
         *
         * @return void
         */
        public function menu_page()
        {
            $settings 			 = apply_filters( 'rx_admin_menu', array(
                'reviewx-settings' => array(
                    'title'      => __( 'ReviewX', 'reviewx' ),
                    'capability' => 'delete_users',
                    'callback'   => array( $this, 'settings' )
                )
            ) );

            $this->builder_args = ReviewxMetaBox::get_builder_args();
            $this->metabox_id   = $this->builder_args['id'];
            $flag         		= true;

            /**
             * Add Submit
             */
            if( isset( $_POST[ 'rx_builder_add_submit' ] ) ) :

                if ( ! isset( $_POST[$this->metabox_id . '_nonce'] ) || ! wp_verify_nonce( $_POST[$this->metabox_id . '_nonce'], $this->metabox_id ) ) {
                    $flag = false;
                }

                if( $flag ) {

                    do_action( 'rx_before_builder_submit', $_POST );
                    // saving builder meta data with post
                    ReviewxMetaBox::save_data( $this->builder_data( $_POST ), $_POST['rx_builder_from_where'] );
                    /**
                     * Safely Redirect to WooCommerce order Page
                     */
                    wp_safe_redirect( add_query_arg( array(
                        'post_type' => 'shop_order',
                    ), admin_url( 'edit.php' ) ) );
                }

            endif;

            if( class_exists('woocommerce') ) {
                add_menu_page( 'ReviewX', 'ReviewX', 'delete_users', 'reviewx-settings', '', esc_url(assets('admin/images/ReviewX_dash_icon_white.png')), 80 );
                foreach( $settings as $slug => $setting ) {
                    $cap  = isset( $setting['capability'] ) ? $setting['capability'] : 'delete_users';
                    $hook = add_submenu_page( 'reviewx-settings', "Settings", "Settings", $cap, $slug, $setting['callback'] );
                }
            }

            unset($GLOBALS['submenu']['reviewx-settings'][0]);
        }

        /**
         *
         * @return array
         * @since    1.0.0
         */
        public function settings()
        {
            $builder_args = $this->builder_args;
            $tabs         = $this->builder_args['tabs'];
            $prefix       = self::$prefix;
            $metabox_id   = $this->metabox_id;
            /**
             * This lines of code is for editing a notification in simple|quick builder
             *
             * @var  [type]
             */
            $idd = null;
            if( isset( $_GET['post_id'] ) && ! empty( $_GET['post_id'] ) ) {
                $idd = intval( wp_unslash($_GET['post_id']) );
            }

            include_once REVIEWX_PARTIALS_PATH . 'admin/settings.php';
        }

        /**
         * Quick setup
         *
         * @return void
         * @since    2.0.0
         */
        public function quick_setup()
        {
            
            $this->generateUnsubscribeEmailPage();

            wp_enqueue_style( $this->plugin_name . '-sweetalert', esc_url(assets('admin/css/sweetalert2.min.css')), array(), $this->version, 'all' );
            wp_enqueue_style( $this->plugin_name, esc_url(assets('admin/css/reviewx-admin.css')), array(), $this->version, 'all' );
            wp_enqueue_script( $this->plugin_name . '-sweetalert2-js', esc_url(assets('admin/js/sweetalert2.all.min.js')), array( 'jquery' ), $this->version, true );

            if( ! \ReviewX_Helper::is_pro() ) {
                wp_enqueue_script( $this->plugin_name . '-admin-script', esc_url(assets('admin/js/reviewx-admin.js')), array( 'jquery' ), $this->version, true );
                $js_filter = apply_filters( 'reviewx_js_filter', array(
                    'ajax_admin_url' 			=>  admin_url('admin-ajax.php'),
                    'rx_review_text_error' 		=> __( 'Review can\'t be empty', 'reviewx' ),
                    'rx_rating_satisfaction' 	=> __( 'Please rate your satisfaction', 'reviewx' ),
                    'review_success_title'		=> __( 'Success', 'reviewx' ),
                    'review_success_msg'		=> __( 'Settings saved successfully!', 'reviewx' ),
                    'review_failed_title'		=> __( 'Error', 'reviewx' ),
                    'review_failed_msg'			=> __( 'Settings saved fail!', 'reviewx' ),
                    'rx_name_error'				=> __( 'Name can\'t be empty', 'reviewx' ),
                    'rx_email_error'			=> __( 'Email can\'t be empty', 'reviewx' ),
                    'rx_invalid_email_error'	=> __( 'Invalid email', 'reviewx' ),
                    'rx_setting_sending'	    => __( 'Sending...', 'reviewx' ),
                    'rx_setting_saving'	        => __( 'Saving...', 'reviewx' ),
                    'rx_save_setting'	        => __( 'Save & Next', 'reviewx' ),
                    'rx_before_email_sent'      => __( 'Save & Send Email', 'reviewx' ),
                    'already_review_msg'		=> __( 'This email has already given review on this product', 'reviewx' ),
                    'rx_criteria_error'         => __( 'Your product review criteria field is empty', 'reviewx' ),
					'rx_finalize_title'			=> __( 'Good job!', 'reviewx' ),
                    'rx_finalize_msg'         	=> __( 'Setup is Complete.',  'reviewx' ),
                    'rx_remidner_title'	        => __( 'Warning!', 'reviewx' ),
                    'rx_remidner_msg'	        => __( 'A review reminder email will be sent out to your customers for their unreviewed order items.', 'reviewx' ), 
                    'rx_btn_cancel_next'	    => __( 'Cancel & Next', 'reviewx' ),
                    'rx_btn_email_sent'         => __( 'Send Email', 'reviewx' ), 
                    'rx_test_email_title'       => __( 'Test Mail', 'reviewx' ),
                    'rx_test_email_message'     => __( 'Test mail sent successfully!', 'reviewx' ),
                    'rx_test_email_valid'       => __( 'Email is invalid!', 'reviewx' ),  
                    'rx_mail_sent_msg'		    => __( 'Mail Sent successfully!', 'reviewx' ),             
                ) );
                wp_localize_script( $this->plugin_name . '-admin-script', 'ajax_admin', $js_filter );
            }

            $this->builder_args = ReviewxMetaBox::get_quick_setup_args();

            $builder_args = $this->builder_args;
            $tabs         = $this->builder_args['tabs'];
            $prefix       = self::$prefix;
            $metabox_id   = $builder_args['id'];
            /**
             * This lines of code is for editing a notification in simple|quick builder
             *
             * @var  [type]
             */
            $idd = null;
            if( isset( $_GET['post_id'] ) && ! empty( $_GET['post_id'] ) ) {
                $idd = intval( wp_unslash($_GET['post_id']) );
            }

            include_once REVIEWX_PARTIALS_PATH . 'admin/quick_setup.php';

        }
        


        /**
         * Review Email
         *
         * @return void
         * @since    2.0.0
         */
        public function review_email()
        { 
            $this->generateUnsubscribeEmailPage();

            wp_enqueue_script( 'jquery-ui-core' );
            wp_enqueue_script( 'jquery-ui-sortable' );
            wp_enqueue_style( $this->plugin_name . '-sweetalert', esc_url(assets('admin/css/sweetalert2.min.css')), array(), $this->version, 'all' );
            wp_enqueue_style( $this->plugin_name, esc_url(assets('admin/css/reviewx-admin.css')), array(), $this->version, 'all' );
            wp_enqueue_script( $this->plugin_name . '-magnific-popup-js', esc_url(assets('admin/js/jquery.magnific-popup.min.js')), array( 'jquery' ), $this->version, true );
            wp_enqueue_script( $this->plugin_name . '-sweetalert2-js', esc_url(assets('admin/js/sweetalert2.all.min.js')), array( 'jquery' ), $this->version, true );

            if( ! \ReviewX_Helper::is_pro() ) {
                wp_enqueue_script( $this->plugin_name . '-admin-script', esc_url(assets('admin/js/reviewx-admin.js')), array( 'jquery' ), $this->version, true );
                $js_filter = apply_filters( 'reviewx_js_filter', array(
                    'ajax_admin_url' 			=>  admin_url('admin-ajax.php'),
                    'rx_review_text_error' 		=> __( 'Review can\'t be empty', 'reviewx' ),
                    'rx_rating_satisfaction' 	=> __( 'Please rate your satisfaction', 'reviewx' ),
                    'review_success_title'		=> __( 'Success', 'reviewx' ),
                    'review_success_msg'		=> __( 'Settings saved successfully!', 'reviewx' ),
                    'review_failed_title'		=> __( 'Error', 'reviewx' ),
                    'review_failed_msg'			=> __( 'Settings saved fail!', 'reviewx' ),
                    'rx_name_error'				=> __( 'Name can\'t be empty', 'reviewx' ),
                    'rx_email_error'			=> __( 'Email can\'t be empty', 'reviewx' ),
                    'rx_invalid_email_error'	=> __( 'Invalid email', 'reviewx' ),
                    'rx_setting_sending'	    => __( 'Sending...', 'reviewx' ),
                    'rx_setting_saving'	        => __( 'Saving...', 'reviewx' ),
                    'rx_save_setting'	        => __( 'Save', 'reviewx' ),
                    'rx_before_email_sent'      => __( 'Save & Send Email', 'reviewx' ),
                    'already_review_msg'		=> __( 'This email has already given review on this product', 'reviewx' ),
                    'rx_criteria_error'         => __( 'Your product review criteria field is empty', 'reviewx' ),
					'rx_finalize_title'			=> __( 'Good job!', 'reviewx' ),
                    'rx_finalize_msg'         	=> __( 'Setup is Complete.',  'reviewx' ),
                    'rx_remidner_title'	        => __( 'Warning!', 'reviewx' ),
                    'rx_remidner_msg'	        => __( 'A review reminder email will be sent out to your customers for their unreviewed order items.', 'reviewx' ), 
                    'rx_btn_cancel_next'	    => __( 'Cancel & Next', 'reviewx' ),
                    'rx_btn_email_sent'         => __( 'Send Email', 'reviewx' ),
                    'rx_test_email_title'       => __( 'Test Mail', 'reviewx' ),
                    'rx_test_email_message'     => __( 'Test mail sent successfully!', 'reviewx' ),
                    'rx_test_email_valid'       => __( 'Email is invalid!', 'reviewx' ),
                    'rx_mail_sent_msg'		    => __( 'Mail Sent successfully!', 'reviewx' ),   
                ) );
                wp_localize_script( $this->plugin_name . '-admin-script', 'ajax_admin', $js_filter );
            }

            $this->builder_args = ReviewxMetaBox::get_review_email_args();

            $builder_args = $this->builder_args;
            $tabs         = $this->builder_args['tabs'];
            $prefix       = self::$prefix;
            $metabox_id   = $builder_args['id'];
            /**
             * This lines of code is for editing a notification in simple|quick builder
             *
             * @var  [type]
             */
            $idd = null;
            if( isset( $_GET['post_id'] ) && ! empty( $_GET['post_id'] ) ) {
                $idd = intval( wp_unslash($_GET['post_id']) );
            }

            include_once REVIEWX_PARTIALS_PATH . 'admin/review_email.php';

        }


        /**
         * Genereate Unsubscribe email page
         *
         * @return void
         */
        public function generateUnsubscribeEmailPage()
        {
            \ReviewX\Modules\Activator::setupPages();
            // $url = get_option('_rx_option_unsubscribe_url', null);

            // if (is_null($url) || ! strlen($url)) {
            //     \ReviewX\Modules\Activator::setupPages();
            // } else {
            //     $urlToPostId = url_to_postid($url);

            //     if ($urlToPostId) {
            //         $post = get_post($urlToPostId);
            //         if ($post->post_status !== "publish") {
            //             \ReviewX\Modules\Activator::setupPages();
            //         }
            //     } else {
            //         \ReviewX\Modules\Activator::setupPages();
            //     }

            // }
        }

        /**
         * Generate the builder data acording to default meta data
         *
         * @param array $data
         * @return array
         * @since    1.0.0
         */
        protected function builder_data( $data )
        {
            $post_data   = [];
            $prefix      = self::$prefix;
            $meta_fields = ReviewxMetaBox::get_metabox_fields( $prefix );

            foreach( $meta_fields as $meta_key => $meta_field ) {

                if( in_array( $meta_key, array_keys($data) ) ) {
                     
                    $post_data[ $meta_key ] = $data[ $meta_key ];
                } else {
                    $post_data[ $meta_key ] = '';                 

                    if( isset( $meta_field['defaults'] ) ) {
                        $post_data[ $meta_key ] = $meta_field['defaults'];
                    }

                    if( isset( $meta_field['default'] ) ) {
                        $post_data[ $meta_key ] = $meta_field['default'];

                        if( $meta_key == 'rx_option_allow_img' ){
                            $post_data[ $meta_key ] = '';
                        }
                        
                        if( $meta_key == 'rx_option_allow_recommendation' ){
                            $post_data[ $meta_key ] = '';
                        } 

                        if( class_exists('ReviewXPro') ) {                        
                            if( $meta_key == 'rx_option_disable_auto_approval' ){
                                $post_data[ $meta_key ] = '';
                            }

                            if( $meta_key == 'rx_option_allow_video' ){
                                $post_data[ $meta_key ] = '';
                            }

                            if( $meta_key == 'rx_option_allow_anonymouse' ){
                                $post_data[ $meta_key ] = '';
                            }

                            if( $meta_key == 'rx_option_allow_share_review' ){
                                $post_data[ $meta_key ] = '';
                            }

                            if( $meta_key == 'rx_option_allow_like_dislike' ){
                                $post_data[ $meta_key ] = '';
                            }

                            if( $meta_key == 'rx_option_allow_multiple_review' ){
                                $post_data[ $meta_key ] = '';
                            }

                        }                                        

                        if( $meta_key == 'rx_option_allow_review_title' ){
                            $post_data[ $meta_key ] = '';
                        }
                        
                    }                    
                }
            }

            return array_merge( $post_data, $data );
        }

        /**
         * @param string $query_var
         * @param bool $builder_form
         * @return string|void
         */
        public static function get_form_action( $query_var = '', $builder_form = false )
        {
            $page = '/admin.php?page=rx-settings';

            if( $builder_form ) {
                $page = '/admin.php?page=reviewx-settings';
            }

            if ( is_network_admin() ) {
                return network_admin_url( $page . $query_var );
            } else {
                return admin_url( $page . $query_var );
            }
        }

        /**
         * Save Quick setup current tab
         *
         * @return void
         */
        public function save_quick_setup_current_tab()
        {
            check_ajax_referer( 'special-string', 'security' );
            $current_tab = sanitize_text_field( $_POST['tab'] );
            update_option( '_rx_builder_quick_setup', $current_tab );
            wp_die();
        }

        /**
         * Save current tab
         * @param none
         * @since    1.0.0
         */
        public function save_current_tab()
        {
            check_ajax_referer( 'special-string', 'security' );
            $current_tab = sanitize_text_field( $_POST['tab'] );
            $current_page = sanitize_text_field( $_POST['page'] );
            if( $current_page == 'reviewx-settings' ) {
                update_option( '_rx_builder_current_tab', $current_tab );
            } else if( $current_page == 'reviewx-quick-setup' ) {
                update_option( '_rx_builder_quick_setup', $current_tab );
            }            
            wp_die();
        }

        /**
         * Save settings value
         *
         * @param none
         * @return array
         */
        public function save_setting_tab()
        {
            check_ajax_referer( 'special-string', 'security' );
            $data 				= [];
            $rx_setting_tab_arg = wp_unslash($_POST['rx_tab_field']);
            $rx_tab_arg 		= $this->set_rating_arg( $rx_setting_tab_arg );
            // Below these functions will be activated for next released
            $rx_ctr_key 		= $this->set_ctr_key( $rx_setting_tab_arg );
            $rx_ctr_key_value   = array_combine($rx_ctr_key, $rx_tab_arg);

            foreach ( $rx_setting_tab_arg as $key => $value ) {
                if( $value['name'] == 'rx_option_review_criteria[]' || $value['name'] == 'rx_option_review_criteria_name[]' ) {
                    $data['rx_option_review_criteria'] = $rx_ctr_key_value;
                    continue;
                } else {
                    $data[$value['name']] = $value['value'];
                }
            }

            if ($data['rx_builder_from_where'] == "settings") {
                
                $optFormID = LockForm::SETTINGS;
                if (! OptimisticLock::validate($optFormID, $data)) {
                    OptimisticLock::errorResponse($optFormID);
                }

                (new CriteriaController())->handleAction($data['rx_option_review_criteria']);

            }

            if ($data['rx_builder_from_where'] == "quick_setup") {
                
                $optFormID = LockForm::QUICK_SETUP;
                if (! OptimisticLock::validate($optFormID, $data)) {
                    OptimisticLock::errorResponse($optFormID);
                }

                (new CriteriaController())->handleAction($data['rx_option_review_criteria']);
            }

            if ($data['rx_builder_from_where'] == "review_email") {
                
                if (\ReviewX_Helper::is_pro()) {
                    $this->reviewEmailFields();
                }

                $optFormID = LockForm::REVIEW_EMAIL;
                if (! OptimisticLock::validate($optFormID, $data)) {
                    OptimisticLock::errorResponse($optFormID);
                }
            }

            ReviewxMetaBox::save_data( $this->builder_data( $data ), $data['rx_builder_from_where'] );

            if ($data['rx_builder_current_tab'] == "email_tab") {
                $this->sendEmail(false);
            }

            $success_status = ($data) ? true : false;
            $return = array_merge(array(
                'success' => $success_status,
                'current_tab' => $data['rx_builder_current_tab'],
            ), OptimisticLock::successResponse($optFormID));

            wp_send_json($return);

        }

        /**
         * Return array for rating criteria
         *
         * @param $rating_arg
         * @return array
         */
        public function set_rating_arg( $rating_arg )
        {
            $rating_data = [];
            foreach ( $rating_arg as $key => $value ) {
                if( $value['name'] == 'rx_option_review_criteria[]') {
                    array_push( $rating_data, str_replace( ' ', '-', trim( sanitize_text_field($value['value']) ) ) );
                }
            }

            return $rating_data;
        }

        /**
         * Return array for rating criteria key
         *
         * @param $rating_arg
         * @return array
         */
        public function set_ctr_key( $rating_arg )
        {
            $rating_key = [];
            foreach ( $rating_arg as $key => $value ) {
                if( $value['name'] == 'rx_option_review_criteria_name[]') {
                    array_push( $rating_key, trim( sanitize_text_field($value['value']) ) );
                }
            }

            return $rating_key;
        }

        /**
         * Load custom CSS
         *
         * @param none
         * @return void
         */
        public function load_admin_custom_css()
        {
            include_once REVIEWX_PARTIALS_PATH . 'admin/admin-custom-css.php';
        }       
        
        public function sendEmail($return = true)
        {
            $unreviewdOrderWiseProduct = [];

            (new EmailSettings())->processBulkEmail($unreviewdOrderWiseProduct);

            if (! is_bool($return)) {
                $return  = boolval($_POST['returned']);
            }

            if ($return) {
                wp_send_json(array(
                    'success' => true,
                    'mailed' => $unreviewdOrderWiseProduct,
                ));
            }
        }

        /**
         * Review Email Fields
         *
         * @return void
         */
        public function reviewEmailFields()
        {
            add_filter('rx_reminder_email_settings_sections', function($items) {
				return array(
                    'order_status' => array(
                        'title'  => __('Automatic Reminder Email', 'reviewx'),
                        'fields' => array(
                            'auto_review_reminder' => array(
                                'heading' => __('Auto Review Reminder', 'reviewx'),
                                'label'  => __('', 'reviewx'),
                                'type'  => 'switcher',
                            ), 
                            'get_review_email'  => array(
                                'type'      => 'number',
                                'heading'   => __( 'Days to Wait', 'reviewx' ),
                                'label'     => __('After the order is completed how long \'ReviewX\' should wait to send the review reminder email.', 'reviewx'),
                                'default'   => 5
                            ),
                            // 'filter_products_email'  => array(
                            //     'type'      => 'switcher',
                            //     'heading'     => __('Filter Products', 'reviewx'),
                            //     'default'   => 5
                            // ),
                            // 'filter_products_by' => array(
                            //     'type'    => 'select',
                            //     'heading'   => __( 'Filter by', 'reviewx' ),
                            //     'label'   => __( 'Based on your selection ReviewX will send the review reminder email', 'reviewx' ),
                            //     'options' => array(
                            //         'most_reviewed'     => __( 'Most reviewed product', 'reviewx' ),
                            //         'lowest_reviewed'   => __( 'Lowest reviewed product', 'reviewx' ),
                            //         'highest_price' => __( 'Products with highest price', 'reviewx' ),
                            //         'lowest_price'  => __( 'Products with lowest price', 'reviewx' ),
                            //         'max_quantity'  => __( 'Products with max. quantity', 'reviewx' ),
                            //         'min_quantity'  => __( 'Products with min. quantity', 'reviewx' ),
                            //     ),
                            //     'default'  => 'most_reviewed',
                            // )
                        )
                    ),
                    'allow_utilities' => array(
                        'title'  => __('Other Settings', 'reviewx'),
                        'fields' => array(       
                            'consent_email_subscription' => array(
                                'type' => 'switcher',
                                'heading'   => __('Consent on Checkout Page', 'reviewx'),
                                'label' => __('Allow customers to decide whether they want to receive the review reminder email or not. If you check this box the customer will have a checkbox into their checkout page to decide email consent.', 'reviewx'),
                            ),                     

                            'how_many_email'  => array(
                                'type'      => 'number',
                                'heading'   => __('Email Per Order', 'reviewx'),
                                'label'     => __('Set how many reminder email(s) a customer should receive for single order.', 'reviewx'),
                                'default'   => 5
                            ),
                            'unsubscribe_url' => array(
                                'type'      => 'text',
                                'heading'   => __('Unsubscribe URL', 'reviewx'),
                                'label'     => __('Check the unsubscribe page link. BTW, you are free to modify the page content.', 'reviewx'),
                                'default'   => !empty(get_option('_rx_option_unsubscribe_url') ) ? esc_url( get_option('_rx_option_unsubscribe_url') ) : get_permalink(get_page_by_path('rx-schedule-email-unsubscribe')),
                                'disabled'  => true
                            ),
                        )
                    ), 
                );
			} );
        }

        /**
         * Save Review Email current tab
         * @param none
         * @since    1.0.0
         */
        public function save_review_email_current_tab()
        {
            check_ajax_referer( 'special-string', 'security' );
            $current_tab = sanitize_text_field( $_POST['tab'] );
            update_option( '_rx_review_email_current_tab', $current_tab );
            wp_die();
        }
    }
}