<!-- ReDi Restaurant Booking plugin version <?php echo $this->version ?> -->
<div id="redi_booking_form">
<div id="redi_f_box">
    <br/>
    <br/>
    <input type="hidden" id="placeID" name="placeID" value="<?php echo $places[0]->ID ?>"/>
    <input id="redi-booking-startDateISO" type="hidden" value="<?php echo $startDateISO ?>" name="startDateISO"/>
    <input type="hidden" id="redi-booking-startTimeHidden" value=""/>
   <div class="f_step_box">
         <div class="f_step_box_left_column">

            <div id="tab1" class="f_active_step1">
                <br/>
                <div id="f_check_step1" class="f_check"></div>
                <span class="underline">
                <?php echo esc_html_e( 'STEP 1', 'redi-booking' ); ?><div id="f_arrow1" class="f_arrow_next_step"></div>
            </span>
            </div>
        </div>
        <div class="f_step_box_right_column">
            <div id="tab2" class="f_non_active_step2">
                <br/>
                <div id="f_check_step2" class="f_check"></div>
                <span class="underline">
                <?php echo esc_html_e( 'STEP 2', 'redi-booking' ); ?><div id="f_arrow2" class="f_arrow_next_step"></div>
            </span>
            </div>
        </div>
    </div>
    <div id="redi-booking-div">
        <div id="step1" class="f_tab_box">
            <p>&nbsp;</p>
            <div class="f_subbox_title">
                <table class="redi-table-full-width">
                    <tr>
                        <td class="redi-table-icon-cell">
                            <img src="<?php echo REDI_BOOKING_PLUGIN_URL ?>img/f_name.png"
                                 class="redi-icon" alt="forward icon"/>
                        </td>
                        <td>
                            <span class="f_H2">
                                <?php echo esc_html_e( 'Guests', 'redi-booking' ); ?>
                            </span>
                        </td>
                    </tr>
                </table>
            </div>
            <div class="f_subbox_data">
				<?php
				$fits     = $maxPersons - $minPersons < 8;
				$maxInRow = $fits ? 8 : 7;
				?>
                <table class="redi-table-full-width f_person_data">
                    <tr>
						<?php foreach ( range( $minPersons, $maxPersons - $minPersons <= $maxInRow ? $maxPersons : $minPersons + $maxInRow - 1 ) as $current ): ?>
                            <td class="persons"><?php echo $current ?></td>
						<?php endforeach; ?>
						<?php if ( ! $fits ): ?>
                            <td class="more_persons">
                                <div class="selectBox" data-value="Option 1">
                                    <span id="more">...</span>
                                    <div class="selectOptions">
										<?php foreach ( range( $minPersons + 7, $maxPersons ) as $current ): ?>
                                            <span data-value="<?php echo $current; ?>" class="selectOption persons"><?php echo $current; ?></span>
										<?php endforeach; ?>
                                    </div>
                                </div>
                            </td>
						<?php endif; ?>
						<?php if ( ! empty( $largeGroupsMessage ) ): ?>
                            <td id="large" class="message_for_large_group">
                                <abbr title="<?php echo sprintf( esc_html__( 'More than %s people', 'redi-booking' ), $maxPersons ); ?>">
                                    <span>> </span>
                                </abbr>
                            </td>
						<?php endif ?>
                    </tr>
                </table>
                <div id="large_groups_message"
                     class="redi-booking-alert-info redi-booking-alert">
					<?php echo $largeGroupsMessage ?>
                </div>
            </div>
            <br/>
            <div id="date_selection_box">
            <div class="f_subbox_title">
                <table class="redi-table-full-width">
                    <tr>
                        <td class="redi-table-icon-cell">
                            <img src="<?php echo REDI_BOOKING_PLUGIN_URL ?>img/f_calender.png"
                                 class="redi-icon" alt="calendar"/>
                        </td>
                        <td>
                            <span class="f_H2">
                                <?php echo esc_html_e( 'Date', 'redi-booking' ); ?>
                            </span>
                        </td>
                    </tr>
                </table>
            </div>
            <div id="datepicker"></div>
            <div class="f_subbox_data2">
                <table class="redi-table-full-width f_calender_data">
                    <tr id="dates_row">
						<?php foreach ( $dates as $date ): ?>
                            <td class="<?php if ( $date['selected'] ): ?>select<?php endif ?> date">
                                <input type="hidden" value="<?php echo $date['hidden'] ?>"/>
                                <span class="legend">
                                    <?php echo $date['month'] ?>
                                </span>
                                <br/>
								<?php echo $date['day'] ?>
                                <br/>
								<?php if ( in_array( 'reserved', $date ) ): ?>
                                    <img class="reserve redi-icon" alt="reserve"
                                         src="<?php echo REDI_BOOKING_PLUGIN_URL ?>img/f_reserve.png"/>
								<?php elseif ( in_array( 'closed', $date ) ): ?>
                                    <img class="closed redi-icon" alt="closed date"
                                         src="<?php echo REDI_BOOKING_PLUGIN_URL ?>img/f_closed_date.png"/>
								<?php else: ?>
                                    <span class="legend">
                                <?php echo $date['weekday'] ?>
                            </span>
								<?php endif ?>
                            </td>
						<?php endforeach ?>
                        <td id="more-date-select" class="more_date_select">
                            <input type="hidden" value=""/>
                            <br/>
                            ...
                            <br/>
                        </td>
                    </tr>
                </table>
            </div>
            <br/>
            </div>
            <div id="time_selection_box">
            <div class="f_subbox_title">
                <table class="redi-table-full-width">
                    <tr>
                        <td class="redi-table-icon-cell">
                            <img src="<?php echo REDI_BOOKING_PLUGIN_URL ?>img/f_time.png"
                                 class="redi-icon" alt="time"/>
                        </td>
                        <td>
                            <span class="f_H2">
                                <?php echo esc_html_e( 'Time', 'redi-booking' ); ?>
                            </span>
                        </td>
                    </tr>
                </table>
            </div>
            <div class="f_subbox_data3">
                <div id="step1errors"
                     class="redi-booking-alert-error redi-booking-alert <?php if (!isset( $step1['Error'] ) ): ?> redi-hidden <?php endif; ?>">
                    <img class="img-error" alt="error"
                         src="<?php echo REDI_BOOKING_PLUGIN_URL ?>img/f_error.png"/>
                    <div id="step1errors-div">
						<?php if ( isset( $step1['Error'] ) ): ?>
							<?php echo $step1['Error']; ?>
                            <br class="clear-both"/>
						<?php endif; ?>
                    </div>
                </div>
                <div id="step2busy"
                     class="redi-booking-alert-error redi-booking-alert <?php if (!$all_busy ): ?> redi-hidden <?php endif; ?>">
                     <span>
                        <img alt="error"
                            src="<?php echo REDI_BOOKING_PLUGIN_URL ?>img/f_error.png"/>
                        <?php echo esc_html_e( 'Reservation is not available on selected day. Please select another day.', 'redi-booking' ); ?>
                    </span>
                </div>
                <span id="step1load">
	                <img src="<?php echo REDI_BOOKING_PLUGIN_URL ?>img/loader1.gif" alt="loader"/>
	                </span>
                <table class="f_time_data time" id="buttons">
					
                </table>
            </div>
            <br/>
            </div>
            <div id="buttons_first_step">
                <div class="f_btn" id="next" disabled="disabled">
					<?php echo esc_html_e( 'NEXT', 'redi-booking' ); ?> &nbsp;&gt;
                </div>
            </div>
            <div class="clear-both"></div>
            <br/>
        </div>
        <div id="step2" class="f_tab_box">
            <p>&nbsp;</p>
            <div class="f_text_box"></div>
            <div class="f_text_selection_step2">
                <table class="redi-table-full-width redi-table-summary">
                    <tr>
                        <td>
							<?php echo esc_html_e( 'Guests:', 'redi-booking' ); ?>
                        </td>
                        <td id="persons_view">2</td>
                    </tr>
                    <tr>
                        <td>
							<?php echo esc_html_e( 'Date:', 'redi-booking' ); ?>
                        </td>
                        <td id="date_view">
							
                        </td>
                    </tr>
                    <tr>
                        <td>
							<?php echo esc_html_e( 'Time:', 'redi-booking' ); ?>
                        </td>
                        <td id="time_view">
							
                        </td>
                    </tr>
                </table>
            </div>
            <br/>
            <div class="f_select2">
                <div class="f_input_box">
                    <span class="selectArrow2 required"></span>
                    <input class="text_field" type="text" placeholder="<?php echo esc_html_e( 'name', 'redi-booking' ); ?>" id="UserName"/>
                </div>
            </div>
            <div id="incorrect_name">
                <span class="validation_error">
                    <?php echo esc_html_e( 'Please enter correct name', 'redi-booking' ); ?>
                </span>
            </div>
            <br/>
            <div class="f_select2">
                <div class="f_input_box">
                    <span class="selectArrow3 required"></span>
                    <input class="text_field" type="text" placeholder="<?php echo esc_html_e( 'phone', 'redi-booking' ); ?>"
                           id="UserPhone"/>
                </div>
            </div>
            <div id="incorrect_phone">
                <span class="validation_error">
                    <?php echo esc_html_e( 'Please enter correct phone', 'redi-booking' ); ?>
                </span>
            </div>
            <br/>
            <div class="f_select2">
                <div class="f_input_box">
                    <span class="selectArrow4 required"></span>
                    <input class="text_field" type="text" placeholder="<?php echo esc_html_e( 'e-mail', 'redi-booking' ); ?>" id="UserEmail"/>
                </div>
            </div>
            <div id="incorrect_email">
                <span class="validation_error">
                    <?php echo esc_html_e( 'Please enter correct email', 'redi-booking' ); ?>
                </span>
            </div>
            <br/>
            <div class=" redi-textarea-input f_select2">
                <div class="f_input_box">
                    <span class="selectArrow5 redi-textarea-input"></span>
                    <textarea class="textarea_field redi-textarea-input" placeholder="<?php echo esc_html_e( 'comment', 'redi-booking' ); ?>" id="UserComments"></textarea>
                </div>
            </div>
            <br/>
            <!-- custom fields -->
            <div id="custom_fields_container"></div>		
            <!-- /custom fields -->    
            <br/>
            <div id="step2errors" class="redi-booking-alert-error redi-booking-alert"></div>
            <img id="step2load" src="<?php echo REDI_BOOKING_PLUGIN_URL ?>img/loader3.gif" alt="loader"/>
            <div id="redi-booking-buttons">
                <table>
                    <tr>
                        <td>
                            <div class="f_btn_step back">
                                &lt; &nbsp; <?php echo esc_html_e( 'BACK', 'redi-booking' ); ?>
                            </div>
                        </td>
                        <td class="space-between-buttons"></td>
                        <td>
                            <div id="redi-booking" class="f_btn_step">
								<?php echo esc_html_e( 'MAKE BOOKING', 'redi-booking' ); ?> &nbsp; &gt;
                            </div>
                        </td>
                    </tr>
                </table>
            </div>
            <br/>
            <br/>
        </div>
        <div id="step3" class="f_tab_box">
            <div>
                <br/>
                <p>
                    <div class="f_final_title">
                        <?php esc_html_e( 'Thank you for your booking!', 'redi-booking' ); ?>
                        <br/>
                    </div>
                </p>
                <div class="f_final_text">
                    <p>
                        <?php if ( isset( $manual ) && $manual ): ?>
                            <?php esc_html_e( 'We have received your request and will process it shortly. Please note that your reservation is not confirmed until you receive written confirmation from us.', 'redi-booking' ); ?>
                        <?php else: ?>
                            <?php esc_html_e('A confirmation email has been sent to you, should you not receive it, please rest assured that your booking has been received and is confirmed. If you wish you may contact us by phone to confirm.', 'redi-booking' ); ?>
                        <?php endif ?>
                    </p>
                    <p>
                        <?php esc_html_e('Your reservation number for reference:', 'redi-booking'); ?> <span id="reservation-id"><?php echo number_format($reservation_id, 0, ',', ' ') ?></span>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="redi-cancel-box">
    <div class="f_close_icon">
                    </div>
                    <div class="f_close_icon_text"><?php esc_html_e('If you have an existing reservation, please', 'redi-booking'); ?>
					<a id="cancel-booking" href="#redi_f_box_cancel"><?php esc_html_e('click here to cancel', 'redi-booking'); ?></a>.</div>
</div>
<br class="clear-both"/>
</div>
