<div class="icon32" id="icon-options-general"><br></div>

	<div class="icon32" id="icon-users"><br></div>
	<h2><?php esc_html_e('Restaurant settings', 'redi-booking'); ?></h2>
    <input type="hidden" name="Place" id="Place" value="<?php echo $placeID?>"/>
	<input id="WebAddress" type="hidden" value="<?php echo esc_html($place['WebAddress']) ?>" name="WebAddress"/>

	<table class="form-table">
	    <tr>
			<th scope="row">
				<label for="Name">
					<?php esc_html_e('Restaurant name', 'redi-booking'); ?>
				</label>
			</th>
			<td>
				<input id="Name" type="text" value="<?php echo esc_html($place['Name']) ?>" name="Name"/>
			</td>
			<td class="redi-table-description">
				<p class="description">
					<?php esc_html_e('The name of the restaurant is to be specified here.', 'redi-booking'); ?>
				</p>
			</td>		
		</tr>
		<tr>
			<th scope="row">
				<label for="Country">
					<?php esc_html_e('Country', 'redi-booking'); ?> <span class="redi_required">*</span>
				</label>
			</th>
			<td>
				<select id="Country" name="Country">
					<option value=""> -- <?php esc_html_e('Select Country', 'redi-booking')?> -- </option>
					<?php foreach($redi_countries as $country):?>
					<option value="<?php echo esc_html($country) ?>" <?php if($place['Country']==$country): ?>selected="selected"<?php endif ?>><?php echo esc_html($country) ?></option>
					<?php endforeach ?>
                </select>
			</td>
			<td>
				<p class="description">
					<?php esc_html_e('The country of restaurant can be mentioned here.', 'redi-booking'); ?>
				</p>
			</td>		
        </tr>
		<tr>
			<th scope="row">
				<label for="City">
					<?php esc_html_e('City', 'redi-booking'); ?>
				</label>
			</th>
			<td>
				<input id="City" type="text" value="<?php echo esc_html($place['City']) ?>" name="City"/>
			</td>
			<td>
				<p class="description">
					<?php esc_html_e('The restaurant city is to be specified in this field.', 'redi-booking'); ?>
				</p>
			</td>			
		</tr>
		<tr>
			<th scope="row">
				<label for="Address">
					<?php esc_html_e('Address', 'redi-booking'); ?>
				</label>
			</th>
			<td>
				<input id="Address" type="text" value="<?php echo esc_html($place['Address']) ?>" name="Address"/>
			</td>
			<td>
				<p class="description">
					<?php esc_html_e('Address of the restaurant is to be written here.', 'redi-booking'); ?>
				</p>
			</td>
		</tr>

		<tr>

			<th scope="row">
				<label for="Email">
					<?php esc_html_e('Email', 'redi-booking'); ?>
				</label>
			</th>
			<td>
				<input id="Email" type="text" value="<?php echo esc_html($place['Email']) ?>" name="Email"/>
			</td>
			<td>
				<p class="description">
					<?php esc_html_e('Email address for contacting the restaurant.', 'redi-booking'); ?>
				</p>
			</td>
		
		</tr>
		<tr>
			<th scope="row">
				<label for="EmailCC">
					<?php esc_html_e('Email CC', 'redi-booking'); ?>
				</label>
			</th>
			<td>
				<input id="EmailCC" type="text" value="<?php echo esc_html($place['EmailCC']) ?>" name="EmailCC"/>
			</td>
			<td>
				<p class="description">
					<?php esc_html_e('The email addresses of recipients who should be sent the copies of reservation emails. You can separate multiple recipients using commas.', 'redi-booking'); ?>
				</p>
			</td>		
        </tr>
		<tr>
			<th scope="row">
				<label for="Phone">
					<?php esc_html_e('Phone', 'redi-booking'); ?>
				</label>
			</th>
			<td>
				<input id="Phone" type="text" value="<?php echo esc_html($place['Phone']) ?>" name="Phone"/>
			</td>
			<td>
				<p class="description">
					<?php esc_html_e('The contact number of restaurant. It could have the format [area code] [phone number]', 'redi-booking'); ?>
				</p>
			</td>
		</tr>

		<tr>
			<th scope="row">
				<label for="MinTimeBeforeReservation">
					<?php esc_html_e('Late Bookings', 'redi-booking'); ?>
				</label>
			</th>
			<td>
				<input id="MinTimeBeforeReservation" type="text" value="<?php echo esc_html($place['MinTimeBeforeReservation']) ?>" name="MinTimeBeforeReservation"/>
			</td>
			<td>
				<p class="description">
					<?php esc_html_e('Specify how late customers can make their booking in hours. For example, the current time is 10:00 and this setting is set to 3 hours then the first time, when the reservation will be accepted is 13:00.', 'redi-booking'); ?>
					<br/>
					<?php esc_html_e('NOTE: If you define Open Time in Advanced Settings, then this setting will be ignored. Use open times settings to define Late Bookings.', 'redi-booking'); ?>
				</p>
			</td>
		</tr>
		<tr >
			<th scope="row">
				<label for="services"><?php esc_html_e('Maximum number of guests', 'redi-booking'); ?> </label>
			</th>
			<td>
				<select name="services" id="services">
					<?php foreach(range(1, 500) as $current):?>
						<option value="<?php echo $current?>" <?php if($current == (int)count($getServices)): ?>selected="selected"<?php endif;?>>
							<?php echo $current ?>
						</option>
					<?php endforeach; ?>
				</select>
			</td>
			<td>
				<p class="description">
					<?php esc_html_e('This is the number of maximum persons in restaurant at any time. System will check automatically availability of free seats and will not allow to go beyond this number.', 'redi-booking'); ?></br>
				</p>
			</td>
		</tr>	
		
		<tr >
			<th scope="row">
				<label for="TableFeature"><?php esc_html_e('Use table capacity', 'redi-booking'); ?> </label>
			</th>
			<td>
				<input type="checkbox" name="TableFeature" id="TableFeature" value="1" <?php if (isset($place['TableFeature']) && $place['TableFeature']) echo 'checked="checked"' ?>>
			</td>
			<td>
				<p class="description">
					<?php esc_html_e('When this option is enabled, then total number of guests will be counted based on all table max capacity. Define tables in Advanced settings.', 'redi-booking'); ?></br>
				</p>
			</td>
		</tr>	

	</table>
	<h2><?php esc_html_e('Working time', 'redi-booking'); ?> </h2>
	<table class="form-table">
		<tr >

			<th scope="row">

			</th>
			<td>
				<?php esc_html_e('Open', 'redi-booking'); ?>
			</td>
			<td>
				<?php esc_html_e('Close', 'redi-booking'); ?>
			</td>
		</tr>

		<?php foreach ($this->weekday as $serviceTimeName): ?>
			<?php $serviceTimeValue = isset($serviceTimes[$serviceTimeName]) ? $serviceTimes[$serviceTimeName] : ''; ?>

			<tr >
				<th scope="row">
					<label for="OpenTime[<?php echo esc_html($serviceTimeName) ?>]">
						<?php echo esc_html($serviceTimeName) ?>
					</label>
				</th>
				<td>
					<input id="OpenTime[<?php echo esc_html($serviceTimeName) ?>]" type="text"
							value="<?php echo esc_html(isset($serviceTimeValue['OpenTime'])?$serviceTimeValue['OpenTime']:'') ?>"
							name="OpenTime[<?php echo esc_html($serviceTimeName) ?>]"/>
				</td>
				<td>
					<input id="" type="text" value="<?php echo esc_html(isset($serviceTimeValue['CloseTime'])?$serviceTimeValue['CloseTime']:'') ?>"
							name="CloseTime[<?php echo esc_html($serviceTimeName) ?>]"/>
				</td>
			</tr>
		<?php endforeach ?>
	</table>
	<br/>
	<br/>

	<p class="description">

		<?php esc_html_e('You can specify the working time of restaurant by setting the opening time and closing time for each day of the week.', 'redi-booking'); ?>
		<br/>

		<?php esc_html_e('Specify time in 24h format (00:00 - 23:59).', 'redi-booking'); ?>
		<br/>

		<?php esc_html_e('If you close next day at night then set closing time on a same day. For example 18:00 - 3:00', 'redi-booking'); ?>
		<br/>
		<?php esc_html_e('Set Open and Close fields to blank if restaurant is closed.', 'redi-booking'); ?>
		<br/>
		<?php esc_html_e('Multiple open and close times are available in Advanced Settings.', 'redi-booking'); ?>
	</p>
	<br/>
        <div class="icon32" id="icon-edit-comments"><br></div>
        <h2><?php esc_html_e('Email Configuration', 'redi-booking'); ?></h2>

        <table class="form-table">
                <tr>
                        <th scope="row">
                                <label for="Lang">
                                        <?php esc_html_e('Language', 'redi-booking'); ?>
                                </label>
                        </th>
                        <td>
                                <select name="Lang">
                                <?php foreach ((array)$redi_l10n_sys_locales as $locale): ?>
                                        <option <?php if ($place['Lang'] == $locale['lang-www']): ?> selected="selected" <?php endif ?> value="<?php echo $locale['lang-www'] ?>">
                                                <?php echo $locale['lang-native']; ?>
                                        </option>
                                <?php endforeach ?>
                                </select>
                        </td>
                        <td>
							<p class="description">
								<?php esc_html_e('Language for internal emails communication. It is specially used for admin emails. ', 'redi-booking'); ?><br/>
								<?php esc_html_e('Language for emails of clients depend on the user interface language selected.', 'redi-booking'); ?>
							</p>
						</td>
                </tr>
                <tr >

                        <th scope="row">
                                <label for="DateFormat">
                                        <?php esc_html_e('Date format', 'redi-booking'); ?>
                                </label>
                        </th>
                        <td>
                                <select id="DateFormat" name="DateFormat">
                                        <optgroup label="<?php esc_html_e('Hyphen', 'redi-booking'); ?>">
                                                <option <?php if ($place['DateFormat'] == 'yyyy-MM-dd'): ?> selected="selected" <?php endif ?> value="yyyy-MM-dd">yyyy-mm-dd</option>
                                                <option <?php if ($place['DateFormat'] == 'MM-dd-yyyy'): ?> selected="selected" <?php endif ?> value="MM-dd-yyyy">mm-dd-yyyy</option>
                                                <option <?php if ($place['DateFormat'] == 'dd-MM-yyyy'): ?> selected="selected" <?php endif ?> value="dd-MM-yyyy">dd-mm-yyyy</option>
                                        </optgroup>
                                        <optgroup label="<?php esc_html_e('Dot', 'redi-booking'); ?>">
                                                <option <?php if ($place['DateFormat'] == 'yyyy.MM.dd'): ?> selected="selected" <?php endif ?> value="yyyy.MM.dd">yyyy.mm.dd</option>
                                                <option <?php if ($place['DateFormat'] == 'MM.dd.yyyy'): ?> selected="selected" <?php endif ?> value="MM.dd.yyyy">mm.dd.yyyy</option>
                                                <option <?php if ($place['DateFormat'] == 'dd.MM.yyyy'): ?> selected="selected" <?php endif ?> value="dd.MM.yyyy">dd.mm.yyyy</option>
                                        </optgroup>
                                        <optgroup label="<?php esc_html_e('Slash', 'redi-booking'); ?>">
                                                <option <?php if ($place['DateFormat'] == 'yyyy/MM/dd'): ?> selected="selected" <?php endif ?> value="yyyy/MM/dd">yyyy/mm/dd</option>
                                                <option <?php if ($place['DateFormat'] == 'MM/dd/yyyy'): ?> selected="selected" <?php endif ?> value="MM/dd/yyyy">mm/dd/yyyy</option>
                                                <option <?php if ($place['DateFormat'] == 'dd/MM/yyyy'): ?> selected="selected" <?php endif ?> value="dd/MM/yyyy">dd/mm/yyyy</option>
                                        </optgroup>
                                </select>
                        </td>
                </tr>

        </table>