<?php
if ( ! defined( 'REDI_USER' ) ) {
	define( 'REDI_USER', 'User.svc/' );
}
if ( ! defined( 'REDI_PLACE' ) ) {
	define( 'REDI_PLACE', 'Place.svc/' );
}
if ( ! defined( 'REDI_SERVICE' ) ) {
	define( 'REDI_SERVICE', 'Service.svc/' );
}
if ( ! defined( 'REDI_CATEGORY' ) ) {
	define( 'REDI_CATEGORY', 'Category.svc/' );
}
if ( ! defined( 'REDI_RESERVATION' ) ) {
	define( 'REDI_RESERVATION', 'Reservation.svc/' );
}
if ( ! defined( 'REDI_EMAILCONTENT' ) ) {
	define( 'REDI_EMAILCONTENT', 'emailcontent.svc/' );
}
if ( ! defined( 'REDI_CUSTOMFIELDS' ) ) {
	define( 'REDI_CUSTOMFIELDS', 'CustomFields.svc/' );
}
if ( ! defined( 'REDI_DATES' ) ) {
	define( 'REDI_DATES', 'Date.svc/' );
}
if ( ! defined( 'REDI_POST' ) ) {
	define( 'REDI_POST', 'POST' );
}
if ( ! defined( 'REDI_GET' ) ) {
	define( 'REDI_GET', 'GET' );
}
if ( ! defined( 'REDI_PUT' ) ) {
	define( 'REDI_PUT', 'PUT' );
}
if ( ! defined( 'REDI_DELETE' ) ) {
	define( 'REDI_DELETE', 'DELETE' );
}
if ( ! defined( 'REDI_SUCCESS' ) ) {
	define( 'REDI_SUCCESS', 'SUCCESS' );
}
if ( ! defined( 'REDI_BOOKING_API' ) ) {
	define( 'REDI_BOOKING_API', 'https://api.reservationdiary.eu/service/' );
}

if ( ! defined( 'REDI_CUSTOM_FIELDS' ) ) {
	define( 'REDI_CUSTOM_FIELDS', 6 );
}

if ( ! class_exists( 'ReDiBookingApi' ) ) {
	class ReDiBookingApi {
		private $ApiKey;

		public function __construct( $ApiKey ) {
			$this->ApiKey = $ApiKey;
		}

		public function deleteCustomField( $lang, $placeID, $customFieldID ) {
			return $this->request( REDI_BOOKING_API . REDI_CUSTOMFIELDS . $lang . '/' . $this->ApiKey . '/place/' . $placeID . '/customfield/' . $customFieldID, REDI_DELETE );
		}

		public function updateCustomField( $lang, $placeID, $customFieldID, $params ) {
			return $this->request( REDI_BOOKING_API . REDI_CUSTOMFIELDS . $lang . '/' . $this->ApiKey . '/place/' . $placeID . '/customfield/' . $customFieldID, REDI_PUT,
				json_encode( self::unescape_array( $params ) ) );
		}

		public function saveCustomField( $lang, $placeID, $params ) {
			return $this->request( REDI_BOOKING_API . REDI_CUSTOMFIELDS . $lang . '/' . $this->ApiKey . '/place/' . $placeID, REDI_POST,
				json_encode( self::unescape_array( $params ) ) );
		}

		public function getCustomField( $lang, $placeID ) {
			return $this->request( REDI_BOOKING_API . REDI_CUSTOMFIELDS . $lang . '/' . $this->ApiKey . '/place/' . $placeID, REDI_GET );
		}

		public function getBlockingDates( $lang, $categoryID, $params ) {
			return $this->request( REDI_BOOKING_API . REDI_DATES . $lang . '/' . $this->ApiKey . '/' . $categoryID, REDI_GET, self::strParams( $params ) );
		}

		public function getReservationUrl( $lang ) {
			return '//wp.reservationdiary.eu/' . $lang . '/' . $this->ApiKey . '/Reservation/Index';
		}

		public function getEmailContent( $reservationID, $type, $params ) {
			return $this->request( REDI_BOOKING_API . REDI_EMAILCONTENT . $this->ApiKey . '/' . $reservationID . '/ClientReservation' . $type,
			REDI_GET, self::strParams( $params ) );
		}

		public function cancelReservationByClient( $params ) {
			return $this->request( REDI_BOOKING_API . REDI_RESERVATION .'/v1/'. $this->ApiKey . '/cancelByClient', REDI_DELETE,
				self::strParams( $params ) );
		}

		public function cancelReservation( $params ) {
			return $this->request( REDI_BOOKING_API . REDI_RESERVATION . $this->ApiKey . '/cancelByProvider', REDI_DELETE, self::strParams( $params ) );
		}

		public function createReservation( $categoryID, $params ) {
			return $this->request( REDI_BOOKING_API . REDI_RESERVATION . $this->ApiKey . '/' . $categoryID, REDI_POST,
				json_encode( self::unescape_array( $params ) ) );
		}

		public function confirmReservation( $reservationID, $params) {
			$url = REDI_BOOKING_API . REDI_RESERVATION . $this->ApiKey . '/Approve/' . ((int)$reservationID).$this->strParams( $params );
			return $this->request( $url, REDI_PUT );
		}

		public function query( $categoryID, $params ) {
			return $this->request( REDI_BOOKING_API . REDI_RESERVATION . $this->ApiKey . '/' . $categoryID . '/Person',
			REDI_GET, self::strParams( $params ) );
		}

		public function createCategory( $placeID, $params ) {
			return $this->request( REDI_BOOKING_API . REDI_CATEGORY . $this->ApiKey . '/' . $placeID, REDI_POST,
				json_encode( self::unescape_array( $params ) ) );
		}

		public function getServices( $categoryID ) {
			return $this->request( REDI_BOOKING_API . REDI_SERVICE . $this->ApiKey . '/' . $categoryID . '/Person', REDI_GET );
		}

		public function deleteServices( $categoryID, $quantity ) {
			return $this->request( REDI_BOOKING_API . REDI_SERVICE . $this->ApiKey . '/' . $categoryID . '/person/delete?quantity=' . $quantity,
			REDI_DELETE );
		}
		
		public function setServiceTime( $categoryID, $timeSet ) {
			return $this->request( REDI_BOOKING_API . REDI_CATEGORY . $this->ApiKey . '/' . $categoryID . '/time',
			REDI_PUT,
				json_encode( self::unescape_array( array( 'timeSet' => $timeSet ) ) ) );
		}

		public function getServiceTime( $categoryID ) {
			return $this->request( REDI_BOOKING_API . REDI_CATEGORY . $this->ApiKey . '/' . $categoryID . '/time', REDI_GET);
		}

		public function createService( $categoryID, $params ) {
			return $this->request( REDI_BOOKING_API . REDI_SERVICE . $this->ApiKey . '/' . $categoryID, REDI_POST,
				json_encode( self::unescape_array( $params ) ) );
		}

		public function userGetError() {
			return $this->request( REDI_BOOKING_API . REDI_USER );
		}

		public function createUser( $params ) {
			return $this->request( REDI_BOOKING_API . REDI_USER, REDI_POST, json_encode( self::unescape_array( $params ) ) );
		}

		public function setPlace( $placeID, $params ) {
			return $this->request( REDI_BOOKING_API . REDI_PLACE . $this->ApiKey . '/' . $placeID, REDI_PUT,
				json_encode( self::unescape_array( $params ) ) );
		}

		public function createPlace( $params ) {
			return $this->request( REDI_BOOKING_API . REDI_PLACE . $this->ApiKey, REDI_POST,
				json_encode( self::unescape_array( $params ) ) );
		}

		public function shiftsStartTime( $categoryID, $params ) {
			return $this->request( REDI_BOOKING_API . REDI_CATEGORY . $this->ApiKey . '/' . $categoryID . '/shiftsStartTime',
			REDI_GET, self::strParams( $params ) );
		}

		public function availabilityByDay( $categoryID, $params ) {
			return $this->request( REDI_BOOKING_API . REDI_RESERVATION . $this->ApiKey . '/' . $categoryID . '/availabilityByDay/Person',
			REDI_GET, self::strParams( $params ) );
		}

		public function availabilityByShifts( $categoryID, $params ) {
			return $this->request( REDI_BOOKING_API . REDI_RESERVATION . $this->ApiKey . '/' . $categoryID . '/availabilityByShifts/Person',
			REDI_GET, self::strParams( $params ) );
		}

		public function getPlace( $placeID ) {
			return $this->request( REDI_BOOKING_API . REDI_PLACE . $this->ApiKey . '/' . $placeID, REDI_GET );
		}

		public function getPlaceCategories( $placeID ) {
			return $this->request( REDI_BOOKING_API . REDI_PLACE . $this->ApiKey . '/' . $placeID . '/categories', REDI_GET );
		}

		public function getPlaces() {
			return $this->request( REDI_BOOKING_API . REDI_PLACE . $this->ApiKey, REDI_GET );
		}

		public function setApiKey( $ApiKey ) {
			$this->ApiKey = $ApiKey;
		}

		private static function strParams( $params ) {
			$url_param = '';
			$first     = 0;

			if ( is_array( $params ) ) {
				foreach ( $params as $param_name => $param_value ) {
					$url_param .= ( ( $first ++ == 0 ) ? '?' : '&' ) . $param_name . '=' . $param_value;
				}
			}

			return $url_param;
		}

		private static function unescape_array( $array ) {
			$unescaped_array = array();
			foreach ( $array as $key => $val ) {
				if ( is_array( $val ) ) {
					$unescaped_array[ $key ] = self::unescape_array( $val );
				} else {
					$unescaped_array[ $key ] = stripslashes( $val );
				}
			}

			return $unescaped_array;
		}


		private function request( $url, $method = REDI_GET, $params_string = null ) {
			$request = new WP_Http;
			$curTime = microtime( true );
			$req     = array(
				'method'  => $method,
				'body'    => (($method === REDI_GET || $method === REDI_DELETE ) ? null : $params_string),
				'headers' => array(
					'Content-Type'   => 'application/json; charset=utf-8',
					'Content-Length' => ($method === REDI_GET || $method === REDI_DELETE ) ? 0 : strlen( $params_string )
				)
			);
			$output  = $request->request(
				$url . ( ( $method === REDI_GET || $method === REDI_DELETE ) ? $params_string : '' ), $req );
			if ( is_wp_error( $output ) ) {
				return array(
					'request_time' => round( microtime( true ) - $curTime, 3 ) * 1000,
					'Error'        => esc_html_e( 'Online reservation service is not available at this time. Try again later or contact us directly.',
						'redi-booking' ),
					'Wp-Error'     => $output->errors
				);
			}
		if ( $output['response']['code'] != 200 && $output['response']['code'] != 400 ) {
				return array(
					'Error' => esc_html_e( 'Online reservation service is not available at this time. Try again later or contact us directly.',
						'redi-booking' )
				);
		}
			$output = $output['body'];

			// convert response
			$output = (array) json_decode( $output );

			return $output;
		}
	}
}
