"use strict";

jQuery(function () {
    if (typeof(datepicker_locale) != "undefined" && jQuery.datepicker.regional[datepicker_locale] !== undefined) {
        jQuery.datepicker.setDefaults(jQuery.datepicker.regional[datepicker_locale.substring(0, 2)]);
    }
    else {
        jQuery.datepicker.setDefaults(jQuery.datepicker.regional['']);
    }

    jQuery.datepicker.setDefaults({
        beforeShow: function(input, obj)
        {
            jQuery(input).prop('readonly', 'readonly');
        },
        onClose: function () 
        {
            jQuery(this).prop('readonly', false);
        }});    
});

function show_cancel_booking_form () {
    jQuery('#redi_f_box_cancel').show();
    jQuery('#redi_booking_form').slideUp();
};

jQuery(window).on("load", function () {

    if (Object.values(location.hash.split('?')).indexOf('#cancel') > -1) {
        jQuery('#redi-booking-cancelID').val(getParameterByName("reservation"));
        jQuery('#redi-booking-cancelEmail').val(getParameterByName("personalInformation"));
        show_cancel_booking_form();
    }
});

function getParameterByName(name) {
    var match = RegExp('[?&]' + name + '=([^&]*)').exec(window.location.hash);
    return match && decodeURIComponent(match[1].replace(/\+/g, ' '));
}


(function ($) {
   var calendar_select = function () {
        $('.date').each(function () {
            $(this).removeClass('select');
        });
        $(this).addClass('select');
        $('#time_selection_box').show();
        step1call($(this).children('input').val());
    };
    /* new calendar select */
    $('td.date').on('click', calendar_select);

    /* new persons select */
    $('.persons').on('click', function () {
        $('.persons').each(function () {
            $(this).removeClass('select');
        });
        $('.more_persons').removeClass('select');

        $('#persons_view').html($(this).addClass('select').html());// update viewbox
        if (!($(this).hasClass('message_for_large_group') || $(this).hasClass('more_persons'))
        ) { // no API call if large group message is selected
            $('#large_groups_message').slideUp();
            $('#date_selection_box').show();
            step1call($('.date.select > input[type="hidden"]').val());
        }
        $('.selectOptions').hide();
    });

    $('.more_persons').on('click', function () {
        $('.selectOptions').show();
    });

    $('.selectOption').on('click', function (e) {
        $('#more').html($(this).attr('value'));
        $('.more_persons').addClass('select');
        $('.selectOptions').hide();
        e.stopImmediatePropagation();
    });

    $.datepicker.setDefaults({ 
        beforeShowDay: function (date) {
            let d = jQuery.datepicker.formatDate('yy-mm-dd', date);

            for (let i = 0; i < disabled_dates.length; i++)
            {
                if (disabled_dates[i].date == d)
                {   
                    return [false, '', disabled_dates[i].reason];
                }
            }        

            return [true, '', ''];
        }
        ,
        minDate: new Date(),
        maxDate: maxDate
    });

    $('#more-date-select').on('click', function () {
        $('#datepicker').datepicker('dialog', null,
            //on Select Date
            function () {
                var selectedDate = moment($(this).datepicker('getDate')).set('hour', 0).set('minute', 0).set('second', 0);
                var current = moment(selectedDate);
                var now = moment().set('hour', 0).set('minute', 0).set('second', 0);
                var isToday = now.startOf('day').isSame(selectedDate.startOf('day'));
                var start = 0;
                if (!isToday) {
                    var dayDiff = selectedDate.diff(now, 'days');
                    start = dayDiff > 3 ? 3 : dayDiff;
                }
                var startDate = moment(selectedDate.add(-start, 'days'));

                //remove all .date columns except datepicker
                $('.date').each(function () {
                    $(this).remove();
                });
                startDate = startDate.add(7, 'days');
                //add new dates
                for (var i = 0; i != 7; i++) {
                    startDate = startDate.add(-1, 'days');
                    var new_element = $('<td>')
                        .addClass('date')
                        .append('<input type="hidden" value="' + startDate.format('YYYY-MM-DD') + '"/>' +
                            '<span class="legend">' + startDate.format('MMM') + ' </span>' +
                            '<br/>' + startDate.format('DD') + '<br/>' +
                            '<span class="legend">' + startDate.format('ddd') + '</span>'
                        );
                    $('#dates_row').prepend(new_element);

                    new_element.on('click', calendar_select);// should work without it
                    //select new added date
                    if (current.isSame(startDate)) {
                        new_element.click();
                    }
                }
            });

        $('html, body').animate({ scrollTop: $("#more-date-select").offset().top - 150 }, 'slow');

        return false;
    });

    /* step1 > step2 */
    $('#next').on('click', function (event) {
        if ($(this).attr('disabled')) return;

        getCustomFields();

        //check if everything is selected
        $('#tab1').removeClass('f_active_step1').addClass('f_non_active_step1');
        $('#tab2').removeClass('f_non_active_step2').addClass('f_active_step2');
        $('#step1').hide();
        $('#f_check_step1').show();
        $('#f_check_step1').css('display', 'inline-block');
        $('#step2').show();
        $('#f_arrow1').hide();
        $('#f_arrow2').show();
        $('#f_arrow2').css('display', 'inline-block');
        $('#step2errors').hide();
        event.preventDefault();
    });

    /* step2 > step1 */
    $('.back').on('click', function (event) {
            go_back_to_step1(event);
    });

    $('#back_to_booking').on('click', function()
        {
            $('#redi_booking_form').slideDown();
            $('#redi_f_box_cancel').hide();
            $('html, body').animate({ scrollTop: $("#redi_booking_form").offset().top - 150 }, 'slow');
        });

    function go_back_to_step1(event){
        $('#step1').show();
        $('#step2').hide();

        $('#tab2').removeClass('f_active_step2').addClass('f_non_active_step2');
        $('#tab1').removeClass('f_non_active_step1').addClass('f_active_step1');

        $('#f_arrow2').hide();
        $('#f_arrow1').show();

        $('#f_check_step1').hide();
        $('#redi-booking-buttons').show();
        $('#step3').hide();

        event.preventDefault();
    }

    $('#tab1').on('click', function(event){

        go_back_to_step1(event);
    });

    function hideSteps() {
        $('#step2').hide('slow'); // if user clicks again first button we hide the other steps
        $('#step3').hide('slow');
        if (hidesteps) {
            $('#step1busy').hide();
        }
    }

    var updateTime = function () {
        $('#redi-booking-startTime').val($('#redi-booking-startHour').val() + ':' + $('#redi-booking-startMinute').val());
        hideSteps();
    };

    $('#large').on('click', function () {
        $('#large_groups_message').show();
    });

    $('#redi-booking-startHour').change(updateTime);
    $('#redi-booking-startMinute').change(updateTime);
    $('#persons').change(function () {
        if ($(this).val() === 'group') {
            $('#step1button').attr('disabled', true);
            $('#large_groups_message').show('slow');
        }
        else {
            $('#step1button').attr('disabled', false);
            $('#large_groups_message').hide('slow');
        }
        var start_date = $('#redi-booking-startDate').datepicker('getDate');
        var day1 = start_date.getDate();
        var month1 = start_date.getMonth() + 1;
        var year1 = start_date.getFullYear();
        var fullDate = year1 + '-' + month1 + '-' + day1;
        
            step1call(fullDate);
        
    });

    $('#redi-booking-startDate').change(function () {
        var start_date = $('#redi-booking-startDate').datepicker('getDate');
        var day1 = start_date.getDate();
        var month1 = start_date.getMonth() + 1;
        var year1 = start_date.getFullYear();
        var fullDate = year1 + '-' + month1 + '-' + day1;

        $('#redi-booking-startDateISO').val(fullDate);
    });

    $(document).on('click', '.redi-restaurant-time-button', function (event) {
        if ($(this).attr('disabled')) {
            return;
        }

        $('.redi-restaurant-time-button').each(function () {
            $(this).removeClass('select');
        });
        $(this).addClass('select');
        $('#next').attr('disabled', false);

        var startTime = $(this).children('input').val();
        $('#redi-booking-startTimeHidden').val(startTime);
        $('#redi-booking-startDateISO').val(startTime);

        $('#date_view').html($.datepicker.formatDate(date_format, moment(startTime).toDate())); //using moment to parse and datePicker to properly format
        $('#time_view').html($(this).html());
        if (hidesteps) {
            $('#step2').hide();
        }
        $('#UserName').focus();
        return false;
    });

    $('#redi-booking').on('click', function () {
        var error = false;
        if ($('#UserEmail').val() === '' || !validateEmail($('#UserEmail').val())) {
            $('#UserEmail').addClass('form_validation_error');
            $('#incorrect_email').show();
            $('#UserEmail').focus();
            error = true;
        }
        else {
            $('#UserEmail').removeClass('form_validation_error');
            $('#incorrect_email').hide();
        }
        if ($('#UserPhone').val() === '') {
            $('#UserPhone').addClass('form_validation_error');
            $('#incorrect_phone').show();
            $('#UserPhone').focus();
            error = true;
        }
        else {
            $('#UserPhone').removeClass('form_validation_error');
            $('#incorrect_phone').hide();
        }
        if ($('#UserName').val() === '') {
            $('#UserName').addClass('form_validation_error');
            $('#incorrect_name').show();
            $('#UserName').focus();
            error = true;
        }
        else {
            $('#UserName').removeClass('form_validation_error');
            $('#incorrect_name').hide();
        }

        $('.field_required').each(function () {
            
            if ($(this).attr('type') === 'checkbox' && !$(this).prop('checked') || $(this).attr('type') === 'text' && $(this).val() === '') {
                $('#' + this.id + '_message').show();
                $('#' + this.id).addClass('form_validation_error');
                error = true;
            } 
            else if ($(this).attr('type') === 'radio') 
            {
                if (!jQuery('input[type="radio"]:checked').val()) 
                {              
                    error = true;
                    $('#' + this.name + '_message').show();
                }
            }
            else if ($(this).prop("tagName") === 'SELECT') 
            {
                if ($(this).children("option:selected").val() == "")
                {
                    $('#' + this.id + '_message').show();
                    $('#' + this.id).addClass('form_validation_error');
                    error = true;
                }
            }
            else {
                $('#' + this.id + '_message').hide();
                $('#' + this.id).removeClass('form_validation_error');
            }
        });
        if (error) {
            return false;
        }
        var data = {
            action: 'redi_booking_submit',
            get: 'step3',
            startDate: $('#redi-booking-startDateICO').val(),
            startTime: $('#redi-booking-startTimeHidden').val(),
            persons: $('.f_person_data').find('.select.persons').html(),
            UserName: $('#UserName').val(),
            UserEmail: $('#UserEmail').val(),
            UserComments: $('#UserComments').val(),
            UserPhone: $('#UserPhone').val(),
            placeID: $('#placeID').val(),
            lang: locale,
            apikeyid: apikeyid
        };

        var custom_fields = jQuery("[name^='field_']");

        for (var index = 0; index < custom_fields.length; ++index)
        {
			if (jQuery(custom_fields[index]).attr('type') === 'checkbox') {
                if(jQuery(custom_fields[index]).is(':checked')) {
                    data[custom_fields[index].id] = 'on';
                }
            }else if (jQuery(custom_fields[index]).attr('type') === 'radio') {

                if(jQuery(custom_fields[index]).is(':checked')) {
                    data[jQuery(custom_fields[index]).attr('name')] = jQuery(custom_fields[index]).val();
                }
            } else {
                data[custom_fields[index].id] = jQuery(custom_fields[index]).val();
            }
        }
        
        $('#step2load').show();
        $('#redi-booking-buttons').hide();
        $('#step2errors').hide('slow');
        $('#redi-booking-step3').attr('disabled', true);

        $.post(redi_booking.ajaxurl, data, function (response) {
            $('#redi-booking-step3').attr('disabled', false);
            $('#step2load').hide();
            if (response['Error']) {
                $('#step2errors').html(response['Error']).show('slow');
                $('#redi-booking-buttons').show();
            } else {
                //complete step
                ga_event('Reservation confirmed', '');
                
                if (payment)
                {
                    jQuery(location).attr('href', document.URL + '?action=booking-confirmation&quantity=' + data.persons+'&id='+response['ID']+'&lang='+
                    locale+'&startdate='+jQuery('#redi-booking-startDateISO').val());
                }
                else
                {
                    $('#step1').hide('slow');
                    $('#step2').hide();
                    $('#step3').show(); //success message
                    $('#f_check_step2').show();
                    $('#f_check_step2').css('display', 'inline-block');
                    $('html, body').animate({ scrollTop: $("#redi_booking_form").offset().top - 150}, 'slow');
                    $('#reservation-id').html(addSpace(response['ID']));
                    $('#f_arrow2').hide();
                    $('#tab2').removeClass('f_active_step2').addClass('f_non_active_step2');
                }
            }
        }, 'json');
        return false;
    });

    $('#step1button').on('click', function () {
        step1call();
        return false;
    });

    $('#placeID').change(function () {
        if (hidesteps) {
            $('#step1buttons').hide('slow');
        }
        $('#step2').hide('slow'); // if user clicks again first button we hide the other steps
        $('#step1errors').hide('slow');
    });

    function addSpace(n) {
        var rx = /(\d+)(\d{3})/;
        return String(n).replace(/^\d+/, function (w) {
            while (rx.test(w)) {
                w = w.replace(rx, '$1 $2');
            }
            return w;
        });
    }

    function step1call(fullDate) {

        if (typeof fullDate === 'undefined')
        {
            return;
        }

        hideSteps();

        $('#next').attr('disabled', true);
        var persons = $('.f_person_data').find('.select.persons').html();
        $('#persons_view').html(persons);
        $('#redi-booking-startDateISO').val(fullDate);
        //update view display

        $('#step2').hide('slow'); // if user clicks again first button we hide the other steps
        $('#step1load').show();
        $('#step2busy').hide();
        $('#buttons').hide();
        $('#step1errors').hide('slow');
        if (hidesteps) {
            $('#step1times').hide();
        }
        var data = {
            action: 'redi_booking_submit',
            get: 'step1',
            placeID: $('#placeID').val(),
            startTime: $('#redi-booking-startTime').val(),
            startDateISO: fullDate,
            persons: persons,
            lang: locale,
            apikeyid: apikeyid
        };

        $.post(redi_booking.ajaxurl, data, function (response) {
            $('#step1load').hide();
            $('#step2busy').hide();
            $('#step1button').attr('disabled', false);
            $('#buttons').html('');
            if (response['Error']) {
                $('#step1errors-div').html(response['Error']);
                $('#step1errors').show('slow');
            } else {
                if (hidesteps) {
                    $('#step1times').show();
                }
                    $('#buttons').show();

					var all_busy = true;

                    var step1buttons_html = '';
					$('#step1buttons_html').html(step1buttons_html).hide();
					for (var availability in response) {
						if (response[availability] !== undefined || response[availability]['Name'] !== undefined) {
							
							if (typeof(response[availability]) == "function") continue;
							
							var html = '<tr><td colspan="4" class="redi-restaurant-shift-name">' + response[availability].Name + "</td></tr>";
							var current = 0;
							for (var current_button_index in response[availability]['Availability']) {
								if (typeof(response[current_button_index]) == "function") continue;
								var b = response[availability]['Availability'][current_button_index];
								current++;
								if (current == 1) {
									html += '<tr>';
								}

								html += '<td class="redi-restaurant-time-button ' + (b['Select'] ? 'select' : '') + '" ' + (b['Available'] ? '' : 'disabled="disabled"') + '>';
								html += '<input type="hidden" value="' + b['StartTimeISO'] + '"/>';
								html += b['StartTime'];
								html += '</td>';
								if (current == 4) {
									current = 0;
									html += '</tr>';
								}
								if (b['Available']) all_busy = false;
							}
							$('#buttons').append(html);
						}
					}
					$('#step1buttons').html(step1buttons_html).show();
					display_all_busy(all_busy);
                    
                $('#UserName').focus();
                $('#redi-booking-startTimeHidden').val(response['StartTimeISO']);
            }
        }, 'json');
    }

    function display_all_busy(display) {
        if (display) {
            if (hidesteps) {
                $('#step1busy').show();
                $('.available').each(function () {
                    $(this).attr('disabled', true);
                });
            } else {
                $('#step2busy').show();
                $('#buttons').hide();
            }
        } else {
            $('#step2busy').hide();
            if (hidesteps) {
                $('#step1busy').hide();

                $('.available').each(function () {
                    $(this).attr('disabled', false);
                });
            } else {
                $('#step2busy').hide();
            }
        }
    }

    function ga_event(event, comment) {
        if (typeof _gaq !== 'undefined') {
            _gaq.push(['_trackEvent', 'ReDi Restaurant Reservation', event, comment]);
        }
    }

    $('#cancel-booking').on('click', function(){show_cancel_booking_form();});
        
    // cancel booking
    $('#redi-booking-cancel').on('click', function () {
        var error = false;
        if ($('#redi-booking-cancelID').val() === '') {
			error = true;
			$('#cancel-incorrect-id').show();
        }
		else{
			$('#cancel-incorrect-id').hide();
		}
        if ($('#redi-booking-cancelEmail').val() === '') {
			error = true;
			$('#cancel-incorrect-email').show();
        }else{
			$('#cancel-incorrect-email').hide();
		}
        if ($('#redi-booking-cancelReason').val() === '') {
			error = true;
			$('#cancel-incorrect-reason').show();
        }else{
			$('#cancel-incorrect-reason').hide();
		}
        if (error) {
            return false;
        }
        //Ajax
        var data = {
            action: 'redi_booking_submit',
            get: 'cancel',
            ID: $('#redi-booking-cancelID').val(),
            PersonalInformation: $('#redi-booking-cancelEmail').val(),
            Reason: $('#redi-booking-cancelReason').val(),
            lang: locale
        };
        $('#cancel-errors-div').slideUp();
        $('#cancel-success').slideUp();
        $('#cancel-load').show();
        $('#redi-booking-cancel').attr('disabled', true);
        $.post(redi_booking.ajaxurl, data, function (response) {
            $('#redi-booking-cancel').attr('disabled', false);
            $('#cancel-load').hide();
            if (response['Error']) {
                $('#cancel-errors-div').slideDown(function(){
                    $('#cancel-errors').html(response['Error']).show('slow');
                });
            } else {
                $('#cancel-success').slideDown();
                $('#step1cancel').hide();
                $('html, body').animate({ scrollTop: $("#redi_f_box_cancel").offset().top - 150}, 'slow');
                $('#step2cancel').show();
                $('#f_check_step1_cancel').show();
                $('#f_check_step1_cancel').css('display', 'inline-block');
                //clear form
                $('#redi-booking-cancelID').val('');
                $('#redi-booking-cancelEmail').val('');
                $('#redi-booking-cancelReason').val('');
            }
        }, 'json');
        return false;
    });

    $('.available').on('click', function (event) {
        event.preventDefault();
        $('#step1').hide();
        $('#step2').show();
        $('#open' + this.id).show();
    });

    $('#step2prev').on('click', function (event) {
        event.preventDefault();
        $('#step1').show();
        $('#step2').hide();
    });
    function validateEmail($email) {
        var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
        return emailReg.test($email);
    }
})(jQuery);