<?php
class RF_Rich_Snippet extends Rating_Form {

	private $parent;

	function __construct( $parent ) {
		$this->parent = $parent;
	}

	function setParent( $parent ) {
		$this->parent = $parent;
	}

	function getParent() {
		return $this->parent;
	}

	function output() {
		// Rating result array for filter
		$rating_form_info = array();
		$rating_form_info['form_id'] = $this->getParent()->getDivID() . 'MD';
		// Default type
		$rating_form_info['average'] = $this->getParent()->getAverage();
		$rating_form_info['max'] = $this->getParent()->getOption('max');
		$rating_form_info['count'] = $this->getParent()->getCount();
		// Other types
		if ($this->getParent()->isType('tud') && $this->getParent()->getCount() > 0) {
			$rating_form_info['average'] = round((($this->getParent()->getUpCount()*5+$this->getParent()->getDownCount()) / $this->getParent()->getCount()), 1);
			$rating_form_info['max'] = 5;
		}

		// Post Data
		$post_info = get_post( $this->getParent()->getArgument('post_id') );
		$remove_item_type = (!$this->getParent()->getOption('remove_rs_itemtype') && !( is_home() || is_front_page() ));

		// Begin Markup
		$structuredData = '<div class="rf_rich_snippet">'."\n";
		// Structure: Microdata
		if ($this->getParent()->isSchemaType('microdata')) {
			if ($remove_item_type) {
				$structuredData .= '<meta itemprop="headline" content="' . trim(strip_tags($post_info->post_title)) . '" />'."\n";
				$structuredData .= '<meta itemprop="datePublished" content="' . mysql2date( 'c', $post_info->post_date, false ) . '" />'."\n";
				$structuredData .= '<meta itemprop="dateModified" content="' . mysql2date( 'c', $post_info->post_modified, false ) . '" />'."\n";
				$structuredData .= '<meta itemprop="url" content="' . get_permalink( $post_info->ID ) . '" />'."\n";
				$structuredData .= '<div itemprop="author" itemscope="itemscope" itemtype="https://schema.org/Person">'."\n";
				$structuredData .= '<meta itemprop="name" content="' . get_the_author() . '" />'."\n";
				$structuredData .= '</div>'."\n";
				$structuredData .= '<meta itemprop="mainEntityOfPage" itemscope="itemscope" itemid="' . get_permalink( $post_info->ID ) . '" itemtype="http://schema.org/WebPage" />'."\n";
				// Image
				if( has_post_thumbnail($post_info->ID) ) {
					// Post Image
					$thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( $post_info->ID ), 'full' );
					if( ! empty( $thumbnail ) ) {
						$structuredData .= '<div style="display: none;" itemprop="image" itemscope itemtype="https://schema.org/ImageObject">'."\n";
						$structuredData .= '<meta itemprop="url" content="' . $thumbnail[0] . '" />'."\n";
						$structuredData .= '<meta itemprop="width" content="' . $thumbnail[1] . '" />'."\n";
						$structuredData .= '<meta itemprop="height" content="' . $thumbnail[2] . '" />'."\n";
						$structuredData .= '</div>'."\n";
					}
				}
				// Publisher
				$site_logo = '' . "\n";
				$site_logo_width = '';
				$site_logo_height = '';
				if ( function_exists( 'the_custom_logo' ) ) {
					$custom_logo_id = get_theme_mod( 'custom_logo' );
					if ( $custom_logo_id ) {
						$size = get_theme_support( 'custom-logo' );
						$custom_logo = wp_get_attachment_image_src( $custom_logo_id );
						$site_logo = $custom_logo[0];
						$site_logo_width = $size[0]['width'];
						$site_logo_height = $size[0]['height'];
					}
				}
				if( empty( $site_logo ) ) {
					if( has_header_image() ) {
						$header_image = get_header_image();
						if( ! empty( $header_image ) ) {
							$site_logo = $header_image;
						}
					}
				}
				$site_logo = apply_filters( 'rating_form_site_logo', $site_logo );
				$structuredData .= '<div style="display: none;" itemprop="publisher" itemscope itemtype="https://schema.org/Organization">'."\n";
				$structuredData .= '<meta itemprop="name" content="' . get_bloginfo( 'name' ) . '" />'."\n";
				$structuredData .= '<div itemprop="logo" itemscope itemtype="https://schema.org/ImageObject">'."\n";
				$structuredData .= '<meta itemprop="url" content="' . $site_logo . '" />'."\n";
				$structuredData .= '</div>'."\n";
				$structuredData .= '</div>'."\n";
			}

			if( $rating_form_info['average'] > 0 ) {
				$structuredData .= '<div style="display: none;" itemprop="aggregateRating" itemscope itemtype="http://schema.org/AggregateRating">'."\n";
				if (( is_home() || is_front_page() )) $structuredData .= '<div itemprop="name" />' . get_bloginfo( 'name' ) . '</div>'."\n";
				$structuredData .= '<meta itemprop="bestRating" content="' . $rating_form_info['max'] . '" />'."\n";
				$structuredData .= '<meta itemprop="worstRating" content="1" />'."\n";
				$structuredData .= '<meta itemprop="ratingValue" content="' . $rating_form_info['average'] . '" />'."\n";
				$structuredData .= '<meta itemprop="ratingCount" content="' . $rating_form_info['count'] . '" />'."\n";
				if (( is_home() || is_front_page() )) $structuredData .= '<div itemprop="itemReviewed" itemscope="" itemtype="http://schema.org/CreativeWork"></div>';
				$structuredData .= '</div>'."\n";
			}
		}
		// Structure: JSON-LD
		if ($this->getParent()->isSchemaType('jsonld')) {
			$structuredData .= '<script type="application/ld+json">' . "\n";
			if ($remove_item_type) {
				$structuredData .= '{ "@context": "http://schema.org",' . "\n";
				$structuredData .= '	"@type": "Article",' . "\n";
				$structuredData .= '	"mainEntityOfPage": {' . "\n";
				$structuredData .= '		"@type": "WebPage",' . "\n";
				$structuredData .= '		"@id": "' . get_permalink( $post_info->ID ) . '"' . "\n";
				$structuredData .= '	},' . "\n";
				$structuredData .= '	"headline": "' . $post_info->post_title . '",' . "\n";
				$structuredData .= '	"url": "' . get_permalink( $post_info->ID ) . '",' . "\n";

				// Image
				if( has_post_thumbnail($post_info->ID) ) {
					// Post Image
					$thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( $post_info->ID ), 'full' );
					if( ! empty( $thumbnail ) ) {
						$structuredData .= '	"image": {' . "\n";
						$structuredData .= '			"@type": "ImageObject",' . "\n";
						$structuredData .= '			"url": "' . $thumbnail[0] . '",' . "\n";
						$structuredData .= '			"width": "' . $thumbnail[1] . '",' . "\n";
						$structuredData .= '			"height": "' . $thumbnail[2] . '"' . "\n";
						$structuredData .= '		},' . "\n";
					}
				}

				$structuredData .= '	"author": {' . "\n";
				$structuredData .= '		"@type": "Person",' . "\n";
				$structuredData .= '		"name":"' . get_the_author() . '"' . "\n";
				$structuredData .= '	}, ' . "\n";

				// Publisher
				$site_logo = '' . "\n";
				$site_logo_width = '';
				$site_logo_height = '';
				if ( function_exists( 'the_custom_logo' ) ) {
					$custom_logo_id = get_theme_mod( 'custom_logo' );
					if ( $custom_logo_id ) {
						$size = get_theme_support( 'custom-logo' );
						$custom_logo = wp_get_attachment_image_src( $custom_logo_id );
						$site_logo = $custom_logo[0];
						$site_logo_width = $size[0]['width'];
						$site_logo_height = $size[0]['height'];
					}
				}
				/*
				if( empty( $site_logo ) ) {
					if( has_header_image() ) {
						$header_image = get_header_image();
						if( ! empty( $header_image ) ) {
							$site_logo = $header_image;
							$site_logo_width = $custom_logo[1];
							$site_logo_height = $custom_logo[2];
						}
					}
				}*/
				$site_logo = apply_filters( 'rating_form_site_logo', $site_logo );
				$structuredData .= '	"publisher": {' . "\n";
				$structuredData .= '		"@type": "Organization",' . "\n";
				$structuredData .= '		"name": "' . get_bloginfo( 'name' ) . '",' . "\n";
				$structuredData .= '		"logo": {' . "\n";
				$structuredData .= '			"@type": "ImageObject",' . "\n";
				$structuredData .= '			"url": "' . $site_logo . '",' . "\n";
				$structuredData .= '			"width": "' . $site_logo_width . '",' . "\n";
				$structuredData .= '			"height": "' . $site_logo_height . '"' . "\n";
				$structuredData .= '		}' . "\n";
				$structuredData .= '	},' . "\n";

				$structuredData .= '	"datePublished": "' . mysql2date( 'c', $post_info->post_date, false ) . '",' . "\n";
				$structuredData .= '	"dateModified": "' . mysql2date( 'c', $post_info->post_modified, false ) . '"';
			}

			if( $rating_form_info['average'] > 0 ) {
				if ($remove_item_type) $structuredData .= ', ' . "\n";
				$structuredData .= '	"aggregateRating": {' . "\n";
				$structuredData .= '		"@type": "AggregateRating",' . "\n";
				$structuredData .= '		"bestRating": "' . $rating_form_info['max'] . '",' . "\n";
				$structuredData .= '		"worstRating": "1",' . "\n";
				$structuredData .= '		"ratingValue": "' . $rating_form_info['average'] . '",' . "\n";
				$structuredData .= '		"ratingCount": "' . $rating_form_info['count'] . '"' . "\n";
				$structuredData .= '	}' . "\n";
			}

			if ($remove_item_type) $structuredData .= '}' . "\n";
			$structuredData .= '</script>' . "\n";

		}
		$structuredData .= '</div>';
		// End Markup

		// Custom rich snippet data
		$structuredData = apply_filters( 'rating_form_microdata', $structuredData, $rating_form_info, $post_info->ID );
		// Format data
		return $structuredData;
	}
}
?>
