<?php
// Widget - Wrap Top rating results
function wrap_rating_form_top_results( $instance, $widget, $args = array() ) {
	$content = '';
	global $wpdb;

	if ($widget) {
		$content .= $args['before_widget'];
		if ( ! empty( $instance['title'] ) ) {
			$content .= $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
		}
	} else {
		if (!empty($instance['before_content'])) {
			$content .= html_entity_decode($instance['before_content']);
		}
		$content .= '<div class="rf_top_ratings_widget'. (empty($args['class']) ? '' : ' '.$args['class']) .'">';
		if ( ! empty( $instance['title'] ) ) {
			$content .= html_entity_decode($instance['before_title']) . apply_filters( 'widget_title', $instance['title'] ). html_entity_decode($instance['after_title']);
		}
	}

	$instance['limit'] = empty($instance['limit']) ? 5 : intval($instance['limit']);
	$instance['form_id'] = empty($instance['form_id']) ? 1 : intval($instance['form_id']);
	$instance['post_id'] = empty($instance['post_id']) ? 0 : intval($instance['post_id']);
	$instance['custom_id'] = Rating_Form_API::convertFieldIDArray($instance['custom_id']);
	$instance['post_title_length'] = empty($instance['post_title_length']) ? 20 : $instance['post_title_length'];
	$instance['content_length'] = empty($instance['content_length']) ? 10 : $instance['content_length'];
	$instance['image_size'] = empty($instance['image_size']) ? 48 : $instance['image_size'];
	$instance['author_active'] = empty($instance['author_active']) ? 0 : 1;
	$instance['time'] = empty($instance['time']) ? 0 : intval($instance['time']);
	$instance['type'] = empty($instance['type']) ? 'post_pages' : $instance['type'];
	$instance['content_active'] = empty($instance['content_active']) ? 0 : 1;
	$instance['image_active'] = empty($instance['image_active']) ? 0 : 1;
	$instance['post_type'] = empty($instance['post_type']) || empty($instance['post_type'][0]) ? array() : $instance['post_type'];
	$extractTaxonomy = empty($instance['taxonomy']) ? '' : rf_taxonomy_extract( $instance['taxonomy'] );
	$instance['taxonomy'] = empty($extractTaxonomy) ? array() : $extractTaxonomy;
	$instance['sort'] = (empty($instance['sort']) || empty($instance['sort'][0])) ? array() : $instance['sort'];
	$instance['state'] = empty($instance['state']) ? '' : strtolower($instance['state']);

	$title_length_none = $instance['post_title_length'] == 'none' ? true : false;

	// Rating Form Settings
	$sql = "SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM . " WHERE form_id = %d";
	$this_form_query = $wpdb->get_row( $wpdb->prepare( $sql, $instance['form_id'] ), ARRAY_A );
	// Types
	$isStar = (Rating_Form_Setup::form_types($this_form_query['type'], 'type') == "star");
	$isTUD = (Rating_Form_Setup::form_types($this_form_query['type'], 'type') == "tud");
	// Fields
	$options = empty($this_form_query['display']) ? array() : Rating_Form_API::getOptions($this_form_query['display']);

	// State: review
	$isStateReview = ($instance['state'] == 'review' ? true : false);//TODO: check if Rating Form enabled Review instead shortcode attr state=review
	$review_rating = ($isStateReview ? 'r' : '');

	// Sort by: old,new,top_rating,down_rating
	$sort_sql = 'avgRated DESC, votes DESC, rf_date DESC';
	if ($isTUD) $sort_sql = 'votes DESC, rf_date DESC';
	$sort_sql_field = array();
	if (count($instance['sort']) > 0) {
		if (in_array("old", $instance['sort'])) {
			$sort_sql_field[] = 'rf_date ASC';
		} else if (in_array("new", $instance['sort'])) {
			$sort_sql_field[] = 'rf_date DESC';
		}

		if ($isStar) {
			$sort_sql_field[] = 'votes DESC';
			if (in_array("down_rating", $instance['sort'])) {
				$sort_sql_field[] = 'avgRated ASC';
			} else if (in_array("top_rating", $instance['sort'])) {
				$sort_sql_field[] = 'avgRated DESC';
			}
		} else if ($isTUD) {
			if (in_array("down_rating", $instance['sort'])) {
				$sort_sql_field[] = 'votes ASC';
			} else if (in_array("top_rating", $instance['sort'])) {
				$sort_sql_field[] = 'votes DESC';
			}
		}
		$sort_sql = implode(", ", $sort_sql_field);
	}

	// Custom ID Array SQL
	$custom_id_sql = '';
	if ( is_array($instance['custom_id']) && count($instance['custom_id']) > 1 ) {
		$custom_id_sql .= "AND custom_id IN('" . implode("','", $instance['custom_id']) . "') ";
	} else {
		$custom_id_sql .= "AND custom_id = '" . $instance['custom_id'] . "' ";
	}
	// Type
	$queryStarType = '';
	$queryTudType = '';
	if ($instance['type'] == 'post_pages') {
		$queryStarType = "SELECT post_id, comment_id, term_id, user_id, custom_id, (SUM(rated)/COUNT(post_id)) AS avgRated, COUNT(*) AS votes, MAX(rf.date) AS rf_date " .
		"FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . " rf, " . $wpdb->posts . " wp " .
		"WHERE rf.post_id = wp.ID " .
		"AND wp.post_status = 'publish' " .
		(empty($instance['post_type']) ? "" : "AND wp.post_type IN('" . implode("','", $instance['post_type']) . "') ") .
		(($instance['time'] == 0) ? "" : "AND rf.date >= DATE_SUB(NOW(), INTERVAL " . $instance['time'] . " ". strtoupper($instance['time_field']) .") ") .
		"AND rated REGEXP '^" . $review_rating . "[0-9]+$' " .
		"AND post_id <> 0 " .
		"AND comment_id = 0 " .
		$custom_id_sql .
		"AND user_id = 0 " .
		"AND term_id = 0 " .
		"GROUP BY post_id " .
		"ORDER BY " . $sort_sql;

		$queryTudType = "SELECT post_id, comment_id, term_id, user_id, custom_id, SUM(CASE WHEN rated = '1u' then 1 else 0 end) AS up_count, SUM(CASE WHEN rated = '1d' then 1 else 0 end) AS down_count, COUNT(*) AS votes, MAX(rf.date) AS rf_date " .
		"FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . " rf, " . $wpdb->posts . " wp " .
		"WHERE rf.post_id = wp.ID " .
		"AND wp.post_status = 'publish' " .
		(empty($instance['post_type']) ? "" : "AND wp.post_type IN('" . implode("','", $instance['post_type']) . "') ") .
		(($instance['time'] == 0) ? "" : "AND rf.date >= DATE_SUB(NOW(), INTERVAL " . $instance['time'] . " ". strtoupper($instance['time_field']) .") ") .
		"AND (rated = '" . $review_rating . "1u' || rated = '" . $review_rating . "1d') " .
		"AND post_id <> 0 " .
		"AND comment_id = 0 " .
		$custom_id_sql .
		"AND user_id = 0 " .
		"AND term_id = 0 " .
		"GROUP BY post_id " .
		"ORDER BY " . $sort_sql;
	}
	else if ($instance['type'] == 'comments') {
		$queryStarType = "SELECT post_id, comment_id, term_id, user_id, custom_id, (SUM(rated)/COUNT(comment_id)) AS avgRated, COUNT(*) AS votes, MAX(rf.date) AS rf_date " .
		"FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . " rf, " . $wpdb->posts . " wp " .
		"WHERE rf.post_id = wp.ID " .
		"AND wp.post_status = 'publish' " .
		(empty($instance['post_type']) ? "" : "AND wp.post_type IN('" . implode("','", $instance['post_type']) . "') ") .
		(($instance['time'] == 0) ? "" : "AND rf.date >= DATE_SUB(NOW(), INTERVAL " . $instance['time'] . " ". strtoupper($instance['time_field']) .") ") .
		"AND rated REGEXP '^" . $review_rating . "[0-9]+$' " .
		(empty($instance['post_id']) ? "AND post_id <> 0 " : "AND post_id = '" . $instance['post_id'] . "' ") .
		"AND comment_id <> 0 " .
		$custom_id_sql .
		"AND user_id = 0 " .
		"AND term_id = 0 " .
		"GROUP BY comment_id " .
		"ORDER BY " . $sort_sql;

		$queryTudType = "SELECT post_id, comment_id, term_id, user_id, custom_id, SUM(CASE WHEN rated = '1u' then 1 else 0 end) AS up_count, SUM(CASE WHEN rated = '1d' then 1 else 0 end) AS down_count, COUNT(*) AS votes, MAX(rf.date) AS rf_date " .
		"FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . " rf, " . $wpdb->posts . " wp " .
		"WHERE rf.post_id = wp.ID " .
		"AND wp.post_status = 'publish' " .
		(empty($instance['post_type']) ? "" : "AND wp.post_type IN('" . implode("','", $instance['post_type']) . "') ") .
		(($instance['time'] == 0) ? "" : "AND rf.date >= DATE_SUB(NOW(), INTERVAL " . $instance['time'] . " ". strtoupper($instance['time_field']) .") ") .
		"AND (rated = '" . $review_rating . "1u' || rated = '" . $review_rating . "1d') " .
		(empty($instance['post_id']) ? "AND post_id <> 0 " : "AND post_id = '" . $instance['post_id'] . "' ") .
		"AND comment_id <> 0 " .
		$custom_id_sql .
		"AND user_id = 0 " .
		"AND term_id = 0 " .
		"GROUP BY comment_id " .
		"ORDER BY " . $sort_sql;
	}
	else if ($instance['type'] == 'users') {
		$queryStarType = "SELECT post_id, comment_id, term_id, user_id, custom_id, (SUM(rated)/COUNT(comment_id)) AS avgRated, COUNT(*) AS votes, MAX(rf.date) AS rf_date " .
		"FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . " rf, " . $wpdb->posts . " wp " .
		"WHERE rf.post_id = wp.ID " .
		"AND wp.post_status = 'publish' " .
		(empty($instance['post_type']) ? "" : "AND wp.post_type IN('" . implode("','", $instance['post_type']) . "') ") .
		(($instance['time'] == 0) ? "" : "AND rf.date >= DATE_SUB(NOW(), INTERVAL " . $instance['time'] . " ". strtoupper($instance['time_field']) .") ") .
		"AND rated REGEXP '^" . $review_rating . "[0-9]+$' " .
		"AND post_id <> 0 " .
		"AND comment_id = 0 " .
		$custom_id_sql .
		"AND user_id <> 0 " .
		"AND term_id = 0 " .
		"GROUP BY comment_id " .
		"ORDER BY " . $sort_sql;

		$queryTudType = "SELECT post_id, comment_id, term_id, user_id, custom_id, SUM(CASE WHEN rated = '1u' then 1 else 0 end) AS up_count, SUM(CASE WHEN rated = '1d' then 1 else 0 end) AS down_count, COUNT(*) AS votes, MAX(rf.date) AS rf_date " .
		"FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . " rf, " . $wpdb->posts . " wp " .
		"WHERE rf.post_id = wp.ID " .
		"AND wp.post_status = 'publish' " .
		(empty($instance['post_type']) ? "" : "AND wp.post_type IN('" . implode("','", $instance['post_type']) . "') ") .
		(($instance['time'] == 0) ? "" : "AND rf.date >= DATE_SUB(NOW(), INTERVAL " . $instance['time'] . " ". strtoupper($instance['time_field']) .") ") .
		"AND (rated = '" . $review_rating . "1u' || rated = '" . $review_rating . "1d') " .
		"AND post_id <> 0 " .
		"AND comment_id = 0 " .
		$custom_id_sql .
		"AND user_id <> 0 " .
		"AND term_id = 0 " .
		"GROUP BY comment_id " .
		"ORDER BY " . $sort_sql;
	}
	else if ($instance['type'] == 'taxonomies') {
		$queryStarType = "SELECT post_id, comment_id, term_id, user_id, custom_id, (SUM(rated)/COUNT(term_id)) AS avgRated, COUNT(*) AS votes, MAX(rf.date) AS rf_date " .
		"FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . " rf " .
		"WHERE rated REGEXP '^" . $review_rating . "[0-9]+$' " .
		(($instance['time'] == 0) ? "" : "AND rf.date >= DATE_SUB(NOW(), INTERVAL " . $instance['time'] . " ". strtoupper($instance['time_field']) .") ") .
		"AND post_id = 0 " .
		"AND comment_id = 0 " .
		$custom_id_sql .
		"AND user_id = 0 " .
		"AND term_id <> 0 " .
		"GROUP BY term_id " .
		"ORDER BY " . $sort_sql;

		$queryTudType = "SELECT post_id, comment_id, term_id, user_id, custom_id, SUM(CASE WHEN rated = '1u' then 1 else 0 end) AS up_count, SUM(CASE WHEN rated = '1d' then 1 else 0 end) AS down_count, COUNT(*) AS votes, MAX(rf.date) AS rf_date " .
		"FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . " rf " .
		"WHERE (rated = '" . $review_rating . "1u' || rated = '" . $review_rating . "1d') " .
		(($instance['time'] == 0) ? "" : "AND rf.date >= DATE_SUB(NOW(), INTERVAL " . $instance['time'] . " ". strtoupper($instance['time_field']) .") ") .
		"AND post_id = 0 " .
		"AND comment_id = 0 " .
		$custom_id_sql .
		"AND user_id = 0 " .
		"AND term_id <> 0 " .
		"GROUP BY term_id " .
		"ORDER BY " . $sort_sql;
	}

	//Ratings Top Results
	$top_ratings_sql = ($isTUD) ? $queryTudType : $queryStarType;
	//$top_ratings_sql .= ' LIMIT ' . $instance['limit'];
	$top_ratings_query = $wpdb->get_results( $top_ratings_sql, ARRAY_A );
	$top_ratings_num_rows = $wpdb->num_rows;

	// WPML
	// Display items of current language
	RF_Table_Results::filterByLanguage($top_ratings_query);

	// Filter out non selected taxonomies
	if (!empty($instance['taxonomy'])) {
		$taxonomy = '';
		foreach ($top_ratings_query as $key => $value) {
			$has_tax_terms = false;
			if (count($instance['taxonomy'])) {
				foreach ($instance['taxonomy'] as $val) {
					$taxonomy = $val['taxonomy'];
					if (!empty($taxonomy)) {
						$terms = (empty($val['terms']) ? '' : $val['terms']);
						if ( has_term($terms, $taxonomy, $value['post_id']) ) {
							$sql_and_or = (empty($val['sql_and_or']) ? '' : $val['sql_and_or']);
							$has_tax_terms = true;
							if ($sql_and_or == 'AND') {
								$has_tax_terms2 = true;
								$term_list = wp_get_post_terms( $value['post_id'], $taxonomy, array( 'fields' => 'all' ));
								foreach ($term_list as $term) {
									if (!in_array($term->slug, $val['terms'])) {
										$has_tax_terms2 = false;
									}
								}
								$has_tax_terms = $has_tax_terms2;
							}
						}
					}
				}
				if (!$has_tax_terms) unset($top_ratings_query[$key]);
			}
		}
	}

	$top_ratings_query = array_slice($top_ratings_query, 0, $instance['limit'], true);//TODO: use limit inside SQL query for quick result, this way query will take long time to get results

	$content .= '<ul class="rf_widget_list">'."\r\n";
	if ( $top_ratings_num_rows > 0 && count($top_ratings_query) ) {
		$i = 1;
		foreach ($top_ratings_query as $top_ratings_row) {
			$rf_top_ratings_item = '';
			$rating_average = $rating_count = $rating_up_count = $rating_down_count = 0;
			// Display Rating Form
			// Attributes
			$newRFatts = array (
				'id' => $instance['form_id'],
				'post_id' => $top_ratings_row['post_id'],
				'comment_id' => $top_ratings_row['comment_id'],
				'term_id' => $top_ratings_row['term_id'],
				'user_id' => $top_ratings_row['user_id'],
				'custom_id' => $top_ratings_row['custom_id'],
				'widget' => true,
				'title' => false,
				'total' => false,
				'score' => false,
				'result' => true,
				'tooltip' => false,
				'stats' => false,
			);
			// Rating Form
			$rf = new Rating_Form( $newRFatts, $this_form_query, $options );

			if ($isTUD) {
				$rating_up_count = intval($top_ratings_row['up_count']);
				$rating_down_count = intval($top_ratings_row['down_count']);
				$rf->setUpCount($rating_up_count);
				$rf->setDownCount($rating_down_count);
			} else if ($isStar) {
				$rating_average = round($top_ratings_row['avgRated'], $options['round']);
				$rating_count = intval($top_ratings_row['votes']);
				$rf->setAverage($rating_average);
				$iconPoss = Rating_Form_API::getRatingPositions($rating_average);
				$iconPoss['icon_half'] = $iconPoss['icon_count'] == $iconPoss['icon_half'] ? 0 : $iconPoss['icon_half'];
		        $rf->setRatingPosition($iconPoss['icon_count']);
		        $rf->setRatingHalfPosition($iconPoss['icon_half']);
			}
			$rf->wrapper(
				$rf->container(
					$rf->items(),
					$rf->getItemAverage(),
					$rf->getItemCount()
				)
			);
			$rating_form = $rf->show();

			$rf_tr_item_info = array(
				'rank' => $i,
				'type' => $instance['type'],
				'form_type' => ($isStar ? 'star' : 'tud'),
				'post_id' =>  $top_ratings_row['post_id'],
				'comment_id' => $top_ratings_row['comment_id'],
				'user_id' => $top_ratings_row['user_id'],
				'term_id' => $top_ratings_row['term_id'],
				'average' => $rating_average,
				'count' => $rating_count,
				'up_count' => $rating_up_count,
				'down_count' => $rating_down_count,
				'rating_form' => $rating_form
			);

			if ($instance['type'] == 'post_pages') {
				$post_content = strip_shortcodes( get_post_field('post_content', $top_ratings_row['post_id']) );
				$post_title = get_the_title( $top_ratings_row['post_id'] );
				$rf_top_ratings_item .= '<li>';
				$rf_top_ratings_item .= '<a href="' . get_permalink( $top_ratings_row['post_id'] ) . '" title="' . $post_title .'">';
				$rf_top_ratings_item .= '<span class="alignleft">';
				$rf_top_ratings_item .= '<span class="rf_place">' . $i . '</span>';
				$rf_top_ratings_item .= '<span class="rf_post_title">' . ($title_length_none ? $post_title : (strlen($post_title) > $instance['post_title_length'] ? substr($post_title, 0, $instance['post_title_length']) . '...' : $post_title)) . '</span>';
				if ($isStar) {
					$rf_top_ratings_item .= '<span class="rf_avg_rating">(' . $rating_average . ')</span>';
				}
				$rf_top_ratings_item .= '</span>';
				$rf_top_ratings_item .= '<span class="alignright">';
				$rf_top_ratings_item .= '<span class="rf_form">' . $rating_form . '</span>';
				$rf_top_ratings_item .= '</span>';
				$rf_top_ratings_item .= '</a>';
				$rf_top_ratings_item .= (isset($instance['image_active']) && $instance['image_active'] == 1 && has_post_thumbnail($top_ratings_row['post_id']) ? '<div class="rf_post_image">' . get_the_post_thumbnail( $top_ratings_row['post_id'], array($instance['image_size'], $instance['image_size'])) . '</div>' : '');
				if (!empty($post_content)) $rf_top_ratings_item .= ($instance['content_active'] == 1 ? '<div class="rf_post_content">' . wp_trim_words( $post_content, $instance['content_length'] ) . '</div>' : '');
				$rf_top_ratings_item .= '</li>'."\r\n";
			} else if ($instance['type'] == 'comments') {
				$post_args = get_comment($top_ratings_row['comment_id'], ARRAY_A);
				$post_content = strip_shortcodes( $post_args['comment_content'] );
				$rf_top_ratings_item .= '<li>';
				$rf_top_ratings_item .= '<a href="' . get_permalink( $post_args['comment_post_ID'] ) . '#comment-' . $post_args['comment_ID'] . '">';
				$rf_top_ratings_item .= '<span class="alignleft">';
				$rf_top_ratings_item .= '<span class="rf_place">' . $i . '</span>';
				$rf_top_ratings_item .= ($instance['author_active'] == 1 ? '<span class="rf_post_title">' . $post_args['comment_author'] . '</span>' : wp_trim_words( $post_content, $instance['content_length']));
				$rf_top_ratings_item .= '<span class="rf_avg_rating">' . ($isStar ? '(' . $rating_average . ')' : '').'</span>';
				$rf_top_ratings_item .= '</span>';
				$rf_top_ratings_item .= '<span class="alignright">';
				$rf_top_ratings_item .= '<span class="rf_form">' . $rating_form . '</span>';
				$rf_top_ratings_item .= '</span>';
				$rf_top_ratings_item .= '</a>';
				if (!empty($post_content)) {
					$rf_top_ratings_item .= ($instance['content_active'] == 1 && $instance['author_active'] == 1 ? '<div class="rf_post_content">' . wp_trim_words( $post_content, $instance['content_length'] ) . '</div>' : '');
				}
				$rf_top_ratings_item .= '</li>'."\r\n";
			} else if ($instance['type'] == 'taxonomies') {
				$post_args = Rating_Form_Setup::get_term_by_id( $top_ratings_row['term_id'], 'ARRAY_A' );
				$post_content = strip_shortcodes( $post_args['description'] );
				$rf_top_ratings_item .= '<li>';
				$rf_top_ratings_item .= '<a href="' . get_term_link( $post_args['term_id'], $post_args['taxonomy'] ) . '">';
				$rf_top_ratings_item .= '<span class="alignleft">';
				$rf_top_ratings_item .= '<span class="rf_place">' . $i . '</span>';
				$rf_top_ratings_item .= '<span class="rf_post_title">' . $post_args['name'] . '</span>';
				$rf_top_ratings_item .= ($isStar ? '<span class="rf_avg_rating">(' . $rating_average . ')</span>' : '');
				$rf_top_ratings_item .= '</span>';
				$rf_top_ratings_item .= '<span class="alignright">';
				$rf_top_ratings_item .= '<span class="rf_form">' . $rating_form . '</span>';
				$rf_top_ratings_item .= '</span>';
				$rf_top_ratings_item .= '</a>';
				if (!empty($post_content)) {
					$rf_top_ratings_item .= ($instance['content_active'] == 1 ? '<div class="rf_post_content">' . wp_trim_words( $post_content, $instance['content_length'] ) . '</div>' : '');
				}
				$rf_top_ratings_item .= '</li>'."\r\n";
			} else if ($instance['type'] == 'users') {
				$post_args = get_userdata($top_ratings_row['user_id']);
				$rf_top_ratings_item .= '<li>';
				$rf_top_ratings_item .= '<span class="alignleft">';
				$rf_top_ratings_item .= '<span class="rf_place">' . $i . '</span>';
				$rf_top_ratings_item .= '<span class="rf_post_title">' . $post_args->display_name . '</span>';
				$rf_top_ratings_item .= '<span class="rf_avg_rating">' . ($isStar ? '(' . $rating_average . ')' : '').'</span>';
				$rf_top_ratings_item .= '</span>';
				$rf_top_ratings_item .= '<span class="alignright">';
				$rf_top_ratings_item .= '<span class="rf_form">' . $rating_form . '</span>';
				$rf_top_ratings_item .= '</span>';
				$rf_top_ratings_item .= '</li>'."\r\n";
			}
			// Custom list item data
			$content .= apply_filters( 'rf_top_ratings_item', $rf_top_ratings_item, $rf_tr_item_info, $instance );
			$i++;
		}
	} else {
		$content .= '<li>' . __( 'No results found.', 'rating-form' ) . '</li>';
	}
	$content .= '</ul>'."\r\n";
	if ($widget) {
		$content .= $args['after_widget'];
	} else {
		$content .= '</div>';
		if (!empty($instance['after_content'])) {
			$content .= html_entity_decode($instance['after_content']);
		}
	}

	return $content;
}

function rf_taxonomy_extract( $str ) {
	$tmp  = explode( '|', $str); // explode taxonomies
	$arrTaxonomies = array();

	foreach ( $tmp as $k => $v ) {
		$slug = '';
		$terms = array();
		$sql_and_or = '';

		$slug = $v;
		if (preg_match('/:/', $v)) { // terms
			$taxonomyWithTerms  = explode( ':', $v);
			$termsExp  = explode( ',', $taxonomyWithTerms[1]);
			$slug = $taxonomyWithTerms[0];
			$terms = $termsExp;
		}

		if (preg_match('/-/', $slug)) { // and / or
			$taxAndOr = explode('-', $slug);
			$slug = $taxAndOr[0];
			if (strtolower($taxAndOr[1]) == strtolower('AND')) {
				$sql_and_or = 'AND';
			} else if (strtolower($taxAndOr[1]) == strtolower('OR')) {
				$sql_and_or = 'OR';
			}
		}

		$taxonomy = array('taxonomy' => $slug, 'terms' => $terms, 'sql_and_or' => $sql_and_or);

		if (empty($slug)) unset($taxonomy['taxonomy']);
		if (empty($terms)) unset($taxonomy['terms']);
		if (empty($sql_and_or)) unset($taxonomy['sql_and_or']);

		$arrTaxonomies[$slug] = $taxonomy;
	}

	/*foreach($arrTaxonomies as $tax) {
		$arrTaxonomies['taxonomies'][] = $tax['taxonomy'];
	}*/

	return $arrTaxonomies;
}

// Display rating form top results
function display_rating_form_top_results( $atts ) {

	// Attributes
	$args = shortcode_atts(
		array(
			'form_id' => '1',
			'post_id' => '0',
			'custom_id' => '0',
			'before_title' => '<h3>',
			'title' => 'Top 5 Ratings',
			'after_title' => '</h3>',
			'limit' => '5',
			'post_title_length' => '20',
			'content_length' => '10',
			'content_active' => 'false',
			'image_size' => '48',
			'image_active' => 'false',
			'author_active' => 'false',
			'time' => '',
			'time_field' => '',
			'type' => 'post_pages',
			'post_type' => 'post,page',
			'taxonomy' => '',
			'before_content' => '',
			'after_content' => '',
			'class' => '',
			'sort' => '',
			'state' => ''
		), $atts );

	$args['form_id'] = intval( $args['form_id'] );
	$args['post_id'] = intval( $args['post_id'] );
	$args['before_title'] = htmlentities($args['before_title']);
	$args['title'] = ( ! empty( $args['title'] ) ) ? strip_tags( $args['title'] ) : '';
	$args['after_title'] = htmlentities($args['after_title']);
	$args['limit'] = intval( $args['limit'] );
	$args['content_length'] = intval( $args['content_length'] );
	$args['content_active'] = $args['content_active'] == 'true' ? 1 : 0;
	$args['image_size'] = intval( $args['image_size'] );
	$args['image_active'] = $args['image_active'] == 'true' ? 1 : 0;
	$args['author_active'] = $args['author_active'] == 'true' ? 1 : 0;
	$args['time'] = intval($args['time']);
	$args['type'] = empty($args['type']) ? 'post_pages' : $args['type'];
	$splitPostType = explode(',', $args['post_type']); // split post types to array
	$args['post_type'] = empty($splitPostType) || empty($splitPostType[0]) ? array() : $splitPostType;
	$args['taxonomy'] = empty( $args['taxonomy'] ) ? '' : $args['taxonomy'];
	$splitSort = explode(',', $args['sort']); // split post types to array
	$args['sort'] = count( $splitSort ) == 0 ? array() : $splitSort;

	return wrap_rating_form_top_results($args, false);
}
add_shortcode( 'rating_form_top_rating_results', 'display_rating_form_top_results' );
?>
