<?php
/**
 * Create a Rating Form
 */
class Rating_Form {
    private $args = array();
    private $settings = array();
    private $options = array();
    private $data = array();
    private $user_data = array();
    private $titles = array();
    private $type = 'star';
    private $item_tag = 'span';
    private $cursor = ' cursor';
    private $div_result = '';
    private $average = 0;
    private $up_count = 0;
    private $down_count = 0;
    private $count = 0;
    private $user_rating = 0;
    private $item_count = 0;
    private $item_half = 0;
    private $symbol_percentage = '%';
    private $md_item_type = '';
    private $div_settings = '';
    private $visibility = true;
    private $output = '';

    /**
     * Create class based on options
     * @param array $args Rating Form options
     */
    function __construct( $atts = array(), $settings = array(), $options = array() ) {
        $this->setArguments( $atts );
        $settings = empty($settings) ? Rating_Form_API::settingsByID( $this->getArgument('id') ) : $settings;
        $this->setSettings( $settings );
        $options = empty($options) ? Rating_Form_API::getOptions( $this->getSetting('display') ) : $options;
        $this->setOptions( $options );
        $this->settings();
    }

    function show() {
        if (!$this->validation()->isValid()) {
            return $this->validation()->errorMessages();
        } elseif (!$this->isVisible()) {
            return;
        } else {
            $output = $this->output();
            $filterOutput = apply_filters( 'rating_form_output', $output, $this->getSetting('form_id') );
            return empty($filterOutput) ? $output : $filterOutput;
        }
    }

    function settings() {
    	if (Rating_Form_API::deactivateOnTablet()) return;
    	if (Rating_Form_API::deactivateOnMobile()) return;
        $this->addMetaFake();
        // Change
        $this->setTooltipPosition($this->getOption('tooltip_pos'), $this->getOption('tooltip_pos_wrap'));
        $this->setTooltipArrowPosition($this->getOption('tooltip_arrow_pos'), $this->getOption('tooltip_arrow_pos_wrap'));
        $this->setStatsPosition();
        $this->setMicroDataItem($this->getDefaultMDItem());
        $this->richSnippetOnHome();
        // Show / Hide
        $this->showHide();
    }

    // Show / Hide
    function showHide() {
        if (!$this->getOption('active')) $this->setVisibility(false);
        if ($this->getOption('remove_amp') && $this->isAMP() && defined('AMP__FILE__')) $this->setVisibility(false);
        if (!$this->getArgument('widget') && !$this->isAdmin()) {
            if ($this->optionExists('remove_home') && ( is_home() || is_front_page() )) $this->setVisibility(false);
            if ($this->optionExists('remove_feed') && is_feed()) $this->setVisibility(false);
            if ($this->optionExists('remove_mobile') && wp_is_mobile() && Rating_Form_API::isTablet() === false) $this-setVisibility(false);
            if ($this->optionExists('remove_tablet') && Rating_Form_API::isTablet()) $this->setVisibility(false);
            if (!$this->isPostTypeAllowed()) $this->setVisibility(false);
            if ($this->optionExists('only_single') && (!is_single() || (is_single() && !in_the_loop()))) $this->setVisibility(false);
            if ($this->optionExists('only_page') && (!is_page() || (is_page() && !in_the_loop()))) $this->setVisibility(false);
            if ($this->optionExists('only_category') && (!is_category() || (is_category() && !in_the_loop()))) $this->setVisibility(false);
            if ($this->getOption('hide_after_vote') && $this->hasUserRated()) $this->setVisibility(false);
            $this->includePostID();
            $this->excludePostID();
        }
        $this->userRoleAllowed();
    }

    function formData() {
        // Set
        $this->setData( Rating_Form_API::getData( $this->getArguments(), $this->getSettings(), $this->getOptions() ) );
        $checkUserArgs = $this->getArguments();
        $checkUserArgs['user_check'] = true;
        $this->setUserData( Rating_Form_API::getData( $checkUserArgs, $this->getSettings(), $this->getOptions() ) );
        $this->applyUserRating();
        if (!$this->argExists('result')) $this->setTitles( Rating_Form_API::getTitles( $this->getSetting('type'), $this->getOption('title') ) );
        // Set rating
        if ($this->isType('tud')) {
            $this->setUpCount( intval($this->getRatingResult()['up_count']) );
            $this->setDownCount( intval($this->getRatingResult()['down_count']) );
        } else if ($this->isType('star')) {
            $this->setAverage( round($this->getRatingResult()['average'], intval($this->getOption('round'))) );
            $this->setRatingPosition($this->getRatingPositions()['icon_count']);
            $this->setRatingHalfPosition($this->getRatingPositions()['icon_half']);
        }
        $this->combineCounts();
        $this->setIsResult();
        $this->setIsReview();
        $this->setIsEditRatingDirect();
        $this->setIsAdmin();
    }

    function setVisibility( $bool ) {
        $this->visibility = (bool) $bool;
    }

    function getVisibility() {
        return $this->visibility;
    }

    function isVisible() {
        return ($this->getVisibility() === true);
    }

    function setOutput($html) {
        $this->output .= $html;
    }

    function output() {
        return $this->output;
    }

    function setArguments($atts) {
        $args = shortcode_atts( Rating_Form_API::getDefaultAtts(), $atts );
        $this->args = Rating_Form_API::initArgs($args);
    }

    function getArguments() {
        return $this->args;
    }

    function getArgument($str) {
        return $this->args[$str];
    }

    function setArgument($key, $val) {
        $this->args[$key] = $val;
    }

    function argExists($str) {
        return !empty($this->args[$str]);
    }

    // Rating Form Settings
    function setSettings( $settings ) {// TODO: combine settings and options in separate class, also remove boolean in optionsByID; use optionExists
        $this->settings = (array) $settings;
    }

    function getSettings() {
        return $this->settings;
    }

    function getSetting( $str ) {
        return $this->settings[$str];
    }

    function exists() {
        return (count($this->settings) > 0);
    }

    function getID() {
        return $this->exists() ? $this->getSetting('form_id') : 0;
    }

    function setOptions( $options ) {
        $this->options = $options;
    }

    function getOptions() {
        return $this->options;
    }

    function getOption( $str ) {
        return empty($this->getOptions()[$str]) ? '' : $this->getOptions()[$str];
    }

    function setOption($key, $val) {
        $this->getOptions()[$key] = $val;
    }

    function optionExists($option) {
        return (in_array($option, $this->getOptions(), true));
    }

    function validation() {
    	return new Rating_Form_Validation( $this->getSettings(), $this->getArguments() );
    }

    // Item
    function isType( $type ) {
        return (Rating_Form_Setup::form_types($this->getSetting('type'), 'type') == $type);
    }

    function setType( $type ) {
        $this->type = $type;
    }

    function getType() {
        return $this->type;
    }

    function isItemNumericClass() {
        return !empty( $this->getItemNumericClass() );
    }

    function getItemClass() {
        return Rating_Form_Setup::form_types($this->getSetting('type'), 'class');
    }

    function getItemClass2() {
        return Rating_Form_Setup::form_types($this->getSetting('type'), 'class2');
    }

    function getItemNumericClass() {
        return Rating_Form_Setup::form_types($this->getSetting('type'), '', 'int');
    }

    // TODO: create a separate class Rating_Form_Item, extend this class
    function getItemTag() {
        return $this->item_tag;
    }

    function setItemTag() {
        return $this->item_tag;
    }

    function setIsReview() {
        if ($this->isReview()) {
            $this->setArgument('total', false);
            $this->setOption('icon_half', '');
            $this->setAverage(0);
            $this->setCount(0);
            $this->setRatingPosition(0);
            $this->setRatingHalfPosition(0);
        }
    }

    function setIsAdmin() {
        // Reset cus Admin
		if ( $this->isAdmin() ) {
			$this->div_result = ' rating_form_check';
            $this->setAverage(0);
            $this->setCount(0);
            $this->setRatingPosition(0);
            $this->setRatingHalfPosition(0);
            $this->setArgument('rich_snippet', false);
		}
    }

    function isReview() {
        $settings = get_option(Rating_Form_Setup::PAGE_REVIEW_SLUG);
        $reviewActive = (!empty($settings['comment_review']['enable']) && ($settings['comment_review']['enable'] == '1'));
        return $reviewActive && $this->getArgument('comment_review');
    }

    function isAdmin() {
        return ( is_admin() && ( !defined( 'DOING_AJAX' ) || !DOING_AJAX ) );
    }

    function getReviewRatingValue() {
        return 'r';
    }

    function getUpValue() {
        return '1u';
    }

    function getDownValue() {
        return '1d';
    }

    function getRatingValue( $i ) {
        $rating = '';
        if ($this->isType('star'))
            $rating = $i;
        if ($this->isType('tud'))
            $rating = ($i == 1 ? $this->getUpValue() : ($i == 2 ? $this->getDownValue() : ''));
        return $this->isReview() ? $this->getReviewRatingValue() . $rating : $rating;
    }

    function setTitles( $titles ) {
        $this->titles = $titles;
    }

    function getTitles() {
        return $this->titles;
    }

    function getTitleByPosition($i) {
        return isset($this->getTitles()[$i]) ? $this->getTitles()[$i] : '';
    }

    // Rating data
    function setData( $data ) {
        $this->data = $data;
    }

    function setUserData( $user_data ) {
        $this->user_data = $user_data;
    }

    function setUserRating( $rating ) {
        $this->user_rating = $rating;
    }

    function getRatingResult() {
        return $this->data;
    }

    function setAverage($avg) {
        $this->average = $avg;
    }

    function getAverage() {
        return floatval($this->average);
    }

    function getUpCount() {
        return $this->up_count;
    }

    function setUpCount( $count ) {
        $this->up_count = $count;
    }

    function getDownCount() {
        return $this->down_count;
    }

    function setDownCount( $count ) {
        $this->down_count = $count;
    }

    function setCount( $count ) {
        $this->count = $count;
    }

    function getCount() {
        return $this->count;
    }

    function getCountPercentage() {
        return floatval($this->getRatingResult()['count_percent']) . $this->symbol_percentage;
    }

    function combineCounts() {
        $count = 0;
        if ($this->isType('star')) $count = intval($this->getRatingResult()['count']);
        if ($this->isType('tud')) $count = ($this->getUpCount() + $this->getDownCount());
        if ($this->isCountTypePercentage()) $count = $this->getCountPercentage();
        $this->setCount($count);
    }

    function isCountTypePercentage() {
        return ($this->getArgument('count_type') == 'percentage');
    }

    // Average rating positions for e.g. looping
    function getRatingPositions() {
        return Rating_Form_API::getRatingPositions($this->getAverage());
    }

    function setRatingPosition($val) {
        $this->item_count = $val;
    }

    function setRatingHalfPosition($val) {
        $this->item_half = $val;
    }

    function getRatingPosition() {
        return $this->item_count;
    }

    function getRatingHalfPosition() {
        return $this->item_half;
    }

    function isRatingPosition($i) {
        return ($i <= $this->getRatingPosition());
    }

    function isRatingHalfPosition($i) {
        return ($i >= Rating_Form_API::roundTohalf($this->getAverage()) && $i <= $this->getRatingHalfPosition());
    }

    function item( $i ) {
        if ($this->isType('star') || $this->getSetting('type') == 0) return $this->itemDefault($i);
        if ($this->isType('tud')) return $this->itemUpDown($i);
    }

    function getCustomStarUrl($str) {
    	$upload_dir = wp_upload_dir();
        return $upload_dir['baseurl'] . '/rating-form/icons/' . $this->getID() . '/custom-' . $str . '.png';
    }

    function getCustomStarImgEnd() {
        return ($this->getOption('max') == 1 ? 'empty' : 'full');
    }

    function getCustomStarImg($str) {
        return '<img src="' . $this->getCustomStarUrl($str) . '" alt="Custom ' . ucfirst($str) . '" />';
    }

    function itemDefault( $i ) {
        $hover = ' hover';
        $class = '';
        $img = '';

        $class_name = ($this->isType('tud') && $i == 2 ? $this->getItemClass2() : $this->getItemClass());
        $class .= $this->isItemNumericClass() ? $this->getItemNumericClass() . $i : $class_name;
        if ($this->isType('tud')) $hover = '';

        if ($this->isRatingPosition($i)) { // Full icons
            $class .= $this->getOption('max') == 1 ? '' : $hover;
            $img = 'full';
        }
        elseif ($this->isRatingHalfPosition($i)) { // Half icon
            $class .= ($this->getOption('icon_half') == '-empty' ? $hover : ($this->optionExists('rtl') ? '-rtl' : '')) . $this->getOption('icon_half');
            $img = 'half';
        }
        elseif (!$this->isItemNumericClass()) {
            $class .= $this->getOption('icon_empty'); // Empty icons
            $img = 'empty';
        }

        if ($this->isType('tud') && $i == 1) $class .= ' up_rated'; // Thumbs Up
        if ($this->isType('tud') && $i == 2) $class .= ' down_rated'; // Thumbs Up

        $html = '<' . $this->getItemTag();
        $html .= ($this->argExists('result') || $this->isAdmin() ? '' : ' data-rating="' . $this->getRatingValue( $i ) .'"');
        $html .= ' class="rf_item ' . $class . '"';
        // Tooltip titles
        $html .= ($this->argExists('tooltip') ? ' title="'. $this->getTitleByPosition($i) .'"' : '');
        $html .= '>'; // end item tag
        // Custom Image Url
        if ($this->getSetting('type') == 0) $html .= $this->getCustomStarImg($img);
        // Visible titles
        $html .= ($this->argExists('title') ? '<span class="title">'. $this->getTitleByPosition($i) .'</span>' : '');
        $html .= '</' . $this->getItemTag() . '>';

        return $html;
    }

    function itemUpDown( $i ) {
        if ($i > 2) return;

        $html = $this->itemUp($i);
        $html .= $this->itemDown($i);

        return $html;
    }

    function itemUp( $i ) {
        if ($i != 1) return;
        if ($this->getOption('only_thumbs_down') && !$this->isOnlyUpDown()) return;

        $html = $this->itemDefault($i);
        if (!$this->getOption('hide_up_count')) {
            $html .= '<span class="def up_rated_txt">' . $this->getUpDownChars(0) . $this->getUpCount() . '</span>';
        }

        return $html;
    }

    function itemDown( $i ) {
        if ($i != 2) return;
        if ($this->getOption('only_thumbs_up') && !$this->isOnlyUpDown()) return;

        $html = $this->itemDefault($i);
        if (!$this->getOption('hide_down_count')) {
            $html .= '<span class="def down_rated_txt">' . $this->getUpDownChars(1) . $this->getDownCount() . '</span>';
        }

        return $html;
    }

    function getUpDownChars( $i ) {
        if (!$this->getOption('remove_plus_min_chars')) {
            $arr[0] = '+';
            $arr[1] = '-';
        }
        return $arr[$i];
    }

    function isOnlyUpDown() {
        return ($this->getOption('only_thumbs_up') && $this->getOption('only_thumbs_down'));
    }

    function items( $count = null ) {
        if ( (int)$this->getAverage() == 0 && ($this->getUpCount() + $this->getDownCount()) == 0 ) $this->formData();

        $html = '';
        $max = is_null($count) ? $this->getOption('max') : intval($count);

        for ($i = ($this->optionExists('rtl') ? $max : 1); ($this->optionExists('rtl') ? $i >= 1 : $i <= $max); ($this->optionExists('rtl') ? $i-- : $i++)) {
            $html .= $this->item($i);
        }

        return $html;
    }

    function sideStart() {
        return '<span class="rf_side">';
    }

    function side() {
        $html = '';
        $arg_list = func_get_args();
        $max = func_num_args();

        $html .= $this->sideStart();
        for ($i = ($this->optionExists('rtl') ? $max : 0); ($this->optionExists('rtl') ? $i >= 0 : $i < $max); ($this->optionExists('rtl') ? $i-- : $i++)) {
            if( isset($arg_list[$i]) ) $html .= $arg_list[$i];
        }
        $html .= $this->sideEnd();

        return $html;
    }

    function sideEnd() {
        return '</span>';
    }

    function getItemAverage() {
        $html = '';
        if ($this->argExists('score')) {
            if ($this->getOption('max') > 1) {
                if ($this->isType('star')) {
                    $txt_score = sprintf(
                        html_entity_decode($this->getArgument('txt_score')),
                        '<span class="rf_average">' . $this->getAverage() . '</span>',
                        '<span class="rf_max">' . $this->getOption('max') . '</span>');
                    $html .= '<' . $this->getItemTag() . ' class="def rating_score">' . $txt_score . '</' . $this->getItemTag() . '>';
                }
            }
        }
        return $html;
    }

    function getItemCount() {
        $html = '';
        if ($this->argExists('total')) {
            $exp_rates = explode(',', $this->getArgument('rates'));
            $singular_plural = count($exp_rates) == 1 ? $exp_rates[0] : ($this->getCount() == 1 ? $exp_rates[0] : $exp_rates[1]);
            $count_class = $this->isCountTypePercentage() ? 'rf_count_percent' : 'rf_count';
            $count = '<span class="' . $count_class . '">' . $this->getCount() . '</span>';
            $rates = ((strpos($this->getArgument('rates'), ',') !== false) ? $singular_plural : $this->getArgument('rates'));
            $html .= '<' . $this->getItemTag() . ' class="def rating_total">';
            $html .= ((strpos($this->getArgument('rates'), '%count%') !== false) ? str_replace('%count%', $count, $rates) : $count . ' ' . $rates);
            $html .= '</' . $this->getItemTag() . '>';
        }
        return $html;
    }

    //TODO: Why is custom id input seperated from name="rf_rating"
    function getReviewInputs() {
        if (!$this->isReview()) return;

		if ($this->argExists('custom_id')) {
			$html .= '<input type="hidden" name="rf_custom_id" value="' . $args['custom_id'] . '">';
		}
		$html .= '<input type="hidden" name="rf_rating">';
        return $html;
    }

    function containStart() {
        return '<div class="rating_form' . $this->getDivClasses() . '"' . $this->getDivAttributes()  . '>'."\r\n";
    }

    function container() {
        $html = '';
        $max = func_num_args();
        $arg_list = func_get_args();

        $html .= $this->containStart();
        for ($i = ($this->optionExists('rtl') ? $max : 0); ($this->optionExists('rtl') ? $i >= 0 : $i < $max); ($this->optionExists('rtl') ? $i-- : $i++)) {
            if( isset($arg_list[$i]) ) $html .= $arg_list[$i];
        }
        $html .= $this->containEnd();

        return $html;
    }

    function containEnd() {
        return '</div>'."\r\n";
    }

    // Wrapper
    function getDivID() {
        return 'RF' . ($this->argExists('result') ? 'R' : '') . $this->getID() . Rating_Form_API::getDivID( $this->getArguments() );
    }
    function wrapStart() {
        if ($this->getOption('ajax_load') && !$this->isAdmin()) $this->loadAjax();
        $addClassRtl = $this->getOption('rtl') ? ' rf_rtl' : '';
        $dirRTL = $this->getOption('rtl') ? ' dir="rtl"' : '';
		$html = '<div data-rf-id="' . $this->getDivID() . '" class="rating_form_wrap rating_form_' . $this->getID() . $addClassRtl . '"' . $dirRTL . $this->getMicroDataItem() . '>'."\r\n";
        //$html .= $this->inlineStyle();
        $html .= $this->getReviewInputs();//TODO: this can go to getDivSettings()
        $html .= $this->getDivSettings();
        $html .= $this->getBeforeContent();
        return $html;
    }

    function wrapper() {
        $html = '';
        $arg_list = func_get_args();

        $html .= $this->wrapStart();

        for ($i = 0; $i < func_num_args(); $i++) {
            $html .= $arg_list[$i];
        }

        $html .= $this->wrapEnd();

        $this->setOutput($html);
    }

    function wrapEnd() {
        $this->addTranslationsWPML(); // Create WMPL
        $html = $this->getRichSnippet();
        $html .= $this->getEditRatingMessage();
        $html .= $this->getAfterContent();
        $html .= '</div>'."\r\n";
        return $html;
    }

    function loadAjax() {
        $id = $this->getID();
		if( !wp_script_is( 'rating-form-'. $id .'-script') ) {
			wp_register_script( 'rating-form-'. $id .'-script', false );
			wp_enqueue_script( 'rating-form-'. $id .'-script' );
			// Inline script
            wp_add_inline_script( 'rating-form-js', $this->getLoadAjaxScript() );
        }
    }

    function getLoadAjaxScript() {
		// $html = '<script type="text/javascript">';
		$html = 'jQuery(document).ready(function() {' . "\n";
			$html .= 'jQuery.ajax({' . "\n";
				$html .= 'type: "POST",' . "\n";
				$html .= 'url : rating_form_script.ajaxurl,' . "\n";
				$html .= 'data : { action : "display_rating_form_ajax", args : ' . json_encode($this->getArguments()) . ' }, ' . "\n";
				$html .= 'success : function(data) {' . "\n";

                $html .= 'var params = {' . "\n";
                $html .= '    checks: JSON.parse(data),' . "\n";
                $html .= '    parent: jQuery("body").find("[data-rf-id=\"' . $this->getDivID() . '\"]"),' . "\n";
                $html .= '};' . "\n";

                if ($this->getOption('edit_rating_direct')) {
                    $user_rating = $this->getUserRating();
                    $html .= 'params.checks.user_rating = ' . $user_rating . ';' . "\n";
                }
                $html .= 'rating_form_apply_data(params);' . "\n";

                $html .= '}' . "\n";
			$html .= '});' . "\n";
		$html .= '});' . "\n";
		// $html .= '</script>';
        return $html;
    }

    function addMetaFake() {
        return Rating_Form_API::addMetaFake( $this->getArguments(), $this->getSettings(), $this->getOptions() );
    }

    function getBeforeContent() {
		if ($this->argExists('before_content')) {
    		$before_content = html_entity_decode($this->getArgument('before_content'));
			if (has_filter('wpml_translate_single_string')) {
				$wpml_before_content = apply_filters('wpml_translate_single_string', $before_content, 'rating-form', 'Before Content ID ' . $this->getID());
			} else {
				$wpml_before_content = $before_content;
			}
			return '<div class="rating_before_content">' . ($wpml_before_content == $before_content ? $before_content : $wpml_before_content) . '</div>';
		}

    }

    function getAfterContent() {
		if ($this->argExists('after_content')) {
    		$after_content = html_entity_decode($this->getArgument('after_content'));
			if (has_filter('wpml_translate_single_string')) {
				$wpml_before_content = apply_filters('wpml_translate_single_string', $after_content, 'rating-form', 'After Content ID ' . $this->getID());
			} else {
				$wpml_before_content = $after_content;
			}
			return '<div class="rating_after_content">' . ($wpml_before_content == $after_content ? $after_content : $wpml_before_content) . '</div>';
		}
    }

    function isRichSnippet() {
    	return ($this->optionExists('rich_snippet') && $this->argExists('rich_snippet') && !$this->argExists('widget'));
    }

    function getMicroDataItem() {
        return $this->md_item_type;
    }

    function getDefaultMDItem() {
        $type = apply_filters('rating_form_itemtype', 'itemscope="itemscope" itemtype="http://schema.org/Article"');
        if ($this->isRichSnippet()) return ($this->getOption('remove_rs_itemtype') ? '' : ' ' . $type);
    }

    function setMicroDataItem( $type ) {
        $this->md_item_type = $type;
    }

    function getRichSnippetType() {
        return $this->getOption('rich_snippet_type');
    }

    function isSchemaType( $str ) {
        return ($this->getRichSnippetType() == $str);
    }

    function richSnippetOnHome() {
        if ($this->isSchemaType('jsonld') || is_home() || is_front_page() ) $this->setMicroDataItem('');
    }

    function getRichSnippet() {
        if ($this->isRichSnippet()) {
            $rs = new RF_Rich_Snippet($this);
            return $rs->output();
        }
    }

    function getDivCursor() {
        return $this->cursor;
    }

    function getDivResult() {
        return $this->div_result;
    }

    function getDivClasses() {
        $html = '';
        $html .= $this->getDivResult();
        $html .= $this->getDivCursor();
        if ($this->isRedirect()) $html .= ' redirect_on';
        if ($this->getOption('spinner_check')) $html .= ' ' . $this->getOption('spinner_type') . '_on';
        if ($this->optionExists('empty')) $html .= ' empty_on';
        if ($this->argExists('stats')) $html .= ' stats_on';
        if ($this->argExists('user_stats')) $html .= ' user_stats_on';
        if (wp_is_mobile()) $html .= ' rf_mobile';
        if (wp_is_mobile() && $this->optionExists('hover_click')) $html .= ' rf_hover_click';
        if ($this->hasUserRated()) $html .= ' user_rating';
        return $html;
    }

    function getDivAttributes() {
        $attrs = '';
        if ($this->isReview()) $attrs = $this->addAttr('data-state', 'comment_review');

        if ($this->isRedirect()) {
            if (!empty($this->getOption('redirect_url')))
                $attrs .= $this->addAttr('data-redirect-url', $this->getRedirectURL());
            if (!empty($this->getOption('redirect_params')) && !empty($this->getOption('redirect_url')))
                $attrs .= $this->addAttr('data-redirect-params', $this->getRedirectParams());
            if (!empty($this->getOption('redirect_target')))
                $attrs .= $this->addAttr('data-redirect-target', $this->getRedirectTarget());
        }

        if ($this->hasUserRated() && $this->getOption('edit_rating_direct')) {
            $attrs .= $this->addAttr('data-edit-id', $this->getUserRatings()['rate_id']);
        }

        return $attrs;
    }

    function addAttr($key, $val) {
        return ' ' . $key . '="' . $val . '"';
    }

    function getRedirectURL() {
        if (!empty($this->getOption('redirect_url'))) return $this->getOption('redirect_url');
    }

    function getRedirectParams() {
        if (!empty($this->getOption('redirect_params'))) return $this->getOption('redirect_params');
    }

    function getRedirectTarget() {
        if (!empty($this->getOption('redirect_target'))) return $this->getOption('redirect_target');
    }

    function isRedirect() {
        return $this->getOption('redirect_check') && !empty($this->getOption('redirect_url'));
    }

    function getUserRatings() {
		return $this->user_data;
    }

    function getUserRating() {
        return $this->user_rating;
    }

    function hasUserRated() {
        return (array_key_exists('rate_id', $this->getUserRatings()));
    }

    function setIsResult() {
        if ($this->argExists('result')) {
            $this->cursor = '';
            $this->setArgument('title', false);
            $this->div_result = ' rating_form_result';
        }
    }

    function applyUserRating() {
        $rated = empty($this->getUserRatings()['rated']) ? 0 : $this->getUserRatings()['rated'];
        $rating = ($rated == $this->getUpValue() ? 1 : ($rated == $this->getDownValue() ? 2 : $rated));
        $this->setUserRating($rating);
    }

	/**
	 * Do not display Rating Form if pages are AMP
	 * Plugin: https://wordpress.org/plugins/amp/
	 *
	 * defined('AMP__FILE__') - Check if AMP plugin is enabled
	 */
    function isAMP() {
        // Permalink used, check if current URL ends with amp/
        $url_amp_enabled = preg_match("/\/amp\/?$/", $_SERVER['REQUEST_URI']) ? true : false;
        $get_amp_enabled = isset($_GET['amp']) && $_GET['amp'] == 1 ? true : false; // no permalink
        return ($get_amp_enabled || $url_amp_enabled);
    }

    function isPostTypeAllowed() {
        $db_post_types = (empty($this->getOption('post_type')) ? array() : $this->getOption('post_type'));
        return (count($db_post_types) == 0) ? true : in_array( get_post_type( $this->getArgument('post_id') ), $db_post_types);
    }

    function userRoleAllowed() {
        $current_user = wp_get_current_user();
        $anyUserRolesSlctd = false;
    	$db_user_roles = (empty($this->getOption('user_role')) ? array() : $this->getOption('user_role'));
    	if ( !$this->isAdmin() && !$this->getArgument('widget') ) {
    		if (!array_intersect($db_user_roles, $current_user->roles) && count($db_user_roles) > 0) {
    			$anyUserRolesSlctd = true;
    		}
    	}

    	if ($anyUserRolesSlctd && !$this->getOption('public_view'))  {
    		$this->setVisibility(false);
    	} else if ($anyUserRolesSlctd && $this->getOption('public_view')) {
    		// Public View = ON: rating form is visible to none defined user roles aswell but cannot vote.
    		if (!array_intersect($db_user_roles, $current_user->roles) && count($db_user_roles) > 0) {
    			$this->setArgument('result', true);
    		}
    	}
    }

    function includePostID() {
        $post_ids = empty($this->getOption('post_ids')) ? '' : $this->getOption('post_ids');
        if (empty($post_ids)) return;

        $array = explode(',', $post_ids);
        if (count($post_ids) > 0 && !in_array($this->getArgument('post_id'), $array)) {
            $this->setVisibility(false);
        }
    }

    function excludePostID() {
        $post_ids = empty($this->getOption('ex_post_ids')) ? '' : $this->getOption('ex_post_ids');
        if (empty($post_ids)) return;

		$array = explode(',', $post_ids);
        if (count($post_ids) > 0 && in_array($this->getArgument('post_id'), $array)) {
            $this->setVisibility(false);
        }
    }

    function setIsEditRatingDirect() {
        if ($this->getCount() == 0 || !$this->getOption('edit_rating_direct') || $this->argExists('result')) return;

        $this->div_result = '';
        $this->setOption('icon_half', ($this->getSetting('type') == 0 ? '-empty' : $this->getOption('icon_empty')));
        if ($this->hasUserRated()) {
            $this->setRatingPosition( $this->getUserRating() );
            $this->setRatingHalfPosition(0);
        }
    }

    function getEditRatingMessage() {
        if ($this->getCount() == 0 || !$this->getOption('show_edit_rating_text') || $this->argExists('result')) return;

    	$translatedMsgs = Rating_Form_API::getTranslationForm( $this->getID(), $this->getOption('messages') );
        $count = ($this->getRatingPosition() - 1);
        return '<div class="edit_rating_text">' . sprintf($translatedMsgs['edit_rating'], $count, $this->getTitleByPosition($count)) . '</div>';
    }

    /*function inlineStyle() {
        $id = $this->getID();
		if( !wp_style_is( 'rating-form-'. $id .'-style') ) {
			wp_register_style( 'rating-form-'. $id .'-style', false );
			wp_enqueue_style( 'rating-form-'. $id .'-style' );
			// Inline CSS
			return Rating_Form_API::getInlineStyle( $this->getSettings() );
		}
    }*/

	// Rating Form Args Settings
	// TODO: Place all form settings here for JS functions. Like stats=true, results=false,score
	function getDivSettings() {
        $html = '';
        $args = $this->getArguments();
		// Structure
		if (!empty($args['custom_id_group'])) {
			$cig = is_array($args['custom_id_group']) ? implode(',', $args['custom_id_group']) : $args['custom_id_group'];
			$this->addDivSetting('rf-cig', $cig);
		}
		if (!empty($this->div_settings)) {
			$html .= '<span class="rf_form_data">';
			$html .= $this->div_settings;
			$html .= '</span>';
		}

		return $html;
	}

    function addDivSetting($key, $value) {
        $this->div_settings .= '<span class="rf_settings" data-'. $key .'="' . $value . '"></span>';
    }

    function setTooltipPosition($tb, $lmr) {
        $tb = trim($tb);
        $lmr = trim($lmr);
        $setting = $tb . '-' . $lmr;
        $this->addDivSetting( 'rf-tip-position', $setting );
    }

    function setTooltipArrowPosition($tb, $lmr) {
        $tb = trim($tb);
        $lmr = trim($lmr);
        $setting = $tb . '-' . $lmr;
        $this->addDivSetting( 'rf-tip-arrow-position', $setting );
    }

    function setStatsPosition() {
        if ( !$this->optionExists('move_stats_bottom') ) return;

        $position = 'bottom';
        $this->addDivSetting( 'rf-stats-position', $position );
    }

    function addTranslationsWPML() {
        if ($this->optionExists('wpml_translate')) {
			// before_content - WPML register string for translation
			if (has_action('wpml_register_single_string')) {
				if ($this->argExists('before_content')) {
					do_action('wpml_register_single_string', 'rating-form', 'Before Content ID ' . $this->getID(), html_entity_decode($this->getArgument('before_content')));
				}
			}
			// after_content - WPML register string for translation
			if (has_action('wpml_register_single_string')) {
				if ($this->argExists('after_content')) {
					do_action('wpml_register_single_string', 'rating-form', 'After Content ID ' . $this->getID(), html_entity_decode($this->getArgument('after_content')));
				}
			}
		}
    }
}
?>
