<?php
// Shortcodes
// Add rating
function rating_form_rating_add() {
	if(isset($_POST['form_id']) && isset($_POST['rated'])) {

		global $wpdb;
		$new_rating_id = 0;

		// Global settings
		$globalSettings = Rating_Form_API::getSettings();
		// Check
		$restriction_types = empty($globalSettings['rating_types']) ? array( 'cookie' ) : $globalSettings['rating_types'];
		$restriction_cookie_hours = empty($globalSettings['cookie_restrict_time']) ? 24 : $globalSettings['cookie_restrict_time'];

		$ip = Rating_Form_API::getIP();
		$storeIP = (in_array("save_ip", $globalSettings) ? $ip : '');
		$current_user = wp_get_current_user();
		$user = $current_user->ID;
		preg_match("/RF(\d*)/", $_POST['form_id'], $form_id_array);
		$form_id = empty($form_id_array[1]) ? 0 : $form_id_array[1];
		preg_match("/P(\d*)/", $_POST['form_id'], $post_id_array);
		$post_id = empty($post_id_array[1]) ? 0 : $post_id_array[1];
		preg_match("/\dCO(\d*)/", $_POST['form_id'], $comment_id_array);
		$comment_id = empty($comment_id_array[1]) ? 0 : $comment_id_array[1];
		preg_match("/\dCU(.*)/", $_POST['form_id'], $custom_id_array);
		$custom_id = empty($custom_id_array[1]) ? '0' : $custom_id_array[1];
		preg_match("/\dU(\d*)/", $_POST['form_id'], $user_id_array);
		$user_id = empty($user_id_array[1]) ? 0 : $user_id_array[1]; // current user voted on someone else
		preg_match("/\dT(\d*)/", $_POST['form_id'], $term_id_array);
		$term_id = empty($term_id_array[1]) ? 0 : $term_id_array[1];
		$rated = $_POST['rated'];
		$score = $_POST['score'] == 'true' ? true : false;
		$total = $_POST['total'] == 'true' ? true : false;
		$rates = trim($_POST['rates']);
		$txt_score = $_POST['txt_score'];
		$tooltip = $_POST['tooltip'] == 'true' ? true : false;
		$rich_snippet = $_POST['rich_snippet'] == 'true' ? true : false;
		$cig = empty($_POST['custom_id_group']) ? '' : $_POST['custom_id_group'];
		$title = $_POST['title'] == 'true' ? true : false;
		$stats = $_POST['stats'] == 'true' ? true : false;
		$user_stats = $_POST['user_stats'] == 'true' ? true : false;
		$edit_rating_on = empty($_POST['edit_rating']) ? false : true;
		$edit_rating_id = empty($_POST['edit_rating']) ? 0 : $_POST['edit_rating'];
		$before_content = empty($_POST['before_content']) ? '' : $_POST['before_content'];
		$after_content = empty($_POST['after_content']) ? '' : $_POST['after_content'];

		$args = array(
			'post_id' => $post_id,
			'comment_id' => $comment_id,
			'custom_id' => $custom_id,
			'user_id' => $user_id,
			'term_id' => $term_id,
			'ip' => $storeIP,
			'user' => $user,
			'rated' => $rated
		);

		// Rating Form Settings
		$settings_sql = "SELECT form_id, form_name, type, css, display, date  FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM . " WHERE form_id = %s";
		$settings =  $wpdb->get_row( $wpdb->prepare($settings_sql, $form_id), ARRAY_A );
		$options = Rating_Form_API::getOptions( $settings['display'] );
		// Settings
		$max = empty($options['max']) ? 5 : intval($options['max']);
		$round = empty($options['round']) ? 1 : intval($options['round']);
		$fake_ratings = $options['fake_ratings'];
		$amountOfVotes = empty($options['limitation']) ? 1 : intval($options['limitation']);
		$hideAfterVoting =  $options['hide_after_vote'];

		if ($edit_rating_on == false) {
			$ratingCookieCheck = (in_array("cookie", $restriction_types) && Rating_Form_API::cookieCheck( $args ));
			$ratingIPCheck = (in_array("ip", $restriction_types) && Rating_Form_API::ipAddressCheck( $ip, $args ));
			// Amount of votes cookie
			$cookieAmountOfVotes = ($ratingCookieCheck) ? $_COOKIE['rf_rating-' . Rating_Form_API::getDivID( $args )] : $amountOfVotes;

			// Check if User / IP / Cookie already voted
			$checkArgs = $args;
			$checkArgs['id'] = intval($form_id);
			$checkArgs['ip_check'] = $ratingIPCheck;
			$checkArgs['cookie_check'] = $ratingCookieCheck;
			$checkArgs['cookie_amount'] = $cookieAmountOfVotes;
			checkRating($checkArgs, $settings, $options);

			if (in_array("cookie", $restriction_types)) {
				$cookieArgs = $args;
				$cookieArgs['cookie_amount'] = ($cookieAmountOfVotes > 0 ? ($cookieAmountOfVotes - 1) : 0);
				$cookieArgs['cookie_expiration'] = time() + ( 60 * 60 * $restriction_cookie_hours );
				Rating_Form_API::setCookie( $cookieArgs );
			}
			// Insert rating
			$wpdb->insert( $wpdb->prefix.Rating_Form_Setup::TBL_RATING_LOG, $args);

			$new_rating_id = $wpdb->insert_id;
			// New rating hook
			if (!empty($new_rating_id)) {
				do_action( 'rating_form_new_rating', $new_rating_id, $post_id, $user );
			}
			// Fake ratings update
			if ($fake_ratings) {
				$pmeta_fake_average = get_post_meta($post_id, 'rf_fake_average', true);
				if (empty($pmeta_fake_average)) $pmeta_fake_average = 0;
				$pmeta_fake_total = get_post_meta($post_id, 'rf_fake_total', true);
				if (empty($pmeta_fake_total)) $pmeta_fake_total = 0;
				$pmeta_fake_up = get_post_meta($post_id, 'rf_fake_up', true);
				if (empty($pmeta_fake_up)) $pmeta_fake_up = 0;
				$pmeta_fake_down = get_post_meta($post_id, 'rf_fake_down', true);
				if (empty($pmeta_fake_down)) $pmeta_fake_down = 0;

				if (Rating_Form_Setup::form_types($settings['type'], 'type') == "star") {
					// averagenew = averageold + ((valuenew − averageold) / sizenew)
					$rf_fake_total = $pmeta_fake_total+1;
					$rf_fake_average = round(($pmeta_fake_average+(($rated-$pmeta_fake_average)/$rf_fake_total)), $round);
					update_post_meta($post_id, 'rf_fake_average', $rf_fake_average);
					update_post_meta($post_id, 'rf_fake_total', $rf_fake_total);
				} else if (Rating_Form_Setup::form_types($settings['type'], 'type') == "tud") {
					update_post_meta($post_id, 'rf_fake_up', $pmeta_fake_up+1);
					update_post_meta($post_id, 'rf_fake_down', $pmeta_fake_down+1);
				}
			}
		} else {
			// Edit rating
			$wpdb->update( $wpdb->prefix.Rating_Form_Setup::TBL_RATING_LOG,
					array(
						'rated' => $rated
					),
					array( 'rate_id' => intval($edit_rating_id) ),
					array(
						'%s'
					),
					array( '%d' )
				);
		}

		$atts = array(//TODO: remove not needed attributes from Ajax
			'id' => intval($form_id),
			'post_id' => intval($post_id),
			'comment_id' => intval($comment_id),
			'custom_id' => $custom_id,
			'user_id' => intval($user_id),
			'term_id' => intval($term_id),
			'title' => $title,
			'score' => $score,
			'total' => $total,
			'stats' => $stats,
			'user_stats' => $user_stats,
			'tooltip' => $tooltip,
			'result' => false,
			'rich_snippet' => $rich_snippet,
			'custom_id_group' => $cig,
			'rates' => $rates,
			'before_content' => $before_content,
			'after_content' => $after_content,
			'txt_score' => $txt_score
		);

		// Get Response Rating Data
		echo rfVoteCastData($atts, false, $settings, $options);
	}
	die();
}
function rfVoteCastData($args, $ajax = false, $settings, $options) {
	// Options
	$amountOfVotes = empty($options['limitation']) ? 1 : intval($options['limitation']);
	$hideAfterVoting =  $options['hide_after_vote'];
	$showTyAfterVoting =  $options['show_ty_after_vote'];

	$data 	 				= Rating_Form_API::getData($args, $settings, $options);
	$iconPoss 				= Rating_Form_API::getRatingPositions($data['average']);
	$data['icon_count'] 	= $iconPoss['icon_count'];
	$data['icon_half'] 		= $iconPoss['icon_count'] == $iconPoss['icon_half'] ? 0 : $iconPoss['icon_half'];
	if (!$ajax) $data['thankyou'] = Rating_Form_API::getSuccessMessage($args['id'], $options['messages'], $options['hide_msg_success']);
	$editMsgArgs = array();
	$editMsgArgs['id'] = $settings['form_id'];
	$editMsgArgs['type'] = $settings['type'];
	$editMsgArgs['titles'] = $options['title'];
	$editMsgArgs['messages'] = $options['messages'];
	$editMsgArgs['show_edit_rating_text'] = $options['show_edit_rating_text'];
	$editMsgArgs['index'] = $data['average'];
	if (!$ajax && ($options['edit_rating'] || $options['edit_rating_direct'])) $data['edit_rating'] = Rating_Form_API::getEditRatingMessage( $editMsgArgs );
	if (!$ajax) $data['scripts'] = Rating_Form_API::updateShortcodeData($args, $data['average'], $options);//TODO: move js script from php to frontend JS?
	if (!$ajax) Rating_Form_API::updateMetaRatings($args, $data);
	// Include Options
	if ($hideAfterVoting && ( intval( $data['count'] ) >= $amountOfVotes )) $data['hide_after_vote'] = true;
	if ($showTyAfterVoting) $data['show_ty_after_vote'] = true;

	$data['up_count'] = empty($data['up_count']) ? 0 : $data['up_count'];
	$data['down_count'] = empty($data['down_count']) ? 0 : $data['down_count'];
	$data['count'] = empty($data['count']) ? 0 : $data['count'];

	return json_encode( $data );
}
// Check if User / IP / Cookie already voted
function checkRating( $args, $settings, $options) {
	global $wpdb;

	$message = '';
	$form_restriction = $options['restrict_ip'];
	$isUserLoggedIn = $options['user_logged_in'];
	$amountOfVotes = empty($options['limitation']) ? 1 : intval($options['limitation']);
	$time = empty($options['time']) ? 0 : intval($options['time']);
	$ratingIPCheck = $args['ip_check'];
	$ratingCookieCheck = $args['cookie_check'];
	$cookieAmountOfVotes = intval($args['cookie_amount']);

	$currentUser = wp_get_current_user();
	$currentUserID = $args['user'];
	if ($isUserLoggedIn && !empty($currentUserID)) { // User validation
		$user_val = $currentUserID;
		$user_ip = 'user';
		$user_ip_val = $currentUserID;
 	} else { // IP validation active
		$user_ip = 'ip';
		$user_ip_val = $args['ip'];
	}

	$sql  = 'SELECT date, ';
	$sql .= ($amountOfVotes >= 1 && $time > 0) ? 'NOW() AS dateNow, ' : '';
	$sql .= "SUM(CASE WHEN (rated = '1u' || rated = '1d') then 1 else 0 end) AS tudCount, ";
	$sql .= "SUM(CASE WHEN rated REGEXP '^[0-9]+$' then 1 else 0 end) AS starCount ";
	$sql .= 'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . ' ';
	$sql .= "WHERE post_id = %d ";
	$sql .= "AND comment_id = %d ";
	$sql .= "AND term_id = %d ";
	$sql .= "AND user_id = %d ";
	$sql .= "AND custom_id = %s ";
	$sql .= "AND " . $user_ip . " = %s ";
	$sql .= ($amountOfVotes >= 1 && $time > 0) ? "AND date >= DATE_SUB(NOW(), INTERVAL '".  $time ."' SECOND)" : '';

	$sql_args = array(
		$args['post_id'],
		$args['comment_id'],
		$args['term_id'],
		$args['user_id'],
		$args['custom_id'],
		$user_ip_val
	);
	$votes = $wpdb->get_row( $wpdb->prepare( $sql, $sql_args ), ARRAY_A);
	$totalVotes = (Rating_Form_Setup::form_types($settings['type'], 'type') == 'star' ? $votes['starCount'] : $votes['tudCount']);

	// Get translation Messages
	$translatedMsgs = Rating_Form_API::getTranslationForm($args['id'], $options['messages']);
	if ($isUserLoggedIn && !is_user_logged_in()) {
		$text = '<span class="def rated login">' . $translatedMsgs['login'] . '</span>';
		$message = array('login' => $text);
		// Check if anonymous / user has voted
		// Also if total user votes is higher or equel to defined amount of votes
		// And check if restriction is active
	} else if ((($ratingIPCheck && ($totalVotes >= $amountOfVotes)) || ($ratingCookieCheck && (0 >= $cookieAmountOfVotes))) && ($totalVotes > 0) && $form_restriction) {
		$text = '<span class="def rated">' . $translatedMsgs['rated'] . '</span>';
		$message = array('rated' => $text);
	} else if ($amountOfVotes >= 1 && $time > 0) {
		if ($totalVotes == $amountOfVotes && !$form_restriction) {
			$calculateTimeLeft = ((strtotime($votes['date']) + $time) - strtotime($votes['dateNow']));
			$formatDateTime = Rating_Form_API::formatDateTime($calculateTimeLeft);
			$formatText = sprintf($translatedMsgs['limit'], $formatDateTime['seconds'], $formatDateTime['minutes'], $formatDateTime['hours'], $formatDateTime['days']);
			$text = '<span class="def rated limit">' . $formatText . '</span>';
			$message = array('limit' => $text, 'time_left' => $calculateTimeLeft);
		}
	}
	if ( !$message == '' ) {
		echo json_encode($message);
		die();
	}
}
// Ajax Load - Rating Form
function display_rating_form_ajax() {
	if (isset($_POST['args'])) {
		global $wpdb;
		$args = Rating_Form_API::initArgs($_POST['args']);

		$settings_sql = "SELECT form_id, form_name, type, css, display, date  FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM . " WHERE form_id = %s";
		$settings =  $wpdb->get_row( $wpdb->prepare($settings_sql, intval($args['id'])), ARRAY_A );
		$options = Rating_Form_API::getOptions( $settings['display'] );

		echo rfVoteCastData( $args, true, $settings, $options );
	}
	die();
}
// Ajax Load - Rating Form Total
function display_rating_form_total_ajax() {
	if (isset($_POST['args'])) {
		echo wrap_rating_form_total( $_POST['args'], true );
	}
	die();
}
// Ajax Load - Rating Form Results
function display_rating_form_results_ajax() {
	if(isset($_POST['args'])) {
		echo wrap_rating_form_results( $_POST['args'], true );
	}
	die();
}
// Admin Ajax
// Block User
function rating_form_block_user() {
	if(isset($_POST['user']) && isset($_POST['description'])) {
		global $wpdb;

		$user = trim($_POST['user']);
		$description = trim($_POST['description']);

		$exist_query = $wpdb->get_results( "SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_BLOCK_LIST . " WHERE ip = '". $user ."';", ARRAY_A );
		$exist_num_rows = $wpdb->num_rows;

		if ($exist_num_rows == 0) {
			if (empty($user)) {
				echo '<div class="rf_error">' . __( 'Field User is empty', 'rating-form' ) . '</div>';
			} else {
				$wpdb->insert( $wpdb->prefix.Rating_Form_Setup::TBL_RATING_BLOCK_LIST, array(
								'ip' => $user,
								'reason' => $description ));

				echo '<script>window.location.href = "' . admin_url( 'admin.php?page=' . Rating_Form_Setup::PAGE_BLOCK_LIST_SLUG . '&message=1' ) . '"</script>';
			}
		} else {
			echo '<div class="rf_error">' . __( 'User is already blocked', 'rating-form' ) . '</div>';
		}
	} else {
		echo '<div class="rf_error">' . __( 'Error! User not added.', 'rating-form' ) . '</div>';
	}
	die();
}
// Edit Blocked User
function rating_form_block_list_edit() {
	if(isset($_POST['user'], $_POST['edited_user'], $_POST['description'])) {
		global $wpdb;

		$user = trim($_POST['user']);
		$edited_user = trim($_POST['edited_user']);
		$description = trim($_POST['description']);

		$exist_query = $wpdb->get_results( "SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_BLOCK_LIST . " WHERE ip = '". $user ."';", ARRAY_A );
		$exist_num_rows = $wpdb->num_rows;
		$exist_query2 = $wpdb->get_results( "SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_BLOCK_LIST . " WHERE ip = '". $edited_user ."';", ARRAY_A );
		$exist_num_rows2 = $wpdb->num_rows;

		if (empty($edited_user)) {
			echo '<span class="ip_error" style="color:red"> | ' . __( 'Field User is empty', 'rating-form' ) . '</span>';
		} else if ($exist_num_rows2 > 0) {
			echo '<span class="ip_error" style="color:red"> | ' . __( 'Error! User already exists.', 'rating-form' ) . '</span>';
		} else {
			if ($exist_num_rows > 0) {
				$wpdb->update( $wpdb->prefix.Rating_Form_Setup::TBL_RATING_BLOCK_LIST, array(
						'ip' => $edited_user,
						'reason' => $description
				), array('user' => $user ) );

				echo '<span class="ip_edited" style="color:green"> ' . __( 'Successfully updated!', 'rating-form' ) . '</span>';
			}
		}
	} else {
		echo '<span class="ip_error" style="color:red"> ' . __( 'Error! User not updated.', 'rating-form' ) . '</span>';
	}
	die();
}
// Filter Rating Results table
function rating_form_filter_results() {
	if (isset($_POST['rf_results_filter'], $_POST['type_id'], $_POST['page_no'], $_POST['form_type'])) {
		$sort_by = $page_type	= array();

		$save_filters			= empty($_POST['rf_results_save_filter']) ? array() : $_POST['rf_results_save_filter'];
		$rf_results_filter 		= empty($_POST['rf_results_filter']) ? array() : $_POST['rf_results_filter'];
		$sort_by				= empty($_POST['rf_results_filter']) ? array() : $rf_results_filter['sort_by'];
		$page_type				= empty($rf_results_filter['page_type']) ? array() : $rf_results_filter['page_type'];
		$page_no				= $_POST['page_no'];
		$type_id				= $_POST['type_id'];
		$form_types				= $_POST['form_type'];
		$type_custom_id			= empty($rf_results_filter['type_custom_id']) ? array() : $rf_results_filter['type_custom_id'];

		$rfTableResults 		= new RF_Table_Results();
		$rfTableResults->setSortBy($sort_by);
		$rfTableResults->setPageType($page_type);
		$rfTableResults->setPageNo($page_no);
		$rfTableResults->setFormType($form_types);
		$rfTableResults->setTypeCustomID($type_custom_id);
		$rfTableResults->ajaxTypeID($type_id);
		$rfTableResults->results();
		$rfTableResults->show();

		if (isset($save_filters) && $save_filters == 1) {
			$filters = $_POST;
			unset($filters['action']);
			update_option(Rating_Form_Setup::PAGE_RESULT_RATING_SLUG, $filters);
		}
	}
	die();
}
// Rating Results Delete Rating
function rf_results_delete() {
	if (isset($_POST['action'], $_POST['id'])) {
		global $wpdb;

		$wpdb->query(
			$wpdb->prepare(
					"DELETE FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . " WHERE rate_id = %d",
					$_POST['id']
				)
		);
		echo $wpdb->num_rows;
	}
	die();
}
// Rating Results Delete Rating
function rf_results_edit() {
	if (isset($_POST['action'], $_POST['id'], $_POST['rating'])) {
		global $wpdb;

		$edit_rating_id = $_POST['id'];
		$rated = $_POST['rating'];
		//Edit rating
		$wpdb->update( $wpdb->prefix.Rating_Form_Setup::TBL_RATING_LOG,
				array(
					'rated' => $rated
				),
				array( 'rate_id' => intval($edit_rating_id) ),
				array(
					'%s'
				),
				array( '%d' )
			);
		$rated = ($rated == '1d' ? '-1' : $rated);
		$rated = ($rated == '1u' ? '+1' : $rated);
		echo $rated;
	}
	die();
}
// Block list - Get user list and ip list
function rf_user_ip_list() {
	global $wpdb;

	$users = array();
	// Array of WP_User objects.
	$get_users = get_users( array( 'fields' => array( 'ID', 'display_name' ) ) );
	foreach ( $get_users as $user ) {
		$users[] = array(
			'label' => $user->display_name,
			'value' => $user->ID,
		);
	}
	// Get existing IP's
	$sql = 'SELECT ip FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . ' WHERE ip != "" GROUP BY ip';
	$rows = $wpdb->get_results($sql, ARRAY_A);

	foreach ($rows as $row) {
		$users[] = array(
			'label' => $row['ip'],
			'value' => $row['ip'],
		);
	}
	echo json_encode( $users );

	die();
}
function rf_admin_notice() {
	update_option('rf_admin_notice', 0);
	die();
}
function rf_ratings_approve_add() {
	if (isset($_POST['ratings'])) {
		$ratings = empty($_POST['ratings']) ? array() : $_POST['ratings'];

		$option_settings = get_option(Rating_Form_Setup::PAGE_SETTINGS_SLUG);
		$option_settings = (empty($option_settings) ? array() : $option_settings);
		$option_settings['approval_ratings'] = $ratings;

		update_option(Rating_Form_Setup::PAGE_SETTINGS_SLUG, $option_settings);
	}
	die();
}
// Filter Rating Results table
include_once ('shortcodes/snippets/rf-stats.php');
?>
