<?php
/*
Plugin Name: Rating Form
Plugin URI: https://ratingform.net/
Description: Create rating forms
Version: 1.6.4
Author: پرشین اسکریپت
Author URI: http://www.persianscript.ir
License: GPL
Text Domain: rating-form
Domain Path: /languages
*/

/**
 * Copyright 2014-2018 Serdar Gürler
 */

// Prevent direct access
defined( 'ABSPATH' ) || exit;

class Rating_Form_Setup
{
	private static $instance = null;

	const
	// Class
	PLUGIN_VERSION = '1.6.4',
	// Options
	OPTION_VERSION = 'rating_form_version',
	// Tables
	TBL_RATING_ADD_FORM = 'rating_form',
	TBL_RATING_LOG = 'rating_form_rated',
	TBL_RATING_TITLES = 'rating_form_titles',
	TBL_RATING_BLOCK_LIST = 'rating_form_block_ip',
	// Pages
	PAGE_RESULT_RATING_SLUG = 'rating_form_results',
	PAGE_FORM_RATING_SLUG = 'rating_forms',
	PAGE_TITLES_RATING_SLUG = 'rating_form_titles',
	PAGE_BLOCK_LIST_SLUG = 'rating_form_block_list',
	PAGE_NEW_RATING_SLUG = 'rating_form_add',
	PAGE_REVIEW_SLUG = 'rating_form_review',
	PAGE_TOOLS_RATING_SLUG = 'rating_form_tools',
	PAGE_SETTINGS_SLUG = 'rating_form_settings';

	// Initializes hooks
	public static function init() {
		if ( null == self::$instance ) {

            self::$instance = new Rating_Form_Setup;

			if ( is_admin() ) {
				add_action( 'admin_init', array( self::$instance, 'rf_admin_init' ) );
				add_action( 'admin_menu', array( self::$instance, 'add_admin_menus' ) );
				add_action( 'admin_enqueue_scripts', array( self::$instance, 'admin_header_snippets' ) );
			}

			add_action( 'init', array( self::$instance, 'load_textdomain' ) );
			add_action( 'wp_enqueue_scripts', array( self::$instance, 'assets_front' ) );

			self::$instance->ajax_actions();
			self::$instance->tools_filters();
			self::$instance->review_filters();
			self::$instance->files();
        }

		return Rating_Form_Setup::$instance;
	}

	// Include files
	function files() {
		require plugin_dir_path( __FILE__ ) . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'rating_form_list.php';
		require plugin_dir_path( __FILE__ ) . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'rating_form_titles.php';
		require plugin_dir_path( __FILE__ ) . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'rating_form_block_list.php';
		require plugin_dir_path( __FILE__ ) . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'rating_form_add.php';
		require plugin_dir_path( __FILE__ ) . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'rating_form_results.php';
		// require plugin_dir_path( __FILE__ ) . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'rating_form_review.php';
		require plugin_dir_path( __FILE__ ) . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'rating_form_tools.php';
		require plugin_dir_path( __FILE__ ) . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'rating_form_settings.php';
		require plugin_dir_path( __FILE__ ) . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'shortcode.php';
		require plugin_dir_path( __FILE__ ) . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'widget.php';
		require plugin_dir_path( __FILE__ ) . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'ajax.php';
		require plugin_dir_path( __FILE__ ) . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'rf-api.php';
		require plugin_dir_path( __FILE__ ) . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'rf-create.php';
		require plugin_dir_path( __FILE__ ) . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'shortcodes' . DIRECTORY_SEPARATOR . 'snippets' . DIRECTORY_SEPARATOR . 'rf-rich-snippet.php';
		require plugin_dir_path( __FILE__ ) . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'rf-validation.php';
	}

	public function ajax_actions() {
		// Ajax add new rating
		add_action( 'wp_ajax_nopriv_rating_form_rating_add', 'rating_form_rating_add' );
		add_action( 'wp_ajax_rating_form_rating_add', 'rating_form_rating_add' );
		// Ajax load a Rating Form
		add_action( 'wp_ajax_nopriv_display_rating_form_ajax', 'display_rating_form_ajax' );
		add_action( 'wp_ajax_display_rating_form_ajax', 'display_rating_form_ajax' );
		// Ajax load Statistics a Rating Form
		add_action( 'wp_ajax_nopriv_show_rf_stats', 'show_rf_stats' );
		add_action( 'wp_ajax_show_rf_stats', 'show_rf_stats' );
		// Ajax total average ratings
		add_action( 'wp_ajax_nopriv_display_rating_form_total_ajax', 'display_rating_form_total_ajax' );
		add_action( 'wp_ajax_display_rating_form_total_ajax', 'display_rating_form_total_ajax' );
		// Ajax block user
		add_action( 'wp_ajax_nopriv_rating_form_block_user', 'rating_form_block_user' );
		add_action( 'wp_ajax_rating_form_block_user', 'rating_form_block_user' );
		// Ajax edit blocked user
		add_action( 'wp_ajax_nopriv_rating_form_block_list_edit', 'rating_form_block_list_edit' );
		add_action( 'wp_ajax_rating_form_block_list_edit', 'rating_form_block_list_edit' );
		// Ajax results
		add_action( 'wp_ajax_nopriv_display_rating_form_results_ajax', 'display_rating_form_results_ajax' );
		add_action( 'wp_ajax_display_rating_form_results_ajax', 'display_rating_form_results_ajax' );
		// Ajax filter results
		add_action( 'wp_ajax_nopriv_rating_form_filter_results', 'rating_form_filter_results' );
		add_action( 'wp_ajax_rating_form_filter_results', 'rating_form_filter_results' );
		// Ajax results delete rating
		add_action( 'wp_ajax_nopriv_rf_results_delete', 'rf_results_delete' );
		add_action( 'wp_ajax_rf_results_delete', 'rf_results_delete' );
		// Ajax results edit rating
		add_action( 'wp_ajax_nopriv_rf_results_edit', 'rf_results_edit' );
		add_action( 'wp_ajax_rf_results_edit', 'rf_results_edit' );
		// Block list - autocomplete
		add_action( 'wp_ajax_nopriv_rf_user_ip_list', 'rf_user_ip_list' );
		add_action( 'wp_ajax_rf_user_ip_list', 'rf_user_ip_list' );
		// Admin notice accept
		add_action( 'wp_ajax_nopriv_rf_admin_notice', 'rf_admin_notice' );
		add_action( 'wp_ajax_rf_admin_notice', 'rf_admin_notice' );
	}

	// Front CSS
	public function assets_front() {
		if (Rating_Form_API::deactivateOnMobile()) return;
		if (Rating_Form_API::deactivateOnTablet()) return;
		wp_enqueue_script( 'jquery' );
		wp_enqueue_style( 'rating-form-cyto', plugins_url( 'assets\css\cyto.css', __FILE__ ), array(), Rating_Form_Setup::PLUGIN_VERSION );
		wp_enqueue_style( 'rating-form', plugins_url( 'assets\css\rating-form.css', __FILE__ ), array(), Rating_Form_Setup::PLUGIN_VERSION );
		wp_enqueue_script( 'rating-form-js', plugins_url('assets\js\front.js', __FILE__), array('jquery'), Rating_Form_Setup::PLUGIN_VERSION, true );
		wp_localize_script( 'rating-form-js', 'rating_form_script', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ) ) );
	}

	// Admin CSS
	function admin_header_snippets() {
		wp_enqueue_script( 'jquery' );
		wp_enqueue_script( 'wp-color-picker' );
		wp_enqueue_script( 'jquery-ui-datepicker' );
		wp_enqueue_script( 'jquery-ui-autocomplete' );
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_style( 'rating-form-datepicker', plugins_url( 'assets\css\datepicker.css', __FILE__ ), array(), Rating_Form_Setup::PLUGIN_VERSION );
		wp_enqueue_style( 'rating-form-cyto', plugins_url( 'assets\css\cyto.css', __FILE__ ), array(), Rating_Form_Setup::PLUGIN_VERSION );
		wp_enqueue_style( 'rating-form', plugins_url( 'assets\css\rating-form.css', __FILE__ ), array(), Rating_Form_Setup::PLUGIN_VERSION );
		wp_enqueue_style( 'rating-form-admin', plugins_url( 'assets\css\admin.css', __FILE__ ), array(), Rating_Form_Setup::PLUGIN_VERSION );
		wp_enqueue_script( 'rating-form-admin-js', plugins_url('assets\js\admin.js', __FILE__), array('jquery'), Rating_Form_Setup::PLUGIN_VERSION, true );
		wp_localize_script( 'rating-form-admin-js', 'rating_form_script', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ) ) );
	}

	// Admin init
	function rf_admin_init() {
		Rating_Form_Setup::add_buffer();
		Rating_Form_Setup::rf_plugin_update();
	}

	/**
	 * Output buffer function
	 *
	 * To avoid header already sent issue
	 * @link 	https://tommcfarlin.com/wp_redirect-headers-already-sent/
	 * @since 	1.4
	 */
	public function add_buffer() {
		ob_start();
	}

	//Admin menus
	function add_admin_menus() {
		global $wp_version;
		// Parent menu of Rating Form
		add_menu_page(
			__( 'Rating Form Results', 'rating-form' ),
			'Rating Form',
			'rating_form_manage',
			Rating_Form_Setup::PAGE_RESULT_RATING_SLUG,
			Rating_Form_Setup::PAGE_RESULT_RATING_SLUG,
			(( $wp_version >= 3.8 ) ? 'dashicons-star-filled' : null )
		);
		// Results
		add_submenu_page(
			Rating_Form_Setup::PAGE_RESULT_RATING_SLUG,
			__( 'Rating Form Results', 'rating-form' ),
			__( 'Results', 'rating-form' ),
			'rating_form_manage',
			Rating_Form_Setup::PAGE_RESULT_RATING_SLUG,
			Rating_Form_Setup::PAGE_RESULT_RATING_SLUG
		);
		// Forms
		add_submenu_page(
			Rating_Form_Setup::PAGE_RESULT_RATING_SLUG,
			__( 'Rating Forms', 'rating-form' ),
			__( 'Forms', 'rating-form' ),
			'rating_form_manage',
			Rating_Form_Setup::PAGE_FORM_RATING_SLUG,
			Rating_Form_Setup::PAGE_FORM_RATING_SLUG
		);
		// Titles
		add_submenu_page(
			Rating_Form_Setup::PAGE_RESULT_RATING_SLUG,
			__( 'Rating Form Titles', 'rating-form' ),
			__( 'Titles', 'rating-form' ),
			'rating_form_manage',
			Rating_Form_Setup::PAGE_TITLES_RATING_SLUG,
			Rating_Form_Setup::PAGE_TITLES_RATING_SLUG
		);
		// Block List
		add_submenu_page(
			Rating_Form_Setup::PAGE_RESULT_RATING_SLUG,
			__( 'Rating Form Block List', 'rating-form' ),
			__( 'Block List', 'rating-form' ),
			'rating_form_manage',
			Rating_Form_Setup::PAGE_BLOCK_LIST_SLUG,
			Rating_Form_Setup::PAGE_BLOCK_LIST_SLUG
		);
		// Add New Rating Form
		add_submenu_page(
			Rating_Form_Setup::PAGE_RESULT_RATING_SLUG,
			__( 'Add New Rating Form', 'rating-form' ),
			__( 'Add New', 'rating-form' ),
			'rating_form_manage',
			Rating_Form_Setup::PAGE_NEW_RATING_SLUG,
			Rating_Form_Setup::PAGE_NEW_RATING_SLUG
		);
		// Reviews
		// add_submenu_page(
			// Rating_Form_Setup::PAGE_RESULT_RATING_SLUG,
			// __( 'Rating Form Review', 'rating-form' ),
			// __( 'Reviews', 'rating-form' ),
			// 'rating_form_manage',
			// Rating_Form_Setup::PAGE_REVIEW_SLUG,
			// Rating_Form_Setup::PAGE_REVIEW_SLUG
		// );
		// Tools
		add_submenu_page(
			Rating_Form_Setup::PAGE_RESULT_RATING_SLUG,
			__( 'Rating Form Tools', 'rating-form' ),
			__( 'Tools', 'rating-form' ), 'rating_form_manage',
			Rating_Form_Setup::PAGE_TOOLS_RATING_SLUG,
			Rating_Form_Setup::PAGE_TOOLS_RATING_SLUG
		);
		// Settings
		add_submenu_page(
			Rating_Form_Setup::PAGE_RESULT_RATING_SLUG,
			__( 'Rating Form Settings', 'rating-form' ),
			__( 'Settings', 'rating-form' ), 'rating_form_manage',
			Rating_Form_Setup::PAGE_SETTINGS_SLUG,
			Rating_Form_Setup::PAGE_SETTINGS_SLUG
		);
	}

	//Admin menus array
	public static function admin_menus($curpagename = '') {
		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		$menu = '';

		$pages = array (
			Rating_Form_Setup::PAGE_RESULT_RATING_SLUG => __( 'Results', 'rating-form' ),
			Rating_Form_Setup::PAGE_FORM_RATING_SLUG => __( 'Rating Forms', 'rating-form' ),
			Rating_Form_Setup::PAGE_TITLES_RATING_SLUG => __( 'Titles', 'rating-form' ),
			Rating_Form_Setup::PAGE_BLOCK_LIST_SLUG => __( 'Block List', 'rating-form' ),
			Rating_Form_Setup::PAGE_NEW_RATING_SLUG => __( 'Add New', 'rating-form' ),
			// Rating_Form_Setup::PAGE_REVIEW_SLUG => __( 'Reviews', 'rating-form' ),
			Rating_Form_Setup::PAGE_TOOLS_RATING_SLUG => __( 'Tools', 'rating-form' ),
			Rating_Form_Setup::PAGE_SETTINGS_SLUG => __( 'Settings', 'rating-form' )
		);

		$menu .= '<div class="rf_header_nav">';
		$menu .= '<div class="rf_logo" title="' . get_option(Rating_Form_Setup::OPTION_VERSION) . '"><span class="cyto-star"></span>Rating <span>Form</span></div>';
		$menu .= '<div class="btn-mob-menu dashicons dashicons-menu"></div>';
		$menu .= '<ul>';

			$current_page = __( $curpagename, 'rating-form' );

			foreach ( $pages as $page_slug => $page_name ) {
				$active = isset( $_GET['page'] ) && $_GET['page'] == $page_slug ? ' class="rf_active"' : '';

				$menu .= '<li' . $active . '><a href="?page=' . $page_slug . '">' . (empty($active) || empty($curpagename) ? $page_name : $current_page) . '</a></li>';
			}

		$menu .= '</ul>';
		$menu .= '</div>';

		echo $menu;
	}

	public static function getAdminRTL() {
		$settings = get_option(Rating_Form_Setup::PAGE_SETTINGS_SLUG);
		$rtlAdmin = (empty($settings['rtl_admin']) ? 0 : $settings['rtl_admin']);
		return ($rtlAdmin == 1 ? ' dir="rtl"' : '');
	}

	public static function getAdminRTLclass() {
		$settings = get_option(Rating_Form_Setup::PAGE_SETTINGS_SLUG);
		$rtlAdmin = (empty($settings['rtl_admin']) ? 0 : $settings['rtl_admin']);
		return ($rtlAdmin == 1 ? ' rf_wrap_rtl' : '');
	}

	// Tools filters
	public function tools_filters() {
		if (is_admin()) return;
		$tools_options = get_option(Rating_Form_Setup::PAGE_TOOLS_RATING_SLUG);

		// Post / Pages before_content
		if (!empty($tools_options['before_content']['content'])) {
			function rf_before_content($content){
				$tools_options = get_option(Rating_Form_Setup::PAGE_TOOLS_RATING_SLUG);

				if (empty($tools_options['before_content']['paragraph'])) {
					return do_shortcode(stripslashes($tools_options['before_content']['content'])) . $content;
				} else {
					$paragraphAfter = intval($tools_options['before_content']['paragraph']); //Display shortcode after paragraph
					$content = explode("</p>", $content);
					for ($i = 0; $i <count($content); $i++) {
						if ($i == $paragraphAfter) {
							echo do_shortcode(stripslashes($tools_options['before_content']['content']));
						}
						echo $content[$i] . "</p>";
					}
				}
			}
			add_filter( 'the_content', 'rf_before_content' );
		}
		// Post / Pages after_content
		if (!empty($tools_options['after_content']['content'])) {
			function rf_after_content($content){
				$tools_options = get_option(Rating_Form_Setup::PAGE_TOOLS_RATING_SLUG);

				if (empty($tools_options['after_content']['paragraph'])) {
					return $content . do_shortcode(stripslashes($tools_options['after_content']['content']));
				} else {
					$paragraphAfter = intval($tools_options['after_content']['paragraph']); //Display shortcode after paragraph
					$content = explode("</p>", $content);
					for ($i = 0; $i <count($content); $i++) {
						if ($i == $paragraphAfter) {
							echo do_shortcode(stripslashes($tools_options['after_content']['content']));
						}
						echo $content[$i] . "</p>";
					}
				}
			}
			add_filter( 'the_content', 'rf_after_content' );
		}
		// Comment before_content
		if (!empty($tools_options['comment_text_before']['content'])) {
			function comment_text_before_content($content){
				$tools_options = get_option(Rating_Form_Setup::PAGE_TOOLS_RATING_SLUG);
				if (!empty($tools_options['comment_text_before']['content'])) {
					$shortcode = do_shortcode(stripslashes($tools_options['comment_text_before']['content']));
					return $shortcode . $content;
				}
			}
			add_filter('comment_text', 'comment_text_before_content');
		}
		// Comment after_content
		if (!empty($tools_options['comment_text_after']['content'])) {
			function comment_text_after_content($content){
				$tools_options = get_option(Rating_Form_Setup::PAGE_TOOLS_RATING_SLUG);
				if (!empty($tools_options['comment_text_after']['content'])) {
					$shortcode = do_shortcode(stripslashes($tools_options['comment_text_after']['content']));
					return $content . $shortcode;
				}
			}
			add_filter('comment_text', 'comment_text_after_content');
		}
	}

	// Review filters
	function review_filters() {
		$settings = get_option(Rating_Form_Setup::PAGE_REVIEW_SLUG);
		// Review - Comment
		if (!empty($settings['comment_review']['enable']) && $settings['comment_review']['enable'] == '1') {
			function review_comment_rating_field() {
				$settings = get_option(Rating_Form_Setup::PAGE_REVIEW_SLUG);
				$output = '';

				$rating_form = $settings['comment_review']['rating_form'];
				$label = empty($settings['comment_review']['label']) ? false : true;
				$required = !empty($settings['comment_review']['required']) && $settings['comment_review']['required'] == '1' ? true : false;

				// Output
				$output .= '<span class="comment-form-rating">';
				$output .= $label ? '<label for="rating">'.$settings['comment_review']['label'].' '. ($required ? '<span class="required">*</span>' : '').'</label>' : '';
				if (is_numeric($rating_form)) {
					$output .= do_shortcode('[rating_form id="' . $rating_form . '" comment_review="true" score="false"]');
				} else {
					$output .= do_shortcode(stripslashes($rating_form));
				}

				$output .= '</span>';

				echo $output;
			}
			// Review - comment_form_before_fields
			if ($settings['comment_review']['placement'] == 'before_fields') {
				function review_comment_rating_field_before() {
					return review_comment_rating_field();
				}
				add_action('comment_form_before_fields', 'review_comment_rating_field_before');
				add_action('comment_form_logged_in_after', 'review_comment_rating_field_before');
			}
			// Review - comment_form_after_fields
			if ($settings['comment_review']['placement'] == 'after_fields') {
				function review_comment_rating_field_after() {
					return review_comment_rating_field();
				}
				add_action('comment_form_after_fields', 'review_comment_rating_field_after');
				add_action('comment_form_logged_in_after', 'review_comment_rating_field_after');
			}
			// Add rating
			function review_comment_add_rating($comment_id){
				// Global settings
				$globalSettings = Rating_Form_API::getSettings();
				// Check
				$restriction_types = empty($globalSettings['rating_types']) ? array( 'cookie' ) : $globalSettings['rating_types'];

				$comment = get_comment($comment_id);
				$post_id = $comment->comment_post_ID;
				$custom_id = isset($_POST['rf_custom_id']) && !empty($_POST['rf_custom_id']) ? wp_filter_nohtml_kses($_POST['rf_custom_id']) : '0';
				$comment_author_email = $comment->comment_author_email;
				$user = get_user_by('email', $comment_author_email);
				$user = empty($user) ? 0 : $user->ID;
				$ip = (in_array("ip", $restriction_types)) ? $comment->comment_author_IP : '';

				if (isset($_POST['rf_rating']) && !empty($_POST['rf_rating'])){
					$rated = wp_filter_nohtml_kses($_POST['rf_rating']);
					add_comment_meta($comment_id, '_rf_rating', $rated, true);
					global $wpdb;
					// Insert rating
					$wpdb->insert( $wpdb->prefix.Rating_Form_Setup::TBL_RATING_LOG, array(
							'post_id' => $post_id,
							'comment_id' => $comment_id,
							'custom_id' => $custom_id,
							'ip' => $ip,
							'user' => $user,
							'rated' => $rated ));
				}
			}
			add_action('comment_post', 'review_comment_add_rating', 10);

			//add_action('comment_post', 'review_comment_update_rating', 10);
			function review_comment_verify_rating($commentdata) {
				$settings = get_option(Rating_Form_Setup::PAGE_REVIEW_SLUG);
				$required = !empty($settings['comment_review']['required']) && $settings['comment_review']['required'] == '1' ? true : false;

				$post_id = $commentdata['comment_post_ID'];
				$custom_id = isset($_POST['rf_custom_id']) && !empty($_POST['rf_custom_id']) ? wp_filter_nohtml_kses($_POST['rf_custom_id']) : '0';
				if ($required && isset($_POST['rf_rating']) && empty($_POST['rf_rating'])) {
					wp_die( __( 'Error: You are required to vote.', 'rating-form' ), null, array('back_link' => true) );
				}

				global $wpdb;
				$rating_form = $settings['comment_review']['rating_form'];
				if (is_numeric($rating_form)) {
					$form_id = $rating_form;
				} else {
					$rating_form_parse = shortcode_parse_atts(stripslashes($rating_form));
					var_dump($rating_form_parse);
					$form_id = intval($rating_form_parse['id']);
				}
				// Rating Form Settings
				$sql = "SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM . " WHERE form_id = %d";
				$this_form_query = $wpdb->get_row( $wpdb->prepare( $sql, $form_id ), ARRAY_A );
				// Settings
				$jsonDisplay = empty($this_form_query['display']) ? array() : json_decode($this_form_query['display'], true);
				$restrict_ip = in_array("restrict_ip", $jsonDisplay) ? true : false;
				$user_logged_in = in_array("user_logged_in", $jsonDisplay) ? true : false;

				// Check if User / Cookie / IP has any votes
				$checkUserArgs['user_check'] = true;
				$votes = Rating_Form_API::getData( $checkUserArgs, $this_form_query, Rating_Form_API::getOptions( $this_form_query['display'] ) );
				$hasVotes = (count($votes) > 0);

				if ($hasVotes > 0 && $restrict_ip) {
					wp_die( __( 'Error: You have already submitted a rating here.', 'rating-form' ), null, array('back_link' => true) );
				}

				return $commentdata;
			}
			add_filter('preprocess_comment', 'review_comment_verify_rating', 10);

			// Display rating in comment
			function review_comment_display_rating($comment_text) {
				$settings = get_option(Rating_Form_Setup::PAGE_REVIEW_SLUG);
				$output = '';

				$comment = get_comment();
				$user_id = empty($comment->user_id) ? 0 : $comment->user_id;
				$rating_form = $settings['comment_review']['rating_form'];
				$display_rating_form = $settings['comment_review']['display_rating_form'];

				if (is_numeric($rating_form)) {
					$output .= do_shortcode('[rating_form id="' . $rating_form . '" comment_id="' . $comment->comment_ID . '" user="' . $user_id . '" result="true" score="false" total="false"]');
				} else {
					$rating_form = stripslashes($rating_form);
					if (strpos($rating_form, 'result') !== false) {
						preg_replace('/]/g', ' comment_id="' . $comment->comment_ID . '" user="' . $user_id . '" result="true"]', $rating_form);
					}
					$output .= do_shortcode($rating_form);
				}
				$output .= $comment_text;

				echo $output;
			}
			add_filter('comment_text', 'review_comment_display_rating');
		}
	}

	/**
	 * Get term without knowing it's taxonomy
	 *
	 * @uses type $wpdb
	 * @uses get_term()
	 * @param int|object $term
	 * @param string $output
	 * @param string $filter
	 */
	public static function get_term_by_id($term, $output = OBJECT, $filter = 'raw') {
		global $wpdb;
		$null = null;

		if ( empty($term) ) {
			$error = new WP_Error('invalid_term', __('Empty Term'));
			return $error;
		}

		$_tax = $wpdb->get_row( $wpdb->prepare( "SELECT t.* FROM $wpdb->term_taxonomy AS t WHERE t.term_id = %s LIMIT 1", $term) );
		$taxonomy = $_tax->taxonomy;

		return get_term($term, $taxonomy, $output, $filter);

	}

	//Form Types
	public static $totalFormTypes = 8;
	public static function form_types($type, $val, $diff = '') {
		if ($type == 0) {
			if ($val == 'i') {
				return 10;
			}

			if ($val == 'type') {
				return "star";
			}

			if ($val == 'class') {
				return "cyto-custom";
			}

			if ($val == 'name') {
				return __( 'Custom', 'rating-form' );
			}
		} else if ($type == 1) {
			if ($val == 'i') {
				return 10;
			}

			if ($val == 'type') {
				return "star";
			}

			if ($val == 'class') {
				return "cyto-star";
			}

			if ($val == 'name') {
				return __( 'Star', 'rating-form' );
			}

			if ($val == 'css_color') {
				return "#ffd700";
			}

			if ($val == 'css_color_hover') {
				return "#ff7f00";
			}
		} else if ($type == 2) {
			if ($val == 'i') {
				return 2;
			}

			if ($val == 'type') {
				return "tud";
			}

			if ($val == 'class') {
				return "cyto-thumbs-up";
			}

			if ($val == 'class2') {
				return "cyto-thumbs-down";
			}

			if ($val == 'name') {
				return __( 'Thumbs Up &amp; Down', 'rating-form' );
			}

			if ($val == 'name_one') {
				return __( 'Thumbs Up', 'rating-form' );
			}

			if ($val == 'name_two') {
				return __( 'Thumbs Down', 'rating-form' );
			}
		} else if ($type == 3) {
			if ($val == 'i') {
				return 5;
			}

			if ($val == 'type') {
				return "star";
			}

			if ($val == 'class') {
				return "cyto-smiley-4";
			}

			if ($diff == 'int') {
				return "cyto-smiley-";
			}

			if ($val == 'name') {
				return __( 'Smiley', 'rating-form' );
			}

			if ($val == 'css_color') {
				return "#0074a2";
			}

			if ($val == 'css_color_hover') {
				return "#224e66";
			}
		} else if ($type == 4) {
			if ($val == 'i') {
				return 10;
			}

			if ($val == 'type') {
				return "star";
			}

			if ($val == 'class') {
				return "cyto-heart";
			}

			if ($val == 'name') {
				return __( 'Heart', 'rating-form' );
			}

			if ($val == 'css_color') {
				return "#ff0000";
			}

			if ($val == 'css_color_hover') {
				return "#af0000";
			}
		} else if ($type == 5) {
			if ($val == 'i') {
				return 2;
			}

			if ($val == 'type') {
				return "tud";
			}

			if ($val == 'class') {
				return "cyto-plus";
			}

			if ($val == 'class2') {
				return "cyto-min";
			}

			if ($val == 'name') {
				return __( 'Plus and Min', 'rating-form' );
			}

			if ($val == 'name_one') {
				return __( 'Plus', 'rating-form' );
			}

			if ($val == 'name_two') {
				return __( 'Min', 'rating-form' );
			}
		} else if ($type == 6) {
			if ($val == 'i') {
				return 10;
			}

			if ($val == 'type') {
				return "star";
			}

			if ($val == 'class') {
				return "cyto-circle";
			}

			if ($val == 'name') {
				return __( 'Circle', 'rating-form' );
			}

			if ($val == 'css_color') {
				return "#0094FF";
			}

			if ($val == 'css_color_hover') {
				return "#2ac400";
			}
		} else if ($type == 7) {
			if ($val == 'i') {
				return 2;
			}

			if ($val == 'type') {
				return "tud";
			}

			if ($val == 'class') {
				return "cyto-thumbs-up-2";
			}

			if ($val == 'class2') {
				return "cyto-thumbs-down-2";
			}

			if ($val == 'name') {
				return __( 'Thumbs Up &amp; Down 2', 'rating-form' );
			}

			if ($val == 'name_one') {
				return __( 'Thumbs Up', 'rating-form' );
			}

			if ($val == 'name_two') {
				return __( 'Thumbs Down', 'rating-form' );
			}
		} else if ($type == 8) {
			if ($val == 'i') {
				return 2;
			}

			if ($val == 'type') {
				return "tud";
			}

			if ($val == 'class') {
				return "cyto-plus-2";
			}

			if ($val == 'class2') {
				return "cyto-min-2";
			}

			if ($val == 'name') {
				return __( 'Plus and Min 2', 'rating-form' );
			}

			if ($val == 'name_one') {
				return __( 'Plus', 'rating-form' );
			}

			if ($val == 'name_two') {
				return __( 'Min', 'rating-form' );
			}
		} else {
			return;
		}
	}

	// Load plugin textdomain.
	function load_textdomain() {
		load_plugin_textdomain( 'rating-form', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
	}


	// Plugin update
	function rf_plugin_update() {
		require dirname( __FILE__ ) . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'update.php';
		rf_update_db();
	}

	// Activate the plugin
	public static function activate() {
		global $wpdb;

		// Create rating form table
		$sql_rating_form = 'CREATE TABLE '. $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM . ' (
			form_id bigint(20) NOT NULL AUTO_INCREMENT,
			form_name varchar(50) NOT NULL,
			type int(11) NOT NULL DEFAULT 1,
			display longtext NOT NULL,
			css longtext NOT NULL,
			date timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
			PRIMARY KEY  (form_id)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;';

		// Create rating table
		$sql_rating_rated = "CREATE TABLE " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . " (
			rate_id bigint(20) NOT NULL AUTO_INCREMENT,
			post_id bigint(20) NOT NULL,
			comment_id bigint(20) NOT NULL,
			custom_id varchar(20) NOT NULL DEFAULT '0',
			user_id bigint(20) NOT NULL,
			term_id bigint(20) NOT NULL,
			ip varchar(50) NOT NULL,
			rated varchar(11) NOT NULL,
			user bigint(20) NOT NULL,
			date timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
			PRIMARY KEY  (rate_id)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";

		// Create titles table
		$sql_rating_titles = 'CREATE TABLE '. $wpdb->prefix . Rating_Form_Setup::TBL_RATING_TITLES . ' (
			title_id bigint(20) NOT NULL AUTO_INCREMENT,
			text text NOT NULL,
			position int(11) NOT NULL,
			PRIMARY KEY  (title_id)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;';

		// Create form block table
		$sql_rating_block_ip = 'CREATE TABLE '. $wpdb->prefix . Rating_Form_Setup::TBL_RATING_BLOCK_LIST . ' (
			ip varchar(50) NOT NULL,
			date timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
			reason text NOT NULL,
			PRIMARY KEY  (ip)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;';

		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
		dbDelta( $sql_rating_form );
		dbDelta( $sql_rating_rated );
		dbDelta( $sql_rating_titles );
		dbDelta( $sql_rating_block_ip );

		// Insert default titles
		$wpdb->query("INSERT IGNORE INTO ". $wpdb->prefix . Rating_Form_Setup::TBL_RATING_TITLES . " (title_id, text, position) VALUES
			(1, 'Very Bad', 1),
			(2, 'Bad', 2),
			(3, 'Okay', 3),
			(4, 'Good', 4),
			(5, 'Very Good', 5),
			(6, 'Great', 6),
			(7, 'Excellent', 7),
			(8, 'Perfect', 8),
			(9, 'Best', 9),
			(10, 'Spectaculair', 10),
			(11, 'Like', 1),
			(12, 'Dislike', 2);");

		// Create plugin folder inside uploads
		$upload_dir = wp_upload_dir();
		wp_mkdir_p( $upload_dir['basedir'].'/rating-form/icons/' );
		$iconsFile = fopen($upload_dir['basedir'].'/rating-form/icons/index.html', "w");
		fclose($iconsFile);

		// Add capability
		$role = get_role( 'administrator' );
		$role->add_cap( 'rating_form_manage' );
	}

	// Deactivate the plugin
	public static function deactivate() {
		// Remove capability
		$role = get_role( 'administrator' );
		$role->remove_cap( 'rating_form_manage' );
	}

	// Uninstall the plugin
	public static function uninstall() {
		// Drop tables
		global $wpdb;

		$wpdb->query( 'DROP TABLE IF EXISTS ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM );
		$wpdb->query( 'DROP TABLE IF EXISTS ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG );
		$wpdb->query( 'DROP TABLE IF EXISTS ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_TITLES );
		$wpdb->query( 'DROP TABLE IF EXISTS ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_BLOCK_LIST );

		// Delete post meta
		delete_post_meta_by_key( 'rf_total' );
		delete_post_meta_by_key( 'rf_average' );
		delete_post_meta_by_key( 'rf_up' );
		delete_post_meta_by_key( 'rf_down' );

		delete_post_meta_by_key( 'rf_fake_total' );
		delete_post_meta_by_key( 'rf_fake_average' );
		delete_post_meta_by_key( 'rf_fake_up' );
		delete_post_meta_by_key( 'rf_fake_down' );

		// Delete options
		delete_option( Rating_Form_Setup::OPTION_VERSION );
		delete_option( Rating_Form_Setup::PAGE_TOOLS_RATING_SLUG );
		delete_option( Rating_Form_Setup::PAGE_RESULT_RATING_SLUG );
		delete_option( Rating_Form_Setup::PAGE_SETTINGS_SLUG );
	}

}

// Activate / Install
register_activation_hook( __FILE__, array( 'Rating_Form_Setup', 'activate') );
// Deactivate
register_deactivation_hook( __FILE__, array( 'Rating_Form_Setup', 'deactivate') );
// Uninstall
register_uninstall_hook( __FILE__, array( 'Rating_Form_Setup', 'uninstall') );
// Initialize
Rating_Form_Setup::init();
