<?php
if( ! class_exists( 'WP_List_Table' ) ) {
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

class Rating_Form_Table extends WP_List_Table {

	//Prepare the items for the table to process
	public function prepare_items()
    {
		global $wpdb;

        $columns = $this->get_columns();
        $hidden = $this->get_hidden_columns();
        $sortable = $this->get_sortable_columns();

		$query = 'SELECT * FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM;
        $data = $wpdb->get_results($query, ARRAY_A);
        usort($data, array($this, 'sort_data'));

        $perPage = 15;
        $currentPage = $this->get_pagenum();
        $totalItems = count($data);

        $this->set_pagination_args( array(
            'total_items' => $totalItems,
            'per_page'    => $perPage
        ) );

        $data = array_slice($data,(($currentPage-1)*$perPage),$perPage);

        $this->_column_headers = array($columns, $hidden, $sortable);
        $this->items = $data;
    }

	//Override the parent columns method.
	//Defines the columns to use in your listing table
	public function get_columns()
    {
        $columns = array(
            'form_id' => __( 'ID', 'rating-form' ),
            'type' => __( 'Type', 'rating-form' ),
            'restrict_ip' => __( 'Restriction', 'rating-form' ),
            'shortcode' => 'Shortcode',
            'date' => __( 'Created On', 'rating-form' )
        );

        return $columns;
    }

	//Define what data to show on each column of the table
    public function column_default( $item, $column_name )
    {
        switch( $column_name ) {
            case 'form_id':
				$admin_url = admin_url( 'admin.php' );
				$item_form_id = '';
				$item_form_id .= '<strong>' . $item['form_id'] . '</strong>' . (empty($item['form_name']) ? '' : ' (' . $item['form_name'] . ')');
				$item_form_id .= '<div class="row-actions">';
				$item_form_id .= '<span class="settings"><a href="'. $admin_url .'?page='.Rating_Form_Setup::PAGE_FORM_RATING_SLUG.'&settings='. $item['form_id'] .'">'. __( 'Settings', 'rating-form' ) .'</a> | </span>';
				$item_form_id .= '<span class="style"><a href="'. $admin_url .'?page='.Rating_Form_Setup::PAGE_FORM_RATING_SLUG.'&style='. $item['form_id'] .'">'. __( 'Style', 'rating-form' ) .'</a></span>';
				$item_form_id .= '<span class="duplicate"> | <a href="'. $admin_url .'?page='.Rating_Form_Setup::PAGE_FORM_RATING_SLUG.'&duplicate='. $item['form_id'] .'">'. __( 'Duplicate', 'rating-form' ) .'</a> | </span>';
				$item_form_id .= '<span class="delete"><a onclick="return confirm(&quot;'. __( 'Are you sure you want to delete this?', 'rating-form' ) .'&quot;)" href="'. $admin_url .'?page='.Rating_Form_Setup::PAGE_FORM_RATING_SLUG.'&delete='. $item['form_id'] .'"><strong>X</strong></a></span>';
				$item_form_id .= '</div>';
				$item['form_id'] = $item_form_id;
            case 'type':
				// Get rating form upload dir
				$upload_dir = wp_upload_dir();
				$thisFormUploadDir = $upload_dir['baseurl'].'/rating-form/icons/'.$item['form_id'];
                $item['type'] = ($item['type'] == 0 ? '<img src="'.$thisFormUploadDir.DIRECTORY_SEPARATOR.'custom-full.png'.'" alt="'.Rating_Form_Setup::form_types($item['type'], 'name').'" />' : '<span class="'.Rating_Form_Setup::form_types($item['type'], 'class').'"></span>').Rating_Form_Setup::form_types($item['type'], 'name');
            case 'restrict_ip':
        		$display = empty($item["display"]) ? array() : json_decode($item["display"], true);
				$item['restrict_ip'] = in_array("restrict_ip", $display) ? '<span class="rf_on">' . __( 'On', 'rating-form' ) . '</span>' : '<span class="rf_off">' . __( 'Off', 'rating-form' ) . '</span>';
            case 'shortcode':
				$item['shortcode'] = '<input onclick="this.select()" type="text" readonly="" value="[rating_form id=&quot;'.$item['form_id'].'&quot;]">';
			case 'date':
				$item['date'] = date('Y/m/d @ H:i', strtotime($item['date']));
                return $item[ $column_name ];

            default:
                return print_r( $item, true ) ;
        }
    }

	//Define which columns are hidden
    public function get_hidden_columns()
    {
        return array();
    }

	//Define the sortable columns
    public function get_sortable_columns()
    {
        return array(
			'form_id' => array('form_id', true),
			'type' => array('type', false),
			'restrict_ip' => array('restrict_ip', false),
			'date' => array('date', false)
			);
    }

	//Allows you to sort the data by the variables set in the $_GET
    private function sort_data( $a, $b )
    {
        // Set defaults
        $orderby = 'date';
        $order = 'desc';

        // If orderby is set, use this as the sort column
        if(!empty($_GET['orderby']))
        {
            $orderby = $_GET['orderby'];
        }

        // If order is set use this as the order
        if(!empty($_GET['order']))
        {
            $order = $_GET['order'];
        }

        $result = strnatcmp( $a[$orderby], $b[$orderby] );

        if($order === 'asc')
        {
            return $result;
        }

        return -$result;
    }
}

// Rating list table
function Rating_Forms() {
?>
	<div class="wrap rf_wrap<?php echo Rating_Form_Setup::getAdminRTLclass(); ?>" id="rating_form_add_edit"<?php echo Rating_Form_Setup::getAdminRTL(); ?>>
		<?php Rating_Form_Setup::admin_menus( __( 'Rating Forms', 'rating-form' ) ); ?>
<?php
	$upload_dir = wp_upload_dir();
	$new_rating_id = null;

	global $wpdb;
	$wpdb->show_errors();

	// Get settings or style
	if (isset($_GET['settings'])) {
		$getFormID = $_GET['settings'];
	} else if (isset($_GET['style'])) {
		$getFormID = $_GET['style'];
	} else {
		$getFormID = 0;
	}

	$id_query = $wpdb->get_row( "SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM . " WHERE form_id = '".$getFormID."'", ARRAY_A );
	$rowCount = $wpdb->num_rows;

	// Get rating form upload dir
	$thisFormUploadDir = $upload_dir['basedir'].'/rating-form/icons/' . $id_query['form_id'];

	if ($rowCount > 0) {

	$typeCustomCheck = (isset($_POST['type']) ? $_POST['type'] : $id_query['type']) == 0 ? true : false;
	$qJsonDisplay = isset($_POST['display']) ? $_POST['display'] : (empty($id_query['display']) ? array() : json_decode($id_query['display'], true));

	if (isset($_GET['settings'])) {

	if (isset($_POST['submit'])) {
		$msg_success = null;
		$msg_error = array();
		$style_content = null;
		$type = $_POST['type'];
		$form_name = $_POST['form_name'];
		$display = isset($_POST['display']) ? $_POST['display'] : '';
		$restrict_ip = in_array("restrict_ip", (empty($display) ? array() : $display)) ? 1 : 0;
		$limitation = empty($display['limitation']) ? 0 : $display['limitation'];
		$time = empty($display['time']) ? 0 : $display['time'];
        $titles = '';
        if (!empty($display['title'])) $titles = explode(",", $display['title']);
        if (!empty($titles)) $display['title'] = array_slice($titles, 0, $display['max']);

		if (isset($type) && isset($form_name)) {

			if(strlen($form_name) > 50) {
				$msg_error[] = sprintf( __( '<strong>Name</strong> has %s characters. Allowed: 50 characters', 'rating-form' ), strlen($form_name));
			}

			if ($restrict_ip >= 0 && $limitation == 0) {
				$msg_error[] = sprintf( __( '<strong>Limit</strong> is set to %1$d and <strong>Time</strong> set to %2$d seconds. To rate atleast 1 time in %2$s seconds, set <strong>Limit</strong> to 1.', 'rating-form' ), $limitation, $time );
			}

			if ($restrict_ip == 1 && $time > 0) {
				$msg_error[] = sprintf( __( '<strong>Time</strong> is set to %d seconds. This will not work, because <strong>Restriction</strong> is enabled.', 'rating-form' ), $time );
			}

			if ($restrict_ip == 0 && $time == 0 && $limitation > 1) {
				$msg_error[] = sprintf( __( '<strong>Limit</strong> is set to %1$d and <strong>Time</strong> set to %2$d seconds. You have two options:<br>- Enable <strong>Restriction</strong> to rate %1$d times with no time duration<br>- Set <strong>Time</strong> duration above 0 seconds', 'rating-form' ), $limitation, $time );
			}

			if (count($msg_error) == 0) {

				global $wpdb;

				if (count($display) > 0) {
					// Display[] Attribute
					// Remove Empty values
					for ($i = 0 ; $i < count($display); $i++) {
						if (empty($display[$i])) {
							unset($display[$i]);
						}
					}
					$display = json_encode($display);
				} else {
					$display = '';
				}

				$wpdb->update( $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM, array(
						'form_name' => $form_name,
						'type' => intval($type),
						'display' => $display
				), array('form_id' => $id_query['form_id'] ) );

				$postDisplay = empty($display) ? array() : json_decode($display, true);
				if (in_array("wpml_translate", $postDisplay)) {
					// Success msg
					// WPML register string for translation
					if (has_action('wpml_register_single_string')) {
						do_action('wpml_register_single_string', 'rating-form', 'Success ID ' . $id_query['form_id'], $postDisplay['messages']['ty']);
					}
					// Rated msg
					// WPML register string for translation
					if (has_action('wpml_register_single_string')) {
						do_action('wpml_register_single_string', 'rating-form', 'Rated ID ' . $id_query['form_id'], $postDisplay['messages']['rated']);
					}
					// Login msg
					// WPML register string for translation
					if (has_action('wpml_register_single_string')) {
						do_action('wpml_register_single_string', 'rating-form', 'Login ID ' . $id_query['form_id'], $postDisplay['messages']['login']);
					}
					// Limit msg
					// WPML register string for translation
					if (has_action('wpml_register_single_string')) {
						do_action('wpml_register_single_string', 'rating-form', 'Limit ID ' . $id_query['form_id'], $postDisplay['messages']['limit']);
					}
					// Edit rating msg
					// WPML register string for translation
					if (has_action('wpml_register_single_string')) {
						do_action('wpml_register_single_string', 'rating-form', 'Edit rating ID ' . $id_query['form_id'], $postDisplay['messages']['edit_rating']);
					}
				}

				$msg_success .= __( 'Successfully updated!', 'rating-form' );

			}

		} else {
			$msg_error[] = __( 'Error! Rating form not updated.', 'rating-form' );
		}

		if ( strlen( $msg_success ) > 0) {
			echo '<div class="rf_updated">' . $msg_success . '<br>';
			echo '<strong>Shortcode:</strong> <input onclick="this.select()" type="text" readonly="" value="[rating_form id=&quot;'.$id_query['form_id'].'&quot;]"></div>';
		}

		if ( count( $msg_error ) > 0) {
			foreach ($msg_error as $msg_error_txt)
				echo '<div class="rf_error">' . $msg_error_txt . '</div>';
		}
	}
	?>
		<form method="post" enctype="multipart/form-data">
		<div class="rf_form_content">
            <input type="hidden" value="<?php echo $qJsonDisplay['max']; ?>" name="display[max]" />
            <input type="hidden" value="<?php echo (isset($_POST['display']['title']) ? $qJsonDisplay['title'] : (empty($qJsonDisplay['title']) ? '' : implode(",", $qJsonDisplay['title']))); ?>" name="display[title]" />
			<div class="rf_header_title">
				<div class="rf_left"><strong><?php _e( 'Settings', 'rating-form' ); ?></strong> Rating Form <?php echo $id_query['form_id'] . (empty($id_query['form_name']) ? '' : ' (' . $id_query['form_name'] . ')'); ?></div>
				<div class="rf_right">
				<a class="button" href="admin.php?page=<?php echo Rating_Form_Setup::PAGE_FORM_RATING_SLUG . '&style=' . $id_query['form_id']; ?>"><?php _e( 'Edit Style', 'rating-form' ); ?></a>
				<input type="submit" name="submit" class="button button-primary" value="<?php _e( 'Save', 'rating-form' ); ?>">
				</div>
			</div>
			<div class="rf_form_box_each rf_mt50px">
			<div class="rf_form_box rf_60p rf_left no_tab">
				<h3 class="block"><?php _e( 'Options', 'rating-form' ); ?></h3>
				<div class="rf_form_box_inner rf_column rf_50p rf_left">
					<table class="rf-table">
						<tbody>
							<tr>
								<td>
									<div class="rf-input">
										<span class="rf-title"><strong><?php _e( 'Active', 'rating-form' ); ?></strong></span>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="active" <?php checked(in_array("active", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<p class="description"><?php _e( 'Disable or enable Rating Form', 'rating-form' ); ?></p>
										<div class="rf_clear">
    										<label>
        										<span class="rf-toggle">
            										<?php $mobileEnable = empty($qJsonDisplay['mobile']['display']) ? 'show' : $qJsonDisplay['mobile']['display']; ?>
            										<input type="checkbox" name="display[mobile][display]" value="hide" <?php checked($mobileEnable, 'hide'); ?> />
            										<label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
        										</span>
    										<span class="rf-title"><b><?php _e( 'Deactivate on mobile', 'rating-form' ); ?></b></span>
    										</label>
										</div>
										<div class="rf_clear">
    										<label>
        										<span class="rf-toggle">
					                                  <?php $tabletEnable = empty($qJsonDisplay['tablet']['display']) ? 'show' : $qJsonDisplay['tablet']['display']; ?>
						                              <input type="checkbox" name="display[tablet][display]" value="hide" <?php checked($tabletEnable, 'hide'); ?> />
						                              <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
        										</span>
        										<span class="rf-title"><b><?php _e( 'Deactivate on tablet', 'rating-form' ); ?></b></span>
    										</label>
										</div>
									</div>
								</td>
							</tr>
							<tr>
								<td>
									<div class="rf-input">
										<span class="rf-title"><strong><?php _e( 'Name', 'rating-form' ); ?></strong></span>
										<input class="rf_right" type="text" name="form_name" value="<?php echo isset($_POST['form_name']) ? $_POST['form_name'] : $id_query['form_name']; ?>" />
										<p class="description"><?php _e( 'Name of Rating Form', 'rating-form' ); ?></p>
									</div>
								</td>
							</tr>
							<tr>
								<td>
									<div class="rf-input">
										<span class="rf-title"><strong><?php _e( 'Type', 'rating-form' ); ?></strong></span>
										<select class="rf_right rf_60p" name="type">
										<?php
										$StarOrTud = Rating_Form_Setup::form_types($id_query['type'], 'type') == "star" ? "star" : "tud";
										for ($iTypes = 0; $iTypes <= Rating_Form_Setup::$totalFormTypes; $iTypes++) {
											if (Rating_Form_Setup::form_types($iTypes, 'type') == $StarOrTud) {
												echo '<option value="'. $iTypes . '" ' . selected( (isset($_POST['type']) ? $_POST['type'] : $id_query['type']), $iTypes ) . '>' . Rating_Form_Setup::form_types($iTypes, 'name') .'</option>';
											}
										}
										?>
										</select>
										<p class="description"><?php _e( 'Change form', 'rating-form' ); ?></p>
									</div>
								</td>
							</tr>
							<tr>
								<td>
									<div class="rf-input">
										<span class="rf-title"><strong><?php _e( 'Decimal', 'rating-form' ); ?></strong></span>
										<span class="rf-input-inde">
											<span class="rf-input-number-decrement">-</span>
											<input class="rf-input-number" type="text" name="display[round]" value="<?php echo empty($qJsonDisplay['round']) ? 1 : $qJsonDisplay['round']; ?>" min="1" max="">
											<span class="rf-input-number-increment">+</span>
										</span>
										<p class="description"><?php _e( 'Set decimal of average rounding', 'rating-form' ); ?></p>
									</div>
								</td>
							</tr>
							<tr>
								<td>
									<div class="rf-input">
										<span class="rf-title"><strong><?php _e( 'Limit', 'rating-form' ); ?></strong></span>
										<span class="rf-input-inde">
											<span class="rf-input-number-decrement">-</span>
											<input class="rf-input-number" type="text" name="display[limitation]" value="<?php echo empty($qJsonDisplay['limitation']) ? 1 : $qJsonDisplay['limitation']; ?>" min="1" max="">
											<span class="rf-input-number-increment">+</span>
										</span>
										<p class="description"><?php _e( 'Set rating limit for each users', 'rating-form' ); ?></p>
									</div>
								</td>
							</tr>
							<?php
								// Field Time
								$time_custom = false;
								$time_custom2 = false;
								$field_time = empty($qJsonDisplay['time']) ? 0 : $qJsonDisplay['time'];
								if (!($field_time == 0 || $field_time == 3600 || $field_time == 86400 || $field_time == 604800 ||
										$field_time == 2629744 || $field_time == 31556926)) {
									$time_custom = true;
								}
							?>
							<tr>
								<td>
									<div class="rf-input">
										<span class="rf-title"><strong><?php _e( 'Time', 'rating-form' ); ?></strong></span>
										<select id="time" class="rf_right rf_50p" name="display[time]">
											<option value="0" <?php selected( $field_time, 0 ); ?>><?php _e( 'All Time', 'rating-form' ); ?></option>
											<option value="<?php echo $field_time; ?>"<?php echo $time_custom == true ? ' selected="selected"' : ''; ?>><?php _e( 'Custom', 'rating-form' ); ?></option>
											<option value="3600" <?php selected( $field_time, 3600 ); ?>><?php _e( '1 Hour', 'rating-form' ); ?></option>
											<option value="86400" <?php selected( $field_time, 86400 ); ?>><?php _e( '1 Day', 'rating-form' ); ?></option>
											<option value="604800" <?php selected( $field_time, 604800 ); ?>><?php _e( '1 Week', 'rating-form' ); ?></option>
											<option value="2629744" <?php selected( $field_time, 2629744 ); ?>><?php _e( '1 Month', 'rating-form' ); ?></option>
										</select><span id="time_custom"<?php echo $time_custom == true ? '' : ' style="display: none;"'; ?>><br><input type="text" name="time_custom" value="<?php echo $field_time; ?>" /></span>
										<p class="description"><?php _e( 'Set time duration for limit in seconds', 'rating-form' ); ?></p>
									</div>
								</td>
							</tr>
							<tr>
								<td>
									<div class="rf-input">
										<div class="rf_left rf_clear rf_100p">
										<span class="rf-title"><strong><?php _e( 'Allow Post ID', 'rating-form' ); ?></strong></span>
										<input class="rf_right" type="text" name="display[post_ids]" value="<?php echo empty($qJsonDisplay['post_ids']) ? '' : $qJsonDisplay['post_ids']; ?>" />
										</div>
										<div class="rf_left rf_clear rf_100p">
										<span class="rf-title"><strong><?php _e( 'Disallow Post ID', 'rating-form' ); ?></strong></span>
										<input class="rf_right" type="text" name="display[ex_post_ids]" value="<?php echo empty($qJsonDisplay['ex_post_ids']) ? '' : $qJsonDisplay['ex_post_ids']; ?>" />
										</div>
										<p class="description"><?php _e( 'Set which post ids are allowed or disallowed.<br>Seperate id for multiple posts. Example: 1,5,34', 'rating-form' ); ?></p>
									</div>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
				<div class="rf_form_box_inner rf_column rf_50p rf_left">
					<table class="rf-table">
						<tbody>
							<tr>
								<td>
									<div class="rf-input">
										<span class="rf-title"><strong><?php _e( 'Restriction', 'rating-form' ); ?></strong></span>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="restrict_ip" <?php checked(in_array("restrict_ip", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<p class="description"><?php _e( 'Restrict anonymous users based on User / IP / Cookie validation for voting multiple times', 'rating-form' ); ?></p>
									</div>
								</td>
							</tr>
							<tr>
								<td>
									<div class="rf-input">
										<span class="rf-title"><strong><?php _e( 'User Login', 'rating-form' ); ?></strong></span>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="user_logged_in" <?php checked(in_array("user_logged_in", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<p class="description"><?php _e( 'User must login to rate', 'rating-form' ); ?></p>
									</div>
								</td>
							</tr>
							<tr>
								<td>
									<div class="rf-input">
										<span class="rf-title"><strong><?php _e( 'Ajax Load', 'rating-form' ); ?></strong></span>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="ajax_load" <?php checked(in_array("ajax_load", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<p class="description"><?php _e( 'Useful when using cache plugins', 'rating-form' ); ?></p>
									</div>
								</td>
							</tr>
							<tr>
								<td>
									<div class="rf-input">
										<span class="rf-title"><strong><?php _e( 'Rich Snippet', 'rating-form' ); ?></strong></span>
										<span class="rf-toggle">
										  <?php $richsnippetCheck = in_array("rich_snippet", $qJsonDisplay) ? true : false; ?>
										  <input type="checkbox" name="display[]" value="rich_snippet" <?php checked($richsnippetCheck, true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<?php $rich_snippet_type = empty($qJsonDisplay['rich_snippet']['type']) ? 'microdata' : $qJsonDisplay['rich_snippet']['type']; ?>
										<?php if ($richsnippetCheck) { ?>
										<ul class="rf_clear rf_left">
											<li><label><input type="radio" name="display[rich_snippet][type]" value="microdata" <?php checked($rich_snippet_type, 'microdata'); ?> /> microdata</li></label>
											<li><label><input type="radio" name="display[rich_snippet][type]" value="jsonld" <?php checked($rich_snippet_type, 'jsonld'); ?> /> json-ld</li></label>
										</ul>
										<?php
										}
										?>
										<p class="description"><?php _e( 'Show rating result in search engines', 'rating-form' ); ?></p>
									</div>
								</td>
							</tr>
							<tr>
								<td>
									<div class="rf-input">
										<span class="rf-title"><strong><?php _e( 'Spinner', 'rating-form' ); ?></strong></span>
										<span class="rf-toggle">
										  <?php $spinnerCheck = (empty($qJsonDisplay['spinner']['check']) ? '' : $qJsonDisplay['spinner']['check']) == "enable" ? true : false; ?>
										  <input type="checkbox" name="display[spinner][check]" value="enable" <?php checked($spinnerCheck, true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<?php if ($spinnerCheck) { ?>
										<div class="cyto-spinners">
										<ul>
										<?php for ($iSpinners = 1; $iSpinners <= 3; $iSpinners++) { ?>
										<li>
										  <label>
											<input type="radio" name="display[spinner][type]" value="<?php echo $iSpinners; ?>" <?php checked((empty($qJsonDisplay['spinner']['type']) ? 1 : $qJsonDisplay['spinner']['type']), $iSpinners); ?> />
											<span class="cyto-spin cyto-spinner<?php echo ($iSpinners == 1 ? '' : $iSpinners); ?>"></span>
										  </label>
										</li>
										<?php
										}
										?>
										</ul>
										</div>
										<?php
										}
										?>
										<p class="description"><?php _e( 'Set spinner animation on update rating', 'rating-form' ); ?></p>
									</div>
								</td>
							</tr>
							<tr>
								<td>
									<div class="rf-input">
										<span class="rf-title"><strong><?php _e( 'RTL', 'rating-form' ); ?></strong></span>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="rtl" <?php checked(in_array("rtl", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<p class="description"><?php _e( 'Set form direction to rtl (right to left)', 'rating-form' ); ?></p>
									</div>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
			<div class="rf_form_box rf_40p rf_left no_tab">
				<h3 class="block"><?php _e( 'Messages', 'rating-form' ); ?></h3>
				<div class="rf_form_box_inner rf_column rf_100p rf_left">
					<table class="rf-table">
						<tbody>
							<tr>
								<td>
									<div class="rf-input">
										<div class="rf_left rf_clear rf_100p">
										<span class="rf-title"><strong><?php _e( 'Success', 'rating-form' ); ?></strong></span>
										<input class="rf_right rf_75p" type="text" name="display[messages][ty]" value="<?php echo empty($qJsonDisplay['messages']['ty']) ? '' : $qJsonDisplay['messages']['ty']; ?>" />
										</div>
										<?php
										// WPML - Get current language data
										if (function_exists('icl_get_languages')) {
											$languages = icl_get_languages('skip_missing=1');
											$curr_lang = array();
											if (!empty($languages)) {
												foreach ($languages as $language) {
													if (!empty($language['active'])) {
														$curr_lang = $language;
														break;
													}
												}
											}
										}
										// WPML Translate enabled?
										$wpmlEnabled = in_array("wpml_translate", $qJsonDisplay) ? true : false;
										// Success msg translated of current language
										if (has_action('wpml_translate_single_string') && $wpmlEnabled && !empty($qJsonDisplay['messages']['ty'])) {
											$translated_text = apply_filters('wpml_translate_single_string', $qJsonDisplay['messages']['ty'], 'rating-form', 'Success ID ' . $id_query['form_id'], $curr_lang['code']);
											if ($translated_text != $qJsonDisplay['messages']['ty']) {
												echo '<div class="rf_left rf_clear rf_100p"><img src="'.$curr_lang['country_flag_url'].'" alt="'.$curr_lang['code'].'" /> ' . $translated_text . '</div>';
											}
										}
										?>
										<p class="description"><?php _e( 'Set success message', 'rating-form' ); ?></p>
									</div>
								</td>
							</tr>
							<tr>
								<td>
									<div class="rf-input">
										<div class="rf_left rf_clear rf_100p">
										<span class="rf-title"><strong><?php _e( 'Rated', 'rating-form' ); ?></strong></span>
										<input class="rf_right rf_75p" type="text" name="display[messages][rated]" value="<?php echo empty($qJsonDisplay['messages']['rated']) ? '' : $qJsonDisplay['messages']['rated']; ?>" />
										</div>
										<?php
										// Rated msg translated of current language
										if (has_action('wpml_translate_single_string') && $wpmlEnabled && !empty($qJsonDisplay['messages']['rated'])) {
											$translated_text = apply_filters('wpml_translate_single_string', $qJsonDisplay['messages']['rated'], 'rating-form', 'Rated ID ' . $id_query['form_id'], $curr_lang['code']);
											if ($translated_text != $qJsonDisplay['messages']['rated']) {
												echo '<div class="rf_left rf_clear rf_100p"><img src="'.$curr_lang['country_flag_url'].'" alt="'.$curr_lang['code'].'" /> ' . $translated_text . '</div>';
											}
										}
										?>
										<p class="description"><?php _e( 'Set rated message', 'rating-form' ); ?></p>
									</div>
								</td>
							</tr>
							<tr>
								<td>
									<div class="rf-input">
										<div class="rf_left rf_clear rf_100p">
										<span class="rf-title"><strong><?php _e( 'Login', 'rating-form' ); ?></strong></span>
										<input class="rf_right rf_75p" type="text" name="display[messages][login]" value="<?php echo empty($qJsonDisplay['messages']['login']) ? '' : $qJsonDisplay['messages']['login']; ?>" />
										</div>
										<?php
										// Login msg translated of current language
										if (has_action('wpml_translate_single_string') && $wpmlEnabled && !empty($qJsonDisplay['messages']['login'])) {
											$translated_text = apply_filters('wpml_translate_single_string', $qJsonDisplay['messages']['login'], 'rating-form', 'Login ID ' . $id_query['form_id'], $curr_lang['code']);
											if ($translated_text != $qJsonDisplay['messages']['login']) {
												echo '<div class="rf_left rf_clear rf_100p"><img src="'.$curr_lang['country_flag_url'].'" alt="'.$curr_lang['code'].'" /> ' . $translated_text . '</div>';
											}
										}
										?>
										<p class="description"><?php _e( 'Set login message', 'rating-form' ); ?></p>
									</div>
								</td>
							</tr>
							<tr>
								<td>
									<div class="rf-input">
										<div class="rf_left rf_clear rf_100p">
										<span class="rf-title"><strong><?php _e( 'Limit', 'rating-form' ); ?></strong></span>
										<input class="rf_right rf_75p" type="text" name="display[messages][limit]" value="<?php echo empty($qJsonDisplay['messages']['limit']) ? '' : $qJsonDisplay['messages']['limit']; ?>" />
										</div>
										<?php
										// Limit msg translated of current language
										if (has_action('wpml_translate_single_string') && $wpmlEnabled && !empty($qJsonDisplay['messages']['ty'])) {
											$translated_text = apply_filters('wpml_translate_single_string', $qJsonDisplay['messages']['limit'], 'rating-form', 'Limit ID ' . $id_query['form_id'], $curr_lang['code']);
											if ($translated_text != $qJsonDisplay['messages']['limit']) {
												echo '<div class="rf_left rf_clear rf_100p"><img src="'.$curr_lang['country_flag_url'].'" alt="'.$curr_lang['code'].'" /> ' . $translated_text . '</div>';
											}
										}
										?>
										<p class="description">
										<?php _e( 'Set limit message<br>' .
											'<strong>%1$d</strong> = value of seconds<br>' .
											'<strong>%2$d</strong> = value of minutes<br>' .
											'<strong>%3$d</strong> = value of hours<br>' .
											'<strong>%4$d</strong> = value of days', 'rating-form' ); ?>
										</p>
									</div>
								</td>
							</tr>
							<tr>
								<td>
									<div class="rf-input">
										<div class="rf_left rf_clear rf_100p">
										<span class="rf-title"><strong><?php _e( 'Edit rating', 'rating-form' ); ?></strong></span>
										<input class="rf_right rf_75p" type="text" name="display[messages][edit_rating]" value="<?php echo empty($qJsonDisplay['messages']['edit_rating']) ? '' : $qJsonDisplay['messages']['edit_rating']; ?>" />
										</div>
										<?php
										// Edit rating msg translated of current language
										if (has_action('wpml_translate_single_string') && $wpmlEnabled && !empty($qJsonDisplay['messages']['edit_rating'])) {
											$translated_text = apply_filters('wpml_translate_single_string', $qJsonDisplay['messages']['edit_rating'], 'rating-form', 'Edit rating ID ' . $id_query['form_id'], $curr_lang['code']);
											if ($translated_text != $qJsonDisplay['messages']['edit_rating']) {
												echo '<div class="rf_left rf_clear rf_100p"><img src="'.$curr_lang['country_flag_url'].'" alt="'.$curr_lang['code'].'" /> ' . $translated_text . '</div>';
											}
										}
										?>
										<p class="description">
										<?php _e( 'Set edit rating message<br>' .
													'<strong>%1$d</strong> = value of user rating<br>' .
													'<strong>%2$s</strong> = value of title', 'rating-form' ); ?>
										</p>
									</div>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
			</div> <!-- / .rf_form_box_each -->
			<div class="clear"></div>
			<div class="rf_form_box_each">
			<div class="rf_form_box rf_30p rf_left no_tab">
				<h3 class="block"><?php _e( "Extra's", 'rating-form' ); ?></h3>
				<div class="rf_form_box_inner rf-input-small">
					<table class="rf-table rf_100p">
						<tbody>
							<tr>
								<td>
									<div class="rf-input radio-group rf_clear">
										<?php if (Rating_Form_Setup::form_types($id_query['type'], 'type') == "tud") { ?>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="up_down_total" <?php checked(in_array("up_down_total", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Up (3) - Down (1) = Difference (2)', 'rating-form' ); ?></span>
										</label>
										</div>
										<?php } else if (Rating_Form_Setup::form_types($id_query['type'], 'type') == "star") { ?>
										<?php if (intval((isset($_POST['type']) ? $_POST['type'] : $id_query['type'])) != 0 && Rating_Form_Setup::form_types((isset($_POST['type']) ? $_POST['type'] : $id_query['type']), '', 'int') == '') { // custom forms do not need "empty shapes" option, cus images can be edited ?>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="empty" <?php checked(in_array("empty", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Display Empty shapes', 'rating-form' ); ?></span>
										</label>
										</div>
										<?php } ?>
										<?php } ?>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" class="radio" name="display[]" value="edit_rating" <?php checked(in_array("edit_rating", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Allow to edit rating (through button)', 'rating-form' ); ?></span>
										</label>
										</div>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" class="radio" name="display[]" value="edit_rating_direct" <?php checked(in_array("edit_rating_direct", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Allow to edit rating (straight)', 'rating-form' ); ?></span>
										</label>
										</div>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="remove_bip_votes" <?php checked(in_array("remove_bip_votes", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Remove Blocked Votes', 'rating-form' ); ?></span>
										</label>
										</div>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="live_top_ratings" <?php checked(in_array("live_top_ratings", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Update top ratings after rating', 'rating-form' ); ?></span>
										</label>
										</div>
										<?php if (Rating_Form_Setup::form_types($id_query['type'], 'type') == "star") { ?>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="live_rf_results" <?php checked(in_array("live_rf_results", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title">
                                            <span class="rf-info-icon" title="<?php _e( 'Add shortcode attribute custom_id_group to trigger this shortcode.', 'rating-form' ); ?>">i</span>
                                            <?php _e( 'Update [rating_form_results] after rating', 'rating-form' ); ?>
                                        </span>
                                        </label>
										</div>
										<?php } ?>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="live_rf_total" <?php checked(in_array("live_rf_total", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title">
                                            <span class="rf-info-icon" title="<?php _e( 'Add shortcode attribute custom_id_group to trigger this shortcode.', 'rating-form' ); ?>">i</span>
                                            <?php _e( 'Update [rating_form_total] after rating', 'rating-form' ); ?>
                                        </span>
										</label>
										</div>
									<?php if (function_exists('icl_get_languages')) { ?>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="wpml_translate" <?php checked(in_array("wpml_translate", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( "WPML Translate", 'rating-form' ); ?></span>
										</label>
										</div>
									<?php } ?>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="fake_ratings" <?php checked(in_array("fake_ratings", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Add post_meta fake ratings', 'rating-form' ); ?></span>
										</label>
										</div>
									</div>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
			<div class="rf_form_box rf_30p rf_left no_tab">
				<h3 class="block"><?php _e( "Show / Hide", 'rating-form' ); ?></h3>
				<div class="rf_form_box_inner rf-input-small">
					<table class="rf-table rf_100p">
						<tbody>
							<tr>
								<td>
									<div class="rf-input rf_clear radio-group">
										<?php if (Rating_Form_Setup::form_types($id_query['type'], 'type') == "tud") { ?>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="up" <?php checked(in_array("up", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Display only Up', 'rating-form' ); ?></span>
										</label>
										</div>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="down" <?php checked(in_array("down", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Display only Down', 'rating-form' ); ?></span>
										</label>
										</div>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="hide_up_total" <?php checked(in_array("hide_up_total", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Hide total Up ratings', 'rating-form' ); ?></span>
										</label>
										</div>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="hide_down_total" <?php checked(in_array("hide_down_total", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Hide total Down ratings', 'rating-form' ); ?></span>
										</label>
										</div>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="remove_up_down_plus_min" <?php checked(in_array("remove_up_down_plus_min", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Remove + and - characters', 'rating-form' ); ?></span>
										</label>
										</div>
										<?php } ?>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="remove_home" <?php checked(in_array("remove_home", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Remove Rating Form from Home', 'rating-form' ); ?></span>
										</label>
										</div>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="remove_feed" <?php checked(in_array("remove_feed", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Remove Rating Form from RSS', 'rating-form' ); ?></span>
										</label>
										</div>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="remove_inline_style" <?php checked(in_array("remove_inline_style", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( "Remove inline style", 'rating-form' ); ?></span>
										</label>
										</div>
										<?php if (defined('AMP__FILE__')) { ?>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="remove_amp" <?php checked(in_array("remove_amp", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Remove Rating Form on AMP pages', 'rating-form' ); ?></span>
										</label>
										</div>
										<?php } ?>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="hide_success_msg" <?php checked(in_array("hide_success_msg", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Hide "Success" message', 'rating-form' ); ?></span>
										</label>
										</div>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="edit_rating_text" <?php checked(in_array("edit_rating_text", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Show "Edit Rating" message', 'rating-form' ); ?></span>
										</label>
										</div>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" class="radio" name="display[]" value="only_single" <?php checked(in_array("only_single", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Show Rating Form only in posts', 'rating-form' ); ?></span>
										</label>
										</div>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" class="radio" name="display[]" value="only_page" <?php checked(in_array("only_page", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Show Rating Form only in pages', 'rating-form' ); ?></span>
										</label>
										</div>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" class="radio" name="display[]" value="only_category" <?php checked(in_array("only_category", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Show Rating Form only in categories', 'rating-form' ); ?></span>
										</label>
										</div>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="rich_snippet_itemtype_no" <?php checked(in_array("rich_snippet_itemtype_no", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Show only itemtype aggregateRating', 'rating-form' ); ?></span>
										</label>
										</div>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="hide_after_vote" <?php checked(in_array("hide_after_vote", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Hide after voting', 'rating-form' ); ?></span>
										</label>
										</div>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[]" value="show_ty_after_vote" <?php checked(in_array("show_ty_after_vote", $qJsonDisplay), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Show success message after voting', 'rating-form' ); ?></span>
										</label>
										</div>
									</div>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
			<div class="rf_form_box rf_20p rf_left no_tab">
				<h3 class="block"><?php _e( 'Post Type', 'rating-form' ); ?></h3>
				<div class="rf_form_box_inner rf-input-small">
					<table class="rf-table rf_100p">
						<tbody>
							<tr>
								<td>
									<div class="rf-input rf_clear">
										<?php
										global $wpdb;
										$post_types = get_post_types( '', 'names' );
										foreach ( $post_types as $post_type ) {
										?>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[post_type][]" value="<?php echo $post_type; ?>" <?php checked(in_array($post_type, (empty($qJsonDisplay['post_type']) ? array() : $qJsonDisplay['post_type'])), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php echo $post_type; ?></span>
										</label>
										</div>
										<?php } ?>
										<p class="rf_right description"><?php _e( 'Allowed post types', 'rating-form' ); ?></p>
									</div>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
			<div class="rf_form_box rf_20p rf_left no_tab">
				<h3 class="block"><?php _e( 'User Role', 'rating-form' ); ?></h3>
				<div class="rf_form_box_inner rf-input-small">
					<table class="rf-table rf_100p">
						<tbody>
							<tr>
								<td>
									<div class="rf-input rf_clear">
										<?php
										global $wpdb;
										global $wp_roles;
										$roles_array = $wp_roles->get_names();
										foreach ( $roles_array as $roles_key=>$roles_value ) {
										?>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[user_role][]" value="<?php echo $roles_key; ?>"  <?php checked(in_array($roles_key, (empty($qJsonDisplay['user_role']) ? array() : $qJsonDisplay['user_role'])), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php echo $roles_value; ?></span>
										</label>
										</div>
										<?php
										}
										?>
										<div class="rf_left rf_clear">
    										<label>
            									<span class="rf-toggle">
            									  <input type="checkbox" name="display[user_role][public]" value="1" <?php checked(intval((empty($qJsonDisplay['user_role']['public']) ? '' : $qJsonDisplay['user_role']['public'])), true); ?> />
            									  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
            									</span>
        										<span class="rf-title"><?php _e( 'Public View', 'rating-form' ); ?></span>
    										</label>
										</div>
    		                            <p class="rf_right description"><?php _e( 'Allowed user roles', 'rating-form' ); ?></p>
									</div>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
			</div> <!-- / .rf_form_box_each -->
			<div class="clear"></div>
			<div class="rf_form_box_each">
			<div class="rf_form_box rf_left rf_50p no_tab">
				<h3 class="block"><?php _e( "Redirect", 'rating-form' ); ?></h3>
				<div class="rf_form_box_inner">
					<table class="rf-table rf_100p">
						<tbody>
							<tr>
								<td>
								<div class="rf-input">
									<span class="rf-title"><strong><?php _e( 'Enable', 'rating-form' ); ?></strong></span>
									<span class="rf-toggle">
									  <input type="checkbox" name="display[redirect][check]" value="enable" <?php checked((empty($qJsonDisplay['redirect']['check']) ? '' : $qJsonDisplay['redirect']['check']), "enable"); ?> />
									  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
									</span>
								</div>
								</td>
							</tr>
							<tr>
								<td>
								<div class="rf-input">
									<span class="rf-title"><strong><?php _e( 'URL', 'rating-form' ); ?></strong></span>
									<input class="rf_right" type="text" name="display[redirect][url]" value="<?php echo empty($qJsonDisplay['redirect']['url']) ? '' : $qJsonDisplay['redirect']['url']; ?>" />
									<p class="description"><?php _e( 'After voting go to URL', 'rating-form' ); ?></p>
								</div>
								</td>
							</tr>
							<tr>
								<td>
								<div class="rf-input">
									<span class="rf-title"><strong><?php _e( 'Parameters', 'rating-form' ); ?></strong></span>
									<input class="rf_right" type="text" name="display[redirect][params]" value="<?php echo empty($qJsonDisplay['redirect']['params']) ? '' : $qJsonDisplay['redirect']['params']; ?>" />
									<p class="description"><?php _e( 'Include extra data in URL. Choose:<br> Voted rating: %user_rating%', 'rating-form' ); ?></p>
								</div>
								</td>
							</tr>
							<tr>
								<td>
								<div class="rf-input">
									<span class="rf-title"><strong><?php _e( 'Target', 'rating-form' ); ?></strong></span>
									<input class="rf_right" type="text" name="display[redirect][target]" value="<?php echo empty($qJsonDisplay['redirect']['target']) ? '' : $qJsonDisplay['redirect']['target']; ?>" />
									<p class="description"><?php _e( 'Choose:<br>_blank (default)<br>_parent<br>_self<br>_top', 'rating-form' ); ?></p>
								</div>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
			<div class="rf_form_box rf_left rf_50p no_tab">
				<h3 class="block"><?php _e( "User Stats", 'rating-form' ); ?></h3>
				<div class="rf_form_box_inner">
					<table class="rf-table rf_100p">
						<tbody>
							<tr>
								<td>
								<div class="rf-input">
									<span class="rf-title"><strong><?php _e( 'Enable', 'rating-form' ); ?></strong></span>
									<span class="rf-toggle">
									  <input type="checkbox" name="display[ustats][check]" value="enable" <?php checked((empty($qJsonDisplay['ustats']['check']) ? '' : $qJsonDisplay['ustats']['check']), "enable"); ?> />
									  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
									</span>
								</div>
								</td>
							</tr>
							<tr>
								<td>
								<div class="rf-input">
									<span class="rf-title"><strong><?php _e( 'Row Size', 'rating-form' ); ?></strong></span>
									<input class="rf_right" type="text" name="display[ustats][row_size]" value="<?php echo empty($qJsonDisplay['ustats']['row_size']) ? '' : $qJsonDisplay['ustats']['row_size']; ?>" />
									<p class="description"><?php _e( 'Number of rows', 'rating-form' ); ?></p>
								</div>
								</td>
							</tr>
							<tr>
								<td>
								<div class="rf-input">
									<span class="rf-title"><strong><?php _e( 'Per row', 'rating-form' ); ?></strong></span>
									<input class="rf_right" type="text" name="display[ustats][per_row]" value="<?php echo empty($qJsonDisplay['ustats']['per_row']) ? '' : $qJsonDisplay['ustats']['per_row']; ?>" />
									<p class="description"><?php _e( 'Items per row', 'rating-form' ); ?></p>
								</div>
								</td>
							</tr>
							<tr>
								<td>
								<div class="rf-input">
									<span class="rf-title"><strong><?php _e( 'Avatar Size', 'rating-form' ); ?></strong></span>
									<input class="rf_right" type="text" name="display[ustats][av_size]" value="<?php echo empty($qJsonDisplay['ustats']['av_size']) ? '' : $qJsonDisplay['ustats']['av_size']; ?>" />
									<p class="description">px (pixels)</p>
								</div>
								</td>
							</tr>
							<tr class="rf-input-small">
								<td>
									<div class="rf-input rf_clear">
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[ustats][]" value="av_remove" <?php checked(in_array("av_remove", empty($qJsonDisplay['ustats']) ? array() : $qJsonDisplay['ustats']), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Remove avatar', 'rating-form' ); ?></span>
										</label>
										</div>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[ustats][]" value="rating_show" <?php checked(in_array("rating_show", empty($qJsonDisplay['ustats']) ? array() : $qJsonDisplay['ustats']), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'Display rating', 'rating-form' ); ?></span>
										</label>
										</div>
										<div class="rf_left rf_clear">
										<label>
										<span class="rf-toggle">
										  <input type="checkbox" name="display[ustats][]" value="login_required" <?php checked(in_array("login_required", empty($qJsonDisplay['ustats']) ? array() : $qJsonDisplay['ustats']), true); ?> />
										  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
										</span>
										<span class="rf-title"><?php _e( 'User must login', 'rating-form' ); ?></span>
										</label>
										</div>
									</div>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
			</div> <!-- / .rf_form_box_each -->
		</form>
<?php

	} else if (isset($_GET['style'])) {
		$defDisplay = json_decode($id_query['display'], true);
		//Type Names
		$type_name = Rating_Form_Setup::form_types($id_query['type'], "name");
		$type_name_one = Rating_Form_Setup::form_types($id_query['type'], "name_one");
		$type_name_two = Rating_Form_Setup::form_types($id_query['type'], "name_two");
		$type_color = Rating_Form_Setup::form_types($id_query['type'], "css_color");
		$type_color_hover = Rating_Form_Setup::form_types($id_query['type'], "css_color_hover");

		$arrCss = array();
		//Font Size
		$form_alignment = isset($_POST['alignment']) ? $_POST['alignment'] : null;
		$font_size = isset($_POST['font_size']) ? $_POST['font_size'] : null;
		$font_size_text = isset($_POST['font_size_text']) ? $_POST['font_size_text'] : null;
		//Style star
		$font_color = isset($_POST['font_color']) ? $_POST['font_color'] : null;
		$font_color_text = isset($_POST['font_color_text']) ? $_POST['font_color_text'] : null;
		$font_hover_color = isset($_POST['font_hover_color']) ? $_POST['font_hover_color'] : null;
		$background_def_text = isset($_POST['background_def_text']) ? $_POST['background_def_text'] : null;
		//Style thumbs up
		$tu_font_color = isset($_POST['tu_font_color']) ? $_POST['tu_font_color'] : null;
		$tu_font_color_text = isset($_POST['tu_font_color_text']) ? $_POST['tu_font_color_text'] : null;
		$tu_font_hover_color = isset($_POST['tu_font_hover_color']) ? $_POST['tu_font_hover_color'] : null;
		$tu_background_def_text = isset($_POST['tu_background_def_text']) ? $_POST['tu_background_def_text'] : null;
		//Style thumbs down
		$td_font_color = isset($_POST['td_font_color']) ? $_POST['td_font_color'] : null;
		$td_font_color_text = isset($_POST['td_font_color_text']) ? $_POST['td_font_color_text'] : null;
		$td_font_hover_color = isset($_POST['td_font_hover_color']) ? $_POST['td_font_hover_color'] : null;
		$td_background_def_text = isset($_POST['td_background_def_text']) ? $_POST['td_background_def_text'] : null;
		// Custom CSS
		$custom_css = isset($_POST['custom_css']) ? $_POST['custom_css'] : null;
		if (isset($_POST['save_style'])) {
			$msg_success = null;
			$msg_error = array();
			$display = $_POST['display'];

			if (isset($display)) {
				if (!empty($_FILES['icon_empty']['name'])) {
					$icon_empty_ext = explode('.', strtolower($_FILES['icon_empty']['name']));
					if($_FILES['icon_empty']['error']) {
						$msg_error[] = '<strong>Icon Empty</strong>: ' . __( 'The image you uploaded triggered the following error: ', 'rating-form' ) . $_FILES['icon_empty']['error'];
					} else if ($icon_empty_ext[1] != 'png') {
						$msg_error[] = sprintf( __( 'Only <strong>.png</strong> extension allowed. E.g. for transparency of image.<br>You uploaded: %1$s.<strong>%2$s</strong>', 'rating-form' ), $icon_empty_ext[0], $icon_empty_ext[1] );
					}
				}

				if (!empty($_FILES['icon_full']['name'])) {
					$icon_full_ext = explode('.', strtolower($_FILES['icon_full']['name']));
					if($_FILES['icon_full']['error']) {
						$msg_error[] = '<strong>Icon Ful</strong>: ' . __( 'The image you uploaded triggered the following error: ', 'rating-form' ) . $_FILES['icon_full']['error'];
					} else if ($icon_full_ext[1] != 'png') {
						$msg_error[] = 'Only <strong>.png</strong> extension allowed. E.g. for transparency of full icon.<br>You uploaded: '.$icon_full_ext[0].'.<strong>'.$icon_full_ext[1].'</strong>';
						$msg_error[] = sprintf( __( 'Only <strong>.png</strong> extension allowed. E.g. for transparency of image.<br>You uploaded: %1$s.<strong>%2$s</strong>', 'rating-form' ), $icon_full_ext[0], $icon_full_ext[1] );
					}
				}

				if (!empty($_FILES['icon_half']['name'])) {
					$icon_half_ext = explode('.', strtolower($_FILES['icon_half']['name']));
					if($_FILES['icon_half']['error']) {
						$msg_error[] = '<strong>Icon Half</strong>: ' . __( 'The image you uploaded triggered the following error: ', 'rating-form' ) . $_FILES['icon_half']['error'];
					} else if ($icon_half_ext[1] != 'png') {
						$msg_error[] = sprintf( __( 'Only <strong>.png</strong> extension allowed. E.g. for transparency of image.<br>You uploaded: %1$s.<strong>%2$s</strong>', 'rating-form' ), $icon_half_ext[0], $icon_half_ext[1] );
					}
				}

				// CSS
				if (count($msg_error) == 0) {
					// STAR
					if (Rating_Form_Setup::form_types($id_query['type'], 'type') == "star") {
						if ($id_query['type'] != 0) {
							if (!empty($font_color)) $arrCss['color'] = $font_color;
							if (!empty($font_hover_color)) $arrCss['hover_color'] = $font_hover_color;
						}
					}
					$arrCss['alignment'] = empty($form_alignment) ? 'left' : $form_alignment;
					if (!empty($font_size)) $arrCss['font_size'] = $font_size; // also for img size
					// .def

					if (!empty($font_color_text)) $arrCss['def_color'] = $font_color_text;
					if (!empty($font_size_text)) $arrCss['def_font_size'] = $font_size_text;
					if (!empty($background_def_text)) $arrCss['def_background'] = $background_def_text;
					// TUD .def
					if (Rating_Form_Setup::form_types($id_query['type'], 'type') == "tud") {
						if (!empty($tu_font_color))	$arrCss['up_color'] = $tu_font_color;
						if (!empty($tu_font_hover_color)) $arrCss['hover_up_color'] = $tu_font_hover_color;

						if (!empty($tu_font_color_text)) $arrCss['def_up_color'] = $tu_font_color_text;
						if (!empty($tu_background_def_text)) $arrCss['def_up_background'] = $tu_background_def_text;

						if (!empty($td_font_color)) $arrCss['down_color'] = $td_font_color;
						if (!empty($td_font_hover_color)) $arrCss['hover_down_color'] = $td_font_hover_color;

						if (!empty($td_font_color_text)) $arrCss['def_down_color'] = $td_font_color_text;
						if (!empty($td_background_def_text)) $arrCss['def_down_background'] = $td_background_def_text;
					}
					if (!empty($custom_css)) $arrCss['custom_css'] = stripslashes($custom_css);
					// json_encode
					$arrCss = json_encode($arrCss);
					$defDisplay['max'] = $display['max'];
					$defDisplay['title'] = array_slice($display['title'], 0, $display['max']);
					$display = json_encode($defDisplay);

					$wpdb->update( $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM, array(
							'display' => $display,
							'css' => $arrCss
					), array('form_id' => $id_query['form_id'] ) );

					if ($id_query['type'] == 0) {
						//upload custom icons
						//create folder for icons if it doesn't exists
						if (!file_exists($thisFormUploadDir)) {
							wp_mkdir_p( $thisFormUploadDir );
						}
						if (!empty($_FILES['icon_empty']['name'])) {
							if (file_exists( $thisFormUploadDir . DIRECTORY_SEPARATOR . 'custom-empty.png' )) {
								unlink( $thisFormUploadDir . DIRECTORY_SEPARATOR . 'custom-empty.png' );
							}
							move_uploaded_file($_FILES['icon_empty']['tmp_name'], $thisFormUploadDir . DIRECTORY_SEPARATOR . 'custom-empty.png');
						}
						if (!empty($_FILES['icon_full']['name'])) {
							if (file_exists( $thisFormUploadDir . DIRECTORY_SEPARATOR . 'custom-full.png' )) {
								unlink( $thisFormUploadDir . DIRECTORY_SEPARATOR . 'custom-full.png' );
							}
							move_uploaded_file($_FILES['icon_full']['tmp_name'], $thisFormUploadDir . DIRECTORY_SEPARATOR . 'custom-full.png');
						}
						if (!empty($_FILES['icon_half']['name'])) {
							if (file_exists( $thisFormUploadDir . DIRECTORY_SEPARATOR . 'custom-half.png' )) {
								unlink( $thisFormUploadDir . DIRECTORY_SEPARATOR . 'custom-half.png' );
							}
							move_uploaded_file($_FILES['icon_half']['tmp_name'], $thisFormUploadDir . DIRECTORY_SEPARATOR . 'custom-half.png');
						}
					}

					$msg_success .= __( 'Successfully updated!', 'rating-form' );
				}
			} else {
				$msg_error[] =  __( 'Error! Style not updated.', 'rating-form' );
			}

			if ( strlen( $msg_success ) > 0) {
				echo '<div class="rf_updated">' . $msg_success . '<br>';
				echo '<strong>Shortcode:</strong> <input onclick="this.select()" type="text" readonly="" value="[rating_form id=&quot;'.$id_query['form_id'].'&quot;]"></div>';
			}

			if ( count( $msg_error ) > 0) {
				foreach ($msg_error as $msg_error_txt)
					echo '<div class="rf_error">' . $msg_error_txt . '</div>';
			}
		}
		$styleCss = json_decode((isset($_POST['save_style']) ? $arrCss : $id_query['css']), true);
?>
	<form method="post" action="<?php echo admin_url('admin.php?page=' . Rating_Form_Setup::PAGE_FORM_RATING_SLUG . '&style=' . $id_query['form_id']); ?>" enctype="multipart/form-data">
		<div class="rf_form_content rf_form_create">
		<div class="rf_header_title">
			<div class="rf_left"><strong><?php _e( 'Style', 'rating-form' ); ?></strong> Rating Form <?php echo $id_query['form_id'] . (empty($id_query['form_name']) ? '' : ' (' . $id_query['form_name'] . ')'); ?></div>
			<div class="rf_right">
			<a class="button" href="admin.php?page=<?php echo Rating_Form_Setup::PAGE_FORM_RATING_SLUG . '&settings=' . $id_query['form_id']; ?>"><?php _e( 'Edit Settings', 'rating-form' ); ?></a>
			<input type="submit" name="save_style" class="button button-primary" value="<?php _e( 'Save', 'rating-form' ); ?>">
			</div>
		</div>
		<div class="rf_form_layout_left rf_mt50px rf_left">
			<h3 class="rf_left"><?php _e( 'Live Example', 'rating-form' ); ?></h3>
			<div class="clear"></div>
			<div class="rf_form_example">
			<?php
				// Css Style
				echo '<style type="text/css" id="admin_rf_add_new_css"></style>';
			?>
			<div class="rf_form_example_inner"><?php echo do_shortcode('[rating_form id="' . $id_query['form_id'] . '" stats="false"]'); ?></div>
			</div>
			<?php if (in_array("remove_inline_style", $qJsonDisplay)) { ?>
			<h3 class="rf_form_example_footer rf_left rf_clear"><?php echo __( "Remove inline style", 'rating-form' ) . ' - <span style="color:green"><strong>' . __( "On", 'rating-form' ) .'</strong></span>'; ?></h3>
			<?php } ?>
			<div class="clear"></div>
		</div>
		<div class="rf_form_layout_right rf_mt50px rf_left">
		<?php if (Rating_Form_Setup::form_types(intval($id_query['type']), 'type') == "star") { ?>
			<div class="rf_form_box">
			<h3 class="block">
			<span class="rf_left"><?php _e( 'Style', 'rating-form' ); ?></span>
			<span class="rf_right">
			<select id="form_alignment" name="alignment">
				<option value="" <?php selected((empty($styleCss['alignment']) ? '' : $styleCss['alignment']), ''); ?>><?php _e( 'Alignment', 'rating-form' ); ?></option>
				<option value="left" <?php selected((empty($styleCss['alignment']) ? '' : $styleCss['alignment']), 'left'); ?>><?php _e( 'Left', 'rating-form' ); ?></option>
				<option value="center" <?php selected((empty($styleCss['alignment']) ? '' : $styleCss['alignment']), 'center'); ?>><?php _e( 'Center', 'rating-form' ); ?></option>
				<option value="right" <?php selected((empty($styleCss['alignment']) ? '' : $styleCss['alignment']), 'right'); ?>><?php _e( 'Right', 'rating-form' ); ?></option>
			</select>
			</span>
			</h3>
			<div class="rf_form_box_inner">
				<table class="rf-table rf_100p">
					<tbody>
						<?php if ($typeCustomCheck) { ?>
						<tr>
							<td colspan="2">
								<div class="rf-input rf_100p rf_border_box rf_left">
									<span class="rf-title"><strong><?php _e( 'Icon Empty', 'rating-form' ); ?></strong></span>
									<div class="rf_right">
									<img src="<?php echo $upload_dir['baseurl'].'/rating-form/icons/'.$id_query['form_id']; ?>/custom-empty.png" alt="Custom Empty" /><br>
									<?php
										if ( !file_exists($thisFormUploadDir . DIRECTORY_SEPARATOR . 'custom-empty.png') ) {
											echo '<span class="description" style="color: red">'. __( 'Image not found! To fix this error, upload below.', 'rating-form' ) .'</span><br>';
										}
									?>
									</div>
									<input class="rf_left" type="file" name="icon_empty" />
									<p class="description"><?php _e( 'Upload an empty icon e.g. empty star', 'rating-form' ); ?></p>
								</div>
						</tr>
						<tr>
							<td colspan="2">
								<div class="rf-input rf_100p rf_border_box rf_left">
									<span class="rf-title"><strong><?php _e( 'Icon Full (Hover)', 'rating-form' ); ?></strong></span>
									<div class="rf_right">
									<img src="<?php echo $upload_dir['baseurl'].'/rating-form/icons/'.$id_query['form_id']; ?>/custom-full.png" alt="Custom Full" /><br>
									<?php
										if ( !file_exists($thisFormUploadDir . DIRECTORY_SEPARATOR . 'custom-full.png') ) {
											echo '<span class="description" style="color: red">'. __( 'Image not found! To fix this error, upload below.', 'rating-form' ) .'</span><br>';
										}
									?>
									</div>
									<input class="rf_left" type="file" name="icon_full" />
									<p class="description"><?php _e( 'Upload an full icon e.g. full star', 'rating-form' ); ?></p>
								</div>
						</tr>
						<tr>
							<td colspan="2">
								<div class="rf-input rf_100p rf_border_box rf_left">
									<span class="rf-title"><strong><?php _e( 'Icon Half', 'rating-form' ); ?></strong></span>
									<div class="rf_right">
									<img src="<?php echo $upload_dir['baseurl'].'/rating-form/icons/'.$id_query['form_id']; ?>/custom-half.png" alt="Custom Half" /><br>
									<?php
										if ( !file_exists($thisFormUploadDir . DIRECTORY_SEPARATOR . 'custom-half.png') ) {
											echo '<span class="description" style="color: red">'. __( 'Image not found! To fix this error, upload below.', 'rating-form' ) .'</span><br>';
										}
									?>
									</div>
									<input class="rf_left" type="file" name="icon_half" />
									<p class="description"><?php _e( 'Upload an half icon e.g. half star', 'rating-form' ); ?></p>
								</div>
							</td>
						</tr>
						<?php } ?>
						<tr>
							<td>
								<div class="rf-input rf_100p rf_border_box">
									<h3 class="rf-h3-title"><?php echo $type_name; ?></h3>
									<div class="rf_item rf_left rf_clear rf_100p">
										<span class="rf_left rf-title"><strong><?php _e( 'Size', 'rating-form' ); ?></strong></span>
										<span class="rf_right">
											<span class="rf-input-number-decrement">-</span>
											<input id="font_size" class="rf-input-number" type="text" name="font_size" value="<?php echo empty($styleCss['font_size']) ? '32px' : $styleCss['font_size']; ?>" min="1" max="">
											<span class="rf-input-number-increment">+</span>
										</span>
									</div>
									<?php if (!$typeCustomCheck) { ?>
									<div class="rf_item rf_left rf_clear rf_100p">
										<span class="rf_left rf-title"><strong><?php _e( 'Color', 'rating-form' ); ?></strong></span>
										<div class="rf_right">
										<input id="font_color" type="text" name="font_color" value="<?php echo empty($styleCss['color']) ? $type_color : $styleCss['color']; ?>" />
										</div>
										<div class="rf_clear"></div>
										<span class="rf_left rf-title"><strong><?php _e( 'Hover Color', 'rating-form' ); ?></strong></span>
										<div class="rf_right">
										<input id="font_hover_color" type="text" name="font_hover_color" value="<?php echo empty($styleCss['hover_color']) ? $type_color_hover : $styleCss['hover_color']; ?>" />
										</div>
									</div>
									<?php } ?>
									<div id="max" class="rf_item rf_left rf_clear rf_100p">
										<span class="rf-title"><strong><?php _e( 'Max', 'rating-form' ); ?></strong></span>
										<span class="rf-input-inde">
											<span class="rf-input-number-decrement">-</span>
											<input class="rf-input-number" type="text" name="display[max]" value="<?php echo empty($qJsonDisplay['max']) ? 5 : $qJsonDisplay['max']; ?>" min="1" max="<?php echo Rating_Form_Setup::form_types($id_query['type'], 'i'); ?>">
											<span class="rf-input-number-increment">+</span>
										</span>
										<p class="description"><?php _e( 'Set max shapes', 'rating-form' ); ?></p>
									</div>
								</div>
							</td>
							<td>
								<div class="rf-input rf_100p rf_border_box">
									<h3 class="rf-h3-title"><?php _e( 'Text', 'rating-form' ); ?></h3>
									<div class="rf_item rf_left rf_clear rf_100p">
										<span class="rf_left rf-title"><strong><?php _e( 'Font-Size', 'rating-form' ); ?></strong></span>
										<span class="rf_right">
										<span class="rf-input-number-decrement">-</span>
											<input id="font_size_text" class="rf-input-number" type="text" name="font_size_text" value="<?php echo empty($styleCss['def_font_size']) ? '18px' : $styleCss['def_font_size']; ?>" min="1" max="">
											<span class="rf-input-number-increment">+</span>
										</span>
									</div>
									<div class="rf_item rf_left rf_clear rf_100p">
										<span class="rf_left rf-title"><strong><?php _e( 'Color', 'rating-form' ); ?></strong></span>
										<div class="rf_right">
										<input id="font_color_text" type="text" name="font_color_text" value="<?php echo empty($styleCss['def_color']) ? '#777777' : $styleCss['def_color']; ?>" />
										</div>
										<div class="rf_clear"></div>
										<span class="rf_left rf-title"><strong><?php _e( 'Background', 'rating-form' ); ?></strong></span>
										<div class="rf_right">
										<input id="background_def_text" type="text" name="background_def_text" value="<?php echo empty($styleCss['def_background']) ? '#dddddd' : $styleCss['def_background']; ?>" />
										</div>
									</div>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
				</div>
			</div>
		<?php } else if (Rating_Form_Setup::form_types(intval($id_query['type']), 'type') == "tud") { ?>
			<div class="rf_form_box">
			<input type="hidden" value="<?php echo $qJsonDisplay['max']; ?>" name="display[max]" />
			<h3 class="block">
			<span class="rf_left"><?php _e( 'Style', 'rating-form' ); ?></span>
			<span class="rf_right">
			<select id="form_alignment" name="alignment">
				<option value="" <?php selected((empty($styleCss['alignment']) ? '' : $styleCss['alignment']), ''); ?>><?php _e( 'Alignment', 'rating-form' ); ?></option>
				<option value="left" <?php selected((empty($styleCss['alignment']) ? '' : $styleCss['alignment']), 'left'); ?>><?php _e( 'Left', 'rating-form' ); ?></option>
				<option value="center" <?php selected((empty($styleCss['alignment']) ? '' : $styleCss['alignment']), 'center'); ?>><?php _e( 'Center', 'rating-form' ); ?></option>
				<option value="right" <?php selected((empty($styleCss['alignment']) ? '' : $styleCss['alignment']), 'right'); ?>><?php _e( 'Right', 'rating-form' ); ?></option>
			</select>
			</span>
			</h3>
			<div class="rf_form_box_inner">
				<table class="rf-table rf_100p">
					<tbody>
						<tr>
							<td>
								<div class="rf-input rf_100p rf_border_box">
									<h3 class="rf-h3-title"><?php echo $type_name; ?></h3>
									<div class="rf_item rf_left rf_clear rf_100p">
										<span class="rf_left rf-title"><strong><?php _e( 'Size', 'rating-form' ); ?></strong></span>
										<span class="rf_right">
										<span class="rf-input-number-decrement">-</span>
											<input id="font_size" class="rf-input-number" type="text" name="font_size" value="<?php echo empty($styleCss['font_size']) ? '32px' : $styleCss['font_size']; ?>" min="1" max="">
											<span class="rf-input-number-increment">+</span>
										</span>
									</div>
								</div>
							</td>
							<td>
								<div class="rf-input rf_100p rf_border_box">
									<h3 class="rf-h3-title"><?php _e( 'Text', 'rating-form' ); ?></h3>
									<div class="rf_item rf_left rf_clear rf_100p">
										<span class="rf_left rf-title"><strong><?php _e( 'Font-Size', 'rating-form' ); ?></strong></span>
										<span class="rf_right">
										<span class="rf-input-number-decrement">-</span>
											<input id="font_size_text" class="rf-input-number" type="text" name="font_size_text" value="<?php echo empty($styleCss['def_font_size']) ? '18px' : $styleCss['def_font_size']; ?>" min="1" max="">
											<span class="rf-input-number-increment">+</span>
										</span>
									</div>
									<div class="rf_item rf_left rf_clear rf_100p">
										<span class="rf_left rf-title"><strong><?php _e( 'Color', 'rating-form' ); ?></strong></span>
										<div class="rf_right">
										<input id="font_color_text" type="text" name="font_color_text" value="<?php echo empty($styleCss['def_color']) ? '#777777' : $styleCss['def_color']; ?>" />
										</div>
										<div class="rf_clear"></div>
										<span class="rf_left rf-title"><strong><?php _e( 'Background', 'rating-form' ); ?></strong></span>
										<div class="rf_right">
										<input id="background_def_text" type="text" name="background_def_text" value="<?php echo empty($styleCss['def_background']) ? '#dddddd' : $styleCss['def_background']; ?>" />
										</div>
									</div>
								</div>
							</td>
						</tr>
						<tr>
							<td>
								<div class="rf-input rf_100p rf_border_box">
									<h3 class="rf-h3-title"><?php echo $type_name_one; ?></h3>
									<span class="rf_left rf-title"><strong><?php _e( 'Color', 'rating-form' ); ?></strong></span>
									<span class="rf_right">
									<input id="tu_font_color" type="text" name="tu_font_color" value="<?php echo empty($styleCss['up_color']) ? '#59d600' : $styleCss['up_color']; ?>" />
									</span>
									<div class="rf_clear"></div>
									<span class="rf_left rf-title"><strong><?php _e( 'Hover Color', 'rating-form' ); ?></strong></span>
									<span class="rf_right">
									<input id="tu_font_hover_color" type="text" name="tu_font_hover_color" value="<?php echo empty($styleCss['hover_up_color']) ? '#0e8b00' : $styleCss['hover_up_color']; ?>" />
									</span>
									<div class="rf_clear"></div>
									<span class="rf_left rf-title"><strong><?php _e( 'Text Color', 'rating-form' ); ?></strong></span>
									<span class="rf_right">
									<input id="tu_font_color_text" type="text" name="tu_font_color_text" value="<?php echo empty($styleCss['def_up_color']) ? '#0e8b00' : $styleCss['def_up_color']; ?>" />
									</span>
									<div class="rf_clear"></div>
									<span class="rf_left rf-title"><strong><?php _e( 'Text Background', 'rating-form' ); ?></strong></span>
									<span class="rf_right">
									<input id="tu_background_def_text" type="text" name="tu_background_def_text" value="<?php echo empty($styleCss['def_up_background']) ? '#bdffaf' : $styleCss['def_up_background']; ?>" />
									</span>
								</div>
							</td>
							<td>
								<div class="rf-input rf_100p rf_border_box">
									<h3 class="rf-h3-title"><?php echo $type_name_two; ?></h3>
									<span class="rf_left rf-title"><strong><?php _e( 'Color', 'rating-form' ); ?></strong></span>
									<span class="rf_right">
									<input id="td_font_color" type="text" name="td_font_color" value="<?php echo empty($styleCss['down_color']) ? '#d60000' : $styleCss['down_color']; ?>" />
									</span>
									<div class="rf_clear"></div>
									<span class="rf_left rf-title"><strong><?php _e( 'Hover Color', 'rating-form' ); ?></strong></span>
									<span class="rf_right">
									<input id="td_font_hover_color" type="text" name="td_font_hover_color" value="<?php echo empty($styleCss['hover_down_color']) ? '#b80000' : $styleCss['hover_down_color']; ?>" />
									</span>
									<div class="rf_clear"></div>
									<span class="rf_left rf-title"><strong><?php _e( 'Text Color', 'rating-form' ); ?></strong></span>
									<span class="rf_right">
									<input id="td_font_color_text" type="text" name="td_font_color_text" value="<?php echo empty($styleCss['def_down_color']) ? '#b80000' : $styleCss['def_down_color']; ?>" />
									</span>
									<div class="rf_clear"></div>
									<span class="rf_left rf-title"><strong><?php _e( 'Text Background', 'rating-form' ); ?></strong></span>
									<span class="rf_right">
									<input id="td_background_def_text" type="text" name="td_background_def_text" value="<?php echo empty($styleCss['def_down_background']) ? '#ffb0b0' : $styleCss['def_down_background']; ?>" />
									</span>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			</div>
		<?php } ?>
		<div class="clear"></div>
		<div class="rf_form_box rf_hidden">
			<h3 class="block"><?php _e( 'Titles', 'rating-form' ); ?></h3>
			<div class="rf_form_box_inner">
				<table id="texts" class="rf-table rf_100p">
					<tbody>
						<tr>
							<td>
								<div class="rf-input">
								<?php
								global $wpdb;
								// Rating titles
								// TODO: Add selected="selected"- Check current titles of Rating form
								$titlesID = Rating_Form_API::getTitles($id_query['type'], $qJsonDisplay['title'], 'title_id');

								$hideorshow = null;
								$pos_query = $wpdb->get_results( "SELECT position FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_TITLES . " GROUP BY position ORDER BY position ASC", ARRAY_A );

								$i = 0;
								foreach ($pos_query as $pos_row) {
									$i++;
									if ($i > $defDisplay['max']) {
										$hideorshow = ' rf_hide';
									}
									$text_query = $wpdb->get_results( "SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_TITLES . " WHERE position = ". $pos_row['position'] ." ORDER BY title_id ASC", ARRAY_A );
									$text_query_notin = $wpdb->get_results( "SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_TITLES . " WHERE title_id NOT IN ('".join("','", $titlesID)."') AND position = ". $pos_row['position'] ." ORDER BY title_id DESC", ARRAY_A );
                                    ?>
									<div class="rf_left rf_clear rf_100p text_select<?php echo $hideorshow; ?>">
									<span class="rf-title"><strong><?php _e( 'Position', 'rating-form' ); ?> <?php echo $pos_row['position']; ?></strong></span>
									<select class="rf_right rf_50p" name="display[title][]">
									<?php foreach ($text_query as $text_row) { ?>
										<?php if (in_array($text_row['title_id'], $titlesID)) { ?>
										<option value="<?php echo $text_row['title_id']; ?>"><?php _e(stripslashes($text_row['text']), 'rating-form'); ?></option>
										<?php } ?>
									<?php } ?>
									<?php foreach ($text_query_notin as $text_row_notin) { ?>
										<option value="<?php echo $text_row_notin['title_id']; ?>"><?php _e(stripslashes($text_row_notin['text']), 'rating-form'); ?></option>
									<?php } ?>
									</select>
									</div>
									<?php
								}
								?>
								<p class="description"><?php _e( 'Change titles', 'rating-form' ); ?></p>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
		<div class="clear"></div>
		<div class="rf_form_box rf_custom_css rf_hidden">
			<h3 class="block"><?php _e( 'Custom CSS', 'rating-form' ); ?></h3>
			<div class="rf_form_box_inner">
				<table id="rf_custom_attr" class="rf-table rf_100p">
					<tbody>
						<tr>
							<td>
								<div class="rf-input rf_100p rf_border_box">
								<div class="rf_left rf_clear"><span><?php echo '.rating_form_' . $id_query['form_id']; ?></span> <strong><?php _e( '(outer div)', 'rating-form' ); ?></strong></div>
								<div class="rf_left rf_clear"><span><?php echo '.rating_form_' . $id_query['form_id'] . ' .rating_form'; ?></span> <strong><?php _e( '(shapes list)', 'rating-form' ); ?></strong></div>
								<div class="rf_left rf_clear"><span><?php echo '.rating_form_' . $id_query['form_id'] . ' .rating_form .rf_item'; ?></span> <strong><?php _e( '(single shape)', 'rating-form' ); ?></strong></div>
                                <div class="rf_left rf_clear"><span><?php echo '.rating_form_' . $id_query['form_id'] . ' .rating_form .def'; ?></span> <strong><?php _e( '(average and total result)', 'rating-form' ); ?></strong></div>
                                <div class="rf_left rf_clear"><span><?php echo '.rating_form_' . $id_query['form_id'] . ' .rating_form .rating_score'; ?></span> <strong><?php _e( '(average result)', 'rating-form' ); ?></strong></div>
								<div class="rf_left rf_clear"><span><?php echo '.rating_form_' . $id_query['form_id'] . ' .rating_form .rating_total'; ?></span> <strong><?php _e( '(total result)', 'rating-form' ); ?></strong></div>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
				<div class="rf-input rf_100p rf_border_box">
					<textarea class="rf_custom_css_txt rf_100p rf_border_box" name="custom_css" rows="10"><?php echo empty($styleCss['custom_css']) ? '' : $styleCss['custom_css']; ?></textarea>
				</div>
			</div>
		</div>
		</div>
	</form>
<?php
	}

	// go to list if Rating Form doesn't exist
	} else {
		if (isset($_GET['duplicate'])) { //duplicate rating
			global $wpdb;

            $form_sql = "SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM . " WHERE form_id = %d";
			$form_query = $wpdb->get_row( $wpdb->prepare( $form_sql, $_GET['duplicate'] ) , ARRAY_A );
			$rowCount = $wpdb->num_rows;

			if ($rowCount > 0) {
				$wpdb->insert( $wpdb->prefix.Rating_Form_Setup::TBL_RATING_ADD_FORM, array(
							'form_name' => $form_query['form_name'],
							'type' => $form_query['type'],
							'display' => $form_query['display'],
							'css' => $form_query['css']
					));
				$new_rating_id .= $wpdb->insert_id;
				//duplicate custom images
				if ($form_query['type'] == 0) {
					wp_mkdir_p( $upload_dir['basedir'].'/rating-form/icons/' . $new_rating_id );
					copy($upload_dir['basedir'].'/rating-form/icons/' . $form_query['form_id'] . DIRECTORY_SEPARATOR . 'custom-empty.png',
							$upload_dir['basedir'].'/rating-form/icons/' . $new_rating_id . DIRECTORY_SEPARATOR . 'custom-empty.png');
					copy($upload_dir['basedir'].'/rating-form/icons/' . $form_query['form_id'] . DIRECTORY_SEPARATOR . 'custom-full.png',
							$upload_dir['basedir'].'/rating-form/icons/' . $new_rating_id . DIRECTORY_SEPARATOR . 'custom-full.png');
					copy($upload_dir['basedir'].'/rating-form/icons/' . $form_query['form_id'] . DIRECTORY_SEPARATOR . 'custom-half.png',
							$upload_dir['basedir'].'/rating-form/icons/' . $new_rating_id . DIRECTORY_SEPARATOR . 'custom-half.png');
				}
				echo '<div class="rf_updated">'. __( 'Successfully duplicated!', 'rating-form' ) .'<br>';
				echo '<strong>Shortcode:</strong> <input onclick="this.select()" type="text" readonly="" value="[rating_form id=&quot;'.$new_rating_id.'&quot;]"></div>';
			} else {
				echo '<div class="rf_error">'. sprintf( __( 'Rating Form ID <strong>%d</strong> not found!', 'rating-form' ), $_GET['duplicate'] ) .'</div>';
			}
		} else if (isset($_GET['delete'])) { //delete rating
			global $wpdb;

			$del_query = $wpdb->get_results( "SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM . " WHERE form_id = '".$_GET['delete']."'", ARRAY_A );
			$rowCount = $wpdb->num_rows;

			if ($rowCount == 0) {
				echo '<div class="rf_error">'. sprintf( __( 'Rating Form ID <strong>%d</strong> not found!', 'rating-form' ), $_GET['delete'] ) .'</div>';
			} else {
				//delete form
				$wpdb->query(
					$wpdb->prepare(
							"DELETE FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM . " WHERE form_id = %d",
							$_GET['delete']
						)
				);

				if ($del_query[0]['type'] == 0) {
					// delete custom icons and folder form id
					$form_dir = $upload_dir['basedir'].'/rating-form/icons/' . $del_query[0]['form_id'];
					array_map('unlink', glob("$form_dir/*.*"));
					rmdir($form_dir) or die(sprintf( __("Unable to delete this folder: %s<br>Check folder permission or delete manually.", 'rating-form' ), $form_dir ));
				}

				$wpdb->show_errors();
				echo '<div class="rf_updated"><p>'. __( 'Succesfully deleted!', 'rating-form' ) .'</p></div>';
			}
		}
	$rating_form_table = new Rating_Form_Table();
	$rating_form_table->prepare_items();
?>
		<form class="rf_form_table" id="rating_form_list" method="post">
			<?php $rating_form_table->display(); ?>
		</form>
<?php
	}
?>
	</div>
<?php
}
?>
