<?php
//Add Rating
function rating_form_add() {
?>
<div class="wrap rf_wrap<?php echo Rating_Form_Setup::getAdminRTLclass(); ?>" id="rating_form_add_edit"<?php echo Rating_Form_Setup::getAdminRTL(); ?>>
<?php
	Rating_Form_Setup::admin_menus( __( 'Add New Rating Form', 'rating-form' ) );
	if (isset($_POST['add'])) {
		$msg_success = null;
		$msg_error = array();
		$new_rating_id = null;
		$style_content = null;
		$upload_dir = wp_upload_dir();
		$type = $_POST['type'];
		$form_name = $_POST['form_name'];
		$display = isset($_POST['display']) ? $_POST['display'] : '';
		$max = isset($display['max']) ? $display['max'] : '';
		//Font Size
		$form_alignment = isset($_POST['alignment']) ? $_POST['alignment'] : null;
		$font_size = isset($_POST['font_size']) ? $_POST['font_size'] : null;
		//Def
		$font_size_text = isset($_POST['font_size_text']) ? $_POST['font_size_text'] : null;
		$background_def_text = isset($_POST['background_def_text']) ? $_POST['background_def_text'] : null;
		//Style star
		$font_color = isset($_POST['font_color']) ? $_POST['font_color'] : null;
		$font_color_text = isset($_POST['font_color_text']) ? $_POST['font_color_text'] : null;
		$font_hover_color = isset($_POST['font_hover_color']) ? $_POST['font_hover_color'] : null;
		//Style thumbs up
		$tu_font_color = isset($_POST['tu_font_color']) ? $_POST['tu_font_color'] : null;
		$tu_font_color_text = isset($_POST['tu_font_color_text']) ? $_POST['tu_font_color_text'] : null;
		$tu_font_hover_color = isset($_POST['tu_font_hover_color']) ? $_POST['tu_font_hover_color'] : null;
		$tu_background_def_text = isset($_POST['tu_background_def_text']) ? $_POST['tu_background_def_text'] : null;
		//Style thumbs down
		$td_font_color = isset($_POST['td_font_color']) ? $_POST['td_font_color'] : null;
		$td_font_color_text = isset($_POST['td_font_color_text']) ? $_POST['td_font_color_text'] : null;
		$td_font_hover_color = isset($_POST['td_font_hover_color']) ? $_POST['td_font_hover_color'] : null;
		$td_background_def_text = isset($_POST['td_background_def_text']) ? $_POST['td_background_def_text'] : null;
		//Custom Image files
		$icon_empty = empty($icon_empty['name']) ? null : $_FILES['icon_empty'];
		$icon_full = empty($icon_full['name']) ? null : $_FILES['icon_full'];
		$icon_half = empty($icon_half['name']) ? null : $_FILES['icon_half'];

		if (isset($type, $display)) {
			if (intval($type) == 0) {
				$icon_empty_ext = explode('.', strtolower($_FILES['icon_empty']['name']));
				if (empty($_FILES['icon_empty']['name'])) {
					$msg_error[] = __( "No 'empty icon' selected. <em>Don't forget to select all icons again.</em>", 'rating-form' );
				} else if ($_FILES['icon_empty']['error']) {
					$msg_error[] = '<strong>Icon Empty</strong>: ' . __( 'The image you uploaded triggered the following error: ', 'rating-form' ) . $_FILES['icon_empty']['error'];
				} else if ($icon_empty_ext[1] != 'png') {
					$msg_error[] = sprintf( __( 'Only <strong>.png</strong> extension allowed. E.g. for transparency of image.<br>You uploaded: %1$s.<strong>%2$s</strong>', 'rating-form' ), $icon_empty_ext[0], $icon_empty_ext[1] );
				}

				$icon_full_ext = explode('.', strtolower($_FILES['icon_full']['name']));
				if (empty($_FILES['icon_full']['name'])) {
					$msg_error[] = __( "No 'full icon' selected. <em>Don't forget to select all icons again.</em>", 'rating-form' );
				} else if ($_FILES['icon_full']['error']) {
					$msg_error[] = '<strong>Icon Empty</strong>: ' . __( 'The image you uploaded triggered the following error: ', 'rating-form' ) . $_FILES['icon_full']['error'];
				} else if ($icon_full_ext[1] != 'png') {
					$msg_error[] = sprintf( __( 'Only <strong>.png</strong> extension allowed. E.g. for transparency of image.<br>You uploaded: %1$s.<strong>%2$s</strong>', 'rating-form' ), $icon_full_ext[0], $icon_full_ext[1] );
				}

				$icon_half_ext = explode('.', strtolower($_FILES['icon_half']['name']));
				if (empty($_FILES['icon_half']['name'])) {
					$msg_error[] = __( "No'half icon' selected. <em>Don't forget to select all icons again.</em>", 'rating-form' );
				} else if ($_FILES['icon_half']['error']) {
					$msg_error[] = '<strong>Icon Empty</strong>: ' . __( 'The image you uploaded triggered the following error: ', 'rating-form' ) . $_FILES['icon_half']['error'];
				} else if ($icon_half_ext[1] != 'png') {
					$msg_error[] = sprintf( __( 'Only <strong>.png</strong> extension allowed. E.g. for transparency of image.<br>You uploaded: %1$s.<strong>%2$s</strong>', 'rating-form' ), $icon_half_ext[0], $icon_half_ext[1] );
				}
			}

			if(strlen($form_name) > 50) {
				$msg_error[] = sprintf( __( '<strong>Name</strong> has %s characters. Allowed: 50 characters', 'rating-form' ), strlen($form_name));
			}

			if (count($msg_error) == 0) {

				global $wpdb;

				if (count($display) > 0) {
					// Add fields
					$display[] = 'active';
					// Display[] Attribute
					// Remove Empty values
					for ($i = 0 ; $i < count($display); $i++) {
						if (empty($display[$i])) {
							unset($display[$i]);
						}
					}
					$display = json_encode($display);
				} else {
					$display = '';
				}


				// CSS
				$arrCss = array();
				// STAR
				if (Rating_Form_Setup::form_types(intval($type), 'type') == "star") {
					if (intval($type) != 0) {
						$arrCss['color'] = empty($font_color) ? '' : $font_color;
						$arrCss['hover_color'] = empty($font_hover_color) ? '' : $font_hover_color;
					}
				}
				$arrCss['alignment'] = empty($form_alignment) ? '' : $form_alignment;
				$arrCss['font_size'] = empty($font_size) ? '' : $font_size; // also for img size
				// .def
				$arrCss['def_color'] = empty($font_color_text) ? '' : $font_color_text;
				$arrCss['def_font_size'] = empty($font_size_text) ? '' : $font_size_text;
				$arrCss['def_background'] = empty($background_def_text) ? '' : $background_def_text;
				// TUD .def
				if (Rating_Form_Setup::form_types(intval($type), 'type') == "tud") {
					$arrCss['up_color'] = empty($tu_font_color) ? '' : $tu_font_color;
					$arrCss['hover_up_color'] = empty($tu_font_hover_color) ? '' : $tu_font_hover_color;

					$arrCss['def_up_color'] = empty($tu_font_color_text) ? '' : $tu_font_color_text;
					$arrCss['def_up_background'] = empty($tu_background_def_text) ? '' : $tu_background_def_text;

					$arrCss['down_color'] = empty($td_font_color) ? '' : $td_font_color;
					$arrCss['hover_down_color'] = empty($td_font_hover_color) ? '' : $td_font_hover_color;

					$arrCss['def_down_color'] = empty($td_font_color_text) ? '' : $td_font_color_text;
					$arrCss['def_down_background'] = empty($td_background_def_text) ? '' : $td_background_def_text;
				}
				// json_encode
				$arrCss = json_encode($arrCss);

				$wpdb->insert( $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM, array(
						'form_name' => $form_name,
						'type' => intval($type),
						'display' => $display,
						'css' => $arrCss
				) );

				$new_rating_id .= $wpdb->insert_id;

				if (intval($type) == 0) {
					//upload custom icons
					wp_mkdir_p( $upload_dir['basedir'].'/rating-form/icons/' . $new_rating_id );
					move_uploaded_file($_FILES['icon_empty']['tmp_name'], $upload_dir['basedir'].'/rating-form/icons/' . $new_rating_id . DIRECTORY_SEPARATOR . 'custom-empty.png');
					move_uploaded_file($_FILES['icon_full']['tmp_name'], $upload_dir['basedir'].'/rating-form/icons/' . $new_rating_id . DIRECTORY_SEPARATOR . 'custom-full.png');
					move_uploaded_file($_FILES['icon_half']['tmp_name'], $upload_dir['basedir'].'/rating-form/icons/' . $new_rating_id . DIRECTORY_SEPARATOR . 'custom-half.png');
				}

				$msg_success .= __( 'Successfully added!', 'rating-form' );
			}

		} else {
			$msg_error[] = __( 'Error! Rating Form could not be added. Check your filled fields.', 'rating-form' );
		}

		if ( strlen( $msg_success ) > 0) {
			echo '<div class="rf_updated">' . $msg_success . '<br>';
			echo '<strong>Shortcode:</strong> <input onclick="this.select()" type="text" readonly="" value="[rating_form id=&quot;'.$new_rating_id.'&quot;]"> ';
			echo '<a class="button" href="admin.php?page=' . Rating_Form_Setup::PAGE_FORM_RATING_SLUG . '&style=' . $new_rating_id . '">' . __( 'Edit Style', 'rating-form' ) . '</a> ';
			echo '<a class="button" href="admin.php?page=' . Rating_Form_Setup::PAGE_FORM_RATING_SLUG . '&settings=' . $new_rating_id . '">' . __( 'Edit Settings', 'rating-form' ) . '</a>';
			echo '</div>';
		}

		if ( count( $msg_error ) > 0) {
			foreach ($msg_error as $msg_error_txt)
				echo '<div class="rf_error">' . $msg_error_txt . '</div>';
		}
	}

	//Show Add Form page if form type is selected
	if (isset($_POST['type'])) {

	//Type Names
	$type_name = Rating_Form_Setup::form_types($_POST['type'], "name");
	$type_name_one = Rating_Form_Setup::form_types($_POST['type'], "name_one");
	$type_name_two = Rating_Form_Setup::form_types($_POST['type'], "name_two");
	$type_color = Rating_Form_Setup::form_types($_POST['type'], "css_color");
	$type_color_hover = Rating_Form_Setup::form_types($_POST['type'], "css_color_hover");
?>
	<form method="post" action="<?php echo admin_url('admin.php?page=' . Rating_Form_Setup::PAGE_NEW_RATING_SLUG); ?>" enctype="multipart/form-data">
		<input type="hidden" name="type" value="<?php echo $_POST['type']; ?>" />
		<input type="hidden" name="display[spinner][check]" value="enable" />
		<?php if (Rating_Form_Setup::form_types($_POST['type'], 'type') == "tud") { ?>
		<input type="hidden" value="2" name="display[max]" />
		<?php } ?>
		<div class="rf_form_content rf_form_create">
		<?php if (intval($_POST['type']) == 0) { ?>
		<div class="rf_form_layout_left rf_left">
			<div class="clear"></div>
			<div class="rf_form_example">
				<div class="admin_rf_custom">
					<div class="rf-input">
						<span class="rf-title"><strong><?php _e( 'Icon Empty', 'rating-form' ); ?></strong></span>
						<div class="rf_left">
						<input type="file" name="icon_empty" />
						</div>
						<p class="description"><?php _e( 'Upload an empty icon e.g. empty star', 'rating-form' ); ?></p>
					</div>
					<div class="rf-input">
						<span class="rf-title"><strong><?php _e( 'Icon Full (Hover)', 'rating-form' ); ?></strong></span>
						<div class="rf_left">
						<input type="file" name="icon_full" />
						</div>
						<p class="description"><?php _e( 'Upload an full icon e.g. full star', 'rating-form' ); ?></p>
					</div>
					<div class="rf-input">
						<span class="rf-title"><strong><?php _e( 'Icon Half', 'rating-form' ); ?></strong></span>
						<div class="rf_left">
						<input type="file" name="icon_half" />
						</div>
						<p class="description"><?php _e( 'Upload an half icon e.g. half star', 'rating-form' ); ?></p>
					</div>
				</div>
			</div>
			<div class="clear"></div>
		<?php submit_button( __( 'Add', 'rating-form' ), 'primary', 'add' ); ?>
		</div>
		<?php } else { ?>
		<div class="rf_form_layout_left rf_left">
			<h3 class="rf_left"><?php _e( 'Live Example', 'rating-form' ); ?></h3>
			<h3 class="rf_right"><?php echo $type_name; ?></h3>
			<div class="clear"></div>
			<div class="rf_form_example">
			<div class="rf_form_example_inner">
			<?php
				$content = '';
				$hideShow = '';
				// Css Style
				$content .= '<style type="text/css" id="admin_rf_add_new_css">'."\n";
				if (Rating_Form_Setup::form_types(intval($_POST['type']), 'type') == "star") {
					$content .= '#rating_form_add_edit .rating_form li:not(.def) { color: ' . $type_color . '; }'."\n";
					$content .= '#rating_form_add_edit .rating_form li.hover { color: ' . $type_color_hover . '; }'."\n";
				}
				$content .= '</style>'."\n";

				//Rating titles
				$titlesTranslate = Rating_Form_API::getDefaultTitles();

				if (Rating_Form_Setup::form_types($_POST['type'], 'type') == "star") {
					$content .= '<div class="admin_rf_def">'."\r\n";
						$content .= '<ul class="rating_form cursor">'."\r\n";
				} else if (Rating_Form_Setup::form_types($_POST['type'], 'type') == "tud") {
					$content .= '<div class="admin_rf_tud">'."\r\n";
						$content .= '<ul class="rating_form cursor">'."\r\n";
				}

				for ($i = 1; $i <= Rating_Form_Setup::form_types(intval($_POST['type']), 'i'); $i++) {

					if ($i > 5) {
						$hideShow = ' rf_hide';
					}

					if (Rating_Form_Setup::form_types($_POST['type'], 'type') == "star") {

						$content .= '<li id="rate_' . $i . '" class="rf_item ' . (Rating_Form_Setup::form_types($_POST['type'], '', 'int') == '' ? Rating_Form_Setup::form_types($_POST['type'], 'class') : Rating_Form_Setup::form_types($_POST['type'], '', 'int') . $i) . $hideShow . '" title="'.$titlesTranslate[$i-1].'"></li>'."\r\n";

					} else if (Rating_Form_Setup::form_types($_POST['type'], 'type') == "tud") {

						if ($i == 1) {
							$content .= '<li id="rate_1u" class="rf_item ' . Rating_Form_Setup::form_types($_POST['type'], 'class') . ' up_rated" title="'.$titlesTranslate[10].'"></li>'."\r\n";
							$content .= '<li class="def up_rated_txt">+0</li>'."\r\n";
						} else if ($i == 2) {
							$content .= '<li id="rate_1d" class="rf_item ' . Rating_Form_Setup::form_types($_POST['type'], 'class2') . ' down_rated" title="'.$titlesTranslate[11].'"></li>'."\r\n";
							$content .= '<li class="def down_rated_txt">-0</li>'."\r\n";
						}

					}

				}

						$content .= '<li class="def rating_score">0/5</li>'."\r\n";
						$content .= '<li class="def rating_total">0 '. __( 'ratings', 'rating-form' ) .'</li>'."\r\n";
					$content .= '</ul>'."\r\n";
				$content .= '</div>';

				echo $content
			?>
			</div>
			</div>
			<div class="clear"></div>
			<?php submit_button( __( 'Add', 'rating-form' ), 'primary', 'add' ); ?>
		</div>
		<?php } ?>
		<div class="rf_form_layout_right rf_left">
		<?php if (Rating_Form_Setup::form_types(intval($_POST['type']), 'type') == "star" && intval($_POST['type']) != 0) { ?>
			<div class="rf_form_box">
			<h3 class="block">
			<span class="rf_left"><?php _e( 'Style', 'rating-form' ); ?></span>
			<span class="rf_right">
			<select id="form_alignment" name="alignment">
				<option value=""><?php _e( 'Alignment', 'rating-form' ); ?></option>
				<option value="left"><?php _e( 'Left', 'rating-form' ); ?></option>
				<option value="center"><?php _e( 'Center', 'rating-form' ); ?></option>
				<option value="right"><?php _e( 'Right', 'rating-form' ); ?></option>
			</select>
			</span>
			</h3>
			<div class="rf_form_box_inner">
				<table class="rf-table rf_100p">
					<tbody>
						<tr>
							<td>
								<div class="rf-input rf_100p rf_border_box">
									<h3 class="rf-h3-title"><?php echo $type_name; ?></h3>
									<div class="rf_item rf_left rf_clear rf_100p">
										<span class="rf_left rf-title"><strong><?php _e( 'Size', 'rating-form' ); ?></strong></span>
										<span class="rf_right">
											<span class="rf-input-number-decrement">-</span>
											<input id="font_size" class="rf-input-number" type="text" name="font_size" value="32px" min="1" max="">
											<span class="rf-input-number-increment">+</span>
										</span>
									</div>
									<div class="rf_item rf_left rf_clear rf_100p">
										<span class="rf_left rf-title"><strong><?php _e( 'Color', 'rating-form' ); ?></strong></span>
										<div class="rf_right">
										<input id="font_color" type="text" name="font_color" value="<?php echo $type_color; ?>" />
										</div>
										<div class="rf_clear"></div>
										<span class="rf_left rf-title"><strong><?php _e( 'Hover Color', 'rating-form' ); ?></strong></span>
										<div class="rf_right">
										<input id="font_hover_color" type="text" name="font_hover_color" value="<?php echo $type_color_hover; ?>" />
										</div>
									</div>
								</div>
							</td>
							<td>
								<div class="rf-input rf_100p rf_border_box">
									<h3 class="rf-h3-title"><?php _e( 'Text', 'rating-form' ); ?></h3>
									<div class="rf_item rf_left rf_clear rf_100p">
										<span class="rf_left rf-title"><strong><?php _e( 'Font-Size', 'rating-form' ); ?></strong></span>
										<span class="rf_right">
										<span class="rf-input-number-decrement">-</span>
											<input id="font_size_text" class="rf-input-number" type="text" name="font_size_text" value="18px" min="1" max="">
											<span class="rf-input-number-increment">+</span>
										</span>
									</div>
									<div class="rf_item rf_left rf_clear rf_100p">
										<span class="rf_left rf-title"><strong><?php _e( 'Color', 'rating-form' ); ?></strong></span>
										<div class="rf_right">
										<input id="font_color_text" type="text" name="font_color_text" value="#777777" />
										</div>
										<div class="rf_clear"></div>
										<span class="rf_left rf-title"><strong><?php _e( 'Background', 'rating-form' ); ?></strong></span>
										<div class="rf_right">
										<input id="background_def_text" type="text" name="background_def_text" value="#dddddd" />
										</div>
									</div>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
				</div>
			</div>
		<?php } else if (Rating_Form_Setup::form_types(intval($_POST['type']), 'type') == "tud") { ?>
			<div class="rf_form_box">
			<h3 class="block">
			<span class="rf_left"><?php _e( 'Style', 'rating-form' ); ?></span>
			<span class="rf_right">
			<select id="form_alignment" name="alignment">
				<option value=""><?php _e( 'Alignment', 'rating-form' ); ?></option>
				<option value="left"><?php _e( 'Left', 'rating-form' ); ?></option>
				<option value="center"><?php _e( 'Center', 'rating-form' ); ?></option>
				<option value="right"><?php _e( 'Right', 'rating-form' ); ?></option>
			</select>
			</span>
			</h3>
			<div class="rf_form_box_inner">
				<table class="rf-table rf_100p">
					<tbody>
						<tr>
							<td>
								<div class="rf-input rf_100p rf_border_box">
									<h3 class="rf-h3-title"><?php echo $type_name; ?></h3>
									<div class="rf_item rf_left rf_clear rf_100p">
										<span class="rf_left rf-title"><strong><?php _e( 'Size', 'rating-form' ); ?></strong></span>
										<span class="rf_right">
										<span class="rf-input-number-decrement">-</span>
											<input id="font_size" class="rf-input-number" type="text" name="font_size" value="32px" min="1" max="">
											<span class="rf-input-number-increment">+</span>
										</span>
									</div>
								</div>
							</td>
							<td>
								<div class="rf-input rf_100p rf_border_box">
									<h3 class="rf-h3-title"><?php _e( 'Text', 'rating-form' ); ?></h3>
									<div class="rf_item rf_left rf_clear rf_100p">
										<span class="rf_left rf-title"><strong><?php _e( 'Font-Size', 'rating-form' ); ?></strong></span>
										<span class="rf_right">
										<span class="rf-input-number-decrement">-</span>
											<input id="font_size_text" class="rf-input-number" type="text" name="font_size_text" value="18px" min="1" max="">
											<span class="rf-input-number-increment">+</span>
										</span>
									</div>
									<div class="rf_item rf_left rf_clear rf_100p">
										<span class="rf_left rf-title"><strong><?php _e( 'Color', 'rating-form' ); ?></strong></span>
										<div class="rf_right">
										<input id="font_color_text" type="text" name="font_color_text" value="#777777" />
										</div>
										<div class="rf_clear"></div>
										<span class="rf_left rf-title"><strong><?php _e( 'Background', 'rating-form' ); ?></strong></span>
										<div class="rf_right">
										<input id="background_def_text" type="text" name="background_def_text" value="#dddddd" />
										</div>
									</div>
								</div>
							</td>
						</tr>
						<tr>
							<td>
								<div class="rf-input rf_100p rf_border_box">
									<h3 class="rf-h3-title"><?php echo $type_name_one; ?></h3>
									<span class="rf_left rf-title"><strong><?php _e( 'Color', 'rating-form' ); ?></strong></span>
									<span class="rf_right">
									<input id="tu_font_color" type="text" name="tu_font_color" value="#59d600" />
									</span>
									<div class="rf_clear"></div>
									<span class="rf_left rf-title"><strong><?php _e( 'Hover Color', 'rating-form' ); ?></strong></span>
									<span class="rf_right">
									<input id="tu_font_hover_color" type="text" name="tu_font_hover_color" value="#0e8b00" />
									</span>
									<div class="rf_clear"></div>
									<span class="rf_left rf-title"><strong><?php _e( 'Text Color', 'rating-form' ); ?></strong></span>
									<span class="rf_right">
									<input id="tu_font_color_text" type="text" name="tu_font_color_text" value="#0e8b00" />
									</span>
									<div class="rf_clear"></div>
									<span class="rf_left rf-title"><strong><?php _e( 'Text Background', 'rating-form' ); ?></strong></span>
									<span class="rf_right">
									<input id="tu_background_def_text" type="text" name="tu_background_def_text" value="#bdffaf" />
									</span>
								</div>
							</td>
							<td>
								<div class="rf-input rf_100p rf_border_box">
									<h3 class="rf-h3-title"><?php echo $type_name_two; ?></h3>
									<span class="rf_left rf-title"><strong><?php _e( 'Color', 'rating-form' ); ?></strong></span>
									<span class="rf_right">
									<input id="td_font_color" type="text" name="td_font_color" value="#d60000" />
									</span>
									<div class="rf_clear"></div>
									<span class="rf_left rf-title"><strong><?php _e( 'Hover Color', 'rating-form' ); ?></strong></span>
									<span class="rf_right">
									<input id="td_font_hover_color" type="text" name="td_font_hover_color" value="#b80000" />
									</span>
									<div class="rf_clear"></div>
									<span class="rf_left rf-title"><strong><?php _e( 'Text Color', 'rating-form' ); ?></strong></span>
									<span class="rf_right">
									<input id="td_font_color_text" type="text" name="td_font_color_text" value="#b80000" />
									</span>
									<div class="rf_clear"></div>
									<span class="rf_left rf-title"><strong><?php _e( 'Text Background', 'rating-form' ); ?></strong></span>
									<span class="rf_right">
									<input id="td_background_def_text" type="text" name="td_background_def_text" value="#ffb0b0" />
									</span>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			</div>
		<?php } ?>
		<?php if (intval($_POST['type']) == 0) { ?>
		<div class="rf_form_box">
		<?php } else { ?>
		<div class="clear"></div>
		<div class="rf_form_box rf_hidden">
		<?php } ?>
		<h3 class="block"><?php _e( 'Options', 'rating-form' ); ?></h3>
		<div class="rf_form_box_inner">
			<table class="rf-table rf_100p">
				<tbody>
					<tr>
						<td>
							<div class="rf-input">
								<span class="rf-title"><strong><?php _e( 'Name', 'rating-form' ); ?></strong></span>
								<input class="rf_right" type="text" name="form_name" value="" />
								<p class="description"><?php _e( 'Name of Rating Form', 'rating-form' ); ?></p>
							</div>
						</td>
					</tr>
					<?php if (Rating_Form_Setup::form_types($_POST['type'], 'type') == "star") { ?>
					<tr>
						<td>
							<div id="max" class="rf-input">
								<span class="rf-title"><strong><?php _e( 'Max', 'rating-form' ); ?></strong></span>
								<span class="rf-input-inde">
									<span class="rf-input-number-decrement">-</span>
									<input class="rf-input-number" type="text" name="display[max]" value="5" min="1" max="<?php echo Rating_Form_Setup::form_types($_POST['type'], 'i'); ?>">
									<span class="rf-input-number-increment">+</span>
								</span>
								<p class="description"><?php _e( 'Set max shapes', 'rating-form' ); ?></p>
							</div>
						</td>
					</tr>
					<?php } ?>
					<tr>
						<td>
							<div class="rf-input">
								<span class="rf-title"><strong><?php _e( 'Restriction', 'rating-form' ); ?></strong></span>
								<span class="rf-toggle">
								  <input type="checkbox" name="display[]" value="restrict_ip" checked="checked" />
								  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
								</span>
								<p class="description"><?php _e( 'Restrict anonymous users based on User / IP / Cookie validation for voting multiple times', 'rating-form' ); ?></p>
							</div>
						</td>
					</tr>
				</tbody>
			</table>
			</div>
		</div>
		<div class="clear"></div>
		<div class="rf_form_box rf_hidden">
			<h3 class="block"><?php _e( 'Titles', 'rating-form' ); ?></h3>
			<div class="rf_form_box_inner">
				<table id="texts" class="rf-table rf_100p">
					<tbody>
						<tr>
							<td>
								<div class="rf-input">
								<?php
								global $wpdb;
								if (Rating_Form_Setup::form_types($_POST['type'], 'type') == "star") {
									$hideorshow = ' rf_hide';
									$pos_query = $wpdb->get_results( "SELECT position FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_TITLES . " GROUP BY position ORDER BY position ASC", ARRAY_A );
								} else if (Rating_Form_Setup::form_types($_POST['type'], 'type') == "tud") {
									$hideorshow = '';
									$pos_query = $wpdb->get_results( "SELECT position FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_TITLES . " WHERE position IN(1,2) GROUP BY position ORDER BY position ASC", ARRAY_A );
								}
								$i = 0;
								foreach ($pos_query as $pos_row) {
									$i++;
									if (Rating_Form_Setup::form_types($_POST['type'], 'type') == "star") {
										$text_query = $wpdb->get_results( "SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_TITLES . " WHERE position = ". $pos_row['position'] ." ORDER BY title_id ASC", ARRAY_A );
									} else if (Rating_Form_Setup::form_types($_POST['type'], 'type') == "tud") {
										$text_query = $wpdb->get_results( "SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_TITLES . " WHERE position = ". $pos_row['position'] ." ORDER BY title_id DESC", ARRAY_A );
									}
									?>
									<div class="rf_left rf_clear rf_100p text_select<?php echo $i > 5 ? $hideorshow : ''; ?>">
									<span class="rf-title"><strong><?php _e( 'Position', 'rating-form' ); ?> <?php echo $pos_row['position']; ?></strong></span>
									<select class="rf_right rf_50p" name="display[title][]">
									<?php foreach ($text_query as $text_row) { ?>
										<option value="<?php echo $text_row['title_id']; ?>"><?php echo stripslashes($text_row['text']); ?></option>
									<?php } ?>
									</select>
									</div>
									<?php
								}
								?>
								<p class="description"><?php _e( 'Change titles', 'rating-form' ); ?></p>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
		</div>
	</form>
	<?php } else { ?>
	<form method="post" action="<?php echo admin_url('admin.php?page=' . Rating_Form_Setup::PAGE_NEW_RATING_SLUG); ?>">
		<div id="rating_form_type_select">
			<h3><?php _e( 'Choose form', 'rating-form' ); ?></h3>
			<div class="rf_choose_inside">
				<div class="rf_form_type_list">
					<ul>
						<?php
							$iType = 0;
							for ($i = 0; $i <= Rating_Form_Setup::$totalFormTypes; $i++) {
								if (Rating_Form_Setup::form_types($i, "type") == "star") {
									// Rating Form Type
									echo '<li>';
									echo '<label>';
									echo '<input id="type" type="radio" name="type" value="'. $i . '">';
									echo '<span class="' . Rating_Form_Setup::form_types($i, "class") . '">' . ($i == 0 ? '?' : '') . '</span>';
									echo Rating_Form_Setup::form_types($i, "name");
									echo '</label>';
									echo '</li>';
									$iType++;
									if ($iType % 5 == 0) {
										echo '</ul>';
										echo '<ul>';
									}
								}
							}
						?>
					</ul>
				</div>
				<div class="rf_form_type_list">
					<ul>
						<?php
							$iType = 0;
							for ($i = 0; $i <= Rating_Form_Setup::$totalFormTypes; $i++) {
								if (Rating_Form_Setup::form_types($i, "type") == "tud") {
									// Rating Form Type
									echo '<li>';
									echo '<label>';
									echo '<input type="radio" name="type" value="'. $i . '">';
									echo '<span class="' . Rating_Form_Setup::form_types($i, "class") . '">' . ($i == 0 ? '?' : '') . '</span>';
									echo Rating_Form_Setup::form_types($i, "name");
									echo '</label>';
									echo '</li>';
									$iType++;
									if ($iType % 5 == 0) {
										echo '</ul>';
										echo '<ul>';
									}
								}
							}
						?>
					</ul>
				</div>
				<div class="clear"></div>
				<p class="description"><?php _e( 'Choose a form to start', 'rating-form' ); ?></p>
				<?php submit_button( __( 'Create', 'rating-form' ), 'primary', 'create' ); ?>
			</div>
		</div>
	</form>
	<?php } ?>
	</div>
<?php } ?>
