<?php
/**
 * Rating Form - Display a list of user votes
 *
 * Shortcode [rating_form_recent_ratings]
 * Options
 * 	limit = set number of votes
 * 	time_amount = set amount of time based on time period
 * 	time_period = choose from: sec, hour, day, week, month, year
 * 	sort = sort votes by new or old ratings, highest or lowest ratings (multiple sorting possible)
 * 		use = old,new,high,down
 * 	class = add any CSS classes
 * 	text = change default text output, available values = %username%, %rating%, %post_link%, %post_title%
 * 	anonymous_name = change text 'Anonymous' for anonymous users
 * 	tu_name = change text 'Thumbs Up'
 * 	td_name = change text 'Thumbs Down'
 * @param  array $atts array of shortcode attributes
 * @return html       Output list of user ratings
 */
function rf_user_ratings( $atts ) {
	global $wpdb;
	$html = '';
	
	// Attributes
	$args = shortcode_atts(
		array(
			'anonymous_name' => '',
			'tu_name' => '',
			'td_name' => '',
			'limit' => '5',
            'time_amount' => '',
            'time_period' => '',
			'text' => '',
			'class' => '',
			'sort' => ''
		), $atts );

	$arg_class = empty($args['class']) ? '' : 'class="' . $args['class'] . '"';
	$arg_anonymous_name = empty($args['anonymous_name']) ? __('Anonymous', 'rating-form') : __($args['anonymous_name'], 'rating-form');
	$tu_name = empty($args['tu_name']) ? __('Thumbs Up', 'rating-form') : __($args['tu_name'], 'rating-form');
	$td_name = empty($args['td_name']) ? __('Thumbs Down', 'rating-form') : __($args['td_name'], 'rating-form');
    $arg_limit = empty($args['limit']) ? 5 : intval($args['limit']);
	$arg_time_amount = empty($args['time_amount']) ? 0 : intval($args['time_amount']);
	$arg_time_period = empty($args['time_period']) ? '' : strtoupper( strval($args['time_period']) );
	$arg_text = empty($args['text']) ? __('%username% just gave %rating# ratings#% on <a href=\'%post_link%\'>%post_title%</a>', 'rating-form') : __($args['text'], 'rating-form');

	$splitSort = empty($args['sort']) ? array() : explode(',', $args['sort']); // split post types to array
	$arg_sort = count( $splitSort ) == 0 ? array() : $splitSort;

	// Sort by: old,new,high,down
	$sort_sql = 'date DESC';
	$sort_sql_field = array();
	if (!empty($arg_sort)) {
		if (in_array("old", $arg_sort)) {
			$sort_sql_field[] = 'date ASC';
		} else if (in_array("new", $arg_sort)) {
			$sort_sql_field[] = 'date DESC';
		}

		if (in_array("low", $arg_sort)) {
			$sort_sql_field[] = 'rated ASC';
		} else if (in_array("high", $arg_sort)) {
			$sort_sql_field[] = 'rated DESC';
		}
		$sort_sql = implode(", ", $sort_sql_field);
	}
    // Time field check
    $time_period_sql = '';
    $time_periods = array('SEC', 'HOUR', 'DAY', 'WEEK', 'MONTH', 'YEAR');
    if ( in_array( $arg_time_period, $time_periods ) ) {
        $time_period_sql = $arg_time_period;
    }

    $sql = "SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG;
    if ($time_period_sql != '') $sql .= " WHERE date >= DATE_SUB(NOW(), INTERVAL " . $arg_time_amount . " " . $time_period_sql . ")";
    $sql .= " ORDER BY " . $sort_sql;
    $sql .= " LIMIT " . $arg_limit;
	$results = $wpdb->get_results( $sql, ARRAY_A );

	$html .= '<ul' . $arg_class . '>';
	foreach ($results as $row) {
		$user_info = get_userdata( intval($row['user']) );
		$username = empty($row['user']) && !$user_info ? $arg_anonymous_name : $user_info->display_name;
		$rating = $row['rated'];

		$text = $arg_text;
		$text = str_replace('%username%', $username, $text);
		$text = str_replace('%post_link%', get_permalink( $row['post_id'] ), $text);
		$text = str_replace('%post_title%', get_the_title( $row['post_id'] ), $text);
        preg_match('/(%rating%|%#?(.*)[#%]?rating#(.*)#%)/', $text, $rating_matches);
		$rating = ($rating == '1u') ? $tu_name : ( ($rating == '1d') ? $td_name : $rating_matches[2] . floatval( $rating ) .  $rating_matches[3] );
		$text = str_replace($rating_matches[1], $rating, $text);

		$html .= '<li>' . $text . '</li>';
	}
	$html .= '</ul>';

	return $html;
}
add_shortcode('rating_form_user_ratings', 'rf_user_ratings');
?>
