<?php
// Display total average ratings
function wrap_rating_form_total( $atts, $ajax ) {

	$args = array();
	$content = '';

	global $post;
	global $wpdb;

	// Attributes
	$args = shortcode_atts(
		array(
			'id' => '0',
			'post_id' => '',
			'comment_id' => '',
			'custom_id' => '0',
			'user_id' => '',
			'term_id' => '',
			'round' => '1',
			'live' => 'true',
			'type' => 'star',
			'type_count' => 'count',
			'text' => '',
			'form' => 'false',
			'class' => '',
			'html' => 'true',
			'custom_id_group' => '0',
			'before_content' => '',
			'after_content' => '',
			'score' => 'true',
			'total' => 'true'
		), $atts );

	$args['id'] = intval($args['id']);
	$args['post_id'] = intval($args['post_id']);
	$args['comment_id'] = empty($args['comment_id']) ? 0 : intval($args['comment_id']);
	$args['custom_id'] = Rating_Form_API::convertFieldIDArray($args['custom_id']);
	$args['user_id'] = empty($args['user_id']) ? 0 : intval($args['user_id']);
	$args['term_id'] = empty($args['term_id']) ? 0 : intval($args['term_id']);
	$args['round'] = intval($args['round']);
	$args['live'] = $args['live'] == 'true' ? true : false;
	$args['form'] = $args['form'] == 'true' ? true : false;
	$args['class'] = empty($args['class']) ? '' : 'class="' . $args['class'] . '"';
	$args['custom_id_group'] = empty($args['custom_id_group']) ? '0' : strtolower($args['custom_id_group']);

	if (empty($args['post_id'])) {
		if (isset($post)) {
			$args['post_id'] = $post->ID;
		}
	}

	if ( is_admin() && ( !defined( 'DOING_AJAX' ) || !DOING_AJAX ) ) {
		$args['post_id'] = 1;
	}

	// Get current comment ID
	if (have_comments() && in_the_loop() && empty($args['comment_id'])) {
		$args['comment_id'] = get_comment_ID();
	}

	// Rating Form Settings
	$sql = "SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM . " WHERE form_id = %d";
	$this_form_query = $wpdb->get_row( $wpdb->prepare( $sql, $args['id'] ), ARRAY_A );
	$this_form_num = $wpdb->num_rows;
	// Default settings if args ID is empty
	$options = empty($this_form_query['display']) ? array() : Rating_Form_API::getOptions($this_form_query['display']);
	$args['type'] = $this_form_num > 0 ? Rating_Form_Setup::form_types($this_form_query['type'], 'type') : $args['type'];

	// Total average rating
	// Check if post id exist in WP
	if (!(get_post( $args['post_id'] ) != null) && !is_admin() && (empty($args['term_id']) || empty($args['user_id']))) {

		if (empty($args['post_id'])) {
			$content .= __( 'Post ID is empty', 'rating-form' );
		} else {
			$content .= sprintf( __( 'Post ID %d not found', 'rating-form' ), $args['post_id'] );
		}

	} else {

		// Rating Form Total #ID
		$divRFid = 'RFTO' . Rating_Form_API::getDivID($args);

		//begin ajax
		if ($ajax == false) $content .= '<div data-rf-id="'.$divRFid.'"' . $args['class'] . '>'."\r\n";

		if ($args['live']) {
			$ajaxArgs = $args;
			$ajaxArgs['custom_id'] = is_array($args['custom_id']) ? implode(",", $args['custom_id']) : (string) $args['custom_id'];
			$content .= '<script type="text/javascript">'."\r\n";
			$content .= 'function ' . $divRFid . '(){'."\r\n";
				$content .= 'jQuery.ajax({'."\r\n";
					$content .= 'type: "POST",'."\r\n";
					$content .= 'url : rating_form_script.ajaxurl,'."\r\n";
					$content .= 'data : { '."\r\n";
					$content .= 'action : "display_rating_form_total_ajax", '."\r\n";
					$content .= 'args : ' . json_encode($args) . "\r\n";
					$content .= '}, '."\r\n";
					$content .= 'success : function(data) { jQuery("body").find("[data-rf-id=' . $divRFid . ']").html(data) }'."\r\n";
				$content .= '});'."\r\n";
			$content .= '}'."\r\n";
			$content .= '</script>'."\r\n";
		}

		$content .= '<span>';

		// Get ratings
		$ratingData = Rating_Form_API::getData($args, $this_form_query, $options);
		$iconPoss = Rating_Form_API::getRatingPositions($ratingData['average']);
		$ratingData['icon_count'] = $iconPoss['icon_count'];
		$ratingData['icon_half'] = $iconPoss['icon_count'] == $iconPoss['icon_half'] ? 0 : $iconPoss['icon_half'];
		if ($args['form']) {
			// Attributes
			$newRFatts = array (
				'result' => true,
				'tooltip' => false,
			);
			$newRFatts = array_merge( $newRFatts, $args );
			$newRFatts['custom_id'] = is_array($args['custom_id']) ? implode("", $args['custom_id']) : (string) $args['custom_id'];
			// Rating Form
			$rf = new Rating_Form( $newRFatts );
			if ($args['type'] == 'tud') {
				$rf->setUpCount(intval($ratingData['up_count']));
				$rf->setDownCount(intval($ratingData['down_count']));
			} else if ($args['type'] == 'star') {
				$rf->setAverage($ratingData['average']);
		        $rf->setRatingPosition($ratingData['icon_count']);
		        $rf->setRatingHalfPosition($ratingData['icon_half']);
			}
			$rf->setCount($ratingData['count']);
			$rf->wrapper(
				$rf->container(
					$rf->items(),
		            $rf->getItemAverage(),
		            $rf->getItemCount()
				)
			);
			$content .= $rf->show();
		} else {
			// Type Count / Percentage
			if (empty($args['text'])) {
				if (trim($args['type']) == 'tud') {
					$textData = __( 'Up: %1$s Down: %3$s based on %2$s ratings', 'rating-form' );
				} else {
					$textData = __( '%1$s average based on %2$s ratings', 'rating-form' );
				}
			}
			$countRating = ($args['type_count'] == 'percentage') ? $ratingData['count_percent'] : $ratingData['count'];
			$firstData = (trim($args['type']) == 'tud') ? $ratingData['up_count'] : $ratingData['average'] ;
			$args['text'] = sprintf( htmlentities($textData), $firstData, $countRating, $ratingData['down_count'] );
			$content .= html_entity_decode(trim($args['text']));
		}

		$content .= '</span>'."\r\n";

		// end ajax
		if ($ajax == false) $content .= '</div>'."\r\n";
	}
	return $content;
}
// Display total average ratings
function display_rating_form_total( $atts ) {
	// Total average rating
	return wrap_rating_form_total( $atts, false );
}
add_shortcode( 'rating_form_total', 'display_rating_form_total' );
?>
