<?php
function rating_form_review() {
?>
<div class="wrap rf_wrap<?php echo Rating_Form_Setup::getAdminRTLclass(); ?>"<?php echo Rating_Form_Setup::getAdminRTL(); ?>>
	<?php
	global $wpdb;
	Rating_Form_Setup::admin_menus();

	$option_settings = get_option(Rating_Form_Setup::PAGE_REVIEW_SLUG);
	$option_settings = (empty($option_settings) ? array() : $option_settings);
	$settings = isset($_POST['tools']) ? $_POST['tools'] : $option_settings;
	if (isset($_POST['submit'])) {
		// Switch to Review mode if it isn't
		$reviewSettings = $_POST['tools'];
		$form_id = (empty($reviewSettings['comment_review']['rating_form']) ? 0 : intval($reviewSettings['comment_review']['rating_form']));
		if ($form_id != 0) {
			$sql       = "SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM . " WHERE form_id = %d;";
			$query     = $wpdb->get_row( $wpdb->prepare($sql, $form_id), ARRAY_A );
			$options = empty($query['display']) ? array() : json_decode($query['display'], true);

			if (!in_array("review", $options, true)) {
				$options[] = 'review';
				// Edit settings
				$wpdb->update( $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM, array(
						'display' => json_encode($options)
				), array('form_id' => $form_id ) );
			}
		}

		update_option(Rating_Form_Setup::PAGE_REVIEW_SLUG, $reviewSettings);
		echo '<div class="rf_updated">'. __( 'Successfully saved.', 'rating-form' ) .'</div>';
	}
	$forms_query = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM . ' ORDER BY date DESC', ARRAY_A);
	$forms_query_num_rows = $wpdb->num_rows;
?>
	<form id="rating_form_review" method="post" enctype="multipart/form-data">
		<div class="rf_content rf_100p">
			<div class="rf_content_inner rf_nav_review">
				<h3 class="rf_content_title"><?php _e( 'Comment', 'rating-form' ); ?> <?php _e( 'Review', 'rating-form' ); ?></h3>
				<table class="form-table">
					<tbody>
						<tr>
							<th scope="row"><label for="tools[comment_review][enable]"><?php _e( 'Enable', 'rating-form' ); ?></label></th>
							<td class="rf-input-small">
								<span class="rf-toggle">
								  <?php $enableCheck = (!empty($settings['comment_review']['enable']) && ($settings['comment_review']['enable'] == '1')); ?>
								  <input type="checkbox" name="tools[comment_review][enable]" value="1" <?php checked($enableCheck, true); ?> />
								  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
								</span>
							</td>
						</tr>
						<tr>
							<th scope="row"><label for="tools[comment_review][label]"><?php _e( 'Label', 'rating-form' ); ?></label></th>
							<td><input type="text" name="tools[comment_review][label]" value="<?php echo empty($settings['comment_review']['label']) ? __( 'Rating', 'rating-form' ) : $settings['comment_review']['label']; ?>" placeholder="<?php _e( 'Rating', 'rating-form' ); ?>" /></td>
						</tr>
						<tr>
							<th scope="row"><label for="tools[comment_review][rating_form]">Rating Form</label></th>
							<td>
							<?php
								if ($forms_query_num_rows > 0) {
								?>
								<select class="slt_rating_form" name="tools[comment_review][rating_form]">
									<?php
									$form_id = (empty($settings['comment_review']['rating_form']) ? 0 : intval($settings['comment_review']['rating_form']));
									foreach($forms_query as $form_row) {
									?>
									<option <?php selected( $form_id, $form_row['form_id'] ); ?> value="<?php echo $form_row['form_id']; ?>">Rating Form <?php echo $form_row['form_id']; ?></option>
									<?php
									}
									?>
									<option <?php selected( $form_id, 0 ); ?> value="0"><?php _e( 'Custom', 'rating-form' ); ?></option>
								</select>
								<?php
								} else {
									_e( 'No Rating Form found. Create one.', 'rating-form' );
								}
							?>
							<br/>
							<textarea <?php echo ($form_id === 0 ? '' : 'disabled="disabled" style="display:none;" '); ?>name="tools[comment_review][rating_form]" rows="5" cols="50" placeholder="<?php _e( 'Rating Form Shortcode', 'rating-form'); ?>"><?php echo empty($settings['comment_review']['rating_form']) ? '' : htmlentities(stripslashes($settings['comment_review']['rating_form'])); ?></textarea>
							<p class="description"><?php _e( 'Use settings of a Rating Form.', 'rating-form' ); ?></p>
							</td>
						</tr>
						<tr>
							<th scope="row"><label for="tools[comment_review][display_rating_form]"><?php _e( 'Replies', 'rating-form' ); ?></label></th>
							<td class="rf-input-small use_same_rf">
								<span class="rf-toggle" style="float: none;">
								  <?php $displayRFCheck = (empty($settings['comment_review']['enable_same_rf']) ? true : $settings['comment_review']['enable_same_rf']) == '1' ? true : false; ?>
								  <input type="checkbox" name="tools[comment_review][enable_same_rf]" value="1" <?php checked($displayRFCheck, true); ?> />
								  <label data-on="<?php _e( 'Yes', 'rating-form' ); ?>" data-off="<?php _e( 'No', 'rating-form' ); ?>"></label>
								</span>
								<div class="display_review_rf<?php echo ($displayRFCheck ? ' rf_hide' : ''); ?>">
								<?php
									if ($forms_query_num_rows > 0) {
									?>
									<select class="slt_rating_form" name="tools[comment_review][display_rating_form]">
										<?php
										$display_form_id = (empty($settings['comment_review']['display_rating_form']) ? '' : intval($settings['comment_review']['display_rating_form']));
										foreach($forms_query as $form_row) {
										?>
										<option <?php selected( $display_form_id, $form_row['form_id'] ); ?> value="<?php echo $form_row['form_id']; ?>">Rating Form <?php echo $form_row['form_id']; ?></option>
										<?php
										}
										?>
										<option <?php selected( $display_form_id, 0 ); ?> value="0"><?php _e( 'Custom', 'rating-form' ); ?></option>
									</select>
									<?php
									} else {
										_e( 'No Rating Form found. Create one.', 'rating-form' );
									}
								?>
									<br/>
									<textarea <?php echo (!$displayRFCheck && $display_form_id === 0 ? '' : 'disabled="disabled" style="display:none;" '); ?>name="tools[comment_review][display_rating_form]" rows="5" cols="50" placeholder="<?php _e( 'Rating Form Shortcode', 'rating-form'); ?>"><?php echo empty($settings['comment_review']['display_rating_form']) ? '' : htmlentities(stripslashes($settings['comment_review']['display_rating_form'])); ?></textarea>
								</div>
								<p class="description"><?php _e( 'Use same Rating Form as above?', 'rating-form' ); ?></p>
							</td>
						</tr>
						<tr>
							<th scope="row"><label for="tools[comment_review][required]"><?php _e( 'Required', 'rating-form' ); ?></label></th>
							<td class="rf-input-small">
								<span class="rf-toggle">
								  <?php $reqCheck = (empty($settings['comment_review']['required']) ? '' : $settings['comment_review']['required']) == '1' ? true : false; ?>
								  <input type="checkbox" name="tools[comment_review][required]" value="1" <?php checked($reqCheck, true); ?> />
								  <label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
								</span>
							</td>
						</tr>
						<tr>
							<th scope="row"><label for="tools[comment_review][placement]"><?php _e( 'Placement', 'rating-form' ); ?></label></th>
							<td>
							<?php $comReviewPlacement = (empty($settings['comment_review']['placement']) ? 'after_fields' : $settings['comment_review']['placement']); ?>
								<select name="tools[comment_review][placement]">
									<option <?php selected( $comReviewPlacement, 'before_fields' ); ?> value="before_fields"><?php _e( 'Before Fields', 'rating-form' ); ?></option>
									<option <?php selected( $comReviewPlacement, 'after_fields' ); ?> value="after_fields"><?php _e( 'After Fields', 'rating-form' ); ?></option>
								</select>
							</td>
						</tr>
					</tbody>
				</table>
				<?php submit_button( __( 'Save', 'rating-form' ), 'primary' ); ?>
			</div>
		</div>
	</form>
</div>
<?php
}
?>
