<?php

// Filter Rating Results table
function show_rf_stats() {
	if (isset($_POST['form_id'])) {
        global $wpdb;
        $content        = '';
        $review_rating  = '';

		preg_match("/RF(\d*)/", $_POST['form_id'], $form_id_array);
		$form_id = empty($form_id_array[1]) ? 0 : $form_id_array[1];
		preg_match("/P(\d*)/", $_POST['form_id'], $post_id_array);
		$post_id = empty($post_id_array[1]) ? 0 : $post_id_array[1];
		preg_match("/\dCO(\d*)/", $_POST['form_id'], $comment_id_array);
		$comment_id = empty($comment_id_array[1]) ? 0 : $comment_id_array[1];
		preg_match("/\dCU(.*)/", $_POST['form_id'], $custom_id_array);
		$custom_id = empty($custom_id_array[1]) ? 0 : $custom_id_array[1];
		preg_match("/\dU(\d*)/", $_POST['form_id'], $user_id_array);
		$user_id = empty($user_id_array[1]) ? 0 : $user_id_array[1]; // current user voted on someone else
		preg_match("/T(\d*)/", $_POST['form_id'], $term_id_array);
		$term_id = empty($term_id_array[1]) ? 0 : $term_id_array[1];

        // Get form settings
        $this_form_query = $wpdb->get_row( "SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM . " WHERE form_id = '".$form_id."'", ARRAY_A );
        // Form options
        $jsonDisplay = empty($this_form_query['display']) ? array() : json_decode($this_form_query['display'], true);
        $display_up = in_array("up", $jsonDisplay) ? true : false;
        $display_down = in_array("down", $jsonDisplay) ? true : false;
    	$display_up_minus_down_total = in_array("up_down_total", $jsonDisplay) ? true : false;
		$fake_ratings = in_array("fake_ratings", $jsonDisplay) ? true : false;
    	// Get titles array
    	$titlesText = Rating_Form_API::getTitles($this_form_query['form_id']);
        // Vars
        $args = array();
        $args['post_id']    = $post_id;
        $args['comment_id'] = $comment_id;
        $args['custom_id']  = $custom_id;
        $args['user_id']    = $user_id;
        $args['term_id']    = $term_id;
        $args['stats']      = $_POST['stats'] == 'true' ? true : false;
        $args['user_stats'] = $_POST['user_stats'] == 'true' ? true : false;
        $args['rates']      = trim($_POST['rates']);
        $totalRating        = intval($_POST['count']);
        $isStateReview      = $_POST['state'] == 'review' ? true : false;

    	// Options Enabled
    	$max = empty($jsonDisplay['max']) ? 5 : intval($jsonDisplay['max']);
    	$round = empty($jsonDisplay['round']) ? 1 : intval($jsonDisplay['round']);

    	// Args to SQL
    	$comment_id_sql = "comment_id = " . $args['comment_id'] .
    					" AND custom_id = '" . $args['custom_id'] .
    					"' AND user_id = " . $args['user_id'] .
    					" AND term_id = " . $args['term_id'] . " AND ";

    	// Rating Form review
    	if ($isStateReview) {
    		$review_rating = 'r';
    	}

		// Args used?
		$argsUsed = false;
		if (!empty($args['comment_id']) || !empty($args['custom_id']) || !empty($args['user_id']) || !empty($args['term_id'])) {
			$argsUsed = true;
		}

		// Thumbs up rated
		$thumbsUpq = $wpdb->get_var( $wpdb->prepare( " SELECT COUNT(rated) FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . " WHERE rated = '" . $review_rating . "1u' AND ".$comment_id_sql."post_id = %s", $args['post_id'] ) );
		$thumbsUp_num_rows = $wpdb->num_rows;
		$thumbsUp = $thumbsUp_num_rows == 0 ? 0 : $thumbsUpq;
		$rf_real_up = $thumbsUp;

		// Thumbs down rated
		$thumbsDownq = $wpdb->get_var( $wpdb->prepare( " SELECT COUNT(rated) FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . " WHERE rated = '" . $review_rating . "1d' AND ".$comment_id_sql."post_id = %s", $args['post_id'] ) );
		$thumbsDown_num_rows = $wpdb->num_rows;
		$thumbsDown = $thumbsDown_num_rows == 0 ? 0 : $thumbsDownq;
		$rf_real_down = $thumbsDown;

		// Fake ratings
		if ($fake_ratings && !$argsUsed) {
			// Post Meta
			$pmeta_fake_up = get_post_meta($args['post_id'], 'rf_fake_up', true);
			if (empty($pmeta_fake_up)) $pmeta_fake_up = 0;
			$pmeta_fake_down = get_post_meta($args['post_id'], 'rf_fake_down', true);
			if (empty($pmeta_fake_down)) $pmeta_fake_down = 0;

			// TUD
			$thumbsUp = $pmeta_fake_up;
			$thumbsDown = $pmeta_fake_down;
		}

		// Thumbs Up and Down = Total votes
		$tudTotal = ($thumbsUp + $thumbsDown);

        // Stats or User Stats
        if ($args['stats'] == true || $args['user_stats'] == true) {
        	$content .= '<div class="rating_stats">'."\r\n";

        	// Statics
        	if ($args['stats'] == true) {
				$content .= '<div class="rf_stats_header">' . $args['rates'] . '<span class="rf_stats_close">X</span></div>'."\r\n";
        		$content .= '<table>'."\r\n";
        		$content .= '<thead>'."\r\n";
        			$content .= '<tr>'."\r\n";
        		for ($i = 1; $i <= $max; $i++) {
        			if (Rating_Form_Setup::form_types($this_form_query['type'], 'type') == "tud") {
        				if ($display_up == true && $display_down == true || $display_up == false && $display_down == false) {
        					$content .= '<th>'.$titlesText[$i].'</th>'."\r\n";
        				} else if ($display_up == true) {
        					if ($i == 1) {
        						$content .= '<th>'.$titlesText[$i].'</th>'."\r\n";
        					}
        				} else if ($display_down == true) {
        					if ($i == 2) {
        						$content .= '<th>'.$titlesText[$i].'</th>'."\r\n";
        					}
        				}
        			} else if (Rating_Form_Setup::form_types($this_form_query['type'], 'type') == "star") {
        				$content .= '<th>'.$titlesText[$i].'</th>'."\r\n";
        			}
        		}
        			$content .= '</tr>'."\r\n";
        		$content .= '</thead>'."\r\n";
        		$content .= '<tbody>'."\r\n";
        			$content .= '<tr>'."\r\n";
        		for ($i = 1; $i <= $max; $i++) {
        			if (Rating_Form_Setup::form_types($this_form_query['type'], 'type') == "star") {
        				$stats_i = $wpdb->get_var( $wpdb->prepare( " SELECT COUNT(rated) FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . " WHERE rated = '" . $review_rating . $i ."' AND ".$comment_id_sql."post_id = %s", $args['post_id'] ) );
        			} else if (Rating_Form_Setup::form_types($this_form_query['type'], 'type') == "tud") {
        				if ($i == 1) {
        					$stats_i = $thumbsUp;
        				} else if ($i == 2) {
        					$stats_i = $thumbsDown;
        				}
        			}

    				if (Rating_Form_Setup::form_types($this_form_query['type'], 'type') == "tud") {
    					if ($display_up == true && $display_down == true || $display_up == false && $display_down == false) {
    						$content .= '<td>'. round(($stats_i == 0 ? 0 : ($stats_i/$tudTotal)*100), 1) .'%</td>'."\r\n";
    					} else if ($display_up == true) {
    						if ($i == 1) {
    							$content .= '<td>'. round(($stats_i == 0 ? 0 : ($stats_i/$tudTotal)*100), 1) .'%</td>'."\r\n";
    						}
    					} else if ($display_down == true) {
    						if ($i == 2) {
    							$content .= '<td>'. round(($stats_i == 0 ? 0 : ($stats_i/$tudTotal)*100), 1) .'%</td>'."\r\n";
    						}
    					}
    				} else if (Rating_Form_Setup::form_types($this_form_query['type'], 'type') == "star") {
    					$content .= '<td>'. round((($stats_i == 0 || $totalRating == 0) ? 0 : ($stats_i/$totalRating)*100), 1) .'%</td>'."\r\n";
    				}
        		}
        		$content .= '</tr>'."\r\n";
        		$content .= '</tbody>'."\r\n";
        		$content .= '</table>'."\r\n";
        	}

        	// User Stats
        	$ustats_login = (count($jsonDisplay) > 0 ? (in_array("login_required", (empty($jsonDisplay['ustats']) ? array() : $jsonDisplay['ustats'])) ? is_user_logged_in() : true) : true);
        	if (($args['user_stats'] || $ustatsCheck) && $ustats_login) {
        		$users_voted = $wpdb->get_results( "SELECT * FROM (SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . " ORDER BY date DESC) as userLatest WHERE " . ($isStateReview ? "rated LIKE '" . $review_rating . "%' AND " : "") . $comment_id_sql."post_id = '".$args['post_id']."' AND user <> 0 GROUP BY user", ARRAY_A );
        		//$users_voted = $wpdb->get_results( "SELECT * FROM " . $wpdb->users . " GROUP BY ID ORDER BY user_registered DESC", ARRAY_A );
        		// UserStats Row
        		$ustats_row = empty($jsonDisplay['ustats']['row_size']) ? 2 : intval($jsonDisplay['ustats']['row_size']);
        		// UserStats Per Row
        		$ustats_per_row = empty($jsonDisplay['ustats']['per_row']) ? 4 : intval($jsonDisplay['ustats']['per_row']);
        		// UserStats Avatar Size
        		$ustats_av_size = empty($jsonDisplay['ustats']['av_size']) ? 48 : intval($jsonDisplay['ustats']['av_size']);
        		$ustats_av_remove = in_array("av_remove", (empty($jsonDisplay['ustats']) ? array() : $jsonDisplay['ustats'])) ? true : false;
        		$user_stats_show_rating = in_array("rating_show", (empty($jsonDisplay['ustats']) ? array() : $jsonDisplay['ustats'])) ? true : false;

        		$user_stats_row = (count($users_voted) <= $ustats_per_row ? 1 : $ustats_row);
        		$user_stats_per_row = (count($users_voted) == 1 ? 1 : $ustats_per_row);
        		$user_stats_scroll_height = ((!get_option('show_avatars') || $ustats_av_remove) ? ($user_stats_row*34)+1 : ($user_stats_row*(43+$ustats_av_size))+1);

        		$content .= '<div class="rf_user_stats">'."\r\n";
        		$content .= '<div class="rf_user_stats_header">' . sprintf ( __( '%s users has voted', 'rating-form' ), count($users_voted) ) . ($args['stats'] == false ? '<span class="rf_stats_close">x</span>' : '') .'</div>'."\r\n";
        		$content .= '<div style="overflow:auto; clear:both; height:'.$user_stats_scroll_height.'px;">'."\r\n";
        		$content .= '<table>'."\r\n";
        		$content .= '<tbody>'."\r\n";
        		foreach (array_chunk($users_voted, $user_stats_per_row) as $row_set) {
        			$content .= '<tr>'."\r\n";
        			foreach ($row_set as $row_user) {
        				$row_user_rating = 0;
        				switch( $row_user['rated'] ) {
        					case '1u':
        						$row_user_rating = '+1';
        						break;
        					case '1d':
        						$row_user_rating = '-1';
        						break;
        					default:
        						$row_user_rating = $row_user['rated'];
        				}
        				$content .= '<td>' . ((!get_option('show_avatars') || $ustats_av_remove) ? '' : get_avatar( $row_user['user'], $ustats_av_size ) . '<br>') . '<span class="user_stats_name'.($user_stats_per_row == 1 && (!get_option('show_avatars') || $ustats_av_remove) ? ' name_left' : '').'">' . get_the_author_meta('user_login', $row_user['user']) . ($user_stats_show_rating ? ' <span class="user_stats_rating">(' . $row_user_rating . ')</span>' : '') . '</span></td>'."\r\n";
        			}
        			$content .= '</tr>'."\r\n";
        		}
        		$content .= '</tbody>'."\r\n";
        		$content .= '</table>'."\r\n";
        		$content .= '</div>'."\r\n";
        		$content .= '</div>'."\r\n";

        	}
        	$content .= '</div>'."\r\n";

        }
        echo $content;
    }
    die();
}
?>
