<?php
function rating_form_settings() {
	$max_restriction_hours = 24;
?>
<div class="wrap rf_wrap<?php echo Rating_Form_Setup::getAdminRTLclass(); ?>"<?php echo Rating_Form_Setup::getAdminRTL(); ?>>
	<?php
	Rating_Form_Setup::admin_menus();

	$option_settings = get_option(Rating_Form_Setup::PAGE_SETTINGS_SLUG);
	$option_settings = (empty($option_settings) ? array() : $option_settings);
	$settings = isset($_POST['settings']) ? $_POST['settings'] : $option_settings;
	if (isset($_POST['submit'])) {
		if (empty($_POST['settings']['ip_restrict_time'])) unset($_POST['settings']['ip_restrict_time']);
		if (empty($_POST['settings']['cookie_restrict_time'])) unset($_POST['settings']['cookie_restrict_time']);
		if (isset($_POST['settings[approval_ratings]'])) $_POST['settings[approval_ratings]'] = $option_settings['approval_ratings'];

		update_option(Rating_Form_Setup::PAGE_SETTINGS_SLUG, $_POST['settings']);
		echo '<div class="rf_updated">'. __( 'Successfully saved.', 'rating-form' ) .'</div>';
	}
?>
	<form id="rating_form_settings" method="post" enctype="multipart/form-data">
		<div class="rf_content">
			<div class="rf_content_inner rf_nav_settings">
				<h3 class="rf_content_title"><?php _e( 'Settings', 'rating-form' ); ?></h3>
				<table class="form-table">
					<tbody>
					<tr>
						<th scope="row"><label for="settings[]"><?php _e( 'Save IP Address', 'rating-form' ); ?></label></th>
						<td>
							<span class="rf-toggle rf_left">
								<input type="checkbox" name="settings[]" value="save_ip" <?php checked(in_array('save_ip', $settings), true); ?> />
								<label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
							</span>
							<div class="rf_clear"></div>
							<p class="description">
								<?php _e( 'Please note: in order to comply with the <a target="_blank" href="https://en.wikipedia.org/wiki/General_Data_Protection_Regulation">GDPR EU law</a>, you must warn your users that you are saving their IP address.', 'rating-form' ); ?>
							</p>
						</td>
					</tr>
					<tr>
						<th scope="row"><label for="settings[]"><?php _e( 'Anonymize IP Address', 'rating-form' ); ?></label></th>
						<td>
							<span class="rf-toggle rf_left">
								<input type="checkbox" name="settings[]" value="anonymize_ip" <?php checked(in_array('anonymize_ip', $settings), true); ?> />
								<label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
							</span>
							<div class="rf_clear"></div>
							<p class="description">
								<?php _e( 'It will anonymize IP addresses (IPv4 and IPv6) by replacing the last octet with zero.', 'rating-form' ); ?>
							</p>
						</td>
					</tr>
					<tr>
						<?php
							$settings_rating_types = (empty($settings['rating_types']) ? array( 'cookie' ) : $settings['rating_types']);
							$settings_ip_restrict_time = (empty($settings['ip_restrict_time']) ? $max_restriction_hours : $settings['ip_restrict_time']);
							$settings_cookie_restrict_time = (empty($settings['cookie_restrict_time']) ? $max_restriction_hours : $settings['cookie_restrict_time']);
						?>
						<th scope="row"><label for="settings[rating_types][]"><?php _e( 'Duplicate Rating Check', 'rating-form' ); ?></label></th>
						<td>
							<div class="rf_settings_rt">
								<div class="rf_settings_rt_item">
									<label><input type="checkbox" name="settings[rating_types][]" value="cookie" <?php checked(in_array("cookie", $settings_rating_types), true); ?> /> <?php _e( 'Cookie', 'rating-form' ); ?></label>
								</div>
								<div class="rf_settings_rt_item">
									<label><?php _e( 'Hours', 'rating-form' ); ?> <input type="number" min="0" value="<?php echo $settings_cookie_restrict_time; ?>" name="settings[cookie_restrict_time]" /></label>
								</div>
								<div class="rf_settings_rt_item">
									<label><input type="checkbox" name="settings[rating_types][]" value="ip" <?php checked(in_array("ip", $settings_rating_types), true); ?> /> <?php _e( 'IP Address', 'rating-form' ); ?></label>
								</div>
								<div class="rf_settings_rt_item">
									<label><?php _e( 'Hours', 'rating-form' ); ?> <input type="number" min="0" value="<?php echo $settings_ip_restrict_time; ?>" name="settings[ip_restrict_time]" /></label>
								</div>
							</div>
							<p class="description">
								<?php _e( 'Choose a type to prevent anonymous users from voting multiple times.', 'rating-form' ); ?>
							</p>
						</td>
					</tr>
						<tr>
							<th scope="row"><label for="settings[deactivate][mobile]"><?php _e( 'Deactivate on mobile', 'rating-form' ); ?></label></th>
							<td>
								<span class="rf-toggle rf_left">
									<?php
									 	$settings_deactivate = (empty($settings['deactivate']) ? array() : $settings['deactivate']);
									?>
									<input type="checkbox" name="settings[deactivate][]" value="mobile" <?php checked(in_array('mobile', $settings_deactivate), true); ?> />
									<label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
								</span>
							</td>
						</tr>
						<tr>
							<th scope="row"><label for="settings[deactivate][tablet]"><?php _e( 'Deactivate on tablet', 'rating-form' ); ?></label></th>
							<td>
								<span class="rf-toggle rf_left">
									<input type="checkbox" name="settings[deactivate][]" value="tablet" <?php checked(in_array('tablet', $settings_deactivate), true); ?> />
									<label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
								</span>
							</td>
						</tr>
						<tr>
							<th scope="row"><label for="settings[]"><?php _e( 'Approve Ratings', 'rating-form' ); ?></label></th>
							<td>
								<span class="rf-toggle rf_left">
									<input type="checkbox" name="settings[]" value="approval" <?php checked(in_array('approval', $settings), true); ?> />
									<label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
								</span>
								<div class="rf_clear"></div>
								<p class="description">
									<?php _e( 'Ratings needs approval before showing them.', 'rating-form' ); ?>
								</p>
							</td>
						</tr>
						<tr>
							<th scope="row"><label for="settings[rtl_admin]"><?php _e( 'Admin RTL', 'rating-form' ); ?></label></th>
							<td>
								<span class="rf-toggle rf_left">
									<?php
									 	$settingsRTLadminActive = (empty($settings['rtl_admin']) ? array() : $settings['rtl_admin']);
										$rtlAdminEnable = ($settingsRTLadminActive == 1 ? true : false);
									?>
									<input type="checkbox" name="settings[rtl_admin]" value="1" <?php checked($rtlAdminEnable, true); ?> />
									<label data-on="<?php _e( 'On', 'rating-form' ); ?>" data-off="<?php _e( 'Off', 'rating-form' ); ?>"></label>
								</span>
							</td>
						</tr>
					</tbody>
				</table>
				<?php submit_button( __( 'Save', 'rating-form' ), 'primary'); ?>
			</div>
		</div>
	</form>
</div>
<?php
}
?>
