<?php
class RF_Table_Results {

	// Variables
	private $number_of_rows	 = 25;
	private $items 		 	 = array();
	private $page_no 	 	 = 0;
	private $page_type 	 	 = array();
	private $form_type 	 	 = array();
	private $type_custom_id	 = array();
	private $sort_by 	 	 = array();
	private $admin_url 	 	 = null;
	private $order_by	 	 = 'lastDate DESC';
	private $limit_title 	 = 70;
	private $date_format	 = 'Y/m/d @ H:i';
	private $approve_rating  = false;
	private $approve_ratings = array();

	// Type ID
	private $post_id	 	 = 0;
	private $comment_id	 	 = 0;
	private $term_id	 	 = 0;
	private $user_id	 	 = 0;

	// Prepare the items for the table to process
	function __construct()
    {
		$this->vars();
		$this->savedFilters();
		$this->results();
    }

	public function vars() {
		// Set admin url
		$this->admin_url = admin_url( 'admin.php' );
		// Get current page number
		$this->page_no = (isset($_GET['page_no']) ? intval($_GET['page_no']) : 0);
		// Set default sorting order by new ratings
		$this->sort_by = array('new');
		// Set default rating VALUES
		$this->form_type = array('star', 'tud');
		// Get type ID
		$this->post_id = (isset($_GET['post_id']) ? intval($_GET['post_id']) : 0);
		$this->comment_id = (isset($_GET['comment_id']) ? intval($_GET['comment_id']) : 0);
		$this->term_id = (isset($_GET['term_id']) ? intval($_GET['term_id']) : 0);
		$this->user_id = (isset($_GET['user_id']) ? intval($_GET['user_id']) : 0);
		$this->custom_id = (isset($_GET['custom_id']) ? strval($_GET['custom_id']) : '0');
		$this->approve_rating = Rating_Form_Setup::approveRatings();
		$this->approve_ratings = Rating_Form_Setup::getSetting('approval_ratings');
	}

	public function results () {
		if ($this->isResultsByID()) {
			$this->items = $this->getRatingsByType($this->getTypeID()['key'], false);
		} else {
			$this->items = array_merge(
				$this->getRatingsByType('post_id'),
				$this->getRatingsByType('comment_id'),
				$this->getRatingsByType('term_id'),
				$this->getRatingsByType('user_id'),
				$this->getRatingsByType('custom_id')
			);
		}
		$this->filterByLanguage($this->items);
	}

	// Filter result based on current WPML language
	public static function filterByLanguage(&$data) {
		if (has_action('wpml_loaded')) {
			$current_language = apply_filters('wpml_current_language', null);
			if (empty($data) || $current_language == 'all') return; // stop filtering because all languages selected

			foreach ($data as $key => $value) {
				$post_type = get_post_type( $value['post_id'] );
				if ($post_type === false) return;

				$args = array('element_id' => $value['post_id'], 'element_type' => $post_type);
				$post_language = apply_filters('wpml_element_language_code', $current_language, $args);
				// If $post_language is not $current_language: remove item
				//echo $post_language . '<br>';
				if ( !empty($post_language) && ( $current_language != $post_language ) ) {
					//echo 'not - ' . $value['post_id'] . ' - ' . $post_language . '<br>';
					unset($data[$key]);
				}
			}
		}
	}

	private function getRatingsByType($field = null, $group = true) {
		global $wpdb;

		$sql = 'SELECT *, ' .
		($group ? ' MAX' : '') . '(date) AS lastDate ' .
		($group ? ", SUM(CASE WHEN rated = '1u' then 1 else 0 end) AS upCount, " : '') .
		($group ? "SUM(CASE WHEN rated = '1d' then 1 else 0 end) AS downCount, " : '') .
		($group ? "SUM(CASE WHEN rated REGEXP '^[0-9]+$' then 1 else 0 end) AS starCount, " : '') .
		($group ? "(SUM(CASE WHEN rated REGEXP '^[0-9]+$' then rated else 0 end)/SUM(CASE WHEN rated REGEXP '^[0-9]+$' then 1 else 0 end)) AS avgRating " : '') .
		'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . ' WHERE ';

		switch ($field) {
			case 'post_id':
				$sql .= (empty($this->post_id) ? 'post_id <> 0 ' : 'post_id = "' . $this->post_id . '" ');
				$sql .= 'AND comment_id = 0 ';
				$sql .= 'AND term_id = 0 ';
				$sql .= 'AND user_id = 0 ';
				$sql .= "AND custom_id = '0' ";
				break;
			case 'comment_id':
				$sql .= (empty($this->post_id) ? 'post_id <> 0 ' : 'post_id = "' . $this->post_id . '" ');
				$sql .= 'AND ';
				$sql .= (empty($this->comment_id) ? 'comment_id <> 0 ' : 'comment_id = "' . $this->comment_id . '" ');
				$sql .= 'AND term_id = 0 ';
				$sql .= 'AND user_id = 0 ';
				$sql .= "AND custom_id = '0' ";
				break;
			case 'term_id':
				$sql .= 'post_id = 0 ';
				$sql .= 'AND comment_id = 0 ';
				$sql .= 'AND ';
				$sql .= (empty($this->term_id) ? 'term_id <> 0 ' : 'term_id = "' . $this->term_id . '" ');
				$sql .= 'AND user_id = 0 ';
				$sql .= "AND custom_id = '0' ";
				break;
			case 'user_id':
				$sql .= 'post_id = 0 ';
				$sql .= 'AND comment_id = 0 ';
				$sql .= 'AND term_id = 0 ';
				$sql .= 'AND ';
				$sql .= (empty($this->user_id) ? 'user_id <> 0 ' :  'user_id = "' . $this->user_id . '" ');
				$sql .= "AND custom_id = '0' ";
				break;
			case 'custom_id':
				if ($this->isResultsByID()) {

					$sql .= (empty($this->custom_id) ? "custom_id = '0' " :  'custom_id = "' . $this->custom_id . '" ');
					$sql .= (empty($this->post_id) ? "AND post_id = '0' " : 'AND post_id = "' . $this->post_id . '" ');
					$sql .= (empty($this->comment_id) ? "AND comment_id = '0' "  : 'AND comment_id = "' . $this->comment_id . '" ');
					$sql .= (empty($this->term_id) ? "AND term_id = '0' "  : 'AND term_id = "' . $this->term_id . '" ');
					$sql .= (empty($this->user_id) ? "AND user_id = '0' "  :  'AND user_id = "' . $this->user_id . '" ');
				} else {
					$sql .= "custom_id <> '0' ";
				}
				break;
		}

		$form_type = $this->form_type;
		if (count($form_type) == 1 && in_array('star', $form_type)) {
			$sql .= "AND rated REGEXP '^[0-9]+$' ";
		} else if (count($form_type) == 1 && in_array('tud', $form_type)) {
			$sql .= "AND (rated = '1d' OR rated = '1u') ";
		}

		$sql .= ($group ? ($field == 'custom_id' ? 'GROUP BY (post_id|comment_id|term_id|user_id), custom_id ' : 'GROUP BY ' . $field . ' ') : '');
		$sql .= 'ORDER BY '. $this->order_by . ';';
		$results = $wpdb->get_results($sql, ARRAY_A);

        return $results;
	}

	public function ajaxTypeID($val = null) {
		$val = empty($val) ? null : preg_match('/(\D*)=(\d*)/i', $val, $matches);
		if (empty($val)) return;

		$field = $matches[1];
		$id = $matches[2];

		switch ($field) {
			case 'post_id':
				$this->post_id = $id;
				break;
			case 'comment_id':
				$this->comment_id = $id;
				break;
			case 'term_id':
				$this->term_id = $id;
				break;
			case 'user_id':
				$this->user_id = $id;
			case 'custom_id':
				$this->custom_id = $id;
				break;
		}
	}

	private function isResultsByID() {
		return (!empty($this->post_id) ||
		!empty($this->comment_id) ||
		!empty($this->term_id) ||
		!empty($this->user_id) ||
		!empty($this->custom_id));
	}

	private function getTypeID() {
		$array = array ();
		if (!empty($this->custom_id)) {
			$array['key'] 	= 'custom_id';
			$array['value'] = $this->custom_id;
		} else if (!empty($this->post_id)) {
			$array['key'] 	= 'post_id';
			$array['value'] = $this->post_id;
		} else if (!empty($this->comment_id)) {
			$array['key'] 	= 'comment_id';
			$array['value'] = $this->comment_id;
		} else if (!empty($this->term_id)) {
			$array['key'] 	= 'term_id';
			$array['value'] = $this->term_id;
		} else if (!empty($this->user_id)) {
			$array['key'] 	= 'user_id';
			$array['value'] = $this->user_id;
		}
		return $array;
	}

	private function countItems() {
		return count($this->items);
	}

	public function sort() {
		$items 				= $this->items;
		$sort_by			= $this->sort_by;
		$page_type			= $this->page_type;
		$type_custom_id			= $this->type_custom_id;
		$hasTypeTUD = in_array('tud', $this->form_type) ? true : false;

		// Sorting
		if (count($sort_by)) {
			// Sort by Date ASC/DESC
			if (in_array('old', $sort_by)) {
				function sortByDateAsc( $a, $b ) {
				    return strtotime($a["lastDate"]) - strtotime($b["lastDate"]);
				}
				usort($items, "sortByDateAsc");
			} else if (in_array('new', $sort_by)) {
				function sortByDateDesc( $a, $b ) {
				    return strtotime($b["lastDate"]) - strtotime($a["lastDate"]);
				}
				usort($items, "sortByDateDesc");
			}
			// Sort by Rating ASC/DESC
			if (in_array('low', $sort_by)) {
				$usort = "sortByAvgRatingAsc";
				function sortByAvgRatingAsc( $a, $b ) {
				    return $a["avgRating"] > $b["avgRating"];
				}
				function sortByRatingAsc( $a, $b ) {
				    return $a["rated"] > $b["rated"];
				}
				function sortByTotalTudAsc( $a, $b ) {
					return ($a["upCount"]+$a["downCount"]) > ($b["upCount"]+$b["downCount"]);
				}
				if (count($this->form_type) == 1 && $hasTypeTUD) $usort = "sortByTotalTudAsc";
				if ($this->isResultsByID()) $usort = 'sortByRatingAsc';
				usort($items, $usort);
			} else if (in_array('high', $sort_by)) {
				$usort = "sortByAvgRatingDesc";
				function sortByAvgRatingDesc( $a, $b ) {
				    return $a["avgRating"] < $b["avgRating"];
				}
				function sortByRatingDesc( $a, $b ) {
				    return $a["rated"] < $b["rated"];
				}
				function sortByTotalTudDesc( $a, $b ) {
				    return ($a["upCount"]+$a["downCount"]) < ($b["upCount"]+$b["downCount"]);
				}
				if (count($this->form_type) == 1 && $hasTypeTUD) $usort = "sortByTotalTudDesc";
				if ($this->isResultsByID()) $usort = 'sortByRatingDesc';
				usort($items, $usort);
			}
		}
		// Filter page types
		// Filter custom id of page types
		if (count($page_type) || count($type_custom_id)) {
			$items = array_filter($items, array($this, 'filterPageTypes'));
		}
		// Re-assign items with sorted / filtered items
		$this->items = $items;
	}

	private function savedFilters() {
		$saved_filters 		= get_option(Rating_Form_Setup::PAGE_RESULT_RATING_SLUG);
		if ($saved_filters === false) return;

		$rf_results_filter 	= empty($saved_filters['rf_results_filter']) ? array() : $saved_filters['rf_results_filter'];
		$sort_by = empty($rf_results_filter['sort_by']) ? array() : $rf_results_filter['sort_by'];
		$page_type = empty($rf_results_filter['page_type']) ? array() : $rf_results_filter['page_type'];
		$page_no = empty($saved_filters['page_no']) ? 0 : $saved_filters['page_no'];
		$form_type = empty($saved_filters['form_type']) ? array() : $saved_filters['form_type'];
		$type_custom_id = empty($rf_results_filter['type_custom_id']) ? array() : $rf_results_filter['type_custom_id'];
		$type_id = empty($saved_filters['type_id']) ? 0 : $saved_filters['type_id'];

		$this->setSortBy($sort_by);
		$this->setPageType($page_type);
		$this->setPageNo($page_no);
		$this->setFormType($form_type);
		$this->setTypeCustomID($type_custom_id);
		$this->ajaxTypeID($type_id);
	}

	public function setSortBy($sort_by) {
		$this->sort_by = $sort_by;
	}

	public function setPageType($page_type) {
		$this->page_type = $page_type;
	}

	public function setPageNo($page_no) {
		$this->page_no = $page_no;
	}

	public function setFormType($form_type) {
		$this->form_type = $form_type;
	}

	public function setTypeCustomID($type_custom_id) {
		$this->type_custom_id = $type_custom_id;
	}

	private function getPageTypes() {
		$pageTypes = array();
		$page_type = $this->page_type;

		$pushPost = 'post';
		if (array_key_exists($pushPost, $page_type) && empty($page_type[$pushPost])) {
			array_push($pageTypes, $pushPost);
		}
		$pushComment = 'comment';
		if (array_key_exists($pushComment, $page_type) && empty($page_type[$pushComment])) {
			array_push($pageTypes, $pushComment);
		}
		$pushTerm = 'term';
		if (array_key_exists($pushTerm, $page_type) && empty($page_type[$pushTerm])) {
			array_push($pageTypes, $pushTerm);
		}
		$pushUser = 'user';
		if (array_key_exists($pushUser, $page_type) && empty($page_type[$pushUser])) {
			array_push($pageTypes, $pushUser);
		}

		return $pageTypes;
	}

	// Typ filtering
	private function filterPageTypes($item) {
		$types		= $this->page_type;
		$pageTypes  = $this->getPageTypes();
		$custom_ids	= $this->type_custom_id;
		$item 		= $this->getItem($item, true);

		$types_post = empty($types['post']) ? array() : $types['post'];
		$types_term = empty($types['term']) ? array() : $types['term'];

		$filter_page_types	= in_array($item['page_type'], $pageTypes) && empty($item['custom_id']) ;
		$filter_post_type	= in_array($item['type'], $types_post);
		$filter_term_type	= in_array($item['type'], $types_term);
		$filter_custom_id	= in_array($item['page_type'], $custom_ids) && !empty($item['custom_id']);

		return $filter_custom_id || $filter_post_type || $filter_term_type || $filter_page_types;
	}

	private function getItem($item, $outputAsArray = false) {
		$data				= array();
		$item 				= count($item) == 1 ? $item[0] : $item;
		$html 				= '';
		$field_custom_id	= '';
		$field_id 			= '';
		$field_attr			= '';
		$field_page_type 	= '';
		$field_type 		= '';
		$field_title 		= '';

		$post_id 			= $item['post_id'];
		$comment_id 		= $item['comment_id'];
		$term_id 			= $item['term_id'];
		$user_id 			= $item['user_id'];
		$custom_id 			= $item['custom_id'];

		$urlResults			= $this->getUrlResults();
		$averageRating 		= array_key_exists('avgRating', $item) ? round( $item['avgRating'] , 1) : $item['rated'];
		$averagePercentage 	= ($averageRating / ($averageRating <= 5 ? 5 : 10)) * 100;

		// Post / Page / Custom Post Type
		if (!empty($post_id) && empty($comment_id) && empty($term_id) && empty($user_id)) {
			$data = $this->getDataOfType($post_id, 'post');
		}
		// Comment
		if (!empty($post_id) && !empty($comment_id) && empty($term_id) && empty($user_id)) {
			$data = $this->getDataOfType($comment_id, 'comment');
		}
		// Term
		if (empty($comment_id) && !empty($term_id) && empty($user_id)) {
			$data = $this->getDataOfType($term_id, 'term');
		}
		// User
		if (empty($comment_id) && empty($term_id) && !empty($user_id)) {
			$data = $this->getDataOfType($user_id, 'user');
		}
		// Custom ID
		if (!empty($custom_id) || !(empty($post_id) || empty($comment_id) || empty($term_id) || empty($user_id))) {
			$field_custom_id = $data['id'];
			$field_custom_id .= '<span class="rf_results_custom_id" title="Custom ID '.$custom_id.' of '.ucwords($data['type']).' ID '.$data['id'].'">' . $custom_id . '</span>';
		}

		// Data
		$field_id 		 = $data['id'];
		$field_exists	 = $data['exists'];
		$field_page_type = $data['page_type'];
		$field_attr		 = $data['attr'];
		$field_url_title = $data['title'];
		if (!$field_exists) {
			$field_type		= $field_page_type;
			$field_title	= '<b>' . __('Not Found', 'rating-form') . '</b>';
		} else {
			$field_type 	= $data['type'];
			$field_title 	= '<a target="_target" href="' . $data['url'] . '">' . $field_url_title . '</a>';
		}

		if ($outputAsArray) {
			return array (
				'id' => $field_id,
				'page_type' => $field_page_type,
				'type' => $field_type,
				'title' => $field_title,
				'custom_id' => $custom_id,
				'avgRating' => $averageRating,
				'avgPercentage' => $averagePercentage,
				'starCount' => $item['starCount'],
				'upCount' => $item['upCount'],
				'downCount' => $item['downCount']
			);
		}

		$html .= '<td>' . (empty($field_custom_id) ? $field_id : $field_custom_id) . '</td>';
		$html .= '<td>' . $field_type . '</td>';
		$html .= '<td>' . $field_title . '</td>';
		$html .= '<td>';
		if (!empty($item['starCount'])) {
			$html .= '<div class="rf_results_rating_group">';
			$html .= '<strong>' . __("Average", "rating-form") . ':</strong> ' . $averageRating . '<br>';
			$html .= '<strong>' . __("Percentage", "rating-form") . ':</strong> ' . $averagePercentage . '%<br>';
			$html .= '<strong>' . __("Total", "rating-form") . ':</strong> ' . $item['starCount'] . '<br>';
			$html .= '</div>';
		}
		if (!empty($item['upCount']) || !empty($item['downCount'])) {
			$html .= '<div class="rf_results_rating_group">';
			$html .= '<strong>' . __("Up", "rating-form") . ':</strong> ' . $item['upCount'] . '<br>';
			$html .= '<strong>' . __("Down", "rating-form") . ':</strong> ' . $item['downCount'] . '<br>';
			$html .= '<strong>' . __("Total", "rating-form") . ':</strong> ' . ($item['upCount'] + $item['downCount']);
			$html .= '</div>';
		}
		$html .= '</td>';
		$param_custom_id = (empty($field_custom_id) ? '' : '&custom_id=' . $custom_id);
		$html .= '<td><a href="' . $urlResults . '&' . $field_attr . '=' . $field_id . $param_custom_id . '" class="rf_results_btn_action">' . __('View Ratings', 'rating-form') . '</a></td>';

		return $html;
	}

	private function getDataOfType($id, $type) {
		$data = array ();
		switch ($type) {
		    case 'post':
		        $data['id'] 		= $id;
		        $data['page_type'] 	= 'post';
		        $data['attr'] 	    = 'post_id';
		        $data['type'] 		= get_post_type($id);
		        $data['title'] 		= get_the_title($id);
		        $data['title']      = strlen($data['title']) > $this->limit_title ? substr($data['title'], 0, $this->limit_title) . "..." : $data['title'];
		        $data['url'] 		= get_permalink($id);
		        $data['exists'] 	= get_post_status($id);
		        break;
		    case 'comment':
		        $data['id'] 		= $id;
		        $data['page_type'] 	= 'comment';
		        $data['attr'] 	    = 'comment_id';
		        $data['type'] 		= get_comment_type($id);
		        $data['title'] 		= get_comment_text($id);
		        $data['title']      = strlen($data['title']) > $this->limit_title ? substr($data['title'], 0, $this->limit_title) . "..." : $data['title'];
		        $data['url'] 		= get_comment_link($id);
		        $data['exists'] 	= wp_get_comment_status($id);
		        break;
		    case 'term':
		        $term               = get_term( $id );
		        $data['id'] 		= $id;
		        $data['page_type'] 	= 'term';
		        $data['attr'] 	    = 'term_id';
		        $data['type'] 		= $term->taxonomy;
		        $data['title'] 		= $term->name;
		        $data['title']      = strlen($data['title']) > $this->limit_title ? substr($data['title'], 0, $this->limit_title) . "..." : $data['title'];
		        $data['url'] 		= is_wp_error($term) ? '' : get_term_link($term);
				$data['exists']		= !is_wp_error($term);
		        break;
		    case 'user':
		        $data['id'] 		= $id;
		        $data['page_type'] 	= 'user';
		        $data['attr'] 	    = 'user_id';
		        $data['type'] 		= $data['page_type'];
		        $data['title'] 		= get_the_author_meta( 'display_name', $id);
		        $data['title']      = strlen($data['title']) > $this->limit_title ? substr($data['title'], 0, $this->limit_title) . "..." : $data['title'];
		        $data['url'] 		= get_author_posts_url($id);
		        $data['exists'] 	= !empty($data['title']);
		        break;
		}
		return $data;
	}

	private function getUrlResults() {
		return $this->admin_url . '?page='. Rating_Form_Setup::PAGE_RESULT_RATING_SLUG;
	}

	private function getUrlBlock() {
		return $this->admin_url . '?page='. Rating_Form_Setup::PAGE_BLOCK_LIST_SLUG;
	}

	private function paginationOutput() {
		$html			= '';
		$pageRows		= $this->number_of_rows;
		$numberOfPages 	= ceil(($this->countItems() / $pageRows));
		$pageNo 		= empty($this->page_no) ? 1 : $this->page_no;
		$urlResults		= $this->getUrlResults();
		$type_id		= $this->getTypeID();
		$type_key		= empty($type_id) ? '' : $type_id['key'];
		$type_val		= empty($type_id) ? '' : $type_id['value'];

		if ($numberOfPages > 1) {
			$html .= '<div class="rf_table_pagination">';
			$html .= '<ul>';
			$html .= '<li class="rf_title"><a href="' . $urlResults . '">' . __('Page', 'rating-form') . '</a></li>';
			for ( $i = 0; $i < $numberOfPages; $i++ ) {
				$no 			= ($i + 1);
				$url		    = $urlResults; // table parameters
				$url		    .= (empty($type_id) ? '' : '&'.$type_key.'=' . $type_val); // table parameters
				$url		    .= (empty($this->custom_id) ? '' : '&custom_id=' . $this->custom_id); // table parameters
				$url		    .= '&page_no=' . $no; // table parameters
				$currentClass	= ' rf_current';
				$currentPage 	= $pageNo == $no ? $currentClass : '';

				if (!isset($_GET['page_no']) && $pageNo == 1 && $no == 1)
					$currentPage = $currentClass;

				$html .= '<li><a href="#' . $no . '" class="rf-pagination-no' . $currentPage . '">' . $no . '</a></li>';
			}
			$html .= '</ul>';
			$html .= '</div>';
		}
		return $html;
	}

	private function approveSelection() {
		if ( !$this->approve_rating ) return;
		$html = '';

		$html .= '<th class="rf-approve-select">';
		$html .= '<select class="rf_left">';
		$html .= '<option value="0">' . __("Approve", "rating-form") . '</option>';
		$html .= '<option value="1">' . __("Approve all", "rating-form") . '</option>';
		$html .= '<option value="2">' . __("Approve none", "rating-form") . '</option>';
		$html .= '</select>';
		$html .= '<input type="submit" class="rf_right button button-primary" value="' . __("Save", "rating-form") . '" />';
		$html .= '</th>';

		return $html;
	}

	private function filterOutput() {
		$sort_by			= $this->sort_by;
		$page_type			= $this->page_type;
		$pageTypes			= $this->getPageTypes();
		$type_custom_id		= $this->type_custom_id;

		$html = '<form class="rf-filter-form" method="post">';
		// Pagination
		$html .= '<div class="rf_left">';
		$html .= $this->paginationOutput();
		$html .= '</div>';
		// Save filters
		$type_id		= $this->getTypeID();
		$type_key		= empty($type_id) ? '' : $type_id['key'];
		$type_val		= empty($type_id) ? '' : $type_id['value'];
		$type_id		= empty($type_id['key']) ? '' : $type_id['key'].'='.$type_id['value'];
		$html .= '<input type="hidden" name="action" value="rating_form_filter_results" />';
		$html .= '<input type="hidden" name="type_id" value="'.$type_id.'" />';
		$html .= '<input type="hidden" name="page_no" value="'.$this->page_no.'" />';
		$html .= '<input type="submit" class="rf_right rf_btn_filter" value="' . __("Filter", "rating-form") . '" />';
		$html .= '<label class="rf_right rf_results_save_filter"><input name="rf_results_save_filter" value="1" type="checkbox" />' . __("Save Filter", "rating-form") . '</label>';
		// Type Form Rating Value 1-5,  1u / 1d , custom
		$checkedStar = in_array('star', $this->form_type) ? 'checked="checked"' : '';
		$checkedTUD = in_array('tud', $this->form_type) ? 'checked="checked"' : '';
		$html .= '<div class="rf-switch-field">';
		$html .= '<input type="checkbox" id="switch_3_left" name="form_type[]" value="star" '.$checkedStar.' />';
		$html .= '<label for="switch_3_left" class="cyto-star"></label>';
		$html .= '<input type="checkbox" id="switch_3_center" name="form_type[]" value="tud" '.$checkedTUD.' />';
		$html .= '<label for="switch_3_center" class="cyto-thumbs-up"></label>';
		$html .= '</div>';
		// Sort by
		$html .= '<div class="rf-results-filter">';
		$html .= '<div class="rf-filter-label">';
		$html .= '<span class="rf-title" title="">';
		$html .= '<span class="rf-filter-button">';
		$html .= '<span class="rf-slt-btn-down">&#9660;</span>';
		$html .= '<span class="rf-slt-btn-up">&#9650;</span>';
		$html .= '</span>';
		$html .= __("Sort by", "rating-form");
		$html .= '<span class="rf-filter-selected">' . __("Newest", "rating-form") . '</span>';
		$html .= '<span class="rf-filter-sltd-def">' . __("Newest", "rating-form") . '</span>';
		$html .= '</span>';
		$html .= '</div>';
		$html .= '<div class="rf-filter-data radio-group">'; // begin rf-filter-type
		//
		// Filter Date (new-old)
		$html .= '<div class="rf-filter-type">';
		$html .= '<label class="rf-filter-type-cat"><input class="radio" data-radio-group="1" type="checkbox" ' . (in_array('new', $sort_by) ? 'checked="checked" ' : '') .'name="rf_results_filter[sort_by][]" value="new">' . __('Newest', 'rating-form') . '</label>';
		$html .= '</div>';
		// End Filter
		//
		// Filter Date (old-new)
		$html .= '<div class="rf-filter-type">';
		$html .= '<label class="rf-filter-type-cat"><input class="radio" data-radio-group="1" type="checkbox" ' . (in_array('old', $sort_by) ? 'checked="checked" ' : '') .'name="rf_results_filter[sort_by][]" value="old">' . __('Oldest', 'rating-form') . '</label>';
		$html .= '</div>';
		// End Filter
		//
		// Filter Rating (high-low)
		$html .= '<div class="rf-filter-type">';
		$html .= '<label class="rf-filter-type-cat"><input class="radio" data-radio-group="2" type="checkbox" ' . (in_array('high', $sort_by) ? 'checked="checked" ' : '') .'name="rf_results_filter[sort_by][]" value="high">' . __('Highest', 'rating-form') . '</label>';
		$html .= '</div>';
		// End Filter
		//
		// Filter Rating (low-high)
		$html .= '<div class="rf-filter-type">';
		$html .= '<label class="rf-filter-type-cat"><input class="radio" data-radio-group="2" type="checkbox" ' . (in_array('low', $sort_by) ? 'checked="checked" ' : '') .'name="rf_results_filter[sort_by][]" value="low">' . __('Lowest', 'rating-form') . '</label>';
		$html .= '</div>';
		// End Filter
		//
		$html .= '</div>'; // end rf-filter-data
		$html .= '</div>'; // end rf-results-filter

		if (!$this->isResultsByID()) {
			// Page types
			$html .= '<div class="rf-results-filter">';
			$html .= '<div class="rf-filter-label">';
			$html .= '<span class="rf-title" title="">';
			$html .= '<span class="rf-filter-button">';
			$html .= '<span class="rf-slt-btn-down">&#9660;</span>';
			$html .= '<span class="rf-slt-btn-up">&#9650;</span>';
			$html .= '</span>';
			$html .= __("Filter by", "rating-form");
			$html .= '<span class="rf-filter-selected">' . __("All", "rating-form") . '</span>';
			$html .= '<span class="rf-filter-sltd-def">' . __("All", "rating-form") . '</span>';
			$html .= '</span>';
			$html .= '</div>';
			$html .= '<div class="rf-filter-data">'; // begin rf-filter-type
			//
			// Filter post
			$post_types = get_post_types();
			$html .= '<div class="rf-filter-type">';
			$html .= '<span class="rf-filter-type-button rf_right">';
			$html .= '<span class="rf-slt-btn-down">&#9660;</span>';
			$html .= '<span class="rf-slt-btn-up">&#9650;</span>';
			$html .= '</span>';
			$html .= '<label class="rf-filter-custom-id"><input type="checkbox" ' . (in_array('post', $type_custom_id) ? 'checked="checked" ' : '') .'name="rf_results_filter[type_custom_id][]" value="post" />Custom ID</label>';
			$html .= '<label class="rf-filter-type-cat"><input type="checkbox" ' . (in_array('post', $pageTypes) || array_key_exists('post', $page_type) && count($page_type['post']) == count($post_types) ? 'checked="checked" ' : '') .'name="rf_results_filter[page_type][post]" value="">Post</label>';
			$html .= '<div class="rf-filter-type-list">';

			foreach ( $post_types as $post_type ) {
				$html .= '<label><input type="checkbox" ' . (array_key_exists('post', $page_type) && in_array($post_type, $page_type['post']) ? 'checked="checked" ' : '') .'name="rf_results_filter[page_type][post][]" value="' . $post_type . '">' . $post_type . '</label>';
			}

			$html .= '</div>';
			$html .= '</div>';
			// End Filter
			//
			// Filter comment
			$html .= '<div class="rf-filter-type">';
			$html .= '<label class="rf-filter-custom-id"><input type="checkbox" ' . (in_array('comment', $type_custom_id) ? 'checked="checked" ' : '') .'name="rf_results_filter[type_custom_id][]" value="comment" />Custom ID</label>';
			$html .= '<label class="rf-filter-type-cat"><input type="checkbox" ' . (in_array('comment', $pageTypes) ? 'checked="checked" ' : '') .' name="rf_results_filter[page_type][comment]" value="">Comment</label>';
			$html .= '</div>';
			// End Filter
			//
			// Filter term
			$term_types = get_taxonomies();
			$html .= '<div class="rf-filter-type">';
			$html .= '<span class="rf-filter-type-button rf_right">';
			$html .= '<span class="rf-slt-btn-down">&#9660;</span>';
			$html .= '<span class="rf-slt-btn-up">&#9650;</span>';
			$html .= '</span>';
			$html .= '<label class="rf-filter-custom-id"><input type="checkbox" ' . (in_array('term', $type_custom_id) ? 'checked="checked" ' : '') .'name="rf_results_filter[type_custom_id][]" value="term" />Custom ID</label>';
			$html .= '<label class="rf-filter-type-cat"><input type="checkbox" ' . (in_array('term', $pageTypes) || array_key_exists('term', $page_type) && count($page_type['term']) == count($term_types) ? 'checked="checked" ' : '') .' name="rf_results_filter[page_type][term]" value="">Term</label>';
			$html .= '<div class="rf-filter-type-list">';

			foreach ( $term_types as $term ) {
				$html .= '<label><input type="checkbox" ' . (array_key_exists('term', $page_type) && in_array($term, $page_type['term']) ? 'checked="checked" ' : '') .'name="rf_results_filter[page_type][term][]" value="' . $term . '">' . $term . '</label>';
			}

			$html .= '</div>';
			$html .= '</div>';
			// End Filter
			//
			// Filter user
			$html .= '<div class="rf-filter-type">';
			$html .= '<label class="rf-filter-custom-id"><input type="checkbox" ' . (in_array('user', $type_custom_id) ? 'checked="checked" ' : '') .'name="rf_results_filter[type_custom_id][]" value="user" />Custom ID</label>';
			$html .= '<label class="rf-filter-type-cat"><input type="checkbox" ' . (in_array('user', $pageTypes) ? 'checked="checked" ' : '') .' name="rf_results_filter[page_type][user]" value="">User</label>';
			$html .= '</div>';
			// End Filter
			//
			$html .= '</div>'; // end rf-filter-data
			$html .= '</div>'; // end rf-results-filter
		}
		$html .= '</form>';
		return $html;
	}

	private function valueRating($rating) {
		switch( $rating ) {
			case '1u':
				$rating = '+1';
				break;
			case '1d':
				$rating = '-1';
				break;
			default:
				$rating = $rating;
		}
		return $rating;
	}

	private function showTypeInfoByID($item) {
		if (empty($item['id'])) return;

		$html = '<div class="rf_results_type_info">';
		$html .= '<ul>';
		$html .= '<li><span>' . __('ID', 'rating-form') . '</span>' . $item['id'] . '</li>';
		$html .= '<li><span>' . __('Type', 'rating-form') . '</span>' . $item['type'] . '</li>';
		$html .= '<li><span>' . __('Title', 'rating-form') . '</span>' . $item['title'] . '</li>';
		if (!empty($item['custom_id'])) $html .= '<li><span>Custom ID</span>' . $item['custom_id'] . '</li>';
		if (!empty($item['starCount'])) {
			$html .= '<li>&vert;</li>';
			$html .= '<li><span>' . __('Average', 'rating-form') . '</span>' . $item['avgRating'] . '</li>';
			$html .= '<li><span>' . __('Percentage', 'rating-form') . '</span>' . $item['avgPercentage'] . '%</li>';
			$html .= '<li><span>' . __('Total', 'rating-form') . '</span>' . $item['starCount'] . '</li>';
		}
		if (!empty($item['upCount']) || !empty($item['downCount'])) {
			$html .= '<li>&vert;</li>';
			$html .= '<li><span>' . __('Up', 'rating-form') . '</span>' . $item['upCount'] . '</li>';
			$html .= '<li><span>' . __('Down', 'rating-form') . '</span>' . $item['downCount'] . '</li>';
			$html .= '<li><span>' . __('Total', 'rating-form') . '</span>' . ($item['upCount'] + $item['downCount']) . '</li>';
		}
		$html .= '</ul>';
		$html .= '</div>';
		return $html;
	}

	private function showTop() {
		$html = '<div class="rf_results_top">';
		$html .= $this->filterOutput();
		$html .= '</div>';
		if ($this->isResultsByID())	{
			$html .= $this->showTypeInfoByID(
				$this->getItem(
					$this->getRatingsByType($this->getTypeID()['key']), true)
			);
		}
		return $html;
	}

    public function show() {
		$this->sort();
		$pageNumber 			= $this->page_no == 0 ? 0 : ($this->page_no - 1);
		$pageRows				= $this->number_of_rows;
		$data					= array_slice($this->items, ($pageNumber * $pageRows), $pageRows);

		$table = '<div class="rf_form_ajax_update"></div>';
		if ( $this->approve_rating ) {
			$imp_approve_ratings = empty($this->approve_ratings) ? '' : implode(',', $this->approve_ratings);

			$table .= '<input type="hidden" name="rf-rating-approves" value="' . $imp_approve_ratings . '" />';
		}

		$table .= $this->showTop();
        $table .= '<table class="rf_results_table">';
            $table .= '<thead>';
			if ($this->isResultsByID()) {
				// Rating by Type ID
				$table .= $this->approveSelection();
	            $table .= '<th>' . __("Rating", "rating-form") . '</th>';
				$table .= '<th>' . __("By", "rating-form") . '</th>';
				$table .= '<th>' . __("Date", "rating-form") . '</th>';
	            $table .= '<th class="rf_width_20p">' . __("Action", "rating-form") . '</th>';
			} else {
				// All ratings
				$table .= '<th class="rf_width_10p">' . __("ID", "rating-form") . '</th>';
	            $table .= '<th class="rf_width_10p">' . __("Type", "rating-form") . '</th>';
				$table .= '<th>' . __("Title", "rating-form") . '</th>';
	            $table .= '<th>' . __("Rating", "rating-form") . '</th>';
	            $table .= '<th class="rf_width_10p">' . __("Action", "rating-form") . '</th>';
			}
            $table .= '</thead>';
            $table .= '<tbody>';

			if (count($data)) {
				foreach ($data as $item) {
					$table .= '<tr>';
					if ($this->isResultsByID()) {
						if ($this->approve_rating) {
							$arr_approve_ratings = empty($this->approve_ratings) ? array() : $this->approve_ratings;
							$table .= '<td><input ' .  checked( in_array( $item['rate_id'], $arr_approve_ratings ), true, false) . ' type="checkbox" name="approve[]" value="' . $item['rate_id'] . '" /></td>';
						}
						$table .= '<td><span class="rf_results_rating">' . $this->valueRating($item['rated']) . '</span></td>';
						if (empty($item['ip']) && empty($item['user'])) {
							$table .= '<td><i>' . __('Anonymous', 'rating-form') . '</i></td>';
						} else if (empty($item['user']) && !empty($item['ip'])) {
							$table .= '<td><a class="rf_results_block_user" title="' . __( 'Block IP', 'rating-form' ) . '" href="'. $this->getUrlBlock() .'&user='. trim($item['ip']) . '">' . $item['ip'] . '</a></td>';
						} else {
							// Get user info by ID
							$user = get_userdata( $item['user'] );
							$table .= '<td><a class="rf_results_block_user" title="' . __( 'Block User', 'rating-form' ) . '" href="'. $this->getUrlBlock() .'&user='. trim($item['user']) . '">' . $user->display_name . '</a></td>';
						}
						$table .= '<td>' . date($this->date_format, strtotime($item['date'])) . '</td>';
						$table .= '<td><div class="rf_results_btn_action_group">';
						$table .= '<input class="rf_rate_id" type="hidden" value="'.$item['rate_id'].'" />';
						$table .= '<a class="rf_results_btn_action rf_results_btn_edit" href="#">Edit</a>';
						$table .= '<div class="rf_results_edit">';
						$table .= '<div class="rf_results_edit_group">';
						$table .= '<select>';
						$matchStarRatings = preg_match('/^[0-9]+$/i', $item['rated']);

						if ($matchStarRatings) {
							for ($i = 1; $i <= 10; $i++) {
								$selected = ($item['rated'] == $i ? 'selected' : '');
								$table .= '<option value="'.$i.'" '.$selected.'>'.$i.'</option>';
							}
						} else {
							$table .= '<option value="1d" '.($item['rated'] == '1d' ? 'selected' : '').'>-1</option>';
							$table .= '<option value="1u" '.($item['rated'] == '1u' ? 'selected' : '').'>+1</option>';
						}
						$table .= '</select>';
						$table .= '<a class="rf_results_btn_action rf-save" href="#">'. __( 'Save', 'rating-form' ) .'</a>';
						$table .= '<a class="rf_results_btn_action rf-cancel" href="#">'. __( 'Cancel', 'rating-form' ) .'</a>';
						$table .= '</div>';
						$table .= '</div>';
						$table .= '<a class="rf_results_btn_action rf_results_btn_delete" href="#">'. __( 'Delete', 'rating-form' ) .'</a>';
						$table .= '<div class="rf_results_delete">';
						$table .= '<div class="rf_results_delete_group">';
						$table .= __( 'Are you sure?', 'rating-form' );
						$table .= '<a class="rf_results_btn_action rf-yes" href="#">'. __( 'Yes', 'rating-form' ) .'</a>';
						$table .= '<a class="rf_results_btn_action rf-cancel" href="#">'. __( 'Cancel', 'rating-form' ) .'</a>';
						$table .= '</div>';
						$table .= '</div>';
						$table .= '</div></td>';
					} else {
						$table .= $this->getItem($item);
					}
	                $table .= '</tr>';
				}
			} else {
				$table .= '<tr><td colspan="5">' . __('No ratings found.', 'rating-form') . '</td></tr>';
			}

			$tfoot_colspan = ($this->isResultsByID() ? 4 : 5);
			if ($this->approve_rating) $tfoot_colspan = 5;
            $table .= '</tbody>';
            $table .= '<tfoot>';
			$table .= '<th colspan="' . $tfoot_colspan . '">' . __('Entries: ', 'rating-form') . count($data) . '</th>';
            $table .= '</tfoot>';
        $table .= '</table>';
        echo $table;
    }
}

// Rating list table
function rating_form_results() {
	$rfTableResults = new RF_Table_Results();
?>
	<div class="wrap rf_wrap<?php echo Rating_Form_Setup::getAdminRTLclass(); ?>"<?php echo Rating_Form_Setup::getAdminRTL(); ?>>
		<?php Rating_Form_Setup::admin_menus( __( 'Latest Ratings', 'rating-form' ) ); ?>
		<div class="rf_form_table">
			<?php $rfTableResults->show(); ?>
		</div>
	</div>
<?php
}
?>
