<?php
/*
 * Plugin Name: QuadMenu PRO
 * Plugin URI:  https://www.quadmenu.com
 * Description: The best drag & drop WordPress Mega Menu plugin which allow you to create Tabs Menus & Carousel Menus.
 * Version:     1.8.2
 * Author:      Mega Menu
 * Author URI:  https://www.quadmenu.com
 * Copyright:   2018 QuadMenu (https://www.quadmenu.com)
 * Text Domain: quadmenu-pro
 */

if (!defined('ABSPATH'))
  exit;

if (!defined('QUADMENU_PLUGIN_NAME')) {
  define('QUADMENU_PLUGIN_NAME', 'QuadMenu');
}
if (!defined('QUADMENU_PRO_DB_KEY')) {
  define('QUADMENU_PRO_DB_KEY', '_menu_item_quadmenu');
}
if (!defined('QUADMENU_PRO_PLUGIN_NAME')) {
  define('QUADMENU_PRO_PLUGIN_NAME', 'QuadMenu PRO');
}
if (!defined('QUADMENU_PRO_PLUGIN_VERSION')) {
  define('QUADMENU_PRO_PLUGIN_VERSION', '1.8.2');
}
if (!defined('QUADMENU_DOMAIN')) {
  define('QUADMENU_DOMAIN', 'quadmenu');
}
if (!defined('QUADMENU_PRO_PLUGIN_FILE')) {
  define('QUADMENU_PRO_PLUGIN_FILE', __FILE__);
}
if (!defined('QUADMENU_PRO_PLUGIN_DIR')) {
  define('QUADMENU_PRO_PLUGIN_DIR', __DIR__ . DIRECTORY_SEPARATOR);
}
if (!defined('QUADMENU_PRO_DEMO_URL')) {
  define('QUADMENU_PRO_DEMO_URL', 'https://quadmenu.com/?utm_source=quadmenu_admin');
}
if (!defined('QUADMENU_PRO_LICENSES_URL')) {
  define('QUADMENU_PRO_LICENSES_URL', 'https://quadmenu.com/account/licenses/?utm_source=quadmenu_admin');
}
if (!defined('QUADMENU_PRO_SUPPORT_URL')) {
  define('QUADMENU_PRO_SUPPORT_URL', 'https://quadmenu.com/account/support/?utm_source=quadmenu_admin');
}

if (!class_exists('QuadMenu_PRO')) {

  class QuadMenu_PRO {

    protected static $instance;
    var $free = 'quadmenu';

    function add_admin_notices() {

      $screen = get_current_screen();

      if (isset($screen->parent_file) && 'plugins.php' === $screen->parent_file && 'update' === $screen->id) {
        return;
      }

      $plugin = "{$this->free}/{$this->free}.php";

      if (is_plugin_active($plugin)) {
        return;
      }

      if ($this->is_installed($plugin)) {

        if (!current_user_can('activate_plugins')) {
          return;
        }
        ?>
        <div class="error">
          <p>
            <a href="<?php echo wp_nonce_url('plugins.php?action=activate&amp;plugin=' . $plugin . '&amp;plugin_status=all&amp;paged=1', 'activate-plugin_' . $plugin); ?>" class='button button-secondary'><?php printf(esc_html__('Activate %s', 'quadmenu-pro'), QUADMENU_PLUGIN_NAME); ?></a>
            <?php printf(esc_html__('%s not working because you need to activate the %s plugin.', 'quadmenu-pro'), QUADMENU_PRO_PLUGIN_NAME, QUADMENU_PLUGIN_NAME); ?>   
          </p>
        </div>
        <?php
      } else {
        if (!current_user_can('install_plugins')) {
          return;
        }
        ?>
        <div class="error">
          <p>
            <a href="<?php echo wp_nonce_url(self_admin_url("update.php?action=install-plugin&plugin={$this->free}"), "install-plugin_{$this->free}"); ?>" class='button button-secondary'><?php printf(esc_html__('Install %s', 'quadmenu-pro'), QUADMENU_PLUGIN_NAME); ?></a>
            <?php printf(esc_html__('%s not working because you need to install the %s plugin.', 'quadmenu-pro'), QUADMENU_PRO_PLUGIN_NAME, QUADMENU_PLUGIN_NAME); ?>
          </p>
        </div>
        <?php
      }
    }

    function add_action_links($links) {

      $links[] = '<a target="_blank" href="' . QUADMENU_PRO_SUPPORT_URL . '">' . esc_html__('Support', 'quadmenu') . '</a>';

      $links[] = '<a target="_blank" href="' . QUADMENU_PRO_LICENSES_URL . '">' . esc_html__('License', 'quadmenu') . '</a>';

      return $links;
    }

    function add_body_class($classes) {

      $screen = get_current_screen();

      $classes .= ' quadmenu-pro';

      return $classes;
    }

    function remove_purchase_page() {
      remove_submenu_page('quadmenu_welcome', 'quadmenu_pro');
    }

    function add_license_page() {
      add_submenu_page('quadmenu_welcome', esc_html__('License', 'quadmenu'), esc_html__('License', 'quadmenu'), 'manage_options', 'quadmenu_license', array($this, 'add_license_settings'));
    }

    function add_license_settings() {

      global $quadmenu_license, $quadmenu_updater;

      $defaults = array(
          'market' => null,
          'license_key' => null,
          'email' => null,
      );

      $quadmenu_license = (object) wp_parse_args(get_option(QUADMENU_DOMAIN . '_license'), (array) $defaults);
      ?>
      <?php include_once(QUADMENU_PATH . 'includes/panel/header.php'); ?>
      <div class="about-wrap quadmenu-admin-wrap">
        <?php include_once('updates/panel/license.php'); ?>
      </div>
      <?php
    }

    function add_settings_register() {
      register_setting(sanitize_key(QUADMENU_DOMAIN . '_license-group'), sanitize_key(QUADMENU_DOMAIN . '_license'));
    }

    function add_customizer($ReduxFramework) {

      if (is_admin() || is_customize_preview()) {

        require_once 'includes/customizer/customizer.php';

        new QuadMenu_Customizer($ReduxFramework);
      }
    }

    function add_updater() {

      global $quadmenu_updater;

      if (include_once 'updates/updater.php') {
        $quadmenu_updater = qlwdd_updater(array(
            //'api_url' => 'http://localhost/?wc-api=qlwdd',
            'api_url' => 'https://quadmenu.com/wc-api/qlwdd/',
            'plugin_url' => QUADMENU_PRO_DEMO_URL,
            'plugin_file' => __FILE__,
            'license_url' => admin_url('admin.php?page=quadmenu_license'),
            'product_key' => '81b0d2dc2806687a11ded4c0e9cea254',
            'envato_key' => 'Gn46hMOIcvz8uyVvpe0jB2ge7A1RdH5T',
            'envato_id' => '21315450',
            'emp_id' => '567872'
        ));
      }
    }

    function add_activation() {

      global $quadmenu_updater;

      if (isset($_POST['option_page']) && $_POST['option_page'] == QUADMENU_DOMAIN . '_license-group' && isset($_POST[QUADMENU_DOMAIN . '_license'])) {
        $quadmenu_updater->request_activation($_POST[QUADMENU_DOMAIN . '_license']['license_key'], $_POST[QUADMENU_DOMAIN . '_license']['email'], $_POST[QUADMENU_DOMAIN . '_license']['market']);
      }
    }

    function save_menu_meta_box($post_id) {

      if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return $post_id;

      if (current_user_can('manage_options')) {
        if (array_key_exists('quadmenu', $_POST)) {
          if ($quadmenu = array_filter($_POST['quadmenu'])) {
            update_post_meta($post_id, QUADMENU_PRO_DB_KEY, $quadmenu);
          } else {
            delete_post_meta($post_id, QUADMENU_PRO_DB_KEY);
          }
        }
      }
    }

    function menu_meta_box($post) {

      $quadmenu = wp_parse_args(get_post_meta($post->ID, QUADMENU_PRO_DB_KEY, true), array(
          'menu' => '',
          'layout' => '',
          'theme' => ''
      ));

      $widget = new QuadMenu_Widget();
      ?>
      <p>
        <label for="quadmenu_menu"><?php esc_html_e('Menu', 'quadmenu'); ?></label>
        <select id="quadmenu_menu" name="quadmenu[menu]" class="widefat">
          <option value=""><?php esc_html_e('Default', 'quadmenu'); ?></option>
          <?php echo $widget->menus($quadmenu['menu']); ?>
        </select>
      </p>
      <p>
        <label for="quadmenu_theme"><?php esc_html_e('Theme', 'quadmenu'); ?></label>
        <select id="quadmenu_theme" name="quadmenu[theme]" class="widefat">
          <option value=""><?php esc_html_e('Default', 'quadmenu'); ?></option>
          <?php echo $widget->themes($quadmenu['theme']); ?>
        </select>
      </p>
      <p>
        <label for="quadmenu_layout"><?php esc_html_e('Layout', 'quadmenu'); ?></label>
        <select id="quadmenu_layout" name="quadmenu[layout]" class="widefat">
          <option value=""><?php esc_html_e('Default', 'quadmenu'); ?></option>
          <?php echo $widget->layouts($quadmenu['layout']); ?>
        </select>
      </p>
      <?php
      wp_nonce_field(QUADMENU_DOMAIN, 'nonce');
    }

    function add_menu_meta_box() {
      if (current_user_can('manage_options')) {
        add_meta_box(QUADMENU_DOMAIN, esc_html(QUADMENU_PLUGIN_NAME), array($this, 'menu_meta_box'), '', 'side', 'high');
      }
    }

    function add_meta_box_parameters($args) {

      // 1326
      // agregar quadmenu theme location al metabox
      if (!empty($args['theme_location'])) {

        if (function_exists('is_shop') && is_shop()) {
          if ($quadmenu = get_post_meta(wc_get_page_id('shop'), QUADMENU_PRO_DB_KEY, true)) {
            $args = wp_parse_args($quadmenu, $args);
          }
        } elseif (!is_archive()) {
          if ($quadmenu = get_post_meta(get_queried_object_id(), QUADMENU_PRO_DB_KEY, true)) {
            $args = wp_parse_args($quadmenu, $args);
          }
        }
      }

      return $args;
    }

    function includes() {
      if (class_exists('QuadMenu')) {
        require_once 'includes/advanced.php';
        require_once 'includes/woocommerce.php';
        require_once 'includes/divi/divi.php';
      }
    }

    function init() {

      add_action('admin_notices', array($this, 'add_admin_notices'));
      add_filter('plugin_action_links_' . plugin_basename(QUADMENU_PRO_PLUGIN_FILE), array($this, 'add_action_links'));

      if (class_exists('QuadMenu')) {

        add_filter('admin_body_class', array($this, 'add_body_class'), 99);
        add_action('admin_init', array($this, 'remove_purchase_page'));
        add_action('admin_init', array($this, 'add_updater'));
        add_action('admin_init', array($this, 'add_activation'));
        add_action('admin_menu', array($this, 'add_license_page'));
        add_action('admin_init', array($this, 'add_settings_register'));
        add_action('add_meta_boxes', array($this, 'add_menu_meta_box'));
        add_action('save_post', array($this, 'save_menu_meta_box'));
        add_filter('quadmenu_get_nav_menu_args', array($this, 'add_meta_box_parameters'), 15);

        if (defined('QUADMENU_OPTIONS')) {
          add_action('redux/extensions/' . QUADMENU_OPTIONS . '/before', array($this, 'add_customizer'), 0);
        }
      }
    }

    function is_installed($path) {

      $installed_plugins = get_plugins();

      return isset($installed_plugins[$path]);
    }

    public static function instance() {
      if (!isset(self::$instance)) {
        self::$instance = new self();
        self::$instance->init();
        self::$instance->includes();
      }
      return self::$instance;
    }

  }

  add_action('plugins_loaded', array('QuadMenu_PRO', 'instance'));

  if (!function_exists('is_quadmenu_installed')) {

    function is_quadmenu_installed() {

      $file_path = 'quadmenu/quadmenu.php';

      $installed_plugins = get_plugins();

      return isset($installed_plugins[$file_path]);
    }

  }
}