<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

?>
<span id="pwbe-dialog-content-images" class="pwbe-dialog-content" data-function="pwbeBulkEditorImagesSelectHandler">
    <fieldset id="pwbe-bulkedit-images-mode">
        <input type="radio" value="select" name="pwbe-bulkedit-images-mode" id="pwbe-bulkedit-images-mode-select" /> <label for="pwbe-bulkedit-images-mode-select"><?php _e( 'Specific images', 'pw-bulk-edit' ); ?></label><br />
        <input type="radio" value="add" name="pwbe-bulkedit-images-mode" id="pwbe-bulkedit-images-mode-add" /> <label for="pwbe-bulkedit-images-mode-add"><?php _e( 'Add images', 'pw-bulk-edit' ); ?></label><br />
        <input type="radio" value="remove" name="pwbe-bulkedit-images-mode" id="pwbe-bulkedit-images-mode-remove" /> <label for="pwbe-bulkedit-images-mode-remove"><?php _e( 'Remove images', 'pw-bulk-edit' ); ?></label><br />
        <input type="radio" value="clear" name="pwbe-bulkedit-images-mode" id="pwbe-bulkedit-images-mode-clear" /> <label for="pwbe-bulkedit-images-mode-clear"><?php _e( 'Clear images', 'pw-bulk-edit' ); ?></label><br />
    </fieldset>
    <div id="pwbe-bulkedit-details-images-container">
        <div>
            <div class="pwbe-bulkedit-details pwbe-bulkedit-details-images">
                <label class="pwbe-bulkedit-details-text-select" for="pwbe-dialog-select-images-container"><?php printf( __( 'Set %s to the following images:', 'pw-bulk-edit' ), '<span class="pwbe-bulkedit-field-name"></span>' ); ?></label>
                <label class="pwbe-bulkedit-details-text-add" for="pwbe-dialog-select-images-container"><?php printf( __( 'Add these images to %s:', 'pw-bulk-edit' ), '<span class="pwbe-bulkedit-field-name"></span>' ); ?></label>
                <label class="pwbe-bulkedit-details-text-remove" for="pwbe-dialog-select-images-container"><?php printf( __( 'Remove these images from %s:', 'pw-bulk-edit' ), '<span class="pwbe-bulkedit-field-name"></span>' ); ?></label>
                <br />
                <div id="pwbe-dialog-select-images-container" data-image-ids=""></div>
                <button class="button" id="pwbe-dialog-bulk-edit-select-images"><?php _e( 'Select images', 'pw-bulk-edit' ); ?></button>
            </div>

            <div class="pwbe-bulkedit-details pwbe-bulkedit-details-clear">
                <label><?php printf( __( 'Clear the %s value.', 'pw-bulk-edit' ), '<span class="pwbe-bulkedit-field-name"></span>' ); ?></label>
            </div>
        </div>
    </div>
</span>
<style>
    #pwbe-dialog-content-images {
        white-space: nowrap;
    }

    #pwbe-bulkedit-images-mode, #pwbe-bulkedit-details-images-container {
        display: inline-block;
        vertical-align: top;
    }

    #pwbe-bulkedit-details-images-container {
        padding-left: 30px;
        min-width: 400px;
    }

    .pwbe-bulkedit-details {
        display: none;
    }
</style>
<script>
    jQuery(function() {
        jQuery('#pwbe-bulkedit-images-mode').find('input[type=radio]').on('change', function() {
            var mode = jQuery(this).val();

            jQuery('#pwbe-dialog-content-images').find('.pwbe-bulkedit-details').hide();

            var details = (mode == 'clear') ? jQuery('.pwbe-bulkedit-details-clear') : jQuery('.pwbe-bulkedit-details-images');

            details.find('label').hide();
            details.find('.pwbe-bulkedit-details-text-' + mode).show();
            details.show().find('input:first').focus();
        });

        pwbeGetImageHtml(jQuery('#pwbe-dialog-select-images-container'), '');
    });


    function pwbeBulkEditorImagesSelectHandler(action, oldValue) {
        var dialog = jQuery('#pwbe-dialog-content-images');
        var fieldName = dialog.attr('data-field-name');
        var mode = dialog.find('input[name=pwbe-bulkedit-images-mode]:checked').first();
        var selectImagesContainer = jQuery('#pwbe-dialog-select-images-container');
        var newValue = '';

        switch (action) {
            case 'init':
                dialog.find('.pwbe-bulkedit-field-name').text(fieldName);
                selectImagesContainer.text('');
                selectImagesContainer.attr('data-image-ids', '');
            break;

            case 'apply':
                if (!mode.val()) {
                    return oldValue;
                }

                var selectedImageIds = selectImagesContainer.attr('data-image-ids').split(',');
                var existingImageIds = oldValue.split(',');

                switch (mode.val()) {
                    case 'select':
                        newValue = selectedImageIds.join();
                    break;

                    case 'add':
                        newValue = existingImageIds.concat(selectedImageIds).join();
                    break;

                    case 'remove':
                        newValue = existingImageIds.filter( function( el ) {
                            return selectedImageIds.indexOf( el ) < 0;
                        } ).join();
                    break;

                    case 'clear':
                        newValue = '';
                    break;
                }

                return newValue;
            break;

            case 'reset':
                mode.prop('checked', false);
                dialog.find('.pwbe-bulkedit-details').hide();
            break;
        }
    }

    jQuery('#pwbe-dialog-bulk-edit-select-images').on('click', function(e) {
        var selectImagesContainer = jQuery('#pwbe-dialog-select-images-container');
        var image_frame;
        if (image_frame) {
            image_frame.open();
        }

        // Define image_frame as wp.media object
        image_frame = wp.media({
            title: pwbe.i18n.select_images,
            multiple : true,
            library : {
                type : 'image',
            }
        });

        image_frame.on('close',function() {
            // On close, get selections and save to the hidden input
            // plus other AJAX stuff to refresh the image preview
            var selection =  image_frame.state().get('selection');
            var gallery_ids = new Array();
            var my_index = 0;
            selection.each(function(attachment) {
                gallery_ids[my_index] = attachment['id'];
                my_index++;
            });
            var ids = gallery_ids.join(",");
            selectImagesContainer.attr('data-image-ids', ids);
            pwbeGetImageHtml(selectImagesContainer, ids);
        });

        image_frame.on('open',function() {
            // On open, get the id from the hidden input
            // and select the appropiate images in the media manager
            var selection =  image_frame.state().get('selection');
            var ids = selectImagesContainer.attr('data-image-ids').split(',');
            ids.forEach(function(id) {
                var attachment = wp.media.attachment(id);
                attachment.fetch();
                selection.add( attachment ? [ attachment ] : [] );
            });
        });

        image_frame.open();

        e.preventDefault();
        return false;
    });
</script>