/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@wordpress/api-fetch/build-module/index.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _middlewares_nonce__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./middlewares/nonce */ "./node_modules/@wordpress/api-fetch/build-module/middlewares/nonce.js");
/* harmony import */ var _middlewares_root_url__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./middlewares/root-url */ "./node_modules/@wordpress/api-fetch/build-module/middlewares/root-url.js");
/* harmony import */ var _middlewares_preloading__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./middlewares/preloading */ "./node_modules/@wordpress/api-fetch/build-module/middlewares/preloading.js");
/* harmony import */ var _middlewares_fetch_all_middleware__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./middlewares/fetch-all-middleware */ "./node_modules/@wordpress/api-fetch/build-module/middlewares/fetch-all-middleware.js");
/* harmony import */ var _middlewares_namespace_endpoint__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./middlewares/namespace-endpoint */ "./node_modules/@wordpress/api-fetch/build-module/middlewares/namespace-endpoint.js");
/* harmony import */ var _middlewares_http_v1__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./middlewares/http-v1 */ "./node_modules/@wordpress/api-fetch/build-module/middlewares/http-v1.js");
/* harmony import */ var _middlewares_user_locale__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./middlewares/user-locale */ "./node_modules/@wordpress/api-fetch/build-module/middlewares/user-locale.js");
/* harmony import */ var _middlewares_media_upload__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./middlewares/media-upload */ "./node_modules/@wordpress/api-fetch/build-module/middlewares/media-upload.js");
/* harmony import */ var _middlewares_theme_preview__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./middlewares/theme-preview */ "./node_modules/@wordpress/api-fetch/build-module/middlewares/theme-preview.js");
/* harmony import */ var _utils_response__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./utils/response */ "./node_modules/@wordpress/api-fetch/build-module/utils/response.js");
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */











/**
 * Default set of header values which should be sent with every request unless
 * explicitly provided through apiFetch options.
 *
 * @type {Record<string, string>}
 */
const DEFAULT_HEADERS = {
  // The backend uses the Accept header as a condition for considering an
  // incoming request as a REST request.
  //
  // See: https://core.trac.wordpress.org/ticket/44534
  Accept: 'application/json, */*;q=0.1'
};

/**
 * Default set of fetch option values which should be sent with every request
 * unless explicitly provided through apiFetch options.
 *
 * @type {Object}
 */
const DEFAULT_OPTIONS = {
  credentials: 'include'
};

/** @typedef {import('./types').APIFetchMiddleware} APIFetchMiddleware */
/** @typedef {import('./types').APIFetchOptions} APIFetchOptions */

/**
 * @type {import('./types').APIFetchMiddleware[]}
 */
const middlewares = [_middlewares_user_locale__WEBPACK_IMPORTED_MODULE_7__["default"], _middlewares_namespace_endpoint__WEBPACK_IMPORTED_MODULE_5__["default"], _middlewares_http_v1__WEBPACK_IMPORTED_MODULE_6__["default"], _middlewares_fetch_all_middleware__WEBPACK_IMPORTED_MODULE_4__["default"]];

/**
 * Register a middleware
 *
 * @param {import('./types').APIFetchMiddleware} middleware
 */
function registerMiddleware(middleware) {
  middlewares.unshift(middleware);
}

/**
 * Checks the status of a response, throwing the Response as an error if
 * it is outside the 200 range.
 *
 * @param {Response} response
 * @return {Response} The response if the status is in the 200 range.
 */
const checkStatus = response => {
  if (response.status >= 200 && response.status < 300) {
    return response;
  }
  throw response;
};

/** @typedef {(options: import('./types').APIFetchOptions) => Promise<any>} FetchHandler*/

/**
 * @type {FetchHandler}
 */
const defaultFetchHandler = nextOptions => {
  const {
    url,
    path,
    data,
    parse = true,
    ...remainingOptions
  } = nextOptions;
  let {
    body,
    headers
  } = nextOptions;

  // Merge explicitly-provided headers with default values.
  headers = {
    ...DEFAULT_HEADERS,
    ...headers
  };

  // The `data` property is a shorthand for sending a JSON body.
  if (data) {
    body = JSON.stringify(data);
    headers['Content-Type'] = 'application/json';
  }
  const responsePromise = window.fetch(
  // Fall back to explicitly passing `window.location` which is the behavior if `undefined` is passed.
  url || path || window.location.href, {
    ...DEFAULT_OPTIONS,
    ...remainingOptions,
    body,
    headers
  });
  return responsePromise.then(value => Promise.resolve(value).then(checkStatus).catch(response => (0,_utils_response__WEBPACK_IMPORTED_MODULE_10__.parseAndThrowError)(response, parse)).then(response => (0,_utils_response__WEBPACK_IMPORTED_MODULE_10__.parseResponseAndNormalizeError)(response, parse)), err => {
    // Re-throw AbortError for the users to handle it themselves.
    if (err && err.name === 'AbortError') {
      throw err;
    }

    // Otherwise, there is most likely no network connection.
    // Unfortunately the message might depend on the browser.
    throw {
      code: 'fetch_error',
      message: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You are probably offline.')
    };
  });
};

/** @type {FetchHandler} */
let fetchHandler = defaultFetchHandler;

/**
 * Defines a custom fetch handler for making the requests that will override
 * the default one using window.fetch
 *
 * @param {FetchHandler} newFetchHandler The new fetch handler
 */
function setFetchHandler(newFetchHandler) {
  fetchHandler = newFetchHandler;
}

/**
 * @template T
 * @param {import('./types').APIFetchOptions} options
 * @return {Promise<T>} A promise representing the request processed via the registered middlewares.
 */
function apiFetch(options) {
  // creates a nested function chain that calls all middlewares and finally the `fetchHandler`,
  // converting `middlewares = [ m1, m2, m3 ]` into:
  // ```
  // opts1 => m1( opts1, opts2 => m2( opts2, opts3 => m3( opts3, fetchHandler ) ) );
  // ```
  const enhancedHandler = middlewares.reduceRight(( /** @type {FetchHandler} */next, middleware) => {
    return workingOptions => middleware(workingOptions, next);
  }, fetchHandler);
  return enhancedHandler(options).catch(error => {
    if (error.code !== 'rest_cookie_invalid_nonce') {
      return Promise.reject(error);
    }

    // If the nonce is invalid, refresh it and try again.
    return window
    // @ts-ignore
    .fetch(apiFetch.nonceEndpoint).then(checkStatus).then(data => data.text()).then(text => {
      // @ts-ignore
      apiFetch.nonceMiddleware.nonce = text;
      return apiFetch(options);
    });
  });
}
apiFetch.use = registerMiddleware;
apiFetch.setFetchHandler = setFetchHandler;
apiFetch.createNonceMiddleware = _middlewares_nonce__WEBPACK_IMPORTED_MODULE_1__["default"];
apiFetch.createPreloadingMiddleware = _middlewares_preloading__WEBPACK_IMPORTED_MODULE_3__["default"];
apiFetch.createRootURLMiddleware = _middlewares_root_url__WEBPACK_IMPORTED_MODULE_2__["default"];
apiFetch.fetchAllMiddleware = _middlewares_fetch_all_middleware__WEBPACK_IMPORTED_MODULE_4__["default"];
apiFetch.mediaUploadMiddleware = _middlewares_media_upload__WEBPACK_IMPORTED_MODULE_8__["default"];
apiFetch.createThemePreviewMiddleware = _middlewares_theme_preview__WEBPACK_IMPORTED_MODULE_9__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (apiFetch);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build-module/middlewares/fetch-all-middleware.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/middlewares/fetch-all-middleware.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/url */ "@wordpress/url");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_url__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./node_modules/@wordpress/api-fetch/build-module/index.js");
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Apply query arguments to both URL and Path, whichever is present.
 *
 * @param {import('../types').APIFetchOptions} props
 * @param {Record<string, string | number>}    queryArgs
 * @return {import('../types').APIFetchOptions} The request with the modified query args
 */
const modifyQuery = ({
  path,
  url,
  ...options
}, queryArgs) => ({
  ...options,
  url: url && (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.addQueryArgs)(url, queryArgs),
  path: path && (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.addQueryArgs)(path, queryArgs)
});

/**
 * Duplicates parsing functionality from apiFetch.
 *
 * @param {Response} response
 * @return {Promise<any>} Parsed response json.
 */
const parseResponse = response => response.json ? response.json() : Promise.reject(response);

/**
 * @param {string | null} linkHeader
 * @return {{ next?: string }} The parsed link header.
 */
const parseLinkHeader = linkHeader => {
  if (!linkHeader) {
    return {};
  }
  const match = linkHeader.match(/<([^>]+)>; rel="next"/);
  return match ? {
    next: match[1]
  } : {};
};

/**
 * @param {Response} response
 * @return {string | undefined} The next page URL.
 */
const getNextPageUrl = response => {
  const {
    next
  } = parseLinkHeader(response.headers.get('link'));
  return next;
};

/**
 * @param {import('../types').APIFetchOptions} options
 * @return {boolean} True if the request contains an unbounded query.
 */
const requestContainsUnboundedQuery = options => {
  const pathIsUnbounded = !!options.path && options.path.indexOf('per_page=-1') !== -1;
  const urlIsUnbounded = !!options.url && options.url.indexOf('per_page=-1') !== -1;
  return pathIsUnbounded || urlIsUnbounded;
};

/**
 * The REST API enforces an upper limit on the per_page option. To handle large
 * collections, apiFetch consumers can pass `per_page=-1`; this middleware will
 * then recursively assemble a full response array from all available pages.
 *
 * @type {import('../types').APIFetchMiddleware}
 */
const fetchAllMiddleware = async (options, next) => {
  if (options.parse === false) {
    // If a consumer has opted out of parsing, do not apply middleware.
    return next(options);
  }
  if (!requestContainsUnboundedQuery(options)) {
    // If neither url nor path is requesting all items, do not apply middleware.
    return next(options);
  }

  // Retrieve requested page of results.
  const response = await (0,___WEBPACK_IMPORTED_MODULE_1__["default"])({
    ...modifyQuery(options, {
      per_page: 100
    }),
    // Ensure headers are returned for page 1.
    parse: false
  });
  const results = await parseResponse(response);
  if (!Array.isArray(results)) {
    // We have no reliable way of merging non-array results.
    return results;
  }
  let nextPage = getNextPageUrl(response);
  if (!nextPage) {
    // There are no further pages to request.
    return results;
  }

  // Iteratively fetch all remaining pages until no "next" header is found.
  let mergedResults = /** @type {any[]} */[].concat(results);
  while (nextPage) {
    const nextResponse = await (0,___WEBPACK_IMPORTED_MODULE_1__["default"])({
      ...options,
      // Ensure the URL for the next page is used instead of any provided path.
      path: undefined,
      url: nextPage,
      // Ensure we still get headers so we can identify the next page.
      parse: false
    });
    const nextResults = await parseResponse(nextResponse);
    mergedResults = mergedResults.concat(nextResults);
    nextPage = getNextPageUrl(nextResponse);
  }
  return mergedResults;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (fetchAllMiddleware);
//# sourceMappingURL=fetch-all-middleware.js.map

/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build-module/middlewares/http-v1.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/middlewares/http-v1.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Set of HTTP methods which are eligible to be overridden.
 *
 * @type {Set<string>}
 */
const OVERRIDE_METHODS = new Set(['PATCH', 'PUT', 'DELETE']);

/**
 * Default request method.
 *
 * "A request has an associated method (a method). Unless stated otherwise it
 * is `GET`."
 *
 * @see  https://fetch.spec.whatwg.org/#requests
 *
 * @type {string}
 */
const DEFAULT_METHOD = 'GET';

/**
 * API Fetch middleware which overrides the request method for HTTP v1
 * compatibility leveraging the REST API X-HTTP-Method-Override header.
 *
 * @type {import('../types').APIFetchMiddleware}
 */
const httpV1Middleware = (options, next) => {
  const {
    method = DEFAULT_METHOD
  } = options;
  if (OVERRIDE_METHODS.has(method.toUpperCase())) {
    options = {
      ...options,
      headers: {
        ...options.headers,
        'X-HTTP-Method-Override': method,
        'Content-Type': 'application/json'
      },
      method: 'POST'
    };
  }
  return next(options);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (httpV1Middleware);
//# sourceMappingURL=http-v1.js.map

/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build-module/middlewares/media-upload.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/middlewares/media-upload.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_response__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/response */ "./node_modules/@wordpress/api-fetch/build-module/utils/response.js");
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * @param {import('../types').APIFetchOptions} options
 * @return {boolean} True if the request is for media upload.
 */
function isMediaUploadRequest(options) {
  const isCreateMethod = !!options.method && options.method === 'POST';
  const isMediaEndpoint = !!options.path && options.path.indexOf('/wp/v2/media') !== -1 || !!options.url && options.url.indexOf('/wp/v2/media') !== -1;
  return isMediaEndpoint && isCreateMethod;
}

/**
 * Middleware handling media upload failures and retries.
 *
 * @type {import('../types').APIFetchMiddleware}
 */
const mediaUploadMiddleware = (options, next) => {
  if (!isMediaUploadRequest(options)) {
    return next(options);
  }
  let retries = 0;
  const maxRetries = 5;

  /**
   * @param {string} attachmentId
   * @return {Promise<any>} Processed post response.
   */
  const postProcess = attachmentId => {
    retries++;
    return next({
      path: `/wp/v2/media/${attachmentId}/post-process`,
      method: 'POST',
      data: {
        action: 'create-image-subsizes'
      },
      parse: false
    }).catch(() => {
      if (retries < maxRetries) {
        return postProcess(attachmentId);
      }
      next({
        path: `/wp/v2/media/${attachmentId}?force=true`,
        method: 'DELETE'
      });
      return Promise.reject();
    });
  };
  return next({
    ...options,
    parse: false
  }).catch(response => {
    const attachmentId = response.headers.get('x-wp-upload-attachment-id');
    if (response.status >= 500 && response.status < 600 && attachmentId) {
      return postProcess(attachmentId).catch(() => {
        if (options.parse !== false) {
          return Promise.reject({
            code: 'post_process',
            message: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Media upload failed. If this is a photo or a large image, please scale it down and try again.')
          });
        }
        return Promise.reject(response);
      });
    }
    return (0,_utils_response__WEBPACK_IMPORTED_MODULE_1__.parseAndThrowError)(response, options.parse);
  }).then(response => (0,_utils_response__WEBPACK_IMPORTED_MODULE_1__.parseResponseAndNormalizeError)(response, options.parse));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (mediaUploadMiddleware);
//# sourceMappingURL=media-upload.js.map

/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build-module/middlewares/namespace-endpoint.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/middlewares/namespace-endpoint.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * @type {import('../types').APIFetchMiddleware}
 */
const namespaceAndEndpointMiddleware = (options, next) => {
  let path = options.path;
  let namespaceTrimmed, endpointTrimmed;
  if (typeof options.namespace === 'string' && typeof options.endpoint === 'string') {
    namespaceTrimmed = options.namespace.replace(/^\/|\/$/g, '');
    endpointTrimmed = options.endpoint.replace(/^\//, '');
    if (endpointTrimmed) {
      path = namespaceTrimmed + '/' + endpointTrimmed;
    } else {
      path = namespaceTrimmed;
    }
  }
  delete options.namespace;
  delete options.endpoint;
  return next({
    ...options,
    path
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (namespaceAndEndpointMiddleware);
//# sourceMappingURL=namespace-endpoint.js.map

/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build-module/middlewares/nonce.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/middlewares/nonce.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * @param {string} nonce
 * @return {import('../types').APIFetchMiddleware & { nonce: string }} A middleware to enhance a request with a nonce.
 */
function createNonceMiddleware(nonce) {
  /**
   * @type {import('../types').APIFetchMiddleware & { nonce: string }}
   */
  const middleware = (options, next) => {
    const {
      headers = {}
    } = options;

    // If an 'X-WP-Nonce' header (or any case-insensitive variation
    // thereof) was specified, no need to add a nonce header.
    for (const headerName in headers) {
      if (headerName.toLowerCase() === 'x-wp-nonce' && headers[headerName] === middleware.nonce) {
        return next(options);
      }
    }
    return next({
      ...options,
      headers: {
        ...headers,
        'X-WP-Nonce': middleware.nonce
      }
    });
  };
  middleware.nonce = nonce;
  return middleware;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createNonceMiddleware);
//# sourceMappingURL=nonce.js.map

/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build-module/middlewares/preloading.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/middlewares/preloading.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/url */ "@wordpress/url");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_url__WEBPACK_IMPORTED_MODULE_0__);
/**
 * WordPress dependencies
 */


/**
 * @param {Record<string, any>} preloadedData
 * @return {import('../types').APIFetchMiddleware} Preloading middleware.
 */
function createPreloadingMiddleware(preloadedData) {
  const cache = Object.fromEntries(Object.entries(preloadedData).map(([path, data]) => [(0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.normalizePath)(path), data]));
  return (options, next) => {
    const {
      parse = true
    } = options;
    /** @type {string | void} */
    let rawPath = options.path;
    if (!rawPath && options.url) {
      const {
        rest_route: pathFromQuery,
        ...queryArgs
      } = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.getQueryArgs)(options.url);
      if (typeof pathFromQuery === 'string') {
        rawPath = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.addQueryArgs)(pathFromQuery, queryArgs);
      }
    }
    if (typeof rawPath !== 'string') {
      return next(options);
    }
    const method = options.method || 'GET';
    const path = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.normalizePath)(rawPath);
    if ('GET' === method && cache[path]) {
      const cacheData = cache[path];

      // Unsetting the cache key ensures that the data is only used a single time.
      delete cache[path];
      return prepareResponse(cacheData, !!parse);
    } else if ('OPTIONS' === method && cache[method] && cache[method][path]) {
      const cacheData = cache[method][path];

      // Unsetting the cache key ensures that the data is only used a single time.
      delete cache[method][path];
      return prepareResponse(cacheData, !!parse);
    }
    return next(options);
  };
}

/**
 * This is a helper function that sends a success response.
 *
 * @param {Record<string, any>} responseData
 * @param {boolean}             parse
 * @return {Promise<any>} Promise with the response.
 */
function prepareResponse(responseData, parse) {
  return Promise.resolve(parse ? responseData.body : new window.Response(JSON.stringify(responseData.body), {
    status: 200,
    statusText: 'OK',
    headers: responseData.headers
  }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createPreloadingMiddleware);
//# sourceMappingURL=preloading.js.map

/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build-module/middlewares/root-url.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/middlewares/root-url.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _namespace_endpoint__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./namespace-endpoint */ "./node_modules/@wordpress/api-fetch/build-module/middlewares/namespace-endpoint.js");
/**
 * Internal dependencies
 */


/**
 * @param {string} rootURL
 * @return {import('../types').APIFetchMiddleware} Root URL middleware.
 */
const createRootURLMiddleware = rootURL => (options, next) => {
  return (0,_namespace_endpoint__WEBPACK_IMPORTED_MODULE_0__["default"])(options, optionsWithPath => {
    let url = optionsWithPath.url;
    let path = optionsWithPath.path;
    let apiRoot;
    if (typeof path === 'string') {
      apiRoot = rootURL;
      if (-1 !== rootURL.indexOf('?')) {
        path = path.replace('?', '&');
      }
      path = path.replace(/^\//, '');

      // API root may already include query parameter prefix if site is
      // configured to use plain permalinks.
      if ('string' === typeof apiRoot && -1 !== apiRoot.indexOf('?')) {
        path = path.replace('?', '&');
      }
      url = apiRoot + path;
    }
    return next({
      ...optionsWithPath,
      url
    });
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createRootURLMiddleware);
//# sourceMappingURL=root-url.js.map

/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build-module/middlewares/theme-preview.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/middlewares/theme-preview.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/url */ "@wordpress/url");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_url__WEBPACK_IMPORTED_MODULE_0__);
/**
 * WordPress dependencies
 */


/**
 * This appends a `wp_theme_preview` parameter to the REST API request URL if
 * the admin URL contains a `theme` GET parameter.
 *
 * If the REST API request URL has contained the `wp_theme_preview` parameter as `''`,
 * then bypass this middleware.
 *
 * @param {Record<string, any>} themePath
 * @return {import('../types').APIFetchMiddleware} Preloading middleware.
 */
const createThemePreviewMiddleware = themePath => (options, next) => {
  if (typeof options.url === 'string') {
    const wpThemePreview = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.getQueryArg)(options.url, 'wp_theme_preview');
    if (wpThemePreview === undefined) {
      options.url = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.addQueryArgs)(options.url, {
        wp_theme_preview: themePath
      });
    } else if (wpThemePreview === '') {
      options.url = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.removeQueryArgs)(options.url, 'wp_theme_preview');
    }
  }
  if (typeof options.path === 'string') {
    const wpThemePreview = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.getQueryArg)(options.path, 'wp_theme_preview');
    if (wpThemePreview === undefined) {
      options.path = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.addQueryArgs)(options.path, {
        wp_theme_preview: themePath
      });
    } else if (wpThemePreview === '') {
      options.path = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.removeQueryArgs)(options.path, 'wp_theme_preview');
    }
  }
  return next(options);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createThemePreviewMiddleware);
//# sourceMappingURL=theme-preview.js.map

/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build-module/middlewares/user-locale.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/middlewares/user-locale.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/url */ "@wordpress/url");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_url__WEBPACK_IMPORTED_MODULE_0__);
/**
 * WordPress dependencies
 */


/**
 * @type {import('../types').APIFetchMiddleware}
 */
const userLocaleMiddleware = (options, next) => {
  if (typeof options.url === 'string' && !(0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.hasQueryArg)(options.url, '_locale')) {
    options.url = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.addQueryArgs)(options.url, {
      _locale: 'user'
    });
  }
  if (typeof options.path === 'string' && !(0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.hasQueryArg)(options.path, '_locale')) {
    options.path = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.addQueryArgs)(options.path, {
      _locale: 'user'
    });
  }
  return next(options);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (userLocaleMiddleware);
//# sourceMappingURL=user-locale.js.map

/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build-module/utils/response.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/utils/response.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseAndThrowError: () => (/* binding */ parseAndThrowError),
/* harmony export */   parseResponseAndNormalizeError: () => (/* binding */ parseResponseAndNormalizeError)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/**
 * WordPress dependencies
 */


/**
 * Parses the apiFetch response.
 *
 * @param {Response} response
 * @param {boolean}  shouldParseResponse
 *
 * @return {Promise<any> | null | Response} Parsed response.
 */
const parseResponse = (response, shouldParseResponse = true) => {
  if (shouldParseResponse) {
    if (response.status === 204) {
      return null;
    }
    return response.json ? response.json() : Promise.reject(response);
  }
  return response;
};

/**
 * Calls the `json` function on the Response, throwing an error if the response
 * doesn't have a json function or if parsing the json itself fails.
 *
 * @param {Response} response
 * @return {Promise<any>} Parsed response.
 */
const parseJsonAndNormalizeError = response => {
  const invalidJsonError = {
    code: 'invalid_json',
    message: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The response is not a valid JSON response.')
  };
  if (!response || !response.json) {
    throw invalidJsonError;
  }
  return response.json().catch(() => {
    throw invalidJsonError;
  });
};

/**
 * Parses the apiFetch response properly and normalize response errors.
 *
 * @param {Response} response
 * @param {boolean}  shouldParseResponse
 *
 * @return {Promise<any>} Parsed response.
 */
const parseResponseAndNormalizeError = (response, shouldParseResponse = true) => {
  return Promise.resolve(parseResponse(response, shouldParseResponse)).catch(res => parseAndThrowError(res, shouldParseResponse));
};

/**
 * Parses a response, throwing an error if parsing the response fails.
 *
 * @param {Response} response
 * @param {boolean}  shouldParseResponse
 * @return {Promise<any>} Parsed response.
 */
function parseAndThrowError(response, shouldParseResponse = true) {
  if (!shouldParseResponse) {
    throw response;
  }
  return parseJsonAndNormalizeError(response).then(error => {
    const unknownError = {
      code: 'unknown_error',
      message: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('An unknown error occurred.')
    };
    throw error || unknownError;
  });
}
//# sourceMappingURL=response.js.map

/***/ }),

/***/ "./node_modules/@wordpress/data-controls/build-module/index.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/data-controls/build-module/index.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __unstableAwaitPromise: () => (/* binding */ __unstableAwaitPromise),
/* harmony export */   apiFetch: () => (/* binding */ apiFetch),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   dispatch: () => (/* binding */ dispatch),
/* harmony export */   select: () => (/* binding */ select),
/* harmony export */   syncSelect: () => (/* binding */ syncSelect)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch */ "./node_modules/@wordpress/api-fetch/build-module/index.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_deprecated__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/deprecated */ "./node_modules/@wordpress/data-controls/node_modules/@wordpress/deprecated/build-module/index.js");
/**
 * WordPress dependencies
 */



/**
 * Dispatches a control action for triggering an api fetch call.
 *
 * @param {Object} request Arguments for the fetch request.
 *
 * @example
 * ```js
 * import { apiFetch } from '@wordpress/data-controls';
 *
 * // Action generator using apiFetch
 * export function* myAction() {
 * 	const path = '/v2/my-api/items';
 * 	const items = yield apiFetch( { path } );
 * 	// do something with the items.
 * }
 * ```
 *
 * @return {Object} The control descriptor.
 */
function apiFetch(request) {
  return {
    type: 'API_FETCH',
    request
  };
}

/**
 * Control for resolving a selector in a registered data store.
 * Alias for the `resolveSelect` built-in control in the `@wordpress/data` package.
 *
 * @param storeNameOrDescriptor The store object or identifier.
 * @param selectorName          The selector name.
 * @param args                  Arguments passed without change to the `@wordpress/data` control.
 */
function select(storeNameOrDescriptor, selectorName, ...args) {
  (0,_wordpress_deprecated__WEBPACK_IMPORTED_MODULE_2__["default"])('`select` control in `@wordpress/data-controls`', {
    since: '5.7',
    alternative: 'built-in `resolveSelect` control in `@wordpress/data`'
  });
  return _wordpress_data__WEBPACK_IMPORTED_MODULE_1__.controls.resolveSelect(storeNameOrDescriptor, selectorName, ...args);
}

/**
 * Control for calling a selector in a registered data store.
 * Alias for the `select` built-in control in the `@wordpress/data` package.
 *
 * @param storeNameOrDescriptor The store object or identifier.
 * @param selectorName          The selector name.
 * @param args                  Arguments passed without change to the `@wordpress/data` control.
 */
function syncSelect(storeNameOrDescriptor, selectorName, ...args) {
  (0,_wordpress_deprecated__WEBPACK_IMPORTED_MODULE_2__["default"])('`syncSelect` control in `@wordpress/data-controls`', {
    since: '5.7',
    alternative: 'built-in `select` control in `@wordpress/data`'
  });
  return _wordpress_data__WEBPACK_IMPORTED_MODULE_1__.controls.select(storeNameOrDescriptor, selectorName, ...args);
}

/**
 * Control for dispatching an action in a registered data store.
 * Alias for the `dispatch` control in the `@wordpress/data` package.
 *
 * @param storeNameOrDescriptor The store object or identifier.
 * @param actionName            The action name.
 * @param args                  Arguments passed without change to the `@wordpress/data` control.
 */
function dispatch(storeNameOrDescriptor, actionName, ...args) {
  (0,_wordpress_deprecated__WEBPACK_IMPORTED_MODULE_2__["default"])('`dispatch` control in `@wordpress/data-controls`', {
    since: '5.7',
    alternative: 'built-in `dispatch` control in `@wordpress/data`'
  });
  return _wordpress_data__WEBPACK_IMPORTED_MODULE_1__.controls.dispatch(storeNameOrDescriptor, actionName, ...args);
}

/**
 * Dispatches a control action for awaiting on a promise to be resolved.
 *
 * @param {Object} promise Promise to wait for.
 *
 * @example
 * ```js
 * import { __unstableAwaitPromise } from '@wordpress/data-controls';
 *
 * // Action generator using apiFetch
 * export function* myAction() {
 * 	const promise = getItemsAsync();
 * 	const items = yield __unstableAwaitPromise( promise );
 * 	// do something with the items.
 * }
 * ```
 *
 * @return {Object} The control descriptor.
 */
const __unstableAwaitPromise = function (promise) {
  return {
    type: 'AWAIT_PROMISE',
    promise
  };
};

/**
 * The default export is what you use to register the controls with your custom
 * store.
 *
 * @example
 * ```js
 * // WordPress dependencies
 * import { controls } from '@wordpress/data-controls';
 * import { registerStore } from '@wordpress/data';
 *
 * // Internal dependencies
 * import reducer from './reducer';
 * import * as selectors from './selectors';
 * import * as actions from './actions';
 * import * as resolvers from './resolvers';
 *
 * registerStore( 'my-custom-store', {
 * reducer,
 * controls,
 * actions,
 * selectors,
 * resolvers,
 * } );
 * ```
 * @return {Object} An object for registering the default controls with the
 * store.
 */
const controls = {
  AWAIT_PROMISE: ({
    promise
  }) => promise,
  API_FETCH({
    request
  }) {
    return (0,_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__["default"])(request);
  }
};
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@wordpress/data-controls/node_modules/@wordpress/deprecated/build-module/index.js":
/*!********************************************************************************************************!*\
  !*** ./node_modules/@wordpress/data-controls/node_modules/@wordpress/deprecated/build-module/index.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ deprecated),
/* harmony export */   logged: () => (/* binding */ logged)
/* harmony export */ });
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_0__);
/**
 * WordPress dependencies
 */


/**
 * Object map tracking messages which have been logged, for use in ensuring a
 * message is only logged once.
 *
 * @type {Record<string, true | undefined>}
 */
const logged = Object.create(null);

/**
 * Logs a message to notify developers about a deprecated feature.
 *
 * @param {string} feature               Name of the deprecated feature.
 * @param {Object} [options]             Personalisation options
 * @param {string} [options.since]       Version in which the feature was deprecated.
 * @param {string} [options.version]     Version in which the feature will be removed.
 * @param {string} [options.alternative] Feature to use instead
 * @param {string} [options.plugin]      Plugin name if it's a plugin feature
 * @param {string} [options.link]        Link to documentation
 * @param {string} [options.hint]        Additional message to help transition away from the deprecated feature.
 *
 * @example
 * ```js
 * import deprecated from '@wordpress/deprecated';
 *
 * deprecated( 'Eating meat', {
 * 	since: '2019.01.01'
 * 	version: '2020.01.01',
 * 	alternative: 'vegetables',
 * 	plugin: 'the earth',
 * 	hint: 'You may find it beneficial to transition gradually.',
 * } );
 *
 * // Logs: 'Eating meat is deprecated since version 2019.01.01 and will be removed from the earth in version 2020.01.01. Please use vegetables instead. Note: You may find it beneficial to transition gradually.'
 * ```
 */
function deprecated(feature, options = {}) {
  const {
    since,
    version,
    alternative,
    plugin,
    link,
    hint
  } = options;
  const pluginMessage = plugin ? ` from ${plugin}` : '';
  const sinceMessage = since ? ` since version ${since}` : '';
  const versionMessage = version ? ` and will be removed${pluginMessage} in version ${version}` : '';
  const useInsteadMessage = alternative ? ` Please use ${alternative} instead.` : '';
  const linkMessage = link ? ` See: ${link}` : '';
  const hintMessage = hint ? ` Note: ${hint}` : '';
  const message = `${feature} is deprecated${sinceMessage}${versionMessage}.${useInsteadMessage}${linkMessage}${hintMessage}`;

  // Skip if already logged.
  if (message in logged) {
    return;
  }

  /**
   * Fires whenever a deprecated feature is encountered
   *
   * @param {string}  feature             Name of the deprecated feature.
   * @param {?Object} options             Personalisation options
   * @param {string}  options.since       Version in which the feature was deprecated.
   * @param {?string} options.version     Version in which the feature will be removed.
   * @param {?string} options.alternative Feature to use instead
   * @param {?string} options.plugin      Plugin name if it's a plugin feature
   * @param {?string} options.link        Link to documentation
   * @param {?string} options.hint        Additional message to help transition away from the deprecated feature.
   * @param {?string} message             Message sent to console.warn
   */
  (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_0__.doAction)('deprecated', feature, options, message);

  // eslint-disable-next-line no-console
  console.warn(message);
  logged[message] = true;
}

/** @typedef {import('utility-types').NonUndefined<Parameters<typeof deprecated>[1]>} DeprecatedOptions */
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/postcss-loader/dist/cjs.js!./src/assets/jsx/notifications/css/admin-notifications-overlay.css":
/*!**********************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/postcss-loader/dist/cjs.js!./src/assets/jsx/notifications/css/admin-notifications-overlay.css ***!
  \**********************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `#ppfuture-admin-notifications-overlay {
    position: fixed;
    top: 32px;
    left: 0;
    width: 100%;
    height: calc(100vh - 32px);
    background: rgba(0, 0, 0, 0.5);
    z-index: 99998;
    opacity: 1;
    visibility: visible;
    pointer-events: all;
    transition: opacity 0.3s ease, visibility 0.3s ease;
}

#ppfuture-admin-notifications-overlay.is-hidden {
    opacity: 0;
    visibility: hidden;
    pointer-events: none;
}
`, "",{"version":3,"sources":["webpack://./src/assets/jsx/notifications/css/admin-notifications-overlay.css"],"names":[],"mappings":"AAAA;IACI,eAAe;IACf,SAAS;IACT,OAAO;IACP,WAAW;IACX,0BAA0B;IAC1B,8BAA8B;IAC9B,cAAc;IACd,UAAU;IACV,mBAAmB;IACnB,mBAAmB;IACnB,mDAAmD;AACvD;;AAEA;IACI,UAAU;IACV,kBAAkB;IAClB,oBAAoB;AACxB","sourcesContent":["#ppfuture-admin-notifications-overlay {\r\n    position: fixed;\r\n    top: 32px;\r\n    left: 0;\r\n    width: 100%;\r\n    height: calc(100vh - 32px);\r\n    background: rgba(0, 0, 0, 0.5);\r\n    z-index: 99998;\r\n    opacity: 1;\r\n    visibility: visible;\r\n    pointer-events: all;\r\n    transition: opacity 0.3s ease, visibility 0.3s ease;\r\n}\r\n\r\n#ppfuture-admin-notifications-overlay.is-hidden {\r\n    opacity: 0;\r\n    visibility: hidden;\r\n    pointer-events: none;\r\n}\r\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/postcss-loader/dist/cjs.js!./src/assets/jsx/notifications/css/admin-notifications-sidebar.css":
/*!**********************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/postcss-loader/dist/cjs.js!./src/assets/jsx/notifications/css/admin-notifications-sidebar.css ***!
  \**********************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/* SIDEBAR */

#ppfuture-admin-notifications-sidebar-wrapper {
    position: fixed;
    top: 32px;
    width: 620px;
    height: calc(100vh - 32px);
    background: #1d2327;
    box-shadow: -2px 0 5px rgba(0, 0, 0, 0.1);
    z-index: 99999;
    overflow-y: auto;
    padding: 10px;
    padding-top: 0;
    transition: right 0.3s ease-in-out;
    scrollbar-color: rgb(51, 51, 51, 0.3) rgb(255, 255, 255);
    scrollbar-width: thin;
}

#ppfuture-admin-notifications-sidebar-wrapper.is-open {
    right: 0;
}

#ppfuture-admin-notifications-sidebar-wrapper.is-closed {
    right: -680px;
}

/* NOTICES */

.ppfuture-admin-notifications-notice {
    margin-bottom: 10px;
    padding-left: 15px !important;
    min-width: 90% !important;
    padding-right: 38px;
    background: #fff;
    border: 1px solid #c3c4c7;
    border-left-width: 4px;
    box-shadow: 0 1px 1px rgba(0, 0, 0, 0.04);
    padding: 10px 12px;
}

.ppfuture-admin-notifications-notice-content {
    display: flex;
    flex-direction: column;
    align-items: flex-start;
    justify-content: space-between;
}

.ppfuture-admin-notifications-notice-timestamp {
    display: flex;
    flex-direction: row;
    align-items: center;
    justify-content: space-between;
    gap: 4px;
    margin-bottom: 4px;
    color: #a8a8a8;
}

.ppfuture-admin-notifications-notice-message {
    font-size: 14px;
    color: #555d65;
    margin: 8px 0;
}

.ppfuture-admin-notifications-notice-message.unread {
    color: #3c434a;
}

.ppfuture-admin-notifications-notice-message a {
    color: #2c4364;
    text-decoration: none;
}

.ppfuture-admin-notifications-notice-message a:hover {
    color: #395b8a;
    text-decoration: underline;
}

.ppfuture-admin-notifications-notice-error {
    border-left-color: #e74c3c;
}

.ppfuture-admin-notifications-notice-success {
    border-left-color: #16a085;
}

.ppfuture-admin-notifications-notice-warning {
    border-left-color: #f6d765;
}

.ppfuture-admin-notifications-notice-info {
    border-left-color: #72aee6;
}

.ppfuture-admin-notifications-notice-default {
    border-left-color: #6b7280;
}

.ppfuture-admin-notifications-sidebar-empty-message-icon {
    display: flex;
    justify-content: center;
    align-items: center;
    height: 170px;
    width: 170px;
    background-color: #a8a8a8;
    border-radius: 50%;
    margin-bottom: 10px;
    color: #8e8e8e;
}

.ppfuture-admin-notifications-sidebar-empty-message {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    height: 100%;
}

.ppfuture-admin-notifications-sidebar-empty-message h4 {
    font-size: 24px;
    font-weight: 600;
    color: #a8a8a8;
    margin-bottom: 10px;
}

.ppfuture-admin-notifications-sidebar-empty-message p {
    font-size: 16px;
    color: #a8a8a8;
    text-align: center;
}

/* ACTIONS */

.ppfuture-admin-notifications-notice-actions {
    display: flex;
    flex-direction: row;
    align-items: right;
    justify-content: right;
    width: 100%;
    margin-bottom: 10px;
    margin-top: 10px;
    border-top: 1px solid #e6e7ec;
    padding-top: 10px;
}

.ppfuture-admin-notifications-notice-action {
    border: none;
    padding: 8px 12px;
    cursor: pointer;
    transition: background-color 0.2s ease;
    background-color: #fff;
}

.ppfuture-admin-notifications-notice-action:hover {
    color: #395b8a;
    background-color: #f0f0f0;
}

.ppfuture-admin-notifications-notice-action:active {
    background-color: #565c69;
}

.ppfuture-admin-notifications-notice-action:focus {
    outline: none;
}

.ppfuture-admin-notifications-notice-action:disabled {
    background-color: #6b7280;
}

.ppfuture-admin-notifications-notice-action .ppfuture-notifications-icon {
    margin-right: 4px;
}

.ppfuture-admin-notifications-notice-actions .ppfuture-admin-notifications-notice-action:disabled {
    background-color: #edf0f4;
    color: #878c96;
}


/* SIDEBAR ACTIONS */

.ppfuture-admin-notifications-sidebar-actions {
    display: flex;
    flex-direction: row;
    align-items: right;
    justify-content: right;
    width: 100%;
    margin-bottom: 10px;
}

.ppfuture-admin-notifications-sidebar-action {
    color: #e1e3e7;
    background-color: #1d2327;
    border: none;
    padding: 8px 12px;
    cursor: pointer;
    transition: background-color 0.2s ease;
}

.ppfuture-admin-notifications-sidebar-action:hover {
    color: #fff;
    background-color: #2d353b;
}

.ppfuture-admin-notifications-sidebar-action:active {
    background-color: #3d454b;
}

.ppfuture-admin-notifications-sidebar-action:focus {
    outline: none;
}

.ppfuture-admin-notifications-sidebar-action:disabled {
    background-color: #6b7280;
}

.ppfuture-admin-notifications-sidebar-action .ppfuture-notifications-icon {
    margin-right: 4px;
}

.ppfuture-admin-notifications-sidebar-wrapper.is-open {
    display: flex;
    flex-direction: column;
    height: 100vh;
}

.ppfuture-admin-notifications-filters {
    position: sticky;
    top: 0;
    display: flex;
    gap: 12px;
    z-index: 10;
    background: #f5f5f5;
    padding: 10px 12px;
    margin-bottom: 10px;
    border-bottom: 1px solid #ddd;
}

.ppfuture-admin-notifications-filters .components-base-control {
    flex: 1;
}

.ppfuture-admin-notifications-sidebar-wrapper.is-open > ul {
    overflow-y: auto;
    flex-grow: 1;
    padding: 0 12px;
}`, "",{"version":3,"sources":["webpack://./src/assets/jsx/notifications/css/admin-notifications-sidebar.css"],"names":[],"mappings":"AAAA,YAAY;;AAEZ;IACI,eAAe;IACf,SAAS;IACT,YAAY;IACZ,0BAA0B;IAC1B,mBAAmB;IACnB,yCAAyC;IACzC,cAAc;IACd,gBAAgB;IAChB,aAAa;IACb,cAAc;IACd,kCAAkC;IAClC,wDAAwD;IACxD,qBAAqB;AACzB;;AAEA;IACI,QAAQ;AACZ;;AAEA;IACI,aAAa;AACjB;;AAEA,YAAY;;AAEZ;IACI,mBAAmB;IACnB,6BAA6B;IAC7B,yBAAyB;IACzB,mBAAmB;IACnB,gBAAgB;IAChB,yBAAyB;IACzB,sBAAsB;IACtB,yCAAyC;IACzC,kBAAkB;AACtB;;AAEA;IACI,aAAa;IACb,sBAAsB;IACtB,uBAAuB;IACvB,8BAA8B;AAClC;;AAEA;IACI,aAAa;IACb,mBAAmB;IACnB,mBAAmB;IACnB,8BAA8B;IAC9B,QAAQ;IACR,kBAAkB;IAClB,cAAc;AAClB;;AAEA;IACI,eAAe;IACf,cAAc;IACd,aAAa;AACjB;;AAEA;IACI,cAAc;AAClB;;AAEA;IACI,cAAc;IACd,qBAAqB;AACzB;;AAEA;IACI,cAAc;IACd,0BAA0B;AAC9B;;AAEA;IACI,0BAA0B;AAC9B;;AAEA;IACI,0BAA0B;AAC9B;;AAEA;IACI,0BAA0B;AAC9B;;AAEA;IACI,0BAA0B;AAC9B;;AAEA;IACI,0BAA0B;AAC9B;;AAEA;IACI,aAAa;IACb,uBAAuB;IACvB,mBAAmB;IACnB,aAAa;IACb,YAAY;IACZ,yBAAyB;IACzB,kBAAkB;IAClB,mBAAmB;IACnB,cAAc;AAClB;;AAEA;IACI,aAAa;IACb,sBAAsB;IACtB,mBAAmB;IACnB,uBAAuB;IACvB,YAAY;AAChB;;AAEA;IACI,eAAe;IACf,gBAAgB;IAChB,cAAc;IACd,mBAAmB;AACvB;;AAEA;IACI,eAAe;IACf,cAAc;IACd,kBAAkB;AACtB;;AAEA,YAAY;;AAEZ;IACI,aAAa;IACb,mBAAmB;IACnB,kBAAkB;IAClB,sBAAsB;IACtB,WAAW;IACX,mBAAmB;IACnB,gBAAgB;IAChB,6BAA6B;IAC7B,iBAAiB;AACrB;;AAEA;IACI,YAAY;IACZ,iBAAiB;IACjB,eAAe;IACf,sCAAsC;IACtC,sBAAsB;AAC1B;;AAEA;IACI,cAAc;IACd,yBAAyB;AAC7B;;AAEA;IACI,yBAAyB;AAC7B;;AAEA;IACI,aAAa;AACjB;;AAEA;IACI,yBAAyB;AAC7B;;AAEA;IACI,iBAAiB;AACrB;;AAEA;IACI,yBAAyB;IACzB,cAAc;AAClB;;;AAGA,oBAAoB;;AAEpB;IACI,aAAa;IACb,mBAAmB;IACnB,kBAAkB;IAClB,sBAAsB;IACtB,WAAW;IACX,mBAAmB;AACvB;;AAEA;IACI,cAAc;IACd,yBAAyB;IACzB,YAAY;IACZ,iBAAiB;IACjB,eAAe;IACf,sCAAsC;AAC1C;;AAEA;IACI,WAAW;IACX,yBAAyB;AAC7B;;AAEA;IACI,yBAAyB;AAC7B;;AAEA;IACI,aAAa;AACjB;;AAEA;IACI,yBAAyB;AAC7B;;AAEA;IACI,iBAAiB;AACrB;;AAEA;IACI,aAAa;IACb,sBAAsB;IACtB,aAAa;AACjB;;AAEA;IACI,gBAAgB;IAChB,MAAM;IACN,aAAa;IACb,SAAS;IACT,WAAW;IACX,mBAAmB;IACnB,kBAAkB;IAClB,mBAAmB;IACnB,6BAA6B;AACjC;;AAEA;IACI,OAAO;AACX;;AAEA;IACI,gBAAgB;IAChB,YAAY;IACZ,eAAe;AACnB","sourcesContent":["/* SIDEBAR */\r\n\r\n#ppfuture-admin-notifications-sidebar-wrapper {\r\n    position: fixed;\r\n    top: 32px;\r\n    width: 620px;\r\n    height: calc(100vh - 32px);\r\n    background: #1d2327;\r\n    box-shadow: -2px 0 5px rgba(0, 0, 0, 0.1);\r\n    z-index: 99999;\r\n    overflow-y: auto;\r\n    padding: 10px;\r\n    padding-top: 0;\r\n    transition: right 0.3s ease-in-out;\r\n    scrollbar-color: rgb(51, 51, 51, 0.3) rgb(255, 255, 255);\r\n    scrollbar-width: thin;\r\n}\r\n\r\n#ppfuture-admin-notifications-sidebar-wrapper.is-open {\r\n    right: 0;\r\n}\r\n\r\n#ppfuture-admin-notifications-sidebar-wrapper.is-closed {\r\n    right: -680px;\r\n}\r\n\r\n/* NOTICES */\r\n\r\n.ppfuture-admin-notifications-notice {\r\n    margin-bottom: 10px;\r\n    padding-left: 15px !important;\r\n    min-width: 90% !important;\r\n    padding-right: 38px;\r\n    background: #fff;\r\n    border: 1px solid #c3c4c7;\r\n    border-left-width: 4px;\r\n    box-shadow: 0 1px 1px rgba(0, 0, 0, 0.04);\r\n    padding: 10px 12px;\r\n}\r\n\r\n.ppfuture-admin-notifications-notice-content {\r\n    display: flex;\r\n    flex-direction: column;\r\n    align-items: flex-start;\r\n    justify-content: space-between;\r\n}\r\n\r\n.ppfuture-admin-notifications-notice-timestamp {\r\n    display: flex;\r\n    flex-direction: row;\r\n    align-items: center;\r\n    justify-content: space-between;\r\n    gap: 4px;\r\n    margin-bottom: 4px;\r\n    color: #a8a8a8;\r\n}\r\n\r\n.ppfuture-admin-notifications-notice-message {\r\n    font-size: 14px;\r\n    color: #555d65;\r\n    margin: 8px 0;\r\n}\r\n\r\n.ppfuture-admin-notifications-notice-message.unread {\r\n    color: #3c434a;\r\n}\r\n\r\n.ppfuture-admin-notifications-notice-message a {\r\n    color: #2c4364;\r\n    text-decoration: none;\r\n}\r\n\r\n.ppfuture-admin-notifications-notice-message a:hover {\r\n    color: #395b8a;\r\n    text-decoration: underline;\r\n}\r\n\r\n.ppfuture-admin-notifications-notice-error {\r\n    border-left-color: #e74c3c;\r\n}\r\n\r\n.ppfuture-admin-notifications-notice-success {\r\n    border-left-color: #16a085;\r\n}\r\n\r\n.ppfuture-admin-notifications-notice-warning {\r\n    border-left-color: #f6d765;\r\n}\r\n\r\n.ppfuture-admin-notifications-notice-info {\r\n    border-left-color: #72aee6;\r\n}\r\n\r\n.ppfuture-admin-notifications-notice-default {\r\n    border-left-color: #6b7280;\r\n}\r\n\r\n.ppfuture-admin-notifications-sidebar-empty-message-icon {\r\n    display: flex;\r\n    justify-content: center;\r\n    align-items: center;\r\n    height: 170px;\r\n    width: 170px;\r\n    background-color: #a8a8a8;\r\n    border-radius: 50%;\r\n    margin-bottom: 10px;\r\n    color: #8e8e8e;\r\n}\r\n\r\n.ppfuture-admin-notifications-sidebar-empty-message {\r\n    display: flex;\r\n    flex-direction: column;\r\n    align-items: center;\r\n    justify-content: center;\r\n    height: 100%;\r\n}\r\n\r\n.ppfuture-admin-notifications-sidebar-empty-message h4 {\r\n    font-size: 24px;\r\n    font-weight: 600;\r\n    color: #a8a8a8;\r\n    margin-bottom: 10px;\r\n}\r\n\r\n.ppfuture-admin-notifications-sidebar-empty-message p {\r\n    font-size: 16px;\r\n    color: #a8a8a8;\r\n    text-align: center;\r\n}\r\n\r\n/* ACTIONS */\r\n\r\n.ppfuture-admin-notifications-notice-actions {\r\n    display: flex;\r\n    flex-direction: row;\r\n    align-items: right;\r\n    justify-content: right;\r\n    width: 100%;\r\n    margin-bottom: 10px;\r\n    margin-top: 10px;\r\n    border-top: 1px solid #e6e7ec;\r\n    padding-top: 10px;\r\n}\r\n\r\n.ppfuture-admin-notifications-notice-action {\r\n    border: none;\r\n    padding: 8px 12px;\r\n    cursor: pointer;\r\n    transition: background-color 0.2s ease;\r\n    background-color: #fff;\r\n}\r\n\r\n.ppfuture-admin-notifications-notice-action:hover {\r\n    color: #395b8a;\r\n    background-color: #f0f0f0;\r\n}\r\n\r\n.ppfuture-admin-notifications-notice-action:active {\r\n    background-color: #565c69;\r\n}\r\n\r\n.ppfuture-admin-notifications-notice-action:focus {\r\n    outline: none;\r\n}\r\n\r\n.ppfuture-admin-notifications-notice-action:disabled {\r\n    background-color: #6b7280;\r\n}\r\n\r\n.ppfuture-admin-notifications-notice-action .ppfuture-notifications-icon {\r\n    margin-right: 4px;\r\n}\r\n\r\n.ppfuture-admin-notifications-notice-actions .ppfuture-admin-notifications-notice-action:disabled {\r\n    background-color: #edf0f4;\r\n    color: #878c96;\r\n}\r\n\r\n\r\n/* SIDEBAR ACTIONS */\r\n\r\n.ppfuture-admin-notifications-sidebar-actions {\r\n    display: flex;\r\n    flex-direction: row;\r\n    align-items: right;\r\n    justify-content: right;\r\n    width: 100%;\r\n    margin-bottom: 10px;\r\n}\r\n\r\n.ppfuture-admin-notifications-sidebar-action {\r\n    color: #e1e3e7;\r\n    background-color: #1d2327;\r\n    border: none;\r\n    padding: 8px 12px;\r\n    cursor: pointer;\r\n    transition: background-color 0.2s ease;\r\n}\r\n\r\n.ppfuture-admin-notifications-sidebar-action:hover {\r\n    color: #fff;\r\n    background-color: #2d353b;\r\n}\r\n\r\n.ppfuture-admin-notifications-sidebar-action:active {\r\n    background-color: #3d454b;\r\n}\r\n\r\n.ppfuture-admin-notifications-sidebar-action:focus {\r\n    outline: none;\r\n}\r\n\r\n.ppfuture-admin-notifications-sidebar-action:disabled {\r\n    background-color: #6b7280;\r\n}\r\n\r\n.ppfuture-admin-notifications-sidebar-action .ppfuture-notifications-icon {\r\n    margin-right: 4px;\r\n}\r\n\r\n.ppfuture-admin-notifications-sidebar-wrapper.is-open {\r\n    display: flex;\r\n    flex-direction: column;\r\n    height: 100vh;\r\n}\r\n\r\n.ppfuture-admin-notifications-filters {\r\n    position: sticky;\r\n    top: 0;\r\n    display: flex;\r\n    gap: 12px;\r\n    z-index: 10;\r\n    background: #f5f5f5;\r\n    padding: 10px 12px;\r\n    margin-bottom: 10px;\r\n    border-bottom: 1px solid #ddd;\r\n}\r\n\r\n.ppfuture-admin-notifications-filters .components-base-control {\r\n    flex: 1;\r\n}\r\n\r\n.ppfuture-admin-notifications-sidebar-wrapper.is-open > ul {\r\n    overflow-y: auto;\r\n    flex-grow: 1;\r\n    padding: 0 12px;\r\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/postcss-loader/dist/cjs.js!./src/assets/jsx/notifications/css/admin-notifications-toolbar-item.css":
/*!***************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/postcss-loader/dist/cjs.js!./src/assets/jsx/notifications/css/admin-notifications-toolbar-item.css ***!
  \***************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_animations_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! -!../../../../../node_modules/css-loader/dist/cjs.js!./animations.css */ "./node_modules/css-loader/dist/cjs.js!./src/assets/jsx/notifications/css/animations.css");
// Imports



var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
___CSS_LOADER_EXPORT___.i(_node_modules_css_loader_dist_cjs_js_animations_css__WEBPACK_IMPORTED_MODULE_2__["default"]);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `#ppfuture-admin-notifications > a {
    padding-top: 1px !important;
    margin-right: 5px !important;
    display: flex !important;
    align-items: center !important;
    position: relative !important;
    cursor: pointer !important;
}

#ppfuture-admin-notifications > a span {
    cursor: pointer !important;
}

#ppfuture-admin-notifications .ppfuture-notifications-icon {
    height: 24px;
    width: 24px;
    color: #6B7280;
    transition: color 0.2s ease;
}

#ppfuture-admin-notifications .is-loading .ppfuture-notifications-icon {
    animation: loading 1s linear infinite;
}

#ppfuture-admin-notifications .no-notifications .ppfuture-notifications-icon {
    color: #8e9292;
}

#ppfuture-admin-notifications .ppfuture-notifications-icon:hover {
    color: #707e91;
    cursor: pointer;
}

#ppfuture-admin-notifications .no-notifications .ppfuture-notifications-icon:hover {
    color: #707272;
    cursor: default;
}

#ppfuture-admin-notifications .has-new-notifications .ppfuture-notifications-icon {
    animation: highlightShaking 2s linear infinite;
}

#ppfuture-admin-notifications .ppfuture-admin-notifications-count {
    background-color: #6366F1;
    color: #fff;
    padding: 2px 5px;
    border-radius: 50%;
    font-size: 12px;
    font-weight: 600;
    width: 18px;
    height: 18px;
    display: flex;
    align-items: center;
    justify-content: center;
    box-sizing: border-box;
    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.05);
    margin-top: -3px;
}

#ppfuture-admin-notifications .ppfuture-admin-notifications-count:hover {
    cursor: pointer;
}
`, "",{"version":3,"sources":["webpack://./src/assets/jsx/notifications/css/admin-notifications-toolbar-item.css"],"names":[],"mappings":"AAGA;IACI,2BAA2B;IAC3B,4BAA4B;IAC5B,wBAAwB;IACxB,8BAA8B;IAC9B,6BAA6B;IAC7B,0BAA0B;AAC9B;;AAEA;IACI,0BAA0B;AAC9B;;AAEA;IACI,YAAY;IACZ,WAAW;IACX,cAAc;IACd,2BAA2B;AAC/B;;AAEA;IACI,qCAAqC;AACzC;;AAEA;IACI,cAAc;AAClB;;AAEA;IACI,cAAc;IACd,eAAe;AACnB;;AAEA;IACI,cAAc;IACd,eAAe;AACnB;;AAEA;IACI,8CAA8C;AAClD;;AAEA;IACI,yBAAyB;IACzB,WAAW;IACX,gBAAgB;IAChB,kBAAkB;IAClB,eAAe;IACf,gBAAgB;IAChB,WAAW;IACX,YAAY;IACZ,aAAa;IACb,mBAAmB;IACnB,uBAAuB;IACvB,sBAAsB;IACtB,yCAAyC;IACzC,gBAAgB;AACpB;;AAEA;IACI,eAAe;AACnB","sourcesContent":["@import url('./animations.css');\r\n\r\n\r\n#ppfuture-admin-notifications > a {\r\n    padding-top: 1px !important;\r\n    margin-right: 5px !important;\r\n    display: flex !important;\r\n    align-items: center !important;\r\n    position: relative !important;\r\n    cursor: pointer !important;\r\n}\r\n\r\n#ppfuture-admin-notifications > a span {\r\n    cursor: pointer !important;\r\n}\r\n\r\n#ppfuture-admin-notifications .ppfuture-notifications-icon {\r\n    height: 24px;\r\n    width: 24px;\r\n    color: #6B7280;\r\n    transition: color 0.2s ease;\r\n}\r\n\r\n#ppfuture-admin-notifications .is-loading .ppfuture-notifications-icon {\r\n    animation: loading 1s linear infinite;\r\n}\r\n\r\n#ppfuture-admin-notifications .no-notifications .ppfuture-notifications-icon {\r\n    color: #8e9292;\r\n}\r\n\r\n#ppfuture-admin-notifications .ppfuture-notifications-icon:hover {\r\n    color: #707e91;\r\n    cursor: pointer;\r\n}\r\n\r\n#ppfuture-admin-notifications .no-notifications .ppfuture-notifications-icon:hover {\r\n    color: #707272;\r\n    cursor: default;\r\n}\r\n\r\n#ppfuture-admin-notifications .has-new-notifications .ppfuture-notifications-icon {\r\n    animation: highlightShaking 2s linear infinite;\r\n}\r\n\r\n#ppfuture-admin-notifications .ppfuture-admin-notifications-count {\r\n    background-color: #6366F1;\r\n    color: #fff;\r\n    padding: 2px 5px;\r\n    border-radius: 50%;\r\n    font-size: 12px;\r\n    font-weight: 600;\r\n    width: 18px;\r\n    height: 18px;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    box-sizing: border-box;\r\n    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.05);\r\n    margin-top: -3px;\r\n}\r\n\r\n#ppfuture-admin-notifications .ppfuture-admin-notifications-count:hover {\r\n    cursor: pointer;\r\n}\r\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./src/assets/jsx/notifications/css/animations.css":
/*!***********************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./src/assets/jsx/notifications/css/animations.css ***!
  \***********************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `@keyframes highlightShaking {
    0% {
        transform: rotate(0deg);
        color: #899dc5;
        scale: 1;
    }
    5% {
        transform: rotate(15deg);
        color: rgba(255, 255, 255, 0.5);
        scale: 1.01;
    }
    10% {
        transform: rotate(-15deg);
        color: rgba(255, 255, 255, 0.7);
        scale: 1.03;
    }
    15% {
        transform: rotate(10deg);
        color: rgba(255, 255, 255, 0.9);
        scale: 1.1;
    }
    20% {
        transform: rotate(-10deg);
        color: rgba(255, 255, 255, 0.7);
        scale: 1.13;
    }
    25% {
        transform: rotate(5deg);
        color: rgba(255, 255, 255, 0.5);
        scale: 1.18;
    }
    30% {
        transform: rotate(-5deg);
        color: rgba(255, 255, 255, 0.3);
        scale: 1.12;
    }
    35% {
        transform: rotate(0deg);
        color: #7b8aa8;
        scale: 1.1;
    }
    100% {
        transform: rotate(0deg);
        color: #899dc5;
        scale: 1;
    }
}

@keyframes loading {
    0% {
        transform: scale(1);
        opacity: 1;
    }
    50% {
        transform: scale(0.9);
        opacity: 0.7;
    }
    100% {
        transform: scale(1);
        opacity: 1;
    }
}
`, "",{"version":3,"sources":["webpack://./src/assets/jsx/notifications/css/animations.css"],"names":[],"mappings":"AAAA;IACI;QACI,uBAAuB;QACvB,cAAc;QACd,QAAQ;IACZ;IACA;QACI,wBAAwB;QACxB,+BAA+B;QAC/B,WAAW;IACf;IACA;QACI,yBAAyB;QACzB,+BAA+B;QAC/B,WAAW;IACf;IACA;QACI,wBAAwB;QACxB,+BAA+B;QAC/B,UAAU;IACd;IACA;QACI,yBAAyB;QACzB,+BAA+B;QAC/B,WAAW;IACf;IACA;QACI,uBAAuB;QACvB,+BAA+B;QAC/B,WAAW;IACf;IACA;QACI,wBAAwB;QACxB,+BAA+B;QAC/B,WAAW;IACf;IACA;QACI,uBAAuB;QACvB,cAAc;QACd,UAAU;IACd;IACA;QACI,uBAAuB;QACvB,cAAc;QACd,QAAQ;IACZ;AACJ;;AAEA;IACI;QACI,mBAAmB;QACnB,UAAU;IACd;IACA;QACI,qBAAqB;QACrB,YAAY;IAChB;IACA;QACI,mBAAmB;QACnB,UAAU;IACd;AACJ","sourcesContent":["@keyframes highlightShaking {\r\n    0% {\r\n        transform: rotate(0deg);\r\n        color: #899dc5;\r\n        scale: 1;\r\n    }\r\n    5% {\r\n        transform: rotate(15deg);\r\n        color: rgba(255, 255, 255, 0.5);\r\n        scale: 1.01;\r\n    }\r\n    10% {\r\n        transform: rotate(-15deg);\r\n        color: rgba(255, 255, 255, 0.7);\r\n        scale: 1.03;\r\n    }\r\n    15% {\r\n        transform: rotate(10deg);\r\n        color: rgba(255, 255, 255, 0.9);\r\n        scale: 1.1;\r\n    }\r\n    20% {\r\n        transform: rotate(-10deg);\r\n        color: rgba(255, 255, 255, 0.7);\r\n        scale: 1.13;\r\n    }\r\n    25% {\r\n        transform: rotate(5deg);\r\n        color: rgba(255, 255, 255, 0.5);\r\n        scale: 1.18;\r\n    }\r\n    30% {\r\n        transform: rotate(-5deg);\r\n        color: rgba(255, 255, 255, 0.3);\r\n        scale: 1.12;\r\n    }\r\n    35% {\r\n        transform: rotate(0deg);\r\n        color: #7b8aa8;\r\n        scale: 1.1;\r\n    }\r\n    100% {\r\n        transform: rotate(0deg);\r\n        color: #899dc5;\r\n        scale: 1;\r\n    }\r\n}\r\n\r\n@keyframes loading {\r\n    0% {\r\n        transform: scale(1);\r\n        opacity: 1;\r\n    }\r\n    50% {\r\n        transform: scale(0.9);\r\n        opacity: 0.7;\r\n    }\r\n    100% {\r\n        transform: scale(1);\r\n        opacity: 1;\r\n    }\r\n}\r\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/runtime/api.js":
/*!*****************************************************!*\
  !*** ./node_modules/css-loader/dist/runtime/api.js ***!
  \*****************************************************/
/***/ ((module) => {



/*
  MIT License http://www.opensource.org/licenses/mit-license.php
  Author Tobias Koppers @sokra
*/
module.exports = function (cssWithMappingToString) {
  var list = [];

  // return the list of modules as css string
  list.toString = function toString() {
    return this.map(function (item) {
      var content = "";
      var needLayer = typeof item[5] !== "undefined";
      if (item[4]) {
        content += "@supports (".concat(item[4], ") {");
      }
      if (item[2]) {
        content += "@media ".concat(item[2], " {");
      }
      if (needLayer) {
        content += "@layer".concat(item[5].length > 0 ? " ".concat(item[5]) : "", " {");
      }
      content += cssWithMappingToString(item);
      if (needLayer) {
        content += "}";
      }
      if (item[2]) {
        content += "}";
      }
      if (item[4]) {
        content += "}";
      }
      return content;
    }).join("");
  };

  // import a list of modules into the list
  list.i = function i(modules, media, dedupe, supports, layer) {
    if (typeof modules === "string") {
      modules = [[null, modules, undefined]];
    }
    var alreadyImportedModules = {};
    if (dedupe) {
      for (var k = 0; k < this.length; k++) {
        var id = this[k][0];
        if (id != null) {
          alreadyImportedModules[id] = true;
        }
      }
    }
    for (var _k = 0; _k < modules.length; _k++) {
      var item = [].concat(modules[_k]);
      if (dedupe && alreadyImportedModules[item[0]]) {
        continue;
      }
      if (typeof layer !== "undefined") {
        if (typeof item[5] === "undefined") {
          item[5] = layer;
        } else {
          item[1] = "@layer".concat(item[5].length > 0 ? " ".concat(item[5]) : "", " {").concat(item[1], "}");
          item[5] = layer;
        }
      }
      if (media) {
        if (!item[2]) {
          item[2] = media;
        } else {
          item[1] = "@media ".concat(item[2], " {").concat(item[1], "}");
          item[2] = media;
        }
      }
      if (supports) {
        if (!item[4]) {
          item[4] = "".concat(supports);
        } else {
          item[1] = "@supports (".concat(item[4], ") {").concat(item[1], "}");
          item[4] = supports;
        }
      }
      list.push(item);
    }
  };
  return list;
};

/***/ }),

/***/ "./node_modules/css-loader/dist/runtime/sourceMaps.js":
/*!************************************************************!*\
  !*** ./node_modules/css-loader/dist/runtime/sourceMaps.js ***!
  \************************************************************/
/***/ ((module) => {



module.exports = function (item) {
  var content = item[1];
  var cssMapping = item[3];
  if (!cssMapping) {
    return content;
  }
  if (typeof btoa === "function") {
    var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(cssMapping))));
    var data = "sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(base64);
    var sourceMapping = "/*# ".concat(data, " */");
    return [content].concat([sourceMapping]).join("\n");
  }
  return [content].join("\n");
};

/***/ }),

/***/ "./node_modules/react-dom/client.js":
/*!******************************************!*\
  !*** ./node_modules/react-dom/client.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



var m = __webpack_require__(/*! react-dom */ "react-dom");
if (false) {} else {
  var i = m.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED;
  exports.createRoot = function(c, o) {
    i.usingClientEntryPoint = true;
    try {
      return m.createRoot(c, o);
    } finally {
      i.usingClientEntryPoint = false;
    }
  };
  exports.hydrateRoot = function(c, h, o) {
    i.usingClientEntryPoint = true;
    try {
      return m.hydrateRoot(c, h, o);
    } finally {
      i.usingClientEntryPoint = false;
    }
  };
}


/***/ }),

/***/ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js":
/*!****************************************************************************!*\
  !*** ./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js ***!
  \****************************************************************************/
/***/ ((module) => {



var stylesInDOM = [];
function getIndexByIdentifier(identifier) {
  var result = -1;
  for (var i = 0; i < stylesInDOM.length; i++) {
    if (stylesInDOM[i].identifier === identifier) {
      result = i;
      break;
    }
  }
  return result;
}
function modulesToDom(list, options) {
  var idCountMap = {};
  var identifiers = [];
  for (var i = 0; i < list.length; i++) {
    var item = list[i];
    var id = options.base ? item[0] + options.base : item[0];
    var count = idCountMap[id] || 0;
    var identifier = "".concat(id, " ").concat(count);
    idCountMap[id] = count + 1;
    var indexByIdentifier = getIndexByIdentifier(identifier);
    var obj = {
      css: item[1],
      media: item[2],
      sourceMap: item[3],
      supports: item[4],
      layer: item[5]
    };
    if (indexByIdentifier !== -1) {
      stylesInDOM[indexByIdentifier].references++;
      stylesInDOM[indexByIdentifier].updater(obj);
    } else {
      var updater = addElementStyle(obj, options);
      options.byIndex = i;
      stylesInDOM.splice(i, 0, {
        identifier: identifier,
        updater: updater,
        references: 1
      });
    }
    identifiers.push(identifier);
  }
  return identifiers;
}
function addElementStyle(obj, options) {
  var api = options.domAPI(options);
  api.update(obj);
  var updater = function updater(newObj) {
    if (newObj) {
      if (newObj.css === obj.css && newObj.media === obj.media && newObj.sourceMap === obj.sourceMap && newObj.supports === obj.supports && newObj.layer === obj.layer) {
        return;
      }
      api.update(obj = newObj);
    } else {
      api.remove();
    }
  };
  return updater;
}
module.exports = function (list, options) {
  options = options || {};
  list = list || [];
  var lastIdentifiers = modulesToDom(list, options);
  return function update(newList) {
    newList = newList || [];
    for (var i = 0; i < lastIdentifiers.length; i++) {
      var identifier = lastIdentifiers[i];
      var index = getIndexByIdentifier(identifier);
      stylesInDOM[index].references--;
    }
    var newLastIdentifiers = modulesToDom(newList, options);
    for (var _i = 0; _i < lastIdentifiers.length; _i++) {
      var _identifier = lastIdentifiers[_i];
      var _index = getIndexByIdentifier(_identifier);
      if (stylesInDOM[_index].references === 0) {
        stylesInDOM[_index].updater();
        stylesInDOM.splice(_index, 1);
      }
    }
    lastIdentifiers = newLastIdentifiers;
  };
};

/***/ }),

/***/ "./node_modules/style-loader/dist/runtime/insertBySelector.js":
/*!********************************************************************!*\
  !*** ./node_modules/style-loader/dist/runtime/insertBySelector.js ***!
  \********************************************************************/
/***/ ((module) => {



var memo = {};

/* istanbul ignore next  */
function getTarget(target) {
  if (typeof memo[target] === "undefined") {
    var styleTarget = document.querySelector(target);

    // Special case to return head of iframe instead of iframe itself
    if (window.HTMLIFrameElement && styleTarget instanceof window.HTMLIFrameElement) {
      try {
        // This will throw an exception if access to iframe is blocked
        // due to cross-origin restrictions
        styleTarget = styleTarget.contentDocument.head;
      } catch (e) {
        // istanbul ignore next
        styleTarget = null;
      }
    }
    memo[target] = styleTarget;
  }
  return memo[target];
}

/* istanbul ignore next  */
function insertBySelector(insert, style) {
  var target = getTarget(insert);
  if (!target) {
    throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");
  }
  target.appendChild(style);
}
module.exports = insertBySelector;

/***/ }),

/***/ "./node_modules/style-loader/dist/runtime/insertStyleElement.js":
/*!**********************************************************************!*\
  !*** ./node_modules/style-loader/dist/runtime/insertStyleElement.js ***!
  \**********************************************************************/
/***/ ((module) => {



/* istanbul ignore next  */
function insertStyleElement(options) {
  var element = document.createElement("style");
  options.setAttributes(element, options.attributes);
  options.insert(element, options.options);
  return element;
}
module.exports = insertStyleElement;

/***/ }),

/***/ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js ***!
  \**********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



/* istanbul ignore next  */
function setAttributesWithoutAttributes(styleElement) {
  var nonce =  true ? __webpack_require__.nc : 0;
  if (nonce) {
    styleElement.setAttribute("nonce", nonce);
  }
}
module.exports = setAttributesWithoutAttributes;

/***/ }),

/***/ "./node_modules/style-loader/dist/runtime/styleDomAPI.js":
/*!***************************************************************!*\
  !*** ./node_modules/style-loader/dist/runtime/styleDomAPI.js ***!
  \***************************************************************/
/***/ ((module) => {



/* istanbul ignore next  */
function apply(styleElement, options, obj) {
  var css = "";
  if (obj.supports) {
    css += "@supports (".concat(obj.supports, ") {");
  }
  if (obj.media) {
    css += "@media ".concat(obj.media, " {");
  }
  var needLayer = typeof obj.layer !== "undefined";
  if (needLayer) {
    css += "@layer".concat(obj.layer.length > 0 ? " ".concat(obj.layer) : "", " {");
  }
  css += obj.css;
  if (needLayer) {
    css += "}";
  }
  if (obj.media) {
    css += "}";
  }
  if (obj.supports) {
    css += "}";
  }
  var sourceMap = obj.sourceMap;
  if (sourceMap && typeof btoa !== "undefined") {
    css += "\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))), " */");
  }

  // For old IE
  /* istanbul ignore if  */
  options.styleTagTransform(css, styleElement, options.options);
}
function removeStyleElement(styleElement) {
  // istanbul ignore if
  if (styleElement.parentNode === null) {
    return false;
  }
  styleElement.parentNode.removeChild(styleElement);
}

/* istanbul ignore next  */
function domAPI(options) {
  if (typeof document === "undefined") {
    return {
      update: function update() {},
      remove: function remove() {}
    };
  }
  var styleElement = options.insertStyleElement(options);
  return {
    update: function update(obj) {
      apply(styleElement, options, obj);
    },
    remove: function remove() {
      removeStyleElement(styleElement);
    }
  };
}
module.exports = domAPI;

/***/ }),

/***/ "./node_modules/style-loader/dist/runtime/styleTagTransform.js":
/*!*********************************************************************!*\
  !*** ./node_modules/style-loader/dist/runtime/styleTagTransform.js ***!
  \*********************************************************************/
/***/ ((module) => {



/* istanbul ignore next  */
function styleTagTransform(css, styleElement) {
  if (styleElement.styleSheet) {
    styleElement.styleSheet.cssText = css;
  } else {
    while (styleElement.firstChild) {
      styleElement.removeChild(styleElement.firstChild);
    }
    styleElement.appendChild(document.createTextNode(css));
  }
}
module.exports = styleTagTransform;

/***/ }),

/***/ "./src/assets/jsx/notifications/css/admin-notifications-overlay.css":
/*!**************************************************************************!*\
  !*** ./src/assets/jsx/notifications/css/admin-notifications-overlay.css ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_node_modules_postcss_loader_dist_cjs_js_admin_notifications_overlay_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../../node_modules/css-loader/dist/cjs.js!../../../../../node_modules/postcss-loader/dist/cjs.js!./admin-notifications-overlay.css */ "./node_modules/css-loader/dist/cjs.js!./node_modules/postcss-loader/dist/cjs.js!./src/assets/jsx/notifications/css/admin-notifications-overlay.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());

      options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
    
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_node_modules_postcss_loader_dist_cjs_js_admin_notifications_overlay_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_node_modules_postcss_loader_dist_cjs_js_admin_notifications_overlay_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_node_modules_postcss_loader_dist_cjs_js_admin_notifications_overlay_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_node_modules_postcss_loader_dist_cjs_js_admin_notifications_overlay_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./src/assets/jsx/notifications/css/admin-notifications-sidebar.css":
/*!**************************************************************************!*\
  !*** ./src/assets/jsx/notifications/css/admin-notifications-sidebar.css ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_node_modules_postcss_loader_dist_cjs_js_admin_notifications_sidebar_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../../node_modules/css-loader/dist/cjs.js!../../../../../node_modules/postcss-loader/dist/cjs.js!./admin-notifications-sidebar.css */ "./node_modules/css-loader/dist/cjs.js!./node_modules/postcss-loader/dist/cjs.js!./src/assets/jsx/notifications/css/admin-notifications-sidebar.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());

      options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
    
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_node_modules_postcss_loader_dist_cjs_js_admin_notifications_sidebar_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_node_modules_postcss_loader_dist_cjs_js_admin_notifications_sidebar_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_node_modules_postcss_loader_dist_cjs_js_admin_notifications_sidebar_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_node_modules_postcss_loader_dist_cjs_js_admin_notifications_sidebar_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./src/assets/jsx/notifications/css/admin-notifications-toolbar-item.css":
/*!*******************************************************************************!*\
  !*** ./src/assets/jsx/notifications/css/admin-notifications-toolbar-item.css ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_node_modules_postcss_loader_dist_cjs_js_admin_notifications_toolbar_item_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../../node_modules/css-loader/dist/cjs.js!../../../../../node_modules/postcss-loader/dist/cjs.js!./admin-notifications-toolbar-item.css */ "./node_modules/css-loader/dist/cjs.js!./node_modules/postcss-loader/dist/cjs.js!./src/assets/jsx/notifications/css/admin-notifications-toolbar-item.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());

      options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
    
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_node_modules_postcss_loader_dist_cjs_js_admin_notifications_toolbar_item_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_node_modules_postcss_loader_dist_cjs_js_admin_notifications_toolbar_item_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_node_modules_postcss_loader_dist_cjs_js_admin_notifications_toolbar_item_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_node_modules_postcss_loader_dist_cjs_js_admin_notifications_toolbar_item_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./src/assets/jsx/notifications/icons/clock.jsx":
/*!******************************************************!*\
  !*** ./src/assets/jsx/notifications/icons/clock.jsx ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Based on the icon MdNotifications from react-icons/md.
 */
var ClockIcon = function ClockIcon(_ref) {
  var _ref$size = _ref.size,
    size = _ref$size === void 0 ? 24 : _ref$size,
    _ref$className = _ref.className,
    className = _ref$className === void 0 ? '' : _ref$className,
    _ref$onClick = _ref.onClick,
    onClick = _ref$onClick === void 0 ? function () {} : _ref$onClick,
    _ref$onMouseEnter = _ref.onMouseEnter,
    onMouseEnter = _ref$onMouseEnter === void 0 ? function () {} : _ref$onMouseEnter,
    _ref$onMouseLeave = _ref.onMouseLeave,
    onMouseLeave = _ref$onMouseLeave === void 0 ? function () {} : _ref$onMouseLeave;
  return /*#__PURE__*/React.createElement("span", {
    className: "ppfuture-notifications-icon ".concat(className).trim(),
    onClick: onClick,
    onMouseEnter: onMouseEnter,
    onMouseLeave: onMouseLeave
  }, /*#__PURE__*/React.createElement("svg", {
    stroke: "currentColor",
    fill: "currentColor",
    strokeWidth: "0",
    viewBox: "0 0 24 24",
    height: size,
    width: size,
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/React.createElement("path", {
    d: "M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12.5 7H11v6l5.25 3.15.75-1.23-4.5-2.67z"
  })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ClockIcon);

/***/ }),

/***/ "./src/assets/jsx/notifications/icons/notifications.jsx":
/*!**************************************************************!*\
  !*** ./src/assets/jsx/notifications/icons/notifications.jsx ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Based on the icon MdNotifications from react-icons/md.
 */
var NotificationsIcon = function NotificationsIcon(_ref) {
  var _ref$size = _ref.size,
    size = _ref$size === void 0 ? 24 : _ref$size,
    _ref$className = _ref.className,
    className = _ref$className === void 0 ? '' : _ref$className,
    _ref$onClick = _ref.onClick,
    onClick = _ref$onClick === void 0 ? function () {} : _ref$onClick,
    _ref$onMouseEnter = _ref.onMouseEnter,
    onMouseEnter = _ref$onMouseEnter === void 0 ? function () {} : _ref$onMouseEnter,
    _ref$onMouseLeave = _ref.onMouseLeave,
    onMouseLeave = _ref$onMouseLeave === void 0 ? function () {} : _ref$onMouseLeave;
  return /*#__PURE__*/React.createElement("span", {
    className: "ppfuture-notifications-icon ".concat(className).trim(),
    onClick: onClick,
    onMouseEnter: onMouseEnter,
    onMouseLeave: onMouseLeave
  }, /*#__PURE__*/React.createElement("svg", {
    stroke: "currentColor",
    fill: "currentColor",
    strokeWidth: "0",
    viewBox: "0 0 24 24",
    height: size,
    width: size,
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/React.createElement("path", {
    d: "M12 22c1.1 0 2-.9 2-2h-4a2 2 0 0 0 2 2zm6-6v-5c0-3.07-1.64-5.64-4.5-6.32V4c0-.83-.67-1.5-1.5-1.5s-1.5.67-1.5 1.5v.68C7.63 5.36 6 7.92 6 11v5l-2 2v1h16v-1l-2-2z"
  })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NotificationsIcon);

/***/ }),

/***/ "./src/assets/jsx/notifications/overlay.jsx":
/*!**************************************************!*\
  !*** ./src/assets/jsx/notifications/overlay.jsx ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NotificationsOverlay: () => (/* binding */ NotificationsOverlay),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_admin_notifications_overlay_css__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./css/admin-notifications-overlay.css */ "./src/assets/jsx/notifications/css/admin-notifications-overlay.css");

function NotificationsOverlay(_ref) {
  var isOpen = _ref.isOpen,
    onClick = _ref.onClick;
  var isHidden = !isOpen;
  return /*#__PURE__*/React.createElement("div", {
    id: "ppfuture-admin-notifications-overlay",
    className: isHidden ? 'is-hidden' : '',
    onClick: onClick
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NotificationsOverlay);

/***/ }),

/***/ "./src/assets/jsx/notifications/sidebar.jsx":
/*!**************************************************!*\
  !*** ./src/assets/jsx/notifications/sidebar.jsx ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @publishpress/i18n */ "@publishpress/i18n");
/* harmony import */ var _publishpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _store_index__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./store/index */ "./src/assets/jsx/notifications/store/index.jsx");
/* harmony import */ var _overlay__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./overlay */ "./src/assets/jsx/notifications/overlay.jsx");
/* harmony import */ var _css_admin_notifications_sidebar_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./css/admin-notifications-sidebar.css */ "./src/assets/jsx/notifications/css/admin-notifications-sidebar.css");
/* harmony import */ var _icons_notifications__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./icons/notifications */ "./src/assets/jsx/notifications/icons/notifications.jsx");
/* harmony import */ var _icons_clock__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./icons/clock */ "./src/assets/jsx/notifications/icons/clock.jsx");
/*
 * Copyright (c) 2025, Ramble Ventures
 */









var MINUTE_IN_MS = 1000 * 60;
var NOTIFICATIONS_REFRESH_INTERVAL = MINUTE_IN_MS * 1;
var VALID_NOTIFICATION_TYPES = ['error', 'success', 'info', 'warning'];

// Sanitize HTML in message
var sanitizeHTML = function sanitizeHTML(html) {
  // Create a temporary div element
  var tempDiv = document.createElement('div');
  // Set the HTML content
  tempDiv.textContent = html;
  // Return the sanitized content
  return tempDiv.innerHTML;
};
var NotificationsSidebar = function NotificationsSidebar(props) {
  var _useSelect = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(function (select) {
      var notifications = select(_store_index__WEBPACK_IMPORTED_MODULE_3__.store).getNotifications();
      var notificationsCount = select(_store_index__WEBPACK_IMPORTED_MODULE_3__.store).getNotificationsCount();
      var isOpen = select(_store_index__WEBPACK_IMPORTED_MODULE_3__.store).getIsSidebarOpen();
      var isLoading = select(_store_index__WEBPACK_IMPORTED_MODULE_3__.store).getIsLoading();
      var processingNotificationId = select(_store_index__WEBPACK_IMPORTED_MODULE_3__.store).getProcessingNotificationId();
      var sortOrder = select(_store_index__WEBPACK_IMPORTED_MODULE_3__.store).getSortOrder();
      var filterType = select(_store_index__WEBPACK_IMPORTED_MODULE_3__.store).getFilterType();
      var filterInteraction = select(_store_index__WEBPACK_IMPORTED_MODULE_3__.store).getFilterInteraction();
      var searchQuery = select(_store_index__WEBPACK_IMPORTED_MODULE_3__.store).getSearchQuery();
      var filteredNotificationsCount = select(_store_index__WEBPACK_IMPORTED_MODULE_3__.store).getFilteredNotificationsCount();
      return {
        notifications: notifications,
        notificationsCount: notificationsCount,
        isOpen: isOpen,
        isLoading: isLoading,
        processingNotificationId: processingNotificationId,
        sortOrder: sortOrder,
        filterType: filterType,
        filterInteraction: filterInteraction,
        searchQuery: searchQuery,
        filteredNotificationsCount: filteredNotificationsCount
      };
    }),
    notifications = _useSelect.notifications,
    notificationsCount = _useSelect.notificationsCount,
    isOpen = _useSelect.isOpen,
    processingNotificationId = _useSelect.processingNotificationId,
    sortOrder = _useSelect.sortOrder,
    filterType = _useSelect.filterType,
    filterInteraction = _useSelect.filterInteraction,
    searchQuery = _useSelect.searchQuery,
    filteredNotificationsCount = _useSelect.filteredNotificationsCount;
  var _useDispatch = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_store_index__WEBPACK_IMPORTED_MODULE_3__.store),
    executeNotificationOption = _useDispatch.executeNotificationOption,
    markAllNotificationsAsRead = _useDispatch.markAllNotificationsAsRead,
    closeSidebar = _useDispatch.closeSidebar,
    setSortOrder = _useDispatch.setSortOrder,
    setFilterType = _useDispatch.setFilterType,
    setFilterInteraction = _useDispatch.setFilterInteraction,
    setSearchQuery = _useDispatch.setSearchQuery;
  var handleClick = function handleClick(e) {
    e.preventDefault();
    e.stopPropagation();
    closeSidebar();
  };
  var clickOption = function clickOption(notificationId, optionName) {
    executeNotificationOption(notificationId, optionName);
  };
  var displaySidebar = isOpen;
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(_overlay__WEBPACK_IMPORTED_MODULE_4__["default"], {
    isOpen: displaySidebar,
    onClick: handleClick
  }), /*#__PURE__*/React.createElement("div", {
    id: "ppfuture-admin-notifications-sidebar-wrapper",
    className: displaySidebar ? 'is-open' : 'is-closed'
  }, notificationsCount > 0 && /*#__PURE__*/React.createElement("div", {
    className: "ppfuture-admin-notifications-filters"
  }, /*#__PURE__*/React.createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.SelectControl, {
    label: (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Sort by', 'publishpress-future-pro'),
    value: sortOrder,
    options: [{
      label: (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Newest first', 'publishpress-future-pro'),
      value: 'newest'
    }, {
      label: (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Oldest first', 'publishpress-future-pro'),
      value: 'oldest'
    }],
    onChange: function onChange(value) {
      return setSortOrder(value);
    }
  }), /*#__PURE__*/React.createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.SelectControl, {
    label: (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Filter by type', 'publishpress-future-pro'),
    value: filterType,
    options: [{
      label: (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('All types', 'publishpress-future-pro'),
      value: 'all'
    }, {
      label: (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Info', 'publishpress-future-pro'),
      value: 'info'
    }, {
      label: (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Success', 'publishpress-future-pro'),
      value: 'success'
    }, {
      label: (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Warning', 'publishpress-future-pro'),
      value: 'warning'
    }, {
      label: (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Error', 'publishpress-future-pro'),
      value: 'error'
    }],
    onChange: function onChange(value) {
      return setFilterType(value);
    }
  }), /*#__PURE__*/React.createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.SelectControl, {
    label: (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Filter by interaction', 'publishpress-future-pro'),
    value: filterInteraction,
    options: [{
      label: (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('All notifications', 'publishpress-future-pro'),
      value: 'all'
    }, {
      label: (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Waiting for feedback', 'publishpress-future-pro'),
      value: 'interaction'
    }, {
      label: (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Normal notifications', 'publishpress-future-pro'),
      value: 'normal'
    }],
    onChange: function onChange(value) {
      return setFilterInteraction(value);
    }
  }), /*#__PURE__*/React.createElement(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextControl, {
    label: (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Search', 'publishpress-future-pro'),
    value: searchQuery,
    onChange: function onChange(value) {
      return setSearchQuery(value);
    },
    placeholder: (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Search in notifications...', 'publishpress-future-pro')
  })), filteredNotificationsCount > 0 && /*#__PURE__*/React.createElement("div", {
    className: "ppfuture-admin-notifications-sidebar-actions"
  }, /*#__PURE__*/React.createElement("button", {
    className: "ppfuture-admin-notifications-sidebar-action",
    onClick: markAllNotificationsAsRead,
    disabled: processingNotificationId === 'all'
  }, processingNotificationId === 'all' ? (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Dismissing...', 'publishpress-future-pro') : (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Dismiss all', 'publishpress-future-pro'))), notificationsCount > 0 && filteredNotificationsCount === 0 ? /*#__PURE__*/React.createElement("div", {
    className: "ppfuture-admin-notifications-sidebar-empty-message"
  }, /*#__PURE__*/React.createElement("div", {
    className: "ppfuture-admin-notifications-sidebar-empty-message-icon"
  }, /*#__PURE__*/React.createElement(_icons_notifications__WEBPACK_IMPORTED_MODULE_6__["default"], {
    size: 85
  })), /*#__PURE__*/React.createElement("h4", null, (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('No matching notifications', 'publishpress-future-pro')), /*#__PURE__*/React.createElement("p", null, (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Try changing your filters', 'publishpress-future-pro'))) : notificationsCount === 0 && /*#__PURE__*/React.createElement("div", {
    className: "ppfuture-admin-notifications-sidebar-empty-message"
  }, /*#__PURE__*/React.createElement("div", {
    className: "ppfuture-admin-notifications-sidebar-empty-message-icon"
  }, /*#__PURE__*/React.createElement(_icons_notifications__WEBPACK_IMPORTED_MODULE_6__["default"], {
    size: 85
  })), /*#__PURE__*/React.createElement("h4", null, (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Notifications', 'publishpress-future-pro')), /*#__PURE__*/React.createElement("p", null, (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('No notifications found', 'publishpress-future-pro'))), notificationsCount > 0 && /*#__PURE__*/React.createElement("ul", null, notifications.map(function (notification) {
    var _notification$options;
    var type = notification.type;
    var message = notification.message;
    if (!VALID_NOTIFICATION_TYPES.includes(notification.type)) {
      type = 'default';
      message = notification.type;
    }
    var noticeClass = "ppfuture-admin-notifications-notice ppfuture-admin-notifications-notice-".concat(type);
    var createdAt = new Date(notification.created_at);
    var createdAtFormatted = createdAt.toLocaleString('en-US', {
      year: 'numeric',
      month: 'long',
      day: 'numeric',
      hour: 'numeric',
      minute: 'numeric'
    });
    var noticeMessageClass = notification.is_read == 1 ? 'read' : 'unread';

    // Sanitize the message
    message = sanitizeHTML(message);

    // Replace links with <a> tags
    message = message.replace(/(\bhttps?:\/\/\S+)/g, '<a href="$1" target="_blank">$1</a>');

    // Replace new lines with <br /> tags
    message = message.split("\n").join('<br />');
    var options = (_notification$options = notification.options) === null || _notification$options === void 0 ? void 0 : _notification$options.map(function (option) {
      var isProcessing = processingNotificationId === "".concat(notification.id, ":").concat(option.name);
      return /*#__PURE__*/React.createElement("button", {
        key: "option-".concat(option.name),
        className: "ppfuture-admin-notifications-notice-action",
        onClick: function onClick() {
          return clickOption(notification.id, option.name);
        },
        title: option.hint,
        disabled: isProcessing
      }, isProcessing ? (0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Processing...', 'publishpress-future-pro') : option.label);
    });
    return /*#__PURE__*/React.createElement("li", {
      key: notification.id,
      className: noticeClass
    }, /*#__PURE__*/React.createElement("div", {
      className: "ppfuture-admin-notifications-notice-content"
    }, /*#__PURE__*/React.createElement("div", {
      className: "ppfuture-admin-notifications-notice-timestamp"
    }, /*#__PURE__*/React.createElement(_icons_clock__WEBPACK_IMPORTED_MODULE_7__["default"], {
      size: 16
    }), createdAtFormatted), /*#__PURE__*/React.createElement("div", {
      className: "ppfuture-admin-notifications-notice-message ".concat(noticeMessageClass),
      dangerouslySetInnerHTML: {
        __html: message
      }
    })), /*#__PURE__*/React.createElement("div", {
      className: "ppfuture-admin-notifications-notice-actions"
    }, options));
  }))), /*#__PURE__*/React.createElement("input", {
    type: "hidden",
    id: "ppfuture-admin-notifications-ids",
    value: notifications.map(function (notification) {
      return notification.id;
    }).join(',')
  }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NotificationsSidebar);

/***/ }),

/***/ "./src/assets/jsx/notifications/store/actions.jsx":
/*!********************************************************!*\
  !*** ./src/assets/jsx/notifications/store/actions.jsx ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   closeSidebar: () => (/* binding */ closeSidebar),
/* harmony export */   executeNotificationOption: () => (/* binding */ executeNotificationOption),
/* harmony export */   fetchUnreadNotifications: () => (/* binding */ fetchUnreadNotifications),
/* harmony export */   markAllNotificationsAsRead: () => (/* binding */ markAllNotificationsAsRead),
/* harmony export */   markNotificationAsRead: () => (/* binding */ markNotificationAsRead),
/* harmony export */   openSidebar: () => (/* binding */ openSidebar),
/* harmony export */   setFilterInteraction: () => (/* binding */ setFilterInteraction),
/* harmony export */   setFilterType: () => (/* binding */ setFilterType),
/* harmony export */   setHasNewNotifications: () => (/* binding */ setHasNewNotifications),
/* harmony export */   setIsLoading: () => (/* binding */ setIsLoading),
/* harmony export */   setSearchQuery: () => (/* binding */ setSearchQuery),
/* harmony export */   setSortOrder: () => (/* binding */ setSortOrder),
/* harmony export */   toggleSidebar: () => (/* binding */ toggleSidebar)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_data_controls__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/data-controls */ "./node_modules/@wordpress/data-controls/build-module/index.js");
/* harmony import */ var _publishpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @publishpress/i18n */ "@publishpress/i18n");
/* harmony import */ var _publishpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_publishpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _name__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./name */ "./src/assets/jsx/notifications/store/name.jsx");
function _regenerator() { /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/babel/babel/blob/main/packages/babel-helpers/LICENSE */ var e, t, r = "function" == typeof Symbol ? Symbol : {}, n = r.iterator || "@@iterator", o = r.toStringTag || "@@toStringTag"; function i(r, n, o, i) { var c = n && n.prototype instanceof Generator ? n : Generator, u = Object.create(c.prototype); return _regeneratorDefine2(u, "_invoke", function (r, n, o) { var i, c, u, f = 0, p = o || [], y = !1, G = { p: 0, n: 0, v: e, a: d, f: d.bind(e, 4), d: function d(t, r) { return i = t, c = 0, u = e, G.n = r, a; } }; function d(r, n) { for (c = r, u = n, t = 0; !y && f && !o && t < p.length; t++) { var o, i = p[t], d = G.p, l = i[2]; r > 3 ? (o = l === n) && (c = i[4] || 3, u = i[5] === e ? i[3] : i[5], i[4] = 3, i[5] = e) : i[0] <= d && ((o = r < 2 && d < i[1]) ? (c = 0, G.v = n, G.n = i[1]) : d < l && (o = r < 3 || i[0] > n || n > l) && (i[4] = r, i[5] = n, G.n = l, c = 0)); } if (o || r > 1) return a; throw y = !0, n; } return function (o, p, l) { if (f > 1) throw TypeError("Generator is already running"); for (y && 1 === p && d(p, l), c = p, u = l; (t = c < 2 ? e : u) || !y;) { i || (c ? c < 3 ? (c > 1 && (G.n = -1), d(c, u)) : G.n = u : G.v = u); try { if (f = 2, i) { if (c || (o = "next"), t = i[o]) { if (!(t = t.call(i, u))) throw TypeError("iterator result is not an object"); if (!t.done) return t; u = t.value, c < 2 && (c = 0); } else 1 === c && (t = i.return) && t.call(i), c < 2 && (u = TypeError("The iterator does not provide a '" + o + "' method"), c = 1); i = e; } else if ((t = (y = G.n < 0) ? u : r.call(n, G)) !== a) break; } catch (t) { i = e, c = 1, u = t; } finally { f = 1; } } return { value: t, done: y }; }; }(r, o, i), !0), u; } var a = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} t = Object.getPrototypeOf; var c = [][n] ? t(t([][n]())) : (_regeneratorDefine2(t = {}, n, function () { return this; }), t), u = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(c); function f(e) { return Object.setPrototypeOf ? Object.setPrototypeOf(e, GeneratorFunctionPrototype) : (e.__proto__ = GeneratorFunctionPrototype, _regeneratorDefine2(e, o, "GeneratorFunction")), e.prototype = Object.create(u), e; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, _regeneratorDefine2(u, "constructor", GeneratorFunctionPrototype), _regeneratorDefine2(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = "GeneratorFunction", _regeneratorDefine2(GeneratorFunctionPrototype, o, "GeneratorFunction"), _regeneratorDefine2(u), _regeneratorDefine2(u, o, "Generator"), _regeneratorDefine2(u, n, function () { return this; }), _regeneratorDefine2(u, "toString", function () { return "[object Generator]"; }), (_regenerator = function _regenerator() { return { w: i, m: f }; })(); }
function _regeneratorDefine2(e, r, n, t) { var i = Object.defineProperty; try { i({}, "", {}); } catch (e) { i = 0; } _regeneratorDefine2 = function _regeneratorDefine(e, r, n, t) { if (r) i ? i(e, r, { value: n, enumerable: !t, configurable: !t, writable: !t }) : e[r] = n;else { var o = function o(r, n) { _regeneratorDefine2(e, r, function (e) { return this._invoke(r, n, e); }); }; o("next", 0), o("throw", 1), o("return", 2); } }, _regeneratorDefine2(e, r, n, t); }
var _marked = /*#__PURE__*/_regenerator().m(fetchUnreadNotifications),
  _marked2 = /*#__PURE__*/_regenerator().m(markNotificationAsRead),
  _marked3 = /*#__PURE__*/_regenerator().m(markAllNotificationsAsRead),
  _marked4 = /*#__PURE__*/_regenerator().m(executeNotificationOption);




var _window$ppfutureAdmin = window.ppfutureAdminNotifications,
  apiUrl = _window$ppfutureAdmin.apiUrl,
  nonce = _window$ppfutureAdmin.nonce;
function fetchUnreadNotifications() {
  var notifications, _t;
  return _regenerator().w(function (_context) {
    while (1) switch (_context.n) {
      case 0:
        _context.n = 1;
        return {
          type: 'FETCH_UNREAD_NOTIFICATIONS_START'
        };
      case 1:
        _context.p = 1;
        _context.n = 2;
        return (0,_wordpress_data_controls__WEBPACK_IMPORTED_MODULE_1__.apiFetch)({
          path: "".concat(apiUrl, "/notifications/unread"),
          headers: {
            'X-WP-Nonce': nonce
          }
        });
      case 2:
        notifications = _context.v;
        _context.n = 3;
        return {
          type: 'FETCH_UNREAD_NOTIFICATIONS_SUCCESS',
          payload: notifications
        };
      case 3:
        _context.n = 5;
        break;
      case 4:
        _context.p = 4;
        _t = _context.v;
        (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.dispatch)('core/notices').createErrorNotice((0,_publishpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Unable to load the notifications. Please try again.', 'publishpress-future-pro'));
        _context.n = 5;
        return {
          type: 'FETCH_UNREAD_NOTIFICATIONS_FAILURE'
        };
      case 5:
        return _context.a(2);
    }
  }, _marked, null, [[1, 4]]);
}
;
function markNotificationAsRead(notificationId) {
  var notifications, _t2;
  return _regenerator().w(function (_context2) {
    while (1) switch (_context2.n) {
      case 0:
        _context2.n = 1;
        return {
          type: 'MARK_NOTIFICATION_AS_READ_START',
          payload: notificationId
        };
      case 1:
        _context2.p = 1;
        _context2.n = 2;
        return (0,_wordpress_data_controls__WEBPACK_IMPORTED_MODULE_1__.apiFetch)({
          path: "".concat(apiUrl, "/notifications/mark-as-read"),
          method: 'POST',
          headers: {
            'X-WP-Nonce': nonce
          },
          data: {
            notificationId: notificationId
          }
        });
      case 2:
        notifications = _context2.v;
        _context2.n = 3;
        return {
          type: 'MARK_NOTIFICATION_AS_READ_SUCCESS',
          payload: notifications
        };
      case 3:
        _context2.n = 5;
        break;
      case 4:
        _context2.p = 4;
        _t2 = _context2.v;
        _context2.n = 5;
        return {
          type: 'MARK_NOTIFICATION_AS_READ_FAILURE',
          payload: _t2
        };
      case 5:
        return _context2.a(2);
    }
  }, _marked2, null, [[1, 4]]);
}
function markAllNotificationsAsRead() {
  var notificationIds, _t3;
  return _regenerator().w(function (_context3) {
    while (1) switch (_context3.n) {
      case 0:
        _context3.n = 1;
        return {
          type: 'MARK_ALL_NOTIFICATIONS_AS_READ_START'
        };
      case 1:
        _context3.p = 1;
        // We get from the interface and not from the store
        // because we need to be sure we only get the notifications
        // that are visible to the user. And the state can not be trusted
        // from here.
        notificationIds = document.getElementById('ppfuture-admin-notifications-ids').value;
        _context3.n = 2;
        return (0,_wordpress_data_controls__WEBPACK_IMPORTED_MODULE_1__.apiFetch)({
          path: "".concat(apiUrl, "/notifications/execute-action-and-return-unread"),
          method: 'POST',
          headers: {
            'X-WP-Nonce': nonce
          },
          data: {
            notificationIds: notificationIds.split(',').map(Number),
            optionName: 'dismiss'
          }
        });
      case 2:
        _context3.n = 3;
        return {
          type: 'MARK_ALL_NOTIFICATIONS_AS_READ_SUCCESS',
          payload: []
        };
      case 3:
        _context3.n = 5;
        break;
      case 4:
        _context3.p = 4;
        _t3 = _context3.v;
        _context3.n = 5;
        return {
          type: 'MARK_ALL_NOTIFICATIONS_AS_READ_FAILURE',
          payload: _t3
        };
      case 5:
        return _context3.a(2);
    }
  }, _marked3, null, [[1, 4]]);
}
function executeNotificationOption(notificationIds, optionName) {
  var notifications, _t4;
  return _regenerator().w(function (_context4) {
    while (1) switch (_context4.n) {
      case 0:
        _context4.n = 1;
        return {
          type: 'EXECUTE_NOTIFICATION_OPTION_START',
          payload: {
            notificationIds: notificationIds,
            optionName: optionName
          }
        };
      case 1:
        if (!Array.isArray(notificationIds)) {
          notificationIds = [notificationIds];
        }
        _context4.p = 2;
        _context4.n = 3;
        return (0,_wordpress_data_controls__WEBPACK_IMPORTED_MODULE_1__.apiFetch)({
          path: "".concat(apiUrl, "/notifications/execute-action-and-return-unread"),
          method: 'POST',
          headers: {
            'X-WP-Nonce': nonce
          },
          data: {
            notificationIds: notificationIds,
            optionName: optionName
          }
        });
      case 3:
        notifications = _context4.v;
        _context4.n = 4;
        return {
          type: 'EXECUTE_NOTIFICATION_OPTION_SUCCESS',
          payload: notifications
        };
      case 4:
        _context4.n = 6;
        break;
      case 5:
        _context4.p = 5;
        _t4 = _context4.v;
        _context4.n = 6;
        return {
          type: 'EXECUTE_NOTIFICATION_OPTION_FAILURE',
          payload: _t4
        };
      case 6:
        return _context4.a(2);
    }
  }, _marked4, null, [[2, 5]]);
}
function toggleSidebar() {
  return {
    type: 'TOGGLE_SIDEBAR'
  };
}
function closeSidebar() {
  return {
    type: 'CLOSE_SIDEBAR'
  };
}
function openSidebar() {
  return {
    type: 'OPEN_SIDEBAR'
  };
}
function setIsLoading(isLoading) {
  return {
    type: 'SET_IS_LOADING',
    payload: isLoading
  };
}
function setHasNewNotifications(hasNewNotifications) {
  return {
    type: 'SET_HAS_NEW_NOTIFICATIONS',
    payload: hasNewNotifications
  };
}
function setSortOrder(sortOrder) {
  return {
    type: 'SET_SORT_ORDER',
    payload: sortOrder
  };
}
function setFilterType(filterType) {
  return {
    type: 'SET_FILTER_TYPE',
    payload: filterType
  };
}
function setFilterInteraction(filterInteraction) {
  return {
    type: 'SET_FILTER_INTERACTION',
    payload: filterInteraction
  };
}
function setSearchQuery(searchQuery) {
  return {
    type: 'SET_SEARCH_QUERY',
    payload: searchQuery
  };
}

/***/ }),

/***/ "./src/assets/jsx/notifications/store/controls.jsx":
/*!*********************************************************!*\
  !*** ./src/assets/jsx/notifications/store/controls.jsx ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_data_controls__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data-controls */ "./node_modules/@wordpress/data-controls/build-module/index.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

var controls = _objectSpread({}, _wordpress_data_controls__WEBPACK_IMPORTED_MODULE_0__.controls);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (controls);

/***/ }),

/***/ "./src/assets/jsx/notifications/store/index.jsx":
/*!******************************************************!*\
  !*** ./src/assets/jsx/notifications/store/index.jsx ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   store: () => (/* binding */ store)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _name__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./name */ "./src/assets/jsx/notifications/store/name.jsx");
/* harmony import */ var _reducer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./reducer */ "./src/assets/jsx/notifications/store/reducer.jsx");
/* harmony import */ var _selectors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./selectors */ "./src/assets/jsx/notifications/store/selectors.jsx");
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./actions */ "./src/assets/jsx/notifications/store/actions.jsx");
/* harmony import */ var _controls__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./controls */ "./src/assets/jsx/notifications/store/controls.jsx");
/*
 * WordPress dependencies
 */


/*
 * Internal dependencies
 */





var store = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.createReduxStore)(_name__WEBPACK_IMPORTED_MODULE_1__.STORE_NAME, {
  reducer: _reducer__WEBPACK_IMPORTED_MODULE_2__["default"],
  actions: _actions__WEBPACK_IMPORTED_MODULE_4__,
  selectors: _selectors__WEBPACK_IMPORTED_MODULE_3__,
  controls: _controls__WEBPACK_IMPORTED_MODULE_5__["default"]
});
(0,_wordpress_data__WEBPACK_IMPORTED_MODULE_0__.register)(store);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./src/assets/jsx/notifications/store/name.jsx":
/*!*****************************************************!*\
  !*** ./src/assets/jsx/notifications/store/name.jsx ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STORE_NAME: () => (/* binding */ STORE_NAME)
/* harmony export */ });
var STORE_NAME = 'publishpress-future/notifications';

/***/ }),

/***/ "./src/assets/jsx/notifications/store/reducer.jsx":
/*!********************************************************!*\
  !*** ./src/assets/jsx/notifications/store/reducer.jsx ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DEFAULT_STATE: () => (/* binding */ DEFAULT_STATE),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   reducer: () => (/* binding */ reducer)
/* harmony export */ });
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var DEFAULT_STATE = {
  notifications: [],
  isLoadingNotifications: false,
  notificationsCount: 0,
  isSidebarOpen: false,
  hasNewNotifications: false,
  processingNotificationId: null,
  sortOrder: 'newest',
  filterType: 'all',
  filterInteraction: 'all',
  searchQuery: ''
};
var fetchUnreadNotificationsStart = function fetchUnreadNotificationsStart(state, action) {
  return _objectSpread(_objectSpread({}, state), {}, {
    isLoadingNotifications: true
  });
};
var fetchUnreadNotificationsSuccess = function fetchUnreadNotificationsSuccess(state, action) {
  var payload = action.payload;

  // Check if there are any new notifications in the payload
  var currentNotificationIds = state.notifications.map(function (notification) {
    return notification.id;
  });
  var fetchedNotificationIds = payload.map(function (notification) {
    return notification.id;
  });
  var hasNewNotifications = fetchedNotificationIds.some(function (id) {
    return !currentNotificationIds.includes(id);
  });

  // If we have new notifications, we can set a flag to highlight them in the UI
  if (hasNewNotifications) {
    state = _objectSpread(_objectSpread({}, state), {}, {
      hasNewNotifications: true
    });
  }
  return _objectSpread(_objectSpread({}, state), {}, {
    isLoadingNotifications: false,
    notifications: payload,
    notificationsCount: (payload === null || payload === void 0 ? void 0 : payload.length) || 0
  });
};
var fetchUnreadNotificationsFailure = function fetchUnreadNotificationsFailure(state, action) {
  return _objectSpread(_objectSpread({}, state), {}, {
    isLoadingNotifications: false
  });
};
var markNotificationAsReadStart = function markNotificationAsReadStart(state, action) {
  return _objectSpread(_objectSpread({}, state), {}, {
    isLoadingNotifications: true,
    processingNotificationId: action.payload
  });
};
var markNotificationAsReadSuccess = function markNotificationAsReadSuccess(state, action) {
  var payload = action.payload;
  return _objectSpread(_objectSpread({}, state), {}, {
    isLoadingNotifications: false,
    notifications: payload,
    notificationsCount: (payload === null || payload === void 0 ? void 0 : payload.length) || 0,
    processingNotificationId: null
  });
};
var markNotificationAsReadFailure = function markNotificationAsReadFailure(state, action) {
  return _objectSpread(_objectSpread({}, state), {}, {
    isLoadingNotifications: false,
    processingNotificationId: null
  });
};
var markAllNotificationsAsReadStart = function markAllNotificationsAsReadStart(state, action) {
  return _objectSpread(_objectSpread({}, state), {}, {
    isLoadingNotifications: true,
    processingNotificationId: 'all'
  });
};
var markAllNotificationsAsReadSuccess = function markAllNotificationsAsReadSuccess(state, action) {
  var payload = action.payload;
  return _objectSpread(_objectSpread({}, state), {}, {
    isLoadingNotifications: false,
    notifications: payload,
    notificationsCount: (payload === null || payload === void 0 ? void 0 : payload.length) || 0,
    processingNotificationId: null
  });
};
var markAllNotificationsAsReadFailure = function markAllNotificationsAsReadFailure(state, action) {
  return _objectSpread(_objectSpread({}, state), {}, {
    isLoadingNotifications: false,
    processingNotificationId: null
  });
};
var toggleSidebar = function toggleSidebar(state, action) {
  return _objectSpread(_objectSpread({}, state), {}, {
    isSidebarOpen: !state.isSidebarOpen
  });
};
var closeSidebar = function closeSidebar(state, action) {
  return _objectSpread(_objectSpread({}, state), {}, {
    isSidebarOpen: false
  });
};
var openSidebar = function openSidebar(state, action) {
  return _objectSpread(_objectSpread({}, state), {}, {
    isSidebarOpen: true
  });
};
var setIsLoading = function setIsLoading(state, action) {
  return _objectSpread(_objectSpread({}, state), {}, {
    isLoading: action.payload
  });
};
var setHasNewNotifications = function setHasNewNotifications(state, action) {
  return _objectSpread(_objectSpread({}, state), {}, {
    hasNewNotifications: action.payload
  });
};
var setSortOrder = function setSortOrder(state, action) {
  return _objectSpread(_objectSpread({}, state), {}, {
    sortOrder: action.payload
  });
};
var setFilterType = function setFilterType(state, action) {
  return _objectSpread(_objectSpread({}, state), {}, {
    filterType: action.payload
  });
};
var setFilterInteraction = function setFilterInteraction(state, action) {
  return _objectSpread(_objectSpread({}, state), {}, {
    filterInteraction: action.payload
  });
};
var setSearchQuery = function setSearchQuery(state, action) {
  return _objectSpread(_objectSpread({}, state), {}, {
    searchQuery: action.payload
  });
};
var executeNotificationOptionStart = function executeNotificationOptionStart(state, action) {
  console.log('executeNotificationOptionStart', action);
  return _objectSpread(_objectSpread({}, state), {}, {
    isLoadingNotifications: true,
    processingNotificationId: "".concat(action.payload.notificationIds, ":").concat(action.payload.optionName)
  });
};
var executeNotificationOptionSuccess = function executeNotificationOptionSuccess(state, action) {
  var payload = action.payload;
  return _objectSpread(_objectSpread({}, state), {}, {
    isLoadingNotifications: false,
    notifications: payload,
    notificationsCount: (payload === null || payload === void 0 ? void 0 : payload.length) || 0,
    processingNotificationId: null
  });
};
var executeNotificationOptionFailure = function executeNotificationOptionFailure(state, action) {
  return _objectSpread(_objectSpread({}, state), {}, {
    isLoadingNotifications: false,
    processingNotificationId: null
  });
};
var reducer = function reducer() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : DEFAULT_STATE;
  var action = arguments.length > 1 ? arguments[1] : undefined;
  switch (action.type) {
    case 'FETCH_UNREAD_NOTIFICATIONS_START':
      return fetchUnreadNotificationsStart(state, action);
    case 'FETCH_UNREAD_NOTIFICATIONS_SUCCESS':
      return fetchUnreadNotificationsSuccess(state, action);
    case 'FETCH_UNREAD_NOTIFICATIONS_FAILURE':
      return fetchUnreadNotificationsFailure(state, action);
    case 'MARK_NOTIFICATION_AS_READ_START':
      return markNotificationAsReadStart(state, action);
    case 'MARK_NOTIFICATION_AS_READ_SUCCESS':
      return markNotificationAsReadSuccess(state, action);
    case 'MARK_NOTIFICATION_AS_READ_FAILURE':
      return markNotificationAsReadFailure(state, action);
    case 'MARK_ALL_NOTIFICATIONS_AS_READ_START':
      return markAllNotificationsAsReadStart(state, action);
    case 'MARK_ALL_NOTIFICATIONS_AS_READ_SUCCESS':
      return markAllNotificationsAsReadSuccess(state, action);
    case 'MARK_ALL_NOTIFICATIONS_AS_READ_FAILURE':
      return markAllNotificationsAsReadFailure(state, action);
    case 'TOGGLE_SIDEBAR':
      return toggleSidebar(state, action);
    case 'CLOSE_SIDEBAR':
      return closeSidebar(state, action);
    case 'OPEN_SIDEBAR':
      return openSidebar(state, action);
    case 'SET_IS_LOADING':
      return setIsLoading(state, action);
    case 'SET_HAS_NEW_NOTIFICATIONS':
      return setHasNewNotifications(state, action);
    case 'SET_SORT_ORDER':
      return setSortOrder(state, action);
    case 'SET_FILTER_TYPE':
      return setFilterType(state, action);
    case 'SET_FILTER_INTERACTION':
      return setFilterInteraction(state, action);
    case 'SET_SEARCH_QUERY':
      return setSearchQuery(state, action);
    case 'EXECUTE_NOTIFICATION_OPTION_START':
      return executeNotificationOptionStart(state, action);
    case 'EXECUTE_NOTIFICATION_OPTION_SUCCESS':
      return executeNotificationOptionSuccess(state, action);
    case 'EXECUTE_NOTIFICATION_OPTION_FAILURE':
      return executeNotificationOptionFailure(state, action);
  }
  return state;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (reducer);

/***/ }),

/***/ "./src/assets/jsx/notifications/store/selectors.jsx":
/*!**********************************************************!*\
  !*** ./src/assets/jsx/notifications/store/selectors.jsx ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getFilterInteraction: () => (/* binding */ getFilterInteraction),
/* harmony export */   getFilterType: () => (/* binding */ getFilterType),
/* harmony export */   getFilteredNotificationsCount: () => (/* binding */ getFilteredNotificationsCount),
/* harmony export */   getHasNewNotifications: () => (/* binding */ getHasNewNotifications),
/* harmony export */   getIsLoading: () => (/* binding */ getIsLoading),
/* harmony export */   getIsLoadingNotifications: () => (/* binding */ getIsLoadingNotifications),
/* harmony export */   getIsSidebarOpen: () => (/* binding */ getIsSidebarOpen),
/* harmony export */   getNotificationIds: () => (/* binding */ getNotificationIds),
/* harmony export */   getNotifications: () => (/* binding */ getNotifications),
/* harmony export */   getNotificationsCount: () => (/* binding */ getNotificationsCount),
/* harmony export */   getProcessingNotificationId: () => (/* binding */ getProcessingNotificationId),
/* harmony export */   getSearchQuery: () => (/* binding */ getSearchQuery),
/* harmony export */   getSortOrder: () => (/* binding */ getSortOrder),
/* harmony export */   getUnfilteredNotifications: () => (/* binding */ getUnfilteredNotifications)
/* harmony export */ });
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
var getNotifications = function getNotifications(state) {
  var notifications = state.notifications;

  // Filter by type if not 'all'
  if (state.filterType !== 'all') {
    notifications = notifications.filter(function (notification) {
      return notification.type === state.filterType;
    });
  }

  // Filter by interaction type
  if (state.filterInteraction !== 'all') {
    var isInteraction = state.filterInteraction === 'interaction';
    notifications = notifications.filter(function (notification) {
      var isInteractionNotification = notification.step_id.includes('userInteraction');
      return isInteraction ? isInteractionNotification : !isInteractionNotification;
    });
  }

  // Search by query if provided
  if (state.searchQuery) {
    var query = state.searchQuery.toLowerCase();
    notifications = notifications.filter(function (notification) {
      var _notification$message, _notification$subject;
      var messageMatch = ((_notification$message = notification.message) === null || _notification$message === void 0 ? void 0 : _notification$message.toLowerCase().includes(query)) || false;
      var subjectMatch = ((_notification$subject = notification.subject) === null || _notification$subject === void 0 ? void 0 : _notification$subject.toLowerCase().includes(query)) || false;
      return messageMatch || subjectMatch;
    });
  }

  // Sort by date based on sortOrder
  notifications = _toConsumableArray(notifications).sort(function (a, b) {
    var dateA = new Date(a.created_at);
    var dateB = new Date(b.created_at);
    return state.sortOrder === 'newest' ? dateB - dateA : dateA - dateB;
  });
  return notifications;
};
var getUnfilteredNotifications = function getUnfilteredNotifications(state) {
  return state.notifications;
};
var getNotificationIds = function getNotificationIds(state) {
  return state.notifications.map(function (notification) {
    return notification.id;
  });
};
var getNotificationsCount = function getNotificationsCount(state) {
  return state.notificationsCount;
};
var getIsLoadingNotifications = function getIsLoadingNotifications(state) {
  return state.isLoadingNotifications;
};
var getIsSidebarOpen = function getIsSidebarOpen(state) {
  return state.isSidebarOpen;
};
var getIsLoading = function getIsLoading(state) {
  return state.isLoadingNotifications;
};
var getHasNewNotifications = function getHasNewNotifications(state) {
  return state.hasNewNotifications;
};
var getProcessingNotificationId = function getProcessingNotificationId(state) {
  return state.processingNotificationId;
};
var getSortOrder = function getSortOrder(state) {
  return state.sortOrder;
};
var getFilterType = function getFilterType(state) {
  return state.filterType;
};
var getFilterInteraction = function getFilterInteraction(state) {
  return state.filterInteraction;
};
var getSearchQuery = function getSearchQuery(state) {
  return state.searchQuery;
};
var getFilteredNotificationsCount = function getFilteredNotificationsCount(state) {
  return getNotifications(state).length;
};

/***/ }),

/***/ "./src/assets/jsx/notifications/topbar-item.jsx":
/*!******************************************************!*\
  !*** ./src/assets/jsx/notifications/topbar-item.jsx ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @publishpress/i18n */ "@publishpress/i18n");
/* harmony import */ var _publishpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_publishpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _icons_notifications__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./icons/notifications */ "./src/assets/jsx/notifications/icons/notifications.jsx");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _store_index__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./store/index */ "./src/assets/jsx/notifications/store/index.jsx");
/* harmony import */ var _css_admin_notifications_toolbar_item_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./css/admin-notifications-toolbar-item.css */ "./src/assets/jsx/notifications/css/admin-notifications-toolbar-item.css");
/*
 * Copyright (c) 2025, Ramble Ventures
 */







var NotificationsTopBarItem = function NotificationsTopBarItem(props) {
  var SECOND_IN_MS = 1000;
  var TIMEOUT_TO_RESET_HAS_NEW_NOTIFICATIONS = 10 * SECOND_IN_MS;
  var _useSelect = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(function (select) {
      var isSidebarOpen = select(_store_index__WEBPACK_IMPORTED_MODULE_4__.store).getIsSidebarOpen();
      var notificationsCount = select(_store_index__WEBPACK_IMPORTED_MODULE_4__.store).getNotificationsCount();
      var filteredNotificationsCount = select(_store_index__WEBPACK_IMPORTED_MODULE_4__.store).getFilteredNotificationsCount();
      var isLoading = select(_store_index__WEBPACK_IMPORTED_MODULE_4__.store).getIsLoading();
      var hasNewNotifications = select(_store_index__WEBPACK_IMPORTED_MODULE_4__.store).getHasNewNotifications();
      return {
        isSidebarOpen: isSidebarOpen,
        notificationsCount: notificationsCount,
        filteredNotificationsCount: filteredNotificationsCount,
        isLoading: isLoading,
        hasNewNotifications: hasNewNotifications
      };
    }),
    isSidebarOpen = _useSelect.isSidebarOpen,
    notificationsCount = _useSelect.notificationsCount,
    filteredNotificationsCount = _useSelect.filteredNotificationsCount,
    isLoading = _useSelect.isLoading,
    hasNewNotifications = _useSelect.hasNewNotifications;
  var _useDispatch = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)(_store_index__WEBPACK_IMPORTED_MODULE_4__.store),
    fetchUnreadNotifications = _useDispatch.fetchUnreadNotifications,
    toggleSidebar = _useDispatch.toggleSidebar,
    closeSidebar = _useDispatch.closeSidebar,
    setHasNewNotifications = _useDispatch.setHasNewNotifications;
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(function () {
    fetchUnreadNotifications();

    // Store last fetch time for this window instance
    var localStorageKey = 'ppfuture_last_fetch_time';
    var lastFetchTime = parseInt(localStorage.getItem(localStorageKey) || '0');

    // Set up heartbeat listener
    jQuery(document).on('heartbeat-tick', function (event, data) {
      if (data.publishpress_notifications_timestamp) {
        var serverTimestamp = parseInt(data.publishpress_notifications_timestamp);

        // Only fetch if server timestamp is newer than our last fetch
        if (serverTimestamp > lastFetchTime) {
          fetchUnreadNotifications();

          // Update our last fetch time
          lastFetchTime = serverTimestamp;
          localStorage.setItem(localStorageKey, lastFetchTime.toString());
        }
      }
    });

    // Add our current timestamp to heartbeat
    jQuery(document).on('heartbeat-send', function (event, data) {
      data.publishpress_notifications_request = lastFetchTime;
    });
    return function () {
      jQuery(document).off('heartbeat-tick');
      jQuery(document).off('heartbeat-send');
    };
  }, []);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(function () {
    if (hasNewNotifications) {
      setTimeout(function () {
        setHasNewNotifications(false);
      }, TIMEOUT_TO_RESET_HAS_NEW_NOTIFICATIONS);
    }
  }, [hasNewNotifications]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(function () {
    if (notificationsCount === 0) {
      closeSidebar();
    }
  }, [notificationsCount]);

  // Add ESC key event listener
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(function () {
    var handleEscKey = function handleEscKey(e) {
      if (e.key === 'Escape' && isSidebarOpen) {
        closeSidebar();
      }
    };
    if (isSidebarOpen) {
      document.addEventListener('keydown', handleEscKey);
    }
    setHasNewNotifications(false);
    return function () {
      document.removeEventListener('keydown', handleEscKey);
    };
  }, [isSidebarOpen]);
  var handleClick = function handleClick(e) {
    e.preventDefault();
    e.stopPropagation();
    fetchUnreadNotifications();
    toggleSidebar();
  };
  var className = 'ppfuture-admin-notifications-topbar-item';
  if (hasNewNotifications) {
    className += ' has-new-notifications';
  }
  if (isLoading) {
    className += ' is-loading';
  }
  if ((isSidebarOpen ? filteredNotificationsCount : notificationsCount) === 0) {
    className += ' no-notifications';
  }
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("a", {
    href: "#",
    onClick: handleClick,
    className: className
  }, /*#__PURE__*/React.createElement(_icons_notifications__WEBPACK_IMPORTED_MODULE_2__["default"], {
    size: 22
  }), (isSidebarOpen ? filteredNotificationsCount : notificationsCount) > 0 && /*#__PURE__*/React.createElement("span", {
    className: "ppfuture-admin-notifications-count"
  }, isSidebarOpen ? filteredNotificationsCount : notificationsCount)));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NotificationsTopBarItem);

/***/ }),

/***/ "@publishpress/i18n":
/*!************************************!*\
  !*** external "publishpress.i18n" ***!
  \************************************/
/***/ ((module) => {

module.exports = publishpress.i18n;

/***/ }),

/***/ "@wordpress/components":
/*!********************************!*\
  !*** external "wp.components" ***!
  \********************************/
/***/ ((module) => {

module.exports = wp.components;

/***/ }),

/***/ "@wordpress/data":
/*!**************************!*\
  !*** external "wp.data" ***!
  \**************************/
/***/ ((module) => {

module.exports = wp.data;

/***/ }),

/***/ "@wordpress/element":
/*!*****************************!*\
  !*** external "wp.element" ***!
  \*****************************/
/***/ ((module) => {

module.exports = wp.element;

/***/ }),

/***/ "@wordpress/hooks":
/*!***************************!*\
  !*** external "wp.hooks" ***!
  \***************************/
/***/ ((module) => {

module.exports = wp.hooks;

/***/ }),

/***/ "@wordpress/i18n":
/*!**************************!*\
  !*** external "wp.i18n" ***!
  \**************************/
/***/ ((module) => {

module.exports = wp.i18n;

/***/ }),

/***/ "@wordpress/url":
/*!*************************!*\
  !*** external "wp.url" ***!
  \*************************/
/***/ ((module) => {

module.exports = wp.url;

/***/ }),

/***/ "react-dom":
/*!***************************!*\
  !*** external "ReactDOM" ***!
  \***************************/
/***/ ((module) => {

module.exports = ReactDOM;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			id: moduleId,
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/nonce */
/******/ 	(() => {
/******/ 		__webpack_require__.nc = undefined;
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!************************************************!*\
  !*** ./src/assets/jsx/notifications/admin.jsx ***!
  \************************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_dom_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react-dom/client */ "./node_modules/react-dom/client.js");
/* harmony import */ var _sidebar__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./sidebar */ "./src/assets/jsx/notifications/sidebar.jsx");
/* harmony import */ var _topbar_item__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./topbar-item */ "./src/assets/jsx/notifications/topbar-item.jsx");
/*
 * Copyright (c) 2025, Ramble Ventures
 */




jQuery(document).ready(function () {
  var secondaryTopBar = document.getElementById('wp-admin-bar-top-secondary');
  var body = document.body;
  if (!secondaryTopBar) {
    return;
  }

  // Add the new li element to the secondary top bar
  var newLi = document.createElement('li');
  newLi.id = 'ppfuture-admin-notifications';
  secondaryTopBar.insertBefore(newLi, secondaryTopBar.lastChild);
  var topBarItemComponent = /*#__PURE__*/React.createElement(_topbar_item__WEBPACK_IMPORTED_MODULE_2__["default"], null);
  (0,react_dom_client__WEBPACK_IMPORTED_MODULE_0__.createRoot)(newLi).render(topBarItemComponent);

  // Add the sidebar element to the body
  var sidebar = document.createElement('div');
  sidebar.id = 'ppfuture-admin-notifications-sidebar';
  body.appendChild(sidebar);
  var sidebarComponent = /*#__PURE__*/React.createElement(_sidebar__WEBPACK_IMPORTED_MODULE_1__["default"], null);
  (0,react_dom_client__WEBPACK_IMPORTED_MODULE_0__.createRoot)(sidebar).render(sidebarComponent);
});
})();

/******/ })()
;
//# sourceMappingURL=adminNotifications.js.map