<?php

namespace PublishPress\Future\Modules\Workflows\Domain\Steps\Actions\Definitions;

use PublishPress\Future\Modules\Workflows\Interfaces\StepTypeInterface;
use PublishPress\Future\Modules\Workflows\Models\StepTypesModel;

class RemovePostTerm implements StepTypeInterface
{
    public static function getNodeTypeName(): string
    {
        return "action/core.remove-post-terms";
    }

    public function getElementaryType(): string
    {
        return StepTypesModel::STEP_TYPE_ACTION;
    }

    public function getReactFlowNodeType(): string
    {
        return "generic";
    }

    public function getBaseSlug(): string
    {
        return "removePostTerm";
    }

    public function getLabel(): string
    {
        return __("Remove terms from post", "post-expirator");
    }

    public function getDescription(): string
    {
        return __("This step removes current taxonomy terms.", "post-expirator");
    }

    public function getIcon(): string
    {
        return "media-document";
    }

    public function getFrecency(): int
    {
        return 1;
    }

    public function getVersion(): int
    {
        return 1;
    }

    public function getCategory(): string
    {
        return "post";
    }

    public function getSettingsSchema(): array
    {
        return [
            [
                "label" => __("Target Post", "post-expirator"),
                "description" => __("Select which post will have terms removed.", "post-expirator"),
                "fields" => [
                    [
                        "name" => "post",
                        "type" => "postInput",
                        "label" => __("Post to Remove Terms", "post-expirator"),
                        "description" => __("Choose the post that will have its terms removed.", "post-expirator"),
                        "default" => [
                            "variable" => [
                                "rule" => "first",
                                "dataType" => "post",
                            ]
                        ],
                    ],
                ],
            ],
            [
                "label" => __("Terms to remove", "post-expirator"),
                "description" => __("The terms that will be removed from the posts.", "post-expirator"),
                "fields" => [
                    [
                        "name" => "taxonomyTerms",
                        "type" => "taxonomyTerms",
                        "label" => __("Terms", "post-expirator"),
                        "description" => __(
                            "The terms that will be removed from the posts.",
                            "post-expirator"
                        ),
                        "settings" => [
                            "optionToSelectAll" => true,
                            "labelOptionToSelectAll" => __("Remove all terms", "post-expirator"),
                        ],
                    ],
                ]
            ],
        ];
    }

    public function getValidationSchema(): array
    {
        return [
            "connections" => [
                "rules" => [
                    [
                        "rule" => "hasIncomingConnection",
                    ],
                ],
            ],
            "settings" => [
                "rules" => [
                    [
                        "rule" => "required",
                        "field" => "post.variable",
                    ],
                    [
                        "rule" => "required",
                        "field" => "taxonomyTerms.terms",
                        "label" => __("Terms", "post-expirator"),
                        "condition" => [
                            "field" => "taxonomyTerms.selectAll",
                            "value" => "0"
                        ]
                    ],
                    [
                        "rule" => "validVariable",
                        "field" => "post.variable",
                        "fieldLabel" => __("Post", "post-expirator"),
                        "dataType" => "post",
                    ],
                ],
            ],
        ];
    }

    public function getStepScopedVariablesSchema(): array
    {
        return [];
    }

    public function getOutputSchema(): array
    {
        return [
            [
                "name" => "input",
                "type" => "input",
                "label" => __("Step input", "post-expirator"),
                "description" => __("The input data for this step.", "post-expirator"),
            ]
        ];
    }

    public function getCSSClass(): string
    {
        return "react-flow__node-genericAction";
    }

    public function getHandleSchema(): array
    {
        return [
            "target" => [
                [
                    "id" => "input",
                ]
            ],
            "source" => [
                [
                    "id" => "output",
                    "label" => __("Next", "post-expirator"),
                ]
            ]
        ];
    }

    public function isProFeature(): bool
    {
        return false;
    }
}
