<?php
/**
 * Class Initialization for the Plugin
 *
 * This class handles the initialization of the plugin, including loading necessary files,
 * setting up hooks, and managing dependencies like WooCommerce if needed.
 */

namespace PRAD_PRO\includes;

if ( ! class_exists( 'PRAD_PRO_Initialization' ) ) {

	class PRAD_PRO_Initialization {

		/**
		 * Constructor to initialize the plugin
		 */
		public function __construct() {
			add_action( 'plugins_loaded', array( $this, 'initialize_plugin' ) );
			add_action( 'activated_plugin', array( $this, 'activation_redirect' ) );
			add_filter( 'plugin_row_meta', array( $this, 'plugin_settings_meta' ), 10, 2 );
			add_filter( 'plugin_action_links_' . PRAD_PRO_BASE, array( $this, 'plugin_action_links_callback' ) );
		}

		/**
		 * Plugin Page Menu Add
		 *
		 * @since v.1.0.0
		 *
		 * @param string $links New Option Links.
		 * @param string $file  Plugin file name.
		 *
		 * @return ARRAY
		 */
		public function plugin_settings_meta( $links, $file ) {
			if ( strpos( $file, 'product-addons-pro.php' ) !== false ) {
				$new_links = array(
					'prad_docs'     => '<a href="https://wpxpo.com/docs/wowaddons/" target="_blank">' . esc_html__( 'Docs', 'product-addons-pro' ) . '</a>',
					'prad_support'  => '<a href="https://www.wpxpo.com/contact/" target="_blank">' . esc_html__( 'Support', 'product-addons-pro' ) . '</a>',
				);
				$links     = array_merge( $links, $new_links );
			}
			return $links;
		}

		/**
		 * Settings Pro Update Link
		 *
		 * @since v.1.0.0
		 *
		 * @param string $links New Option Links.
		 * @return ARRAY
		 */
		public function plugin_action_links_callback( $links ) {
			$setting_link = array();
			if ( function_exists( 'product_addons' ) ) {
				$setting_link['prad_options'] = '<a href="'. esc_url(admin_url('admin.php?page=prad-dashboard#lists')) .'">'. esc_html__('Options', 'product-addons-pro') .'</a>';
			}
			return array_merge( $setting_link, $links );
		}

		/**
		 * Initialize the plugin by checking for dependencies and loading necessary files.
		 */
		public function initialize_plugin() {
			require_once PRAD_PRO_PATH . 'admin/class-admin.php';
			require_once PRAD_PRO_PATH . 'frontend/class-frontend.php';
			require_once PRAD_PRO_PATH . 'includes/updater/License.php';
			new \PRAD_PRO\admin\PRAD_PRO_Admin();
			new \PRAD_PRO\frontend\PRAD_PRO_Frontend();
			new \PRAD_PRO\includes\License();
		}

		/**
		 * Redirect after Plugin is Activated to License Page
		 *
		 * @since v.1.0.0
		 * @return NULL
		 */
		public function activation_redirect( $plugin ) {
			if ( $plugin == 'product-addons-pro/product-addons-pro.php' ) {
				product_addons_pro()->activate_addons_plugin();
			}
		}
	}
}
