<?php
namespace PRAD_PRO\includes;

defined( 'ABSPATH' ) || exit;

class Functions {

	/**
	 * Setup class.
	 *
	 * @since v.1.0.0
	 */
	public function __construct() {
	}

	public function is_lc_active() {
		$license_data = get_option( 'edd_prad_license_data', array() );
		return isset( $license_data['license'] ) && $license_data['license'] === 'valid' ? true : false;
	}

	/**
	 * Plugin Install and Active Action
	 *
	 * @since v.1.6.8
	 * @return STRING | Redirect URL
	 */
	public function activate_addons_plugin() {
		if ( ! file_exists( WP_PLUGIN_DIR . '/product-addons/product-addons.php' ) ) {
			if ( ! function_exists( 'plugins_api' ) ) {
				include ABSPATH . 'wp-admin/includes/plugin-install.php';
			}
			if ( ! class_exists( 'WP_Upgrader' ) ) {
				include ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
			}

			if ( ! class_exists( 'Plugin_Upgrader' ) ) {
				include ABSPATH . 'wp-admin/includes/class-plugin-upgrader.php';
			}
			if ( ! class_exists( 'WP_Ajax_Upgrader_Skin' ) ) {
				include ABSPATH . 'wp-admin/includes/class-wp-ajax-upgrader-skin.php';
			}

			$api = plugins_api(
				'plugin_information',
				array(
					'slug'   => 'product-addons',
					'fields' => array(
						'short_description' => false,
						'sections'          => false,
						'requires'          => false,
						'rating'            => false,
						'ratings'           => false,
						'downloaded'        => false,
						'last_updated'      => false,
						'added'             => false,
						'tags'              => false,
						'compatibility'     => false,
						'homepage'          => false,
						'donate_link'       => false,
					),
				)
			);

			if ( is_wp_error( $api ) ) {
                wp_die( $api ); //phpcs:ignore
			}

			$upgrader       = new \Plugin_Upgrader( new \WP_Ajax_Upgrader_Skin( compact( 'title', 'url', 'nonce', 'plugin', 'api' ) ) );
			$install_result = $upgrader->install( $api->download_link );

			if ( ! is_wp_error( $install_result ) ) {
				activate_plugin( 'product-addons/product-addons.php' );
				die();
			}
		} else {
			activate_plugin( 'product-addons/product-addons.php' );
		}

		if ( wp_doing_ajax() || is_network_admin() || isset( $_GET['activate-multi'] ) || isset( $_POST['action'] ) && 'activate-selected' == $_POST['action'] ) {
			return;
		}

		wp_redirect( admin_url( 'admin.php?page=prad-dashboard#dashboard' ) );
		die();
	}
}
