<?php

/* Loads the file for option sanitization */
add_action( 'init', 'pwfw_load_sanitization' );

if ( !function_exists( 'pwfw_load_sanitization' ) ) {

	function pwfw_load_sanitization() {
	
	  require_once ( PWFW_SETTINGS . 'options-sanitize.php' );
	}
}


/*
 * Creates the settings in the database by looping through the array
 * we supplied in options.php. This is a neat way to do it since
 * we won't have to save settings for headers, descriptions, or arguments.
 *
 * Read more about the Settings API in the WordPress codex:
 * http://codex.wordpress.org/Settings_API
 *
 */
if ( !function_exists( 'pwfw_init' ) ) {

	function pwfw_init() {

	  // Include the required files
	  require_once ( PWFW_SETTINGS . 'options-interface.php' );
	  require_once ( PWFW_SETTINGS . 'options-medialibrary-uploader.php' );

	  // Loads the options array
	  require_once ( PWFW_SETTINGS . 'options.php' );

	  $pwfw_settings = get_option( 'pwfw' );

	  // Updates the unique option id in the database if it has changed
	  pwfw_option_name();

	  // Gets the unique id, returning a default if it isn't defined
	  if ( isset($pwfw_settings['id']) ) {
		$option_name = $pwfw_settings['id'];
	  }
	  else {
		$option_name = 'pwfw';
	  }

	  // Registers the settings fields and callback
	  register_setting( 'pwfw', $option_name, 'pwfw_validate' );
	}
}


/* Add a admin menu page. */
if ( !function_exists( 'pwfw_add_page' ) ) {

	function pwfw_add_page() {

		$pwfw_page = add_menu_page( __( 'Pro Watermark v2', PWFW_TEXTDOMAIN ), __( 'Pro Watermark', PWFW_TEXTDOMAIN ), 'manage_options', 'pwfw', 'pwfw_page', PWFW_URL . 'settings/images/icon.png' );
		
		// Adds actions to hook in the required css and javascript
		add_action( "admin_print_styles",'pwfw_load_styles' );
		add_action( "admin_print_scripts", 'pwfw_load_scripts' );
	}
}


/* Loads the CSS */
if ( !function_exists( 'pwfw_load_styles' ) ) {
	
	function pwfw_load_styles() {
		wp_enqueue_style( 'admin-style', PWFW_URL . 'settings/css/admin-style.css' );
		wp_enqueue_style( 'color-picker', PWFW_URL . 'settings/css/colorpicker.css' );
		wp_enqueue_style( 'jqueryFileTree', PWFW_URL . 'settings/css/jqueryFileTree.css' );
		wp_enqueue_style( 'jquery-ui-custom', PWFW_URL . 'settings/css/jquery-ui-1.8.17.custom.css' );
		wp_enqueue_style( 'jquery-ui-timepicker-addon', PWFW_URL . 'settings/css/jquery-ui-timepicker-addon.css' );
	}
}

/* Loads the javascript */
if ( !function_exists( 'pwfw_load_scripts' ) ) {

	function pwfw_load_scripts() {
		// Inline scripts from options-interface.php
		add_action( 'admin_head', 'pwfw_admin_head' );
		
		// Enqueued scripts
		wp_enqueue_script( 'jquery-ui-core' );
		wp_enqueue_script( 'jquery-ui-datepicker' );
		wp_enqueue_script( 'jquery-ui-slider' );
		wp_enqueue_script( 'jquery-ui-sliderAccess-addon', PWFW_URL . 'settings/js/jquery-ui-sliderAccess-addon.js', array('jquery', 'jquery-ui-core', 'jquery-ui-datepicker', 'jquery-ui-slider') );
		wp_enqueue_script( 'jquery-ui-timepicker-addon', PWFW_URL . 'settings/js/jquery-ui-timepicker-addon.js', array('jquery', 'jquery-ui-core', 'jquery-ui-datepicker', 'jquery-ui-slider') );
		wp_enqueue_script( 'color-picker', PWFW_URL . 'settings/js/colorpicker.js', array('jquery') );
		wp_enqueue_script( 'jqueryFileTree', PWFW_URL . 'settings/js/jqueryFileTree.js', array('jquery') );
		wp_enqueue_script( 'options-custom', PWFW_URL . 'settings/js/options-custom.js', array('jquery') );
	}
}


if ( !function_exists( 'pwfw_admin_head' ) ) {

	function pwfw_admin_head() {
		// Hook to add custom scripts
		do_action( 'pwfw_custom_scripts' );
	}
}


/*
 * Builds out the options panel.
 *
 * If we were using the Settings API as it was likely intended we would use
 * do_settings_sections here. But as we don't want the settings wrapped in a table,
 * we'll call our own custom pwfw_fields. See options-interface.php
 * for specifics on how each individual field is generated.
 *
 * Nonces are provided using the settings_fields()
 *
 */

if ( !function_exists( 'pwfw_page' ) ) {

	function pwfw_page() {
	
		$return = pwfw_fields();
		settings_errors();
		?>

		<div class="wrap">
			<img src="<?php echo PWFW_URL . 'settings/images/logo.png'; ?>" style=" margin: 20px 10px 10px 0; float:left;">
			<h2 style="line-height: 60px;"><?php esc_attr_e( 'Pro Watermark for Wordpress', PWFW_TEXTDOMAIN ); ?></h2><br />
			<h2 class="nav-tab-wrapper">
				<?php echo $return[1]; ?>
			</h2>

			<div class="metabox-holder">
			<div id="pwfw" class="postbox">
			<form action="options.php" method="post">
			
			<?php settings_fields( 'pwfw' ); ?>

			<?php echo $return[0]; /* Settings */ ?>
			
				<div id="pwfw-submit">
					<input type="submit" class="button-primary" name="update" value="<?php esc_attr_e( 'Save All Options', PWFW_TEXTDOMAIN ); ?>" />
					<div class="clear"></div>
				</div>
				
				<?php 
				if(count(get_option( 'pwfw' )) > 1){
				?>
				<div id="pwfw-option-demo" class="group always-show demo-watermark" style="display: block;padding-bottom: 0px;">
					<h3>Demo - After saving the settings you will see a live preview of the watermark.</h3>
					<div class="section  section-text mini" id="section-developers">
						<a href="#" target="_blank"><img src="<?php echo PWFW_URL . 'lib/scripts/watermark/request.php?demoImg=yes&noCahe=' . time();?>" /></a>
						
						<p style="margin-top: 10px;">Just a demo image to show you how the watermark will look like. Enjoy our plugin! You can download more plugins here: <a href="http://codecanyon.net/user/AA-Team" target="_blank">AA-Team on Code Canyon</a></p>
					</div>
				</div>
				<?php } ?>
			</form>
			</div> <!-- / #container -->
			
			</div>
		</div> <!-- / .wrap -->
	<?php
	}
}


/**
 * Validate Options.
 *
 * This runs after the submit/reset button has been clicked and
 * validates the inputs.
 *
 * @uses $_POST['reset']
 * @uses $_POST['update']
 *
 */
if ( !function_exists( 'pwfw_validate' ) ) {

	function pwfw_validate( $input ) {

	  /*
	   * Restore Defaults.
	   *
	   * In the event that the user clicked the "Restore Defaults"
	   * button, the options defined in the theme's options.php
	   * file will be added to the option.
	   *
	   */

	  if ( isset( $_POST['reset'] ) ) {
		add_settings_error( 'pwfw', 'restore_defaults', __( 'Default options restored.', PWFW_TEXTDOMAIN ), 'updated fade' );
		return pwfw_get_default_values();
	  }

	  /* Udpdate Settings. */
	  if ( isset( $_POST['update'] ) ) {
		$clean = array();
		$options = pwfw_options();
		foreach ( $options as $option ) {

		  if ( ! isset( $option['id'] ) ) {
			continue;
		  }

		  if ( ! isset( $option['type'] ) ) {
			continue;
		  }

		  $id = preg_replace( '/[^a-zA-Z0-9._\-]/', '', strtolower( $option['id'] ) );
		  
		  // Set checkbox to false if it wasn't sent in the $_POST
		  if ( 'checkbox' == $option['type'] && ! isset( $input[$id] ) ) {
			$input[$id] = '0';
		  }
		  
		  if ( 'htaccess_content' == $option['id'] ){
			$htaccess_content = $_POST['pwfw']['htaccess_content'];
				$pwfw_admin_settings = get_option( 'pwfw' );
				
				if(!isset($pwfw_admin_settings['htaccess_path'])){
					$pwfw_admin_settings['htaccess_path'] = ABSPATH . 'wp-content/uploads/';
				}
					// write the pwfw-v2 file 
					file_put_contents($pwfw_admin_settings['htaccess_path'] . 'pwfw.php', '<?php 
	session_start();

	$absolute_path = __FILE__;
	$path_to_file = explode( "wp-content", $absolute_path );
	$path_to_wp = $path_to_file[0];

	// Access WordPress
	require_once( $path_to_wp . "/wp-load.php" );

	// load pwfw request file
	require_once(PWFW_LIB_DIR . "scripts/watermark/request.php");');
				
					
					// try to write the .htaccess file
					file_put_contents($pwfw_admin_settings['htaccess_path'] . '.htaccess', $htaccess_content);
				
		  }

		  // Set each item in the multicheck to false if it wasn't sent in the $_POST
		  if ( 'multicheck' == $option['type'] && ! isset( $input[$id] ) ) {
			foreach ( $option['options'] as $key => $value ) {
			  $input[$id][$key] = '0';
			}
		  }

		  // For a value to be submitted to database it must pass through a sanitization filter
		  if ( has_filter( 'pwfw_sanitize_' . $option['type'] ) ) {
			$clean[$id] = apply_filters( 'pwfw_sanitize_' . $option['type'], $input[$id], $option );
		  }
		}

		add_settings_error( 'pwfw', 'save_options', __( 'Options have been saved.', PWFW_TEXTDOMAIN ), 'updated fade' );
		return $clean;
	  }

	  /* Request Not Recognized. */
	  return pwfw_get_default_values();
	}
}


/**
 * Format Configuration Array.
 *
 * Get an array of all default values as set in
 * options.php. The 'id','std' and 'type' keys need
 * to be defined in the configuration array. In the
 * event that these keys are not present the option
 * will not be included in this function's output.
 *
 * @return    array     Rey-keyed options configuration array.
 *
 * @access    private
 *
 */
if ( !function_exists( 'pwfw_get_default_values' ) ) {

	function pwfw_get_default_values() {
	
	  $output = array();
	  $config = pwfw_options();
	  foreach ( (array) $config as $option ) {
		if ( ! isset( $option['id'] ) ) {
		  continue;
		}
		if ( ! isset( $option['std'] ) ) {
		  continue;
		}
		if ( ! isset( $option['type'] ) ) {
		  continue;
		}
		if ( has_filter( 'pwfw_sanitize_' . $option['type'] ) ) {
		  $output[$option['id']] = apply_filters( 'pwfw_sanitize_' . $option['type'], $option['std'], $option );
		}
	  }
	  return $output;
	}
}


/* Add Options menu item to Admin Bar. */
add_action( 'wp_before_admin_bar_render', 'pwfw_adminbar' );

if ( !function_exists( 'pwfw_adminbar' ) ) {

	function pwfw_adminbar() {

	  global $wp_admin_bar;

	  $wp_admin_bar->add_menu( array(
		'id' => 'pwfw_options',
		'title' => __( 'Pro Watermark - Options' ),
		'href' => admin_url( 'admin.php?page=pwfw' )
	  ));
	}
}


/**
 * Get Option.
 *
 * Helper function to return the option value.
 * If no value has been saved, it returns $default.
 * Needed because options are saved as serialized strings.
 *
 */
if ( ! function_exists( 'pwfw_get_option' ) ) {

  function pwfw_get_option( $name, $default = false ) {
  
    $config = get_option( 'pwfw' );

    if ( ! isset( $config['id'] ) ) {
      return $default;
    }

    $options = get_option( $config['id'] );

    if ( isset( $options[$name] ) ) {
      return $options[$name];
    }

    return $default;
  }
}
