<?php

if ( !function_exists( 'pwfw_option_name' ) ) {

	function pwfw_option_name() {

		$name = 'pwfw';
		
		$pwfw_settings = get_option( 'pwfw' );
		$pwfw_settings['id'] = $name;
		update_option( 'pwfw', $pwfw_settings );
	}
}

/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the "id" fields, make sure to use all lowercase and no spaces.
 *  
 */
if ( !function_exists( 'pwfw_options' ) ) {

	function pwfw_options() {
		global $wpdb;
		
		/* Here we define the different drop downs for our option page */
		$sm_type = array(
			"image" => __( "Image", PWFW_TEXTDOMAIN ), 
			"text" 	=> __( "Text", PWFW_TEXTDOMAIN )
		);
		
		$sm_debug = array(
			"on" 	=> __( "Debug mode is ON", PWFW_TEXTDOMAIN ), 
			"off" 	=> __( "Debug mode is OFF", PWFW_TEXTDOMAIN )
		);
		
		$sm_image_extensions = array(
			"jpeg" 	=> __( "jpeg", PWFW_TEXTDOMAIN ), 
			"jpg" 	=> __( "jpg", PWFW_TEXTDOMAIN ),
			"png" 	=> __( "png", PWFW_TEXTDOMAIN ),
			"gif" 	=> __( "gif", PWFW_TEXTDOMAIN ),
		);
		
		$position = array(
			'top_left' => 'top left', 
			'top_center' => 'top center', 
			'top_right' => 'top right', 
			'center_left' => 'center left', 
			'center_center' => 'center center', 
			'center_right' => 'center right', 
			'bottom_left' => 'bottom left', 
			'bottom_center' => 'bottom center', 
			'bottom_right' => 'bottom right', 
			'repeat' => 'Repeat All X and Y position '
		);
		
		// Defining the image directoy path for image radio buttons
		$imagepath =  PWFW_URL . 'settings/images/';
			
		$options = array();
		
		// Begin display options	
		$options[] = array( "name" => __( "General settings", PWFW_TEXTDOMAIN ),
							"type" => "heading" );
		
		$options[] = array( "name" => __( "Watermark Type", PWFW_TEXTDOMAIN ),
							"desc" => __( "Image / Text.", PWFW_TEXTDOMAIN ),
							"id" => "type",
							"std" => "text",
							"type" => "select",
							"class" => "mini",
							"options" => $sm_type );
							
		$options[] = array(  "name" => __("Activate watermark only for this IP(s)", PWFW_TEXTDOMAIN),
							"desc" => __('Ex: 127.0.0.1,192.168.1.1 .Your current ip is:<b>' . ( pwfw_getRealIpAddr() ) . '</b>. Leave empty for developer mode off.', PWFW_TEXTDOMAIN),
							"id" =>  "developers",
							"class" => "mini",
							"std" => pwfw_getRealIpAddr(),
							"type" => "text");
							
		$options[] = array( "name" => __( "Cache files", PWFW_TEXTDOMAIN ),
							"desc" => __( "Cache the watermarked files.", PWFW_TEXTDOMAIN ),
							"id" => "useCache",
							"std" => "yes",
							"type" => "select",
							"class" => "mini",
							"options" => array('yes' => 'Yes', 'no' => 'No') );	

		$options[] = array( "name" => __( "Cache Life Time", PWFW_TEXTDOMAIN ),
							"desc" => __( "How many minutes to keep the watermaked images cached.", PWFW_TEXTDOMAIN ),
							"id" => "cacheLifeTime",
							"std" => 86400,
							"type" => "select",
							"class" => "mini",
							"options" => array(
								(60 * 1) => '1 Minute', 
								(60 * 10) => '10 Minutes', 
								(3600 * 1) => '1 Hour', 
								(3600 * 6) => '5 Hours', 
								(3600 * 12) => '12 Hours', 
								(86400 * 1) => '1 Day', 
								(86400 * 7) => '1 Week', 
								(2678400 * 1) => '1 Month', 
								(2678400 * 31536000) => '1 Year',
								) );	
							
		/*					
		$options[] = array( "name" => __( "Use Watermark on", PWFW_TEXTDOMAIN ),
							"desc" => __( "Use watermark only on selected images extension(s).", PWFW_TEXTDOMAIN ),
							"id" => "extensions",
							"std" => pwfw_getRealIpAddr(),
							"type" => "multicheck",
							"options" => $sm_image_extensions );
		*/
		
		$options[] = array(  "name" => __("Image Quality", PWFW_TEXTDOMAIN),
							"desc" => __('Exported image quality. <b>min value <i>0</i> max value <i>100</i></b>.', PWFW_TEXTDOMAIN),
							"id" =>  "quality",
							"class" => "mini",
							"std" => 100,
							"type" => "text");
							
		$options[] = array(  "name" => __("Watermark image min size", PWFW_TEXTDOMAIN),
							"desc" => __('Apply the watermark only on images that have their width less than x (px). Default value 300', PWFW_TEXTDOMAIN),
							"id" =>  "min_size",
							"class" => "mini",
							"std" => 300,
							"type" => "text");
		
		$options[] = array( "name" => __( "Watermark alignment", PWFW_TEXTDOMAIN ),
							"desc" => __( "Choose where to place the watermark on your images. <div style='margin: 10px 0px 0px 0px;'><img src='" . ( $imagepath ) . "align.jpg' border='0' /></div>
							", PWFW_TEXTDOMAIN ),
							"id" => "align",
							"std" => "bottom_right",
							"type" => "select",
							"class" => "mini",
							"options" => $position );
		
		$options[] = array( "name" => __( "Image Watermark", PWFW_TEXTDOMAIN ),
							"type" => "heading" );
		
		$options[] = array(  "name" => __("Watermark image", PWFW_TEXTDOMAIN),
							"desc" => __('Image to display.', PWFW_TEXTDOMAIN),
							"id" =>  "watermark_logo",
							"std" => "",
							"type" => "upload");
							
		$options[] = array(  "name" => __("Watermark margin", PWFW_TEXTDOMAIN),
							"desc" => __('Apply some margin to your watermark.', PWFW_TEXTDOMAIN),
							"id" =>  "image_margin",
							"class" => "mini",
							"std" => 10,
							"type" => "text");
		
		$options[] = array(  "name" => __("Watermark opacity", PWFW_TEXTDOMAIN),
							"desc" => __('Watermark opacity. <b>min value<i>0</i> max value <i>100</i></b>.', PWFW_TEXTDOMAIN),
							"id" =>  "image_opacity",
							"class" => "mini",
							"std" => 80,
							"type" => "text");
							
		$options[] = array( "name" => __( "Text Watermark", PWFW_TEXTDOMAIN ),
							"type" => "heading" );
		
		$options[] = array(  "name" => __("Watermark text", PWFW_TEXTDOMAIN),
							"desc" => __('Text to display.', PWFW_TEXTDOMAIN),
							"id" =>  "text_to_display",
							"std" => "sample text",
							"type" => "text");
							
		$options[] = array( "name" => __( "Typography", PWFW_TEXTDOMAIN ),
							"desc" => __( "Styling the watermark text.", PWFW_TEXTDOMAIN ),
							"id" => "text_typography",
							"std" => array( 'size' => '12px','face' => 'arial','color' => '#000000' ),
							"type" => "typography" );
		
		$options[] = array(  "name" => __("Watermark opacity", PWFW_TEXTDOMAIN),
							"desc" => __('Watermark opacity. <b>min value<i>0</i> max value <i>100</i></b>.', PWFW_TEXTDOMAIN),
							"id" =>  "text_opacity",
							"class" => "mini",
							"std" => 80,
							"type" => "text");
		

		$options[] = array( "name" => __( "Exclude file(s)", PWFW_TEXTDOMAIN ),
							"type" => "heading" );
							
		$options[] = array( "id" =>  "exclude_folders",
							"type" => "filetree" );	
		
		$options[] = array(  "name" => __("exclude file(s)", PWFW_TEXTDOMAIN),
							"desc" => __('Choose from the above list.', PWFW_TEXTDOMAIN),
							"id" =>  "exclude_files",
							"type" => "textarea");
							
		$options[] = array( "name" => __( "htaccess settings (*Advanced)", PWFW_TEXTDOMAIN ),
							"type" => "heading" );
							
		$options[] = array(  "name" => __("htaccess path", PWFW_TEXTDOMAIN),
							"desc" => __('Where to write the <i>.htaccess</i> file. Default value: <i>' . ( ABSPATH . 'wp-content/uploads/' ) . '</i>', PWFW_TEXTDOMAIN),
							"id" =>  "htaccess_path",
							"std" => ABSPATH . 'wp-content/uploads/',
							"type" => "text");	

		$options[] = array(  "name" => __("htaccess content", PWFW_TEXTDOMAIN),
							"desc" => __('
							<div style="border: 0px solid red;width: 300px;">
								<h4 style="margin: 0px 0px 4px 0px;padding: 0px;border-bottom: 1px solid #dadada;">Default value:</h4>
								<p style="margin: 0px;padding: 0px;"><code style="padding-left: 0px;">
# BEGIN pwfwV2<br />
<IfModule mod_rewrite.c><br />
RewriteEngine On<br />
RewriteRule ^([^.]+\.(jpe?g|gif|png))$ pwfw.php<br />
</IfModule><br />
# END pwfwV2</code></p>
							</div>
							
							', PWFW_TEXTDOMAIN),
							"id" =>  "htaccess_content",
							"std" => "# BEGIN pwfwV2
<IfModule mod_rewrite.c>
RewriteEngine On
RewriteRule ^([^.]+\.(jpe?g|gif|png))$ pwfw.php
</IfModule>
# END pwfwV2",
							"type" => "textarea");
							
		return $options;
	}
}