<?php

/* Text */
add_filter( 'pwfw_sanitize_text', 'sanitize_text_field' );


/* Textarea */
if ( !function_exists( 'pwfw_sanitize_textarea' ) ) {

	function pwfw_sanitize_textarea($input) {
	
		global $allowedposttags;
		$output = wp_kses( $input, $allowedposttags );
		return $output;
	}
}
add_filter( 'pwfw_sanitize_textarea', 'pwfw_sanitize_textarea' );


/* Info */
add_filter( 'pwfw_sanitize_info', 'pwfw_sanitize_allowedposttags' );


/* Select */
add_filter( 'pwfw_sanitize_select', 'pwfw_sanitize_enum', 10, 2 );


/* Radio */
add_filter( 'pwfw_sanitize_radio', 'pwfw_sanitize_enum', 10, 2 );


/* Images */
add_filter( 'pwfw_sanitize_images', 'pwfw_sanitize_enum', 10, 2 );


/* Checkbox */
if ( !function_exists( 'pwfw_sanitize_checkbox' ) ) {

	function pwfw_sanitize_checkbox( $input ) {
	
		if ( $input ) {
			$output = "1";
		} else {
			$output = "0";
		}
		return $output;
	}
}
add_filter( 'pwfw_sanitize_checkbox', 'pwfw_sanitize_checkbox' );


/* Multicheck */
if ( !function_exists( 'pwfw_sanitize_multicheck' ) ) {

	function pwfw_sanitize_multicheck( $input, $option ) {

		$output = '';
		if ( is_array( $input ) ) {
			foreach( $option['options'] as $key => $value ) {
				$output[$key] = "0";
			}
			foreach( $input as $key => $value ) {
				if ( array_key_exists( $key, $option['options'] ) && $value ) {
					$output[$key] = "1"; 
				}
			}
		}
		return $output;
	}
}
add_filter( 'pwfw_sanitize_multicheck', 'pwfw_sanitize_multicheck', 10, 2 );

/* Color Picker */
add_filter( 'pwfw_sanitize_color', 'pwfw_sanitize_hex' );


/* Uploader */
if ( !function_exists( 'pwfw_sanitize_upload' ) ) {

	function pwfw_sanitize_upload( $input ) {
	
		$output = '';
		$filetype = wp_check_filetype( $input );
		if ( $filetype["ext"] ) {
			$output = $input;
		}
		return $output;
	}
}
add_filter( 'pwfw_sanitize_upload', 'pwfw_sanitize_upload' );


/* Allowed Tags */
if ( !function_exists( 'pwfw_sanitize_allowedtags' ) ) {

	function pwfw_sanitize_allowedtags( $input ) {
	
		global $allowedtags;
		$output = wpautop( wp_kses( $input, $allowedtags ) );
		return $output;
	}
}
add_filter( 'pwfw_sanitize_info', 'pwfw_sanitize_allowedtags' );


/* Allowed Post Tags */
if ( !function_exists( 'pwfw_sanitize_allowedposttags' ) ) {

	function pwfw_sanitize_allowedposttags($input) {
	
		global $allowedposttags;
		$output = wpautop( wp_kses( $input, $allowedposttags ) );
		return $output;
	}
}
add_filter( 'pwfw_sanitize_info', 'pwfw_sanitize_allowedposttags' );


/* Check that the key value sent is valid */
if ( !function_exists( 'pwfw_sanitize_enum' ) ) {

	function pwfw_sanitize_enum( $input, $option ) {
	
		$output = '';
		if ( array_key_exists( $input, $option['options'] ) ) {
			$output = $input;
		}
		return $output;
	}
}


/* Background */
if ( !function_exists( 'pwfw_sanitize_background' ) ) {

	function pwfw_sanitize_background( $input ) {
		$output = wp_parse_args( $input, array(
			'color' => '',
			'image'  => '',
			'repeat'  => __( 'repeat', PWFW_TEXTDOMAIN ),
			'position' => __( 'top center', PWFW_TEXTDOMAIN ),
			'attachment' => __( 'scroll', PWFW_TEXTDOMAIN )
		) );

		$output['color'] = apply_filters( 'pwfw_sanitize_hex', $input['color'] );
		$output['image'] = apply_filters( 'pwfw_sanitize_upload', $input['image'] );
		$output['repeat'] = apply_filters( 'pwfw_background_repeat', $input['repeat'] );
		$output['position'] = apply_filters( 'pwfw_background_position', $input['position'] );
		$output['attachment'] = apply_filters( 'pwfw_background_attachment', $input['attachment'] );

		return $output;
	}
}
add_filter( 'pwfw_sanitize_background', 'pwfw_sanitize_background' );


if ( !function_exists( 'pwfw_sanitize_background_repeat' ) ) {

	function pwfw_sanitize_background_repeat( $value ) {
	
		$recognized = pwfw_recognized_background_repeat();
		if ( array_key_exists( $value, $recognized ) ) {
			return $value;
		}
		return apply_filters( 'pwfw_default_background_repeat', current( $recognized ) );
	}
}
add_filter( 'pwfw_background_repeat', 'pwfw_sanitize_background_repeat' );


if ( !function_exists( 'pwfw_sanitize_background_position' ) ) {

	function pwfw_sanitize_background_position( $value ) {
	
		$recognized = pwfw_recognized_background_position();
		if ( array_key_exists( $value, $recognized ) ) {
			return $value;
		}
		return apply_filters( 'pwfw_default_background_position', current( $recognized ) );
	}
}
add_filter( 'pwfw_background_position', 'pwfw_sanitize_background_position' );


if ( !function_exists( 'pwfw_sanitize_background_attachment' ) ) {

	function pwfw_sanitize_background_attachment( $value ) {
	
		$recognized = pwfw_recognized_background_attachment();
		if ( array_key_exists( $value, $recognized ) ) {
			return $value;
		}
		return apply_filters( 'pwfw_default_background_attachment', current( $recognized ) );
	}
}
add_filter( 'pwfw_background_attachment', 'pwfw_sanitize_background_attachment' );


/* Typography */
if ( !function_exists( 'pwfw_sanitize_typography' ) ) {

	function pwfw_sanitize_typography( $input ) {

		$output = wp_parse_args( $input, array(
			'size'  => '',
			'face'  => '',
			'style' => '',
			'color' => ''
		) );

		$output['size']  = apply_filters( 'pwfw_font_size', $output['size'] );
		$output['face']  = apply_filters( 'pwfw_font_face', $output['face'] );
		$output['style'] = apply_filters( 'pwfw_font_style', $output['style'] );
		$output['color'] = apply_filters( 'pwfw_color', $output['color'] );

		return $output;
	}
}
add_filter( 'pwfw_sanitize_typography', 'pwfw_sanitize_typography' );


if ( !function_exists( 'pwfw_sanitize_font_size' ) ) {

	function pwfw_sanitize_font_size( $value ) {

		$recognized = pwfw_recognized_font_sizes();
		$value = preg_replace('/px/','', $value);
		if ( in_array( (int) $value, $recognized ) ) {
			return (int) $value;
		}
		return (int) apply_filters( 'pwfw_default_font_size', $recognized );
	}
}
add_filter( 'pwfw_font_face', 'pwfw_sanitize_font_face' );


if ( !function_exists( 'pwfw_sanitize_font_style' ) ) {

	function pwfw_sanitize_font_style( $value ) {

		$recognized = pwfw_recognized_font_styles();
		if ( array_key_exists( $value, $recognized ) ) {
			return $value;
		}
		return apply_filters( 'pwfw_default_font_style', current( $recognized ) );
	}
}
add_filter( 'pwfw_font_style', 'pwfw_sanitize_font_style' );


if ( !function_exists( 'pwfw_sanitize_font_face' ) ) {

	function pwfw_sanitize_font_face( $value ) {
	
		$recognized = pwfw_recognized_font_faces();
		if ( array_key_exists( $value, $recognized ) ) {
			return $value;
		}
		return apply_filters( 'pwfw_default_font_face', current( $recognized ) );
	}
}
add_filter( 'pwfw_font_face', 'pwfw_sanitize_font_face' );


/**
 * Get recognized background repeat settings
 *
 * @return   array
 *
 */
if ( !function_exists( 'pwfw_recognized_background_repeat' ) ) {
 
	function pwfw_recognized_background_repeat() {
	
		$default = array(
			'no-repeat' => __( 'No Repeat', PWFW_TEXTDOMAIN ),
			'repeat-x'  => __( 'Repeat Horizontally', PWFW_TEXTDOMAIN ),
			'repeat-y'  => __( 'Repeat Vertically', PWFW_TEXTDOMAIN ),
			'repeat'    => __( 'Repeat All', PWFW_TEXTDOMAIN )
			);
		return apply_filters( 'pwfw_recognized_background_repeat', $default );
	}
}

/**
 * Get recognized background positions
 *
 * @return   array
 *
 */
if ( !function_exists( 'pwfw_recognized_background_position' ) ) {
 
	function pwfw_recognized_background_position() {
	
		$default = array(
			'top left'      => __( 'Top Left', PWFW_TEXTDOMAIN ),
			'top center'    => __( 'Top Center', PWFW_TEXTDOMAIN ),
			'top right'     => __( 'Top Right', PWFW_TEXTDOMAIN ),
			'center left'   => __( 'Middle Left', PWFW_TEXTDOMAIN ),
			'center center' => __( 'Middle Center', PWFW_TEXTDOMAIN ),
			'center right'  => __( 'Middle Right', PWFW_TEXTDOMAIN ),
			'bottom left'   => __( 'Bottom Left', PWFW_TEXTDOMAIN ),
			'bottom center' => __( 'Bottom Center', PWFW_TEXTDOMAIN ),
			'bottom right'  => __( 'Bottom Right', PWFW_TEXTDOMAIN )
			);
		return apply_filters( 'pwfw_recognized_background_position', $default );
	}
}


/**
 * Get recognized background attachment
 *
 * @return   array
 *
 */
if ( !function_exists( 'pwfw_recognized_background_attachment' ) ) {
 
	function pwfw_recognized_background_attachment() {
	
		$default = array(
			'scroll' => __( 'Scroll Normally', PWFW_TEXTDOMAIN ),
			'fixed'  => __( 'Fixed in Place', PWFW_TEXTDOMAIN )
			);
		return apply_filters( 'pwfw_recognized_background_attachment', $default );
	}
}


/**
 * Sanitize a color represented in hexidecimal notation.
 *
 * @param    string    Color in hexidecimal notation. "#" may or may not be prepended to the string.
 * @param    string    The value that this function should return if it cannot be recognized as a color.
 * @return   string
 *
 */
if ( !function_exists( 'pwfw_sanitize_hex' ) ) {
 
	function pwfw_sanitize_hex( $hex, $default = '' ) {
	
		if ( pwfw_validate_hex( $hex ) ) {
			return $hex;
		}
		return $default;
	}
}


/**
 * Get recognized font sizes.
 *
 * Returns an indexed array pwfw all recognized font sizes.
 * Values are integers and represent a range pwfw sizes from
 * smallest to largest.
 *
 * @return   array
 */
if ( !function_exists( 'pwfw_recognized_font_sizes' ) ) {
 
	function pwfw_recognized_font_sizes() {
	
		$sizes = range( 9, 71 );
		$sizes = apply_filters( 'pwfw_recognized_font_sizes', $sizes );
		$sizes = array_map( 'absint', $sizes );
		return $sizes;
	}
}


/**
 * Get recognized font faces.
 *
 * Returns an array pwfw all recognized font faces.
 * Keys are intended to be stored in the database
 * while values are ready for display in in html.
 *
 * @return   array
 *
 */
if ( !function_exists( 'pwfw_recognized_font_faces' ) ) {

	function pwfw_recognized_font_faces() {
	
		$default = array(
			'arial'     => __( 'Arial', PWFW_TEXTDOMAIN )
			);
		return apply_filters( 'pwfw_recognized_font_faces', $default );
	}
}


/**
 * Get recognized font styles.
 *
 * Returns an array pwfw all recognized font styles.
 * Keys are intended to be stored in the database
 * while values are ready for display in in html.
 *
 * @return   array
 *
 */
if ( !function_exists( 'pwfw_recognized_font_styles' ) ) {

	function pwfw_recognized_font_styles() {
	
		$default = array(
			'normal'      => __( 'Normal', PWFW_TEXTDOMAIN ),
			'italic'      => __( 'Italic', PWFW_TEXTDOMAIN ),
			'bold'        => __( 'Bold', PWFW_TEXTDOMAIN ),
			'bold italic' => __( 'Bold Italic', PWFW_TEXTDOMAIN )
			);
		return apply_filters( 'pwfw_recognized_font_styles', $default );
	}
}


/**
 * Is a given string a color formatted in hexidecimal notation?
 *
 * @param    string    Color in hexidecimal notation. "#" may or may not be prepended to the string.
 * @return   bool
 *
 */
if ( !function_exists( 'pwfw_validate_hex' ) ) {
 
	function pwfw_validate_hex( $hex ) {
	
		$hex = trim( $hex );
		/* Strip recognized prefixes. */
		if ( 0 === strpos( $hex, '#' ) ) {
			$hex = substr( $hex, 1 );
		}
		elseif ( 0 === strpos( $hex, '%23' ) ) {
			$hex = substr( $hex, 3 );
		}
		/* Regex match. */
		if ( 0 === preg_match( '/^[0-9a-fA-F]{6}$/', $hex ) ) {
			return false;
		}
		else {
			return true;
		}
	}
}