/**
 * Prints out the inline javascript needed for the colorpicker and choosing
 * the tabs in the panel.
 */
jQuery(document).ready(function ($) {

    // Fade out the save message
    $('.fade').delay(1000).fadeOut(1000);

    // Color Picker
    $('.colorSelector').each(function () {
        var Othis = this; //cache a copy of the this variable for use inside nested function
        var initialColor = $(Othis).next('input').attr('value');
        $(this).ColorPicker({
            color: initialColor,
            onShow: function (colpkr) {
                $(colpkr).fadeIn(500);
                return false;
            },
            onHide: function (colpkr) {
                $(colpkr).fadeOut(500);
                return false;
            },
            onChange: function (hsb, hex, rgb) {
                $(Othis).children('div').css('backgroundColor', '#' + hex);
                $(Othis).next('input').attr('value', '#' + hex);
            }
        });
    }); //end color picker
    // Switches option sections
    $('.group').not('.always-show').hide();
    var activetab = '';

    if (typeof (localStorage) != 'undefined') {
        activetab = localStorage.getItem("activetab");
    }
    if (activetab != '' && $(activetab).length) {
        $(activetab).fadeIn();
    } else {
        $('.group:first').fadeIn();
    }
    $('.group .collapsed').each(function () {
        $(this).find('input:checked').parent().parent().parent().nextAll().each(

        function () {
            if ($(this).hasClass('last')) {
                $(this).removeClass('hidden');
                return false;
            }
            $(this).filter('.hidden').removeClass('hidden');
        });
    });

    if (activetab != '' && $(activetab + '-tab').length) {
        $(activetab + '-tab').addClass('nav-tab-active');
    } else {
        $('.nav-tab-wrapper a:first').addClass('nav-tab-active');
    }
    $('.nav-tab-wrapper a').click(function (evt) {
        $('.nav-tab-wrapper a').removeClass('nav-tab-active');
        $(this).addClass('nav-tab-active').blur();
        var clicked_group = $(this).attr('href');
        if (typeof (localStorage) != 'undefined') {
            localStorage.setItem("activetab", $(this).attr('href'));
        }
        $('.group').not('.always-show').hide();
        $(clicked_group).fadeIn();
        evt.preventDefault();
    });

    $('.group .collapsed input:checkbox').click(unhideHidden);

    function unhideHidden() {
        if ($(this).attr('checked')) {
            $(this).parent().parent().parent().nextAll().removeClass('hidden');
        } else {
            $(this).parent().parent().parent().nextAll().each(

            function () {
                if ($(this).filter('.last').length) {
                    $(this).addClass('hidden');
                    return false;
                }
                $(this).addClass('hidden');
            });

        }
    }

    // Image Options
    $('.pwfw-radio-img-img').click(function () {
        $(this).parent().parent().find('.pwfw-radio-img-img').removeClass('pwfw-radio-img-selected');
        $(this).addClass('pwfw-radio-img-selected');
    });

    $('.pwfw-radio-img-label').hide();
    $('.pwfw-radio-img-img').show();
    $('.pwfw-radio-img-radio').hide();
	

	var fileTreeTextarea = $("#exclude_files"),
		fileTreeClickAct = function (short_path, action){
		
		// find current short page and remove from list
		var tmp_str = fileTreeTextarea.val();
		
		fileTreeTextarea.val(tmp_str.replace(short_path + "\n", ""));
		
		if(action == 'add'){
			fileTreeTextarea.val(tmp_str + short_path + "\n");
		}
	}
	$('div.file_tree').fileTree({
		script: ajaxurl, 
		root: '/', 
		folderEvent: 'click', 
		expandSpeed: 450, 
		collapseSpeed: 450, 
		multiFolder: true 
	}, function(line) { 
	
		var checkbox = line.children('input');
		if(checkbox.is(':checked')){
			checkbox.attr('checked', false);
			fileTreeClickAct(line.attr('rel'), 'remove');
		}else{
			checkbox.attr('checked', true);
			fileTreeClickAct(line.attr('rel'), 'add');
		}
		return true;
	});
});