<?php
/*
Plugin Name:	Pro Bulk Watermark Plugin for WordPress 
Plugin URI: 	http://codecanyon.net/user/AA-Team
Description: 	Add custom watermarks, text or images that bulk applies on your website images without modifying their source files.
Version: 		2.0
Author: 		پرشین اسکریپت
*/

// Basic plugin definitions 
define( 'PWFW_VERSION', '2.0' );
define( 'PWFW_URL', WP_PLUGIN_URL . '/' . str_replace( basename(__FILE__), '', plugin_basename(__FILE__) ));
define( 'PWFW_URL_DESIGN', PWFW_URL . 'lib/design/' );
define( 'PWFW_DIR', WP_PLUGIN_DIR . '/' . str_replace( basename(__FILE__), '', plugin_basename(__FILE__) ));
define( 'PWFW_LIB_DIR', PWFW_DIR . 'lib/');
define( 'PWFW_SETTINGS', PWFW_DIR . 'settings/' );
define( 'PWFW_TEXTDOMAIN', 'pwfw' );


/**
 * pwfw v2 - Wordpress Plugin
 * Version	: 	2.0.0
 * Author	: 	AA-Team
 */
class pwfwCore {

	// Hold an instance of the class
	private static $instance = NULL;
	
	/**
	 * Constructor
	 *
	 */
	public static function getInstance() {
		if (is_null(self::$instance)) {
			self::$instance = new pwfwCore();
		}
		return self::$instance;
	}

	// The constructor, call on class instance
	public function __construct() {

		// load textdomain!
		add_action('init', array($this, 'loading_the_textdomain'));
	}

	/**
	 * Inits!
	 *
	 */
	public function loading_the_textdomain(){
		// Loading the textdomain to get the plugin ready for translation
		load_plugin_textdomain( PWFW_TEXTDOMAIN, false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
	}

	/**
	 * Activate/Deactivate/Unistall hooks
	 *
	 */
	public function activate() {}

	public function deactivate() {
		// plugin option which hold all settings!
		$pwfwCore_admin_settings = get_option( 'pwfw' );
		if(isset($pwfwCore_admin_settings['htaccess_path'])){
			// try to delete .htaccess and php files 
			if(is_file($pwfwCore_admin_settings['htaccess_path'] . 'pwfw.php')){
				@unlink($pwfwCore_admin_settings['htaccess_path'] . 'pwfw.php');
			}
			if(is_file($pwfwCore_admin_settings['htaccess_path'] . '.htaccess')){
				@unlink($pwfwCore_admin_settings['htaccess_path'] . '.htaccess');
			}
		}

		// Each plugin saves its data in a seperate option, which all gets deleted
		if(isset($pwfwCore_admin_settings['knownoptions'])){
			$knownoptions = $pwfwCore_admin_settings['knownoptions'];
			if ($knownoptions) {
				foreach ($knownoptions as $key) {
					delete_option($key);
				}
			}
		}
		delete_option( 'pwfw' );
	}
}

/* Initialize theme and the plugin core class. */
$pwfwCore = pwfwCore::getInstance();

/* Make the class works first */
if (isset($pwfwCore)) {
    register_activation_hook(dirname(__FILE__) . '/plugin.php', array($pwfwCore, 'activate'));
    register_deactivation_hook(dirname(__FILE__) . '/plugin.php', array($pwfwCore, 'deactivate'));
}

// Plugin settings
require_once ( PWFW_SETTINGS . 'settings.php' );

// Rolecheck
if ( !function_exists( 'pwfw_rolescheck' ) ) {

	function pwfw_rolescheck () {
	  if ( current_user_can( 'manage_options' ) ) {
		// If the user can manage options, let the fun begin!
		add_action( 'admin_menu', 'pwfw_add_page' );
		add_action( 'admin_init', 'pwfw_init' );
		add_action( 'admin_init', 'pwfw_mlu_init' );
	  }
	}
}

add_action( 'init', 'pwfw_rolescheck' );


// pwfw_getRealIpAddr
if ( !function_exists( 'pwfw_getRealIpAddr' ) ) {

	function pwfw_getRealIpAddr () {
		if (!empty($_SERVER['HTTP_CLIENT_IP']))   //check ip from share internet
    {
      $ip=$_SERVER['HTTP_CLIENT_IP'];
    }
    elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))   //to check ip is pass from proxy
    {
      $ip=$_SERVER['HTTP_X_FORWARDED_FOR'];
    }
    else
    {
      $ip=$_SERVER['REMOTE_ADDR'];
    }
    return $ip;
	}
}

if ( !function_exists( 'wplanner_pwfwShowTree_callback' ) ) {

	function wplanner_pwfwShowTree_callback () {
	
		// Plugin facebook utils load
		require_once ( PWFW_SETTINGS . 'options-file-tree.php' );
		
		die(); // this is required to return a proper result
	}
}
add_action('wp_ajax_pwfwShowTree', 'wplanner_pwfwShowTree_callback');
