<?php 
/**
 *
 * pwfw
 * ---------------- 
 * 2012 AA-Team. All rights reserved.
 *
 */
class pwfw
{

	/**
	 * Holds an insance of self
	 * @var $instance
	 */
	private static $instance = NULL;
	
	/**
	* Direcory to use for file caching
	*/
    private $cacheDir = 'cache/images';
	
	
	/**
	 * Holds website option config
	 */
	private static $option = array(
	
		/* commens properties */
		'debug' => false, // if you set debug = true if error on watermark echo them
		'cache' => false, // if you set debug = true if error on watermark echo them
		'curr_image' => '', // path tu current image. Auto load from $_SERVER["PATH_TRANSLATED"] superglobal
		'curr_image_extension' => '', // explode from source image
		'valid_image_extension' => array('jpeg', 'jpg', 'png', 'gif'), // available images extension
		'opacity' => 0, // watermark image opacity. Default value = 100. Available value between 0 - 100
		'min_size_for_wattermark' => 300, // if image is smaller then this value watermark not init

		/* logo watermark */
		'watermark_logo_path' => '', // path to watermark logo
		/* watermark position */
		'valid_position' => array('top_left', 'top_center', 'top_right', 'center_left', 'center_center', 'center_right', 'bottom_left', 'bottom_center', 'bottom_right', 'repeat'), 
		'position' => 'left_top', // watermark logo position.
		'margin' => 20
	);
	
	private static $dbOptions = array();
	
	// store hash
	private $hash;
	private $final_file_obj;
	
	/**
	 *
	 * Return pwfw instance or create intitial instance
	 *
	 * @access public
	 * @params $custom_option (optional)
	 *
	 * @return object
	 *
	 */
	public static function getInstance()
	{
 		if(is_null(self::$instance))
 		{
 			self::$instance = new pwfw();
 		}
		return self::$instance;
	}

	/**
	* the constructor - is set to public
	*/
	public function __construct(){}
	
	
	/**
	* Change the caching directory
	*/
    public function setCacheDir($directory='')
    {
		$directory = rtrim($directory, '/\\');
		
		// Check if directory exists.
		if (!is_dir($directory)) {
			if (@mkdir($directory)) {
				// The directory %directory has been created.
				@chmod($directory, 0775); // Necessary for non-webserver users.
			} else {
				return FALSE;
			}
		}

		// Check to see if the directory is writable.
		if (!is_writable($directory)) {
			if (@chmod($directory, 0775)) {
				// The permissions of directory have been changed to make it writable.
			} else {
				return FALSE;
			}
		}
		
        $this->cacheDir = $directory;
		
		return true;
    }
	
	private function tryFileFromCache()
	{
		$type = $this->getFileType(self::$option['curr_image'], true);
		// Computes the hash
        $this->hash = $this->getHash( $type );

        // Generates the cache file
        $file = $this->generateFileFromHash( $this->hash.'.'.$type );

		// if file is in cache try to show
		if (file_exists($file))
        {
			$create_time = @filemtime( $file );
			
			// the file it's too old, delete it
			if( ($create_time + self::$option['cacheLifeTime']) < time()){
				// delete file from cache
				unlink($file);
			}
			
			// print the file from cache
			else{ 
				// try to get the image 
				$theFile = $file;
				$fileInfo = pathinfo($theFile);
				// empty — Determine whether a variable is empty
				if (empty($outputType)) $outputType = $fileInfo['extension'];
				if ($outputType == "gif") $outputType = "png"; // Okay to remove after July 2004
				
				// header() is used to send a raw HTTP  header. See the » HTTP/1.1 specification  for more information on HTTP headers. 
				header("Content-type: image/$outputType");
				readfile($theFile);
			} 
			
		}
	}
	
	/**
	* the starter of class
	*/
	public function startImageWatermark($custom_option=array()) {
		self::$option['curr_image'] = $this->currImage();
		
		if(!self::$option['curr_image'] && self::$option['debug']){
			// stop script
			die('invalid image!');
		}
		 
		// overwrite default value with custom value
		if(count($custom_option) > 0){
			self::$option = array_merge(self::$option, $custom_option);
		}
		
		// check if image have minim size, if not disable cache
		$size = @getimagesize(self::$option['curr_image']); 
		
		if($size[0] < (int)self::$option['min_size_for_wattermark']){
			self::$option['cache'] = false;
			$this->printNotModifyImg();
		}
		
		if(isset($_REQUEST['demoImg']) && $_REQUEST['demoImg'] != 'yes'){
			// check if image is in excluded files list, and skip
			$tmp_string = explode("wp-content/uploads/", self::$option['curr_image']);
			if(in_array($tmp_string[1], $this->getExcludetImages(self::$option['exclude_files']))){
				$this->printNotModifyImg();
			}
		}
		
		// if cache it's enable, set the cache directory
		if(self::$option['cache']){
			if(!$this->setCacheDir( self::$option['cacheDir'] )){
				// if error on creating cache folder disable cache
				self::$option['cache'] = false;
			}else{
				// try to print image from cache
				$this->tryFileFromCache();
			}
		}
		
		if(self::$option['type'] == 'image'){
			// try to replace watermark url with the path of file
			$logo_path = self::$option['watermark_logo_path'];
			$logo_path = str_replace(home_url("/"), ABSPATH, $logo_path);
			if(!is_file($logo_path)){
				$this->printNotModifyImg();
			}else{
				self::$option['watermark_logo_path'] = $logo_path;
			}
			
			// update wattermark path
			// trim — Strip whitespace (or other characters) from the beginning and end of a string
			// realpath() expands all symbolic links and resolves references to '/./', '/../' and extra '/' characters in the input path and return the canonicalized absolute pathname. 
		
			self::$option['watermark_logo_path'] = trim(self::$option['watermark_logo_path']) != "" ?  realpath(trim(self::$option['watermark_logo_path'])): ''; 
		}
		
		$this->watermark_image();
	}
	
	private function getExcludetImages($dbExcludedFiles=array()) {
		$arr = array();
		$__arr = explode("\n", $dbExcludedFiles);
		if(count($__arr) > 0){
			foreach ($__arr  as $key => $value){
				$arr[] = trim($value);
			}
		}
		
		return $arr;
	}
	
	/**
	 *
	 * return current image throw without watermark 
	 *
	 * @access private
	 *
	 */
	public function printNotModifyImg($file_url='') {
		
		// try to get the image 
		$theFile = $this->currImage();
		die( var_dump( "<pre>", $theFile  , "</pre>" ) . PHP_EOL .  __FILE__ . ":" . __LINE__  ); 
		$fileInfo = pathinfo($theFile);
		// empty — Determine whether a variable is empty
		if (empty($outputType)) $outputType = $fileInfo['extension'];
		if ($outputType == "gif") $outputType = "png"; // Okay to remove after July 2004
		
		// header() is used to send a raw HTTP  header. See the » HTTP/1.1 specification  for more information on HTTP headers. 
		header("Content-type: image/$outputType");
		readfile($theFile);
	}
	
	function mb_basename($file)
	{
		return end(explode('/',$file));
	}

	/**
	 *
	 * return current image path or false
	 *
	 * @access private
	 *
	 */
	public function currImage() {
		
		// try to check if is image for livedemo
		if(isset($_REQUEST['demoImg']) && ( $_REQUEST['demoImg'] == 'yes' )){
			$__img = PWFW_DIR . 'lib/scripts/watermark/demo-img.jpg';
		}else{		
			$__img = isset($_SERVER["PATH_TRANSLATED"]) ? $_SERVER["PATH_TRANSLATED"] : '';
			// recheck try to get file
			if(!is_file($__img)){
				$__img = $_SERVER['DOCUMENT_ROOT'] . $_SERVER['REQUEST_URI'];
			}		
		}
		
		// is_file — Tells whether the filename is a regular file
		// realpath() expands all symbolic links and resolves references to '/./', '/../' and extra '/' characters in the input path and return the canonicalized absolute pathname.
		if(!is_file(realpath($__img))){
			if(self::$option['debug']){
				echo 'invalid $_SERVER["PATH_TRANSLATED"]: <b>'. $_SERVER["PATH_TRANSLATED"] . '</b><br />' . PHP_EOL; 
			}
			return false; // invalid path
		}
		
		
		// validate extension and set
		// in_array — Checks if a value exists in an array
		if(!in_array($this->getFileType($__img), self::$option['valid_image_extension'])){
			if(self::$option['debug']){
				echo 'invalid $this->getFileType("'.($__img).'"): <b>'. $this->getFileType($__img) . '</b><br />' . PHP_EOL; 
			}
			return false; // invalid path
		}
		self::$option['curr_image_extension'] = $this->getFileType($__img);
		
		return $__img;
	}
	
	
	/**
	 *
	 * return current image extension
	 *
	 * @access private
	 *
	 */
	private function getFileType($string, $exact_value=false) 
	{
       $type = strtolower(preg_replace("^(.*)\.^", "", $string)); 
       if ($type == "jpg" && $exact_value == false) $type = "jpeg"; 
       return $type;
    }
    
	function calculateTextBox($text,$fontFile,$fontSize,$fontAngle) {
		/************
		simple function that calculates the *exact* bounding box (single pixel precision).
		The function returns an associative array with these keys:
		left, top:  coordinates you will pass to imagettftext
		width, height: dimension of the image you have to create
		*************/
		$rect = imagettfbbox($fontSize,$fontAngle,$fontFile,$text);
		$minX = min(array($rect[0],$rect[2],$rect[4],$rect[6]));
		$maxX = max(array($rect[0],$rect[2],$rect[4],$rect[6]));
		$minY = min(array($rect[1],$rect[3],$rect[5],$rect[7]));
		$maxY = max(array($rect[1],$rect[3],$rect[5],$rect[7]));
	   
		return array(
		 "left"   => abs($minX) - 1,
		 "top"    => abs($minY) - 1,
		 "width"  => $maxX - $minX,
		 "height" => $maxY - $minY,
		 "box"    => $rect
		);
	} 
  
    /***
	 * return current image extension
	 *
	 * @access private
	 * @param $source the source image
     * @param self::$option['watermark_logo_path'] the watermark to apply
     * @param $outputType the type to output as (png, jpg, gif, etc.), defaults to the image type of $source if left blank
	 *
	 */
	private function watermark_image() {
		$sourceType = self::$option['curr_image_extension'];
		$watermarkType = $this->getFileType(self::$option['watermark_logo_path']);
		 
		// empty — Determine whether a variable is empty
		if (empty($outputType)) $outputType = $sourceType;
		if ($outputType == "gif") $outputType = "png"; // Okay to remove after July 2004
		 
		// Derive function names
		// strtoupper — Make a string uppercase
		$createSource = "ImageCreateFrom" . strtoupper($sourceType);
		$showImage = "Image" . strtoupper($outputType);

		if(self::$option['type'] == 'image'){
			$createWatermark = "ImageCreateFrom" . strtoupper($watermarkType);
			 
			// Load original and watermark to memory
			$output = $createSource(self::$option['curr_image']);
			$logo = $createWatermark(self::$option['watermark_logo_path']); 
		}else{
			// Load original and watermark to memory
			$output = $createSource(self::$option['curr_image']);
		
			/* Render text */
			$text_color = imagecolorallocate($output, 255, 255, 0);
			// Load original and watermark to memory
			$output = $createSource(self::$option['curr_image']);
			
			// Translate color to decimal
			$scolor = sscanf(self::$option['text_color'], '#%2x%2x%2x');
			$color_r = $scolor[0];
			$color_g = $scolor[1];
			$color_b = $scolor[2];
			
			// font face
			$font_face = PWFW_LIB_DIR . 'scripts/watermark/fonts/' . ( self::$option['text_face'] ) . '.ttf';

			/* Calculate TTF text size */
			$ttfboxAttrs = $this->calculateTextBox(self::$option['text_to_display'], $font_face, self::$option['text_size'], 0);
			$logo = imagecreatetruecolor($ttfboxAttrs['width'], $ttfboxAttrs['height'] + 3);
			$imageX = imagesx($logo);
			$imageY = imagesy($logo);

			imagealphablending($logo, false);
			imagesavealpha($logo, true);
			$transparent = imagecolorallocatealpha($logo, 255,255,255, 127);
			
			
			/* Render text */
			$text_color = imagecolorallocate($logo, $color_r, $color_g, $color_b);
			imagefilledrectangle($logo, 0, 0, $imageX, $imageY, $transparent);

			imagettftext($logo, 
				self::$option['text_size'], 
				0, // angle
				0,
				self::$option['text_size'],
				$text_color, 
				$font_face, 
				self::$option['text_to_display']);
		}
		
		// imagealphablending — Set the blending mode for an image
		// more: http://www.php.net/manual/en/function.imagealphablending.php
		imagealphablending($output, true);
		
		// getimagesize — Get the size of an image
		$size = @getimagesize(self::$option['curr_image']);    
		if($size[0] > self::$option['min_size_for_wattermark']){
			// Find proper coordinates so watermark will be in the lower right corner
			// imagesx — Get image width
			// imagesy — Get image height
			$widthWatermark = imagesx($logo);
			$heightWatermark = imagesy($logo); 
			$widthPhoto = imagesx($output);
			$heightPhoto = imagesy($output);
			  
			// swich watermark position
			// repeat
			if(self::$option['position'] == 'repeat'){
				$xLogoPosition = 0;
			    $yLogoPosition = 0;
			}
			
			// top line
			elseif(self::$option['position'] == 'top_left'){
			    $xLogoPosition = ceil(0 + (int)self::$option['margin']);
			    $yLogoPosition = ceil(0 + (int)self::$option['margin']);
			}else if(self::$option['position'] == 'top_center'){
			    $xLogoPosition = ceil(($widthPhoto - $widthWatermark) / 2);
			    $yLogoPosition = ceil(0 + (int)self::$option['margin']);
			}else if(self::$option['position'] == 'top_right'){
			    $xLogoPosition = ceil(($widthPhoto - $widthWatermark) - (int)self::$option['margin']);
			    $yLogoPosition = ceil(0 + (int)self::$option['margin']);
			}
			
			// center line
			else if(self::$option['position'] == 'center_left'){
			    $xLogoPosition = ceil(0 + (int)self::$option['margin']);
			    $yLogoPosition = ceil(($heightPhoto - $heightWatermark) / 2);
			}else if(self::$option['position'] == 'center_center'){
			    $xLogoPosition = ceil(($widthPhoto - $widthWatermark) / 2);
			    $yLogoPosition = ceil(($heightPhoto - $heightWatermark) / 2);
			}else if(self::$option['position'] == 'center_right'){
			    $xLogoPosition = ceil(($widthPhoto - $widthWatermark) - (int)self::$option['margin']);
			    $yLogoPosition = ceil(($heightPhoto - $heightWatermark) / 2);
			}
			
			// bottom line
			else if(self::$option['position'] == 'bottom_left'){
			    $xLogoPosition = ceil(0 + (int)self::$option['margin']);
			    $yLogoPosition = ceil(($heightPhoto - $heightWatermark) - (int)self::$option['margin']);
			}else if(self::$option['position'] == 'bottom_center'){
			    $xLogoPosition = ceil(($widthPhoto - $widthWatermark) / 2);
			    $yLogoPosition = ceil(($heightPhoto - $heightWatermark) - (int)self::$option['margin']);
			}else if(self::$option['position'] == 'bottom_right'){
			    $xLogoPosition = ceil(($widthPhoto - $widthWatermark) - (int)self::$option['margin']);
			    $yLogoPosition = ceil(($heightPhoto - $heightWatermark) - (int)self::$option['margin']);
			}
			
			// default
			else{
			    $xLogoPosition = $widthPhoto - $widthWatermark - 10;
			    $yLogoPosition = $heightPhoto - $heightWatermark - 10;
			}
		
			if(self::$option['position'] == 'repeat'){
				/*
				 * utils
					$widthWatermark = imagesx($logo);
					$heightWatermark = imagesy($logo);
					$widthPhoto = imagesx($output);
					$heightPhoto = imagesy($output);
				 */
				
				// x line
				$__xRepeat = ceil($widthPhoto / $widthWatermark);
				for ($i = 0; $i <= $__xRepeat; $i++) {
				    $this->imagecopymerge_alpha($output, $logo, ($xLogoPosition + $widthWatermark * $i), $yLogoPosition, 0, 0, ImageSX($logo), ImageSY($logo), self::$option['opacity']);
				
					// y line
					$__yRepeat = ceil($heightPhoto / $heightWatermark);
					for ($ii = 1; $ii <= $__yRepeat; $ii++) {
					    $this->imagecopymerge_alpha($output, $logo, ($xLogoPosition + $widthWatermark * $i), ($yLogoPosition + $widthWatermark * $ii), 0, 0, ImageSX($logo), ImageSY($logo), self::$option['opacity']);
					}
				}
			}else{
				// image copy merge with alpha
				$this->imagecopymerge_alpha($output, $logo, $xLogoPosition, $yLogoPosition, 0, 0, ImageSX($logo), ImageSY($logo), self::$option['opacity']);
			}
				
		}else{
			$this->printNotModifyImg();
		}
		
		ob_start();  
		
		// header() is used to send a raw HTTP  header. See the » HTTP/1.1 specification  for more information on HTTP headers. 
		header("Content-type: image/$outputType");
		
		// Display
		if($outputType == 'jpg' || $outputType == 'jpeg'){
			$showImage($output, NULL, self::$option['quality']);
		}else{
			$showImage($output);
		}
		
		// store and show
		$this->final_file_obj = ob_get_clean();
		echo $this->final_file_obj;
		
		
		// now let's cache the image with watermark
		if(self::$option['cache']){
			$this->cacheFile( $this->getFileType(self::$option['curr_image'], true));
		}

		// Purge
		// imagedestroy — Destroy an image
		ImageDestroy($output);
		ImageDestroy($logo);
		
		// clean memory on server, help "php garbage collector": http://php.net/manual/en/features.gc.php
		$logo = $output = $this->cacheFile = '';
	}
	
	/**
	*
	* PNG ALPHA CHANNEL SUPPORT for imagecopymerge();
	* This is a function like imagecopymerge but it handle alpha channel well!!!
	* 
	* use: imagecopymerge — Copy and merge part of an image
	* 	   more: http://usphp.com/manual/en/function.imagecopymerge.php
	*
	*/
	private function imagecopymerge_alpha($dst_im, $src_im, $dst_x, $dst_y, $src_x, $src_y, $src_w, $src_h, $pct)
	{
        $opacity = $pct;

        // getting the watermark width
        $w = imagesx($src_im);
        // getting the watermark height
        $h = imagesy($src_im);
          
        // creating a cut resource
        $cut = imagecreatetruecolor($src_w, $src_h);
		
        // copying that section of the background to the cut
        imagecopy($cut, $dst_im, 0, 0, $dst_x, $dst_y, $src_w, $src_h);
        
        // placing the watermark now
        imagecopy($cut, $src_im, 0, 0, $src_x, $src_y, $src_w, $src_h);
        imagecopymerge($dst_im, $cut, $dst_x, $dst_y, $src_x, $src_y, $src_w, $src_h, $opacity);
    }
	
	/**
	* Gets the cache file name and generate it if it does not exists.
	* Note that if it exists, all the image computation process will
	* not be done.
	*/
    public function cacheFile($type = 'jpg')
    {
        // Computes the hash
        $this->hash = $this->getHash($type, $quality);

        // Generates the cache file
        $file = $this->generateFileFromHash($this->hash.'.'.$type);

        // If the files does not exists, save it
        if (!file_exists($file))
        {
            $this->saveImage($file, $type);
        }

        return $this->getFilename($file);
    }
	
	/**
	* Gets the hash
	*/
    public function getHash($type = 'jpeg')
    {
        if (null === $this->hash)
        {
            $this->generateHash();
        }

        return $this->hash;
    }
	
	private function saveImage( $file, $type='jpg'){
		
		file_put_contents($file, $this->final_file_obj);
	}
	
	/**
	* Hook to helps to extends and enhance this class
	*/
    protected function getFilename($filename)
    {
        return $filename;
    }
	
	/**
	* Generates the hash
	*/
    public function generateHash($type = 'jpeg', $quality = 80)
    {
        $ctime = 0;
        
        try {
			$ctime = filectime( self::$option['curr_image'] );
        }
        catch (\Exception $e)
        {
        }

        $datas = array(
            self::$option['curr_image'],
            $ctime,
            $type,
            $quality
        );

        $this->hash = sha1(serialize($datas));
    }
	
	
	/**
	* Create and returns the absolute directory for a hash
	*
	* @param string $hash the hash
	*
	* @return string the full file name
	*/
    public function generateFileFromhash($hash) {
        $directory = $this->cacheDir;
		
        return $directory.'/'.substr($hash,5);
    }


	
	
	/**
	*
	* Like the constructor, we make __clone private
	* so nobody can clone the instance
	*
	*/
	private function __clone()
	{
	}
	
}