<?php 
$absolute_path = __FILE__;
$path_to_file = explode( 'wp-content', $absolute_path );
$path_to_wp = $path_to_file[0];

// Access WordPress
require_once( $path_to_wp . '/wp-load.php' );

// load pwfw class file
require_once("watermark.class.php");

// get the options from DB
$options = get_option( 'pwfw' );

// start instance of class 
$sm = pwfw::getInstance();

// brake point, invalid IP 
if(trim($options["developers"]) != ""){
	if(!in_array(pwfw_getRealIpAddr(), explode(",", $options["developers"]))) $sm->printNotModifyImg();
}

$wp_upload_dir = wp_upload_dir();

// get type of watermark and create array for config
if( $options['type'] == 'image' ){
	// 1. Image logo
	$setup_option = array(
		'type' => 'image',
		'cacheDir' => $wp_upload_dir['basedir'] . '/pwp_cache/',
		'useCache'	=> ($options['usecache'] == 'yes' ? true : true),
		'cacheLifeTime' => (isset($options['cachelifetime']) ? (int)$options['cachelifetime'] : 0),
		'quality' => $options['quality'],
		'debug' => isset($options['debug']) ? $options['debug'] : false,
		'exclude_files' => $options['exclude_files'],
		'opacity' => $options['image_opacity'], // watermark image opacity. Default value = 100. Available value between 0 - 100
		'min_size_for_wattermark' => $options['min_size'], // if image is smaller then this value watermark not init

		/* logo watermark */
		'watermark_logo_path' => $options['watermark_logo'], // path to watermark logo
		/* watermark position */ 
		'position' => $options['align'], // watermark logo position.
		'margin' => $options['image_margin']
	);
}

// get type of watermark and create array for config
if( $options['type'] == 'text' ){
	// 1. Image logo
	$setup_option = array(
		'type' => 'text',
		'useCache'	=> ($options['usecache'] == 'yes' ? true : false),
		'cacheDir' => $wp_upload_dir['basedir'] . '/pwp_cache/',
		'cacheLifeTime' => (isset($options['cachelifetime']) ? (int)$options['cachelifetime'] : 0),
		'quality' => $options['quality'],
		'exclude_files' => $options['exclude_files'],
		'text_to_display' => $options['text_to_display'],
		'text_size' => (int)str_replace("px", "", $options["text_typography"]['size']),
		'text_face' => $options["text_typography"]['face'],
		'text_color' => $options["text_typography"]['color'],
		'opacity' => $options['text_opacity'], // watermark image opacity. Default value = 100. Available value between 0 - 100
		'min_size_for_wattermark' => $options['min_size'], // if image is smaller then this value watermark not init

		/* logo watermark */
		'watermark_logo_path' => $options['watermark_logo'], // path to watermark logo
		/* watermark position */ 
		'position' => $options['align']
	);
}

// 2. Text

/* start image watermarking ... */
$sm->startImageWatermark($setup_option);