<?php 

// redirects - custom field allowing custom URL insertion
function pc_redirect_custom_field($field_id, $field, $value, $all_vals) {
	
	// WP pages list
	$pages = pc_get_pages(); 
	
	// label and note
	switch($field_id) {
		case 'pg_redirect_page' : 
			$label = __("Main redirect target for restricted pages", 'pc_ml'); 
			$note = __('Unlogged users trying to reach restricted page will be moved there', 'pc_ml'); 
			break;
			
		case 'pg_blocked_users_redirect' : 
			$label = __("Redirect target for blocked users", 'pc_ml'); 
			$note = __('Logged users not matching specific restrictions will be moved there (eg. page visible only by unlogged)', 'pc_ml'); 
			break;
		
		case 'pg_logged_user_redirect' : 
			$label = __("Redirect page after user's login", 'pc_ml'); 
			$note = __("This value can be overwritten in user categories or through shortcode", 'pc_ml'); 
			break;
			
		case 'pg_logout_user_redirect' : 
			$label = __("Redirect page after user's logout", 'pc_ml'); 
			$note = __("This value can be overwritten through shortcode or using any URL + <strong>?pc_logout</strong>", 'pc_ml'); 
			break;	
		
	}
	
	
	// main redirect - if no value - select first page
	if($field_id == 'pg_redirect_page' && !$value) {
		$value = key($pages);	
	}
	
	// options
	$opts = array(
		'' 			=> __('Do not redirect users', 'pc_ml'), 
		'use_main' 	=> __('Use main redirect target', 'pc_ml'),
		'custom' 	=> __('Custom redirect', 'pc_ml')
	) + $pages;
	
	// specific cases
	if($field_id == 'pg_redirect_page' || $field_id == 'pg_blocked_users_redirect') {unset($opts['']);}
	if($field_id != 'pg_blocked_users_redirect') {unset($opts['use_main']);}
	
	// custom text visibility
	$ct_vis = ($value == 'custom' || ($field_id == 'pg_redirect_page' && !$value)) ? '' : 'style="display: none;"';
	
	// custom text value
	$ct_val = isset($all_vals[$field_id .'_custom']) ? esc_attr($all_vals[$field_id .'_custom']) : '';
	
	
	// build code
	echo '
	<tr class="pc_'. $field_id .'">
		<td class="lcwp_sf_label" rowspan="2"><label>'. $label .'</label></td>
		<td class="lcwp_sf_field">
			<select name="'. $field_id .'" class="lcwp_sf_chosen pc_redirect_cf_select" autocomplete="off">';
			
				foreach($opts as $id => $name) {
					echo '<option value="'.$id.'" '.selected($value, $id).'>'.$name.'</option>';	
				}
	echo '
			</select>   
		</td>
		<td><p class="lcwp_sf_note">'. $note .'</p></td>
	</tr>
	<tr>
		<td colspan="2" class="'. $field_id .'_cfw" '.$ct_vis.'>
			<input type="text" name="'. $field_id .'_custom" value="'.$ct_val.'" style="width: 70%;" />
		</td>
	</tr>';
	
	?>
    <script type="text/javascript">
    jQuery(document).ready(function(e) {
        jQuery(document).delegate('.pc_redirect_cf_select', 'change', function(e) {
			var $subj = jQuery('.'+ jQuery(this).attr('name') +'_cfw');
			
			if(jQuery(this).val() == 'custom') {
				$subj.show();	
			} else {
				$subj.hide();
			}
		});
    });
    </script>
    <?php
}




// WP user sync - buttons
//// perform sync
function pc_do_wp_sync($field_id, $field, $value, $all_vals) {
	if($field['hide']) {return false;}
	?>
	<tr>
        <td colspan="2">
        	<input type="button" id="pc_do_wp_sync" class="button-secondary" value="<?php _e('Sync users', 'pc_ml') ?>" />
        	<span class="pc_gwps_result"></span>
        </td>
        <td><span class="lcwp_sf_note"><strong><?php _e('Only users with unique username and e-mail will be synced', 'pc_ml') ?></strong></span></td>
    </tr>
    <?php	
}

//// sync existing users - only if $_GET['wps_existing_sync'] isset
function pc_wps_matches_sync($field_id, $field, $value, $all_vals) {
	if($field['hide'] || !isset($_GET['wps_existing_sync'])) {return false;}
	?>
	<tr>
        <td colspan="2">
        	<input type="button" id="pc_wps_matches_sync" class="button-secondary" value="<?php _e('Search existing matches and sync', 'pc_ml') ?>" />
        	<span class="pc_gwps_result"></span>
        </td>
        <td><span class="lcwp_sf_note"><strong><?php _e('Search matches between existing PrivateContent and WP users, and sync them', 'pc_ml') ?></strong></span></td>
    </tr>
    <?php	
}

//// unsync
function pc_clean_wp_sync($field_id, $field, $value, $all_vals) {
	if($field['hide']) {return false;}
	?>
	<tr>
        <td colspan="2">
        	<input type="button" id="pc_clean_wp_sync" class="button-secondary" value="<?php _e('Clear sync', 'pc_ml') ?>" />
        	<span class="pc_gwps_result"></span>
        </td>
        <td><span class="lcwp_sf_note"><strong><?php _e('Detach previous sync and delete related WP users', 'pc_ml') ?></strong></span></td>
    </tr>
    <?php	
}




// registration form builder
function pc_sc_reg_form_builder($field_id, $field, $value, $all_vals) {
?>
	<table id="pc_reg_form_builder_cmd_wrap"class="widefat">
     <tr>
        <td style="padding-right: 0;">
            <input type="text" name="pg_new_reg_form_name" id="pc_new_reg_form_name" placeholder="<?php _e("New form's name", 'pc_ml') ?>" maxlength="150" autocomplete="off" />
        </td>
        <td style="width: 55px; text-align: center; padding-right: 25px; border-right: 1px solid #e1e1e1;">
            <input type="button" value="<?php _e('Add', 'pc_ml') ?>" id="pc_reg_form_add" class="button-secondary" />
        </td>
        <td style="padding-left: 25px; padding-right: 0;">
            <select name="pg_form_builder_dd" class="lcwp_sf_chosen pc_form_builder_dd" data-placeholder="<?php _e('Select a form to edit', 'pc_ml') ?> .." autocomplete="off">
                <?php 
                $a = 0;
                $reg_forms = get_terms('pc_reg_form', 'hide_empty=0&order=DESC');
                foreach($reg_forms as $rf) {
                    $sel = (!$a) ? 'selected="selected"' : '';
                    echo '<option value="'.$rf->term_id.'" '.$sel.'>'.$rf->term_id.' - '.$rf->name.'</option>';
                    $a++;
                }
                ?>
            </select>
        </td>
        <td id="pc_reg_form_cmd" style="width: 130px; text-align: center; visibility: hidden;">
            <input type="button" value="<?php _e('Save', 'pc_ml') ?>" class="pc_reg_form_save button-primary" />
            <input type="button" value="<?php _e('Delete', 'pc_ml') ?>" id="pc_reg_form_del" class="button-secondary" style="margin-left: 10px;" />
        </td>
     </tr> 	
    </table>
    <i id="pc_reg_form_loader"></i>
    <br style="clear: both;" /> 
    
    <div id="pc_reg_form_builder"></div>	
<?php	
}



// Fixed fields - placeholder and icons
function pc_fix_field_detail($field_id, $field, $value, $all_vals) {
	include_once(PC_DIR .'/classes/pc_form_framework.php');
	
	$f_fw = new pc_form;
	$fields = $f_fw->fields;
	$fname = $field['cb_subj'];
	
	switch($fname) {
		case 'name' 		: $label 	= __("Name's icon and placeholder text", 'pc_ml'); break;
		case 'surname' 		: $label 	= __("Surname's icon and placeholder text", 'pc_ml'); break;
		case 'username' 	: $label 	= __("Username's icon and placeholder text", 'pc_ml'); break;
		case 'psw' 			: $label 	= __("Password's icon and placeholder text", 'pc_ml'); break;
		case 'repeat_psw' 	: $label 	= __("Repeat password's icon and placeholder text", 'pc_ml'); break;
		case 'categories' 	: $label 	= __("Category's icon and placeholder text", 'pc_ml'); break;
		case 'email' 		: $label 	= __("E-mail's icon and placeholder text", 'pc_ml'); break;
		case 'tel' 			: $label 	= __("Telephone's icon and placeholder text", 'pc_ml'); break;	
	}
	
	
	$icon = get_option('pg_'. $fname .'_icon');
	$plac = get_option('pg_'. $fname .'_placeh', ($fname == 'repeat_psw') ? 'Repeat password' : $fields[$fname]['placeh']);
	?>
    <tr class="pc_<?php echo $field_id ?>">
		<td class="lcwp_sf_label">
        	<label><?php echo $label ?></label>
        </td>
		<td class="lcwp_sf_field">
			
            <div class="pc_field_icon_trigger">
            	<i class="fa <?php echo $icon ?>" title="set fiel's icon" style="display: inline-block;"></i>
                <input type="hidden" name="pg_<?php echo $fname ?>_icon" value="<?php echo $icon ?>" maxlength="40" /> 
            </div>
            
           <input type="text" name="pg_<?php echo $fname ?>_placeh" value="<?php echo $plac ?>" style="width: 80%; max-width: 400px;" />  
		</td>
	</tr>
    <?php
}



// Buttons icon
function pc_btns_icon($field_id, $field, $value, $all_vals) {
	$btn = $field['cb_subj'];
	$opt_name = 'pg_'. $btn .'_btn_icon';
	
	switch($btn) {
		case 'register' : $label 	= __("Registration form - button's icon", 'pc_ml'); break;
		case 'login' 	: $label 	= __("Login form - button's icon", 'pc_ml'); break;
		case 'logout' 	: $label 	= __("Logout button's icon", 'pc_ml'); break;	
		case 'user_del' : $label 	= __("User deletion's icon", 'pc_ml'); break;	
	}
	
	$icon = get_option($opt_name);
	?>
    <tr class="pc_<?php echo $field_id ?>">
		<td class="lcwp_sf_label">
        	<label><?php echo $label ?></label>
        </td>
		<td class="lcwp_sf_field">
			
            <div class="pc_field_icon_trigger">
            	<i class="fa <?php echo $icon ?>" title="set icon" style="display: inline-block;"></i>
                <input type="hidden" name="<?php echo $opt_name ?>" value="<?php echo $icon ?>" maxlength="40" /> 
            </div>
		</td>
	</tr>
    <?php
}



// Lightbox Instances
function pg_lightbox_instances($field_id, $field, $value, $all_vals) {
	include_once(PC_DIR . '/functions.php'); 
	?>
    <ul id="pc_lb_inst">
		<?php 
		$lb_instances = get_terms('pc_lightboxes', 'hide_empty=0&order=ASC');
		 
		if(empty($lb_instances)) : ?>
            <em style="font-size: 13px;"><?php _e('no existing instances', 'pc_ml') ?> ..</em>
			
        <?php else : 
            $a = 0;
            foreach($lb_instances as $inst) : 
			
				if(isset($GLOBALS['pc_lb_data']) && isset($GLOBALS['pc_lb_data'][$inst->term_id])) {
					$note 		= $GLOBALS['pc_lb_data'][$inst->term_id]['note'];	
					$contents 	= $GLOBALS['pc_lb_data'][$inst->term_id]['contents'];	
				}
				else {
					$note 		= ($inst->name == '|||pclbft|||') ? '' : $inst->name;	
					$contents 	= base64_decode($inst->description);	
				}
				?>	
                
                <li>
                    <aside>
                        <span class="pc_del_field" rel="<?php echo $inst->term_id ?>" title="<?php echo esc_attr( __('remove restriction', 'pc_ml')) ?>"></span>
                        <input type="hidden" name="pc_lb_id[]" value="<?php echo $inst->term_id ?>" />
                    </aside>    
                    <div style="padding-left: 50px; margin-bottom: 13px;">
                        <table><tr>
                            <td>
                                <input type="text" name="pc_lb_note[]" class="pc_lb_note" value="<?php echo $note ?>" placeholder="<?php echo esc_attr( __("Lightbox note (mandatory)", 'pc_ml')) ?>" maxlength="250" autocomplete="off" />
                            </td>
                            <td style="text-align: right;">
                                <span><strong><?php _e('Trigger class', 'pc_ml') ?>:</strong> <em>pc_lb_trig_<?php echo $inst->term_id ?></em></span><strong style="color: #bbb;">|</strong><span><strong><?php _e('Lightbox class', 'pc_ml') ?>:</strong> <em>pc_lb_<?php echo $inst->term_id ?></em></span>
                            </td>
                        </table></tr>
                    </div>                
                    <div class="pclb_editow_wrap" style="padding-left: 50px;">
                        <?php 
						$args = array('textarea_rows'=> 2);
						wp_editor($contents, 'pclb_'.$inst->term_id, $args); 
						?>
                        <script type="text/javascript">
                        jQuery(document).ready(function(e) {
                        });
                        </script>
                    </div>
                </li>
            <?php endforeach;
         endif; ?>
    </ul>
    
    <?php // force textarea name to be array ?>
    <script type="text/javascript">
    jQuery(document).ready(function(e) {
        setTimeout(function() {
			jQuery('.pclb_editow_wrap textarea.wp-editor-area').attr('name', 'pc_lb_contents[]');
		}, 500);
    });
    </script>
    <?php	
}



// URL-based restrictions
function pg_url_base_restr_field($field_id, $field, $value, $all_vals) {
	include_once(PC_DIR . '/functions.php'); 
	?>
    <ul id="pc_cr_list">
		<?php if(empty($all_vals['pg_cr_url'])) : ?>
            <em style="font-size: 13px;"><?php _e('no custom restrictions added', 'pc_ml') ?> ..</em>
        <?php else : 
            
            $a = 0;
            foreach($all_vals['pg_cr_url'] as $pg_cr_url) {
                echo pc_cr_template($pg_cr_url, $all_vals['pg_cr_allow'][$a], $all_vals['pg_cr_block'][$a]);
                $a++;	
            }
        
         endif; ?>
    </ul>
    <?php	
}



