<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if(!defined('ABSPATH')) exit;



class pc_pvt_content_on_elementor extends Widget_Base {
	
	 public function get_icon() {
      return 'emtr_lcweb_icon';
   }
	
	public function get_name() {
		return 'pc-pvt-content';
	}

	public function get_categories() {
		return array('privatecontent');
	}

   public function get_title() {
      return 'PC - '. __('Private Block', 'pc_ml');
   }



	// user categories array builder
	protected function pc_uc_array($bulk_opts = true, $apply_filter = true) {
		include_once(PC_DIR .'/functions.php');
		
		// fix for PCPP
		if(function_exists('pcpp_is_integrated_flag')) {
			pcpp_is_integrated_flag();	
		}
		
		
		$raw = pc_restr_opts_arr($bulk_opts, $apply_filter);
		
		$arr = array();
		foreach($raw as $block) {
			foreach($block['opts'] as $id => $name) {
				$arr[$id] = $name;	
			}
		}
		return $arr;
	}



	protected function _register_controls() {
		
		$lb_instances = array(
			'' => __('As default', 'pc_ml'), 
			'none' => __('No login button', 'pc_ml')
		) + pc_get_lb_instances();




		$this->start_controls_section(
			'main',
			array(
				'label' => 'PrivateContent - '. __('Private Block', 'gg_ml'),
			)
		);
  
  
		$this->add_control(
		   'allow',
		   array(
			  'label' 	=> __('Who can see contents?', 'gg_ml'),
			  'type' 	=> Controls_Manager::SELECT2,
			  'multiple'=> true,
			  'default' => current(array_keys( $this->pc_uc_array() )),
			  'options' => $this->pc_uc_array()
		   )
		);
		
		
		$this->add_control(
		   'block',
		   array(
			  'label' 	=> __('Who to block?', 'gg_ml'),
			  'type' 	=> Controls_Manager::SELECT2,
			  'multiple'=> true,
			  'default' => current(array_keys( $this->pc_uc_array(false) )),
			  'options' => $this->pc_uc_array(false)
		   )
		);
		
		
		$this->add_control(
		   'warning',
		   array(
			  'label' 		=> __('Show warning box?', 'gg_ml'),
			  'type' 		=> Controls_Manager::SWITCHER,
			  'default' 	=> '1',
			  'label_on' 	=> __('Yes'),
			  'label_off' 	=> __('No'),
			  'return_value' => '1',
		   )
		);
		
		
		$this->add_control(
		   'message',
		   array(
			  	'label' => __('Custom message for not allowed users', 'pc_ml'),
				'type' 	=> Controls_Manager::TEXT,
				
				'condition' => array(
					'warning' => '1',
				),
		   )
		);
		
		
		$this->add_control(
		   'login_lb',
		   array(
			  'label' 	=> __("Login button's lightbox", 'gg_ml'),
			  'type' 	=> Controls_Manager::SELECT,
			  'multiple'=> true,
			  'default' => current(array_keys( $lb_instances )),
			  'options' => $lb_instances,
			  
			  'condition' => array(
				  'warning' => '1',
			  ),
		   )
		);
		
		
		$this->add_control(
		   'registr_lb',
		   array(
			  'label' 	=> __("Registration button's lightbox", 'gg_ml'),
			  'type' 	=> Controls_Manager::SELECT,
			  'multiple'=> true,
			  'default' => current(array_keys( $lb_instances )),
			  'options' => $lb_instances,
			  
			  'condition' => array(
				  'warning' => '1',
			  ),
		   )
		);
		
		
		$this->add_control(
		   'contents',
		   array(
			  	'label' => __("Contents to hide", "pc_ml"),
				'type' => Controls_Manager::WYSIWYG,
		   )
		);
		
		
		$this->end_controls_section();
   }


	
	////////////////////////


	protected function render() {
     	$vals = $this->get_settings();
		//var_dump($vals);

		$allow = implode(',', (array)$vals['allow']);
		$block = implode(',', (array)$vals['block']);
		
		$parts = array('warning', 'message', 'login_lb', 'registr_lb');
		$params = '';
		
		foreach($parts as $part) {
			$params .= $part.'="';

			if(!isset($vals[$part])) {$vals[$part] = '';}
			$params .= $vals[$part].'" ';	
		}
		
		echo do_shortcode('[pc-pvt-content allow="'.$allow.'" block="'.$block.'" '. $params .']'. trim($vals['contents']) .'[/pc-pvt-content]');
	}


	protected function _content_template() {}
}
