<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if(!defined('ABSPATH')) exit;



class pc_logout_on_elementor extends Widget_Base {
	
	 public function get_icon() {
      return 'emtr_lcweb_icon';
   }
	
	public function get_name() {
		return 'pc-logout';
	}

	public function get_categories() {
		return array('privatecontent');
	}

   public function get_title() {
      return 'PC - '. __('Logout Form', 'pc_ml');
   }



   protected function _register_controls() {

		$this->start_controls_section(
			'main',
			array(
				'label' => 'PrivateContent - '. __('Logout', 'pc_ml'),
			)
		);
  
		$this->add_control(
		   'redirect',
		   array(
			  	'label' 		=> __('Custom Redirect', 'pc_ml'),
				'type' 			=> Controls_Manager::TEXT,
				'description'	=> __('Custom redirect (use a valid URL or "<em>refresh</em>" keyword)', 'pc_ml'),
		   )
		);
		
			
		$this->end_controls_section();
   }


	
	////////////////////////



	protected function render() {
     	$vals = $this->get_settings();
		//var_dump($vals);

		$parts = array('redirect');
		$params = '';
		
		foreach($parts as $part) {
			$params .= $part.'="';
			
			if(!isset($vals[$part])) {$vals[$part] = '';}
			$params .= $vals[$part].'" ';	
		}
		
		echo do_shortcode('[pc-logout-box '. $params .']');
	}


	protected function _content_template() {}
}
