<?php
// MANAGE USERS PRIVATE PAGE

// if isset a specific page as user global login manage the page to display a plugin page
function pc_pvt_page_management($content) {
	include_once(PC_DIR . '/functions.php');
	global $wpdb, $post, $pc_users;
	
	$orig_content = $content;
	$target_page = (int)get_option('pg_target_page');
	$curr_page_id = (int)get_the_ID();
	
	
	// must be the chosen container page
	if(pc_wpml_translated_pag_id($target_page) != pc_wpml_translated_pag_id(get_the_ID())) {
		return $content;
	}
		
		
	// preview check
	if(is_user_logged_in() && isset($_REQUEST['pc_pvtpag']) && isset($_REQUEST['pc_utok'])) {
		if(!wp_verify_nonce($_REQUEST['pc_utok'], 'lcwp_nonce')) {return 'Cheating?';}
		$_SESSION['pc_user_id'] = (int)$_REQUEST['pc_pvtpag'];
		$GLOBALS['pc_user_id'] = (int)$_REQUEST['pc_pvtpag'];
		$admin_is_previewing = true;
	}

	// check logged user
	$user_data = pc_user_logged(array('page_id', 'disable_pvt_page', 'wp_user_id'));
	if(!$user_data) {
		
		// return page content and eventually attach form
		$login_form = pc_login_form();
		$pvt_nl_content = get_option('pg_target_page_content');
		
		//only original contents
		if($pvt_nl_content == 'original_content') {
			$content = $content;   
		}	
		// contents + form
		elseif($pvt_nl_content == 'original_plus_form') {
			$content = $content . $login_form;   
		}
		// form + contents
		elseif($pvt_nl_content == 'form_plus_original') {
			$content = $login_form . $content;   
		}
		// only form
		else {$content = $login_form;}
		
		return $content;
	}	
		
	// if not have a reserved area
	if(!empty($user_data['disable_pvt_page'])) {
		return '<p>'. pc_get_message('pc_default_nhpa_mex') .'</p>';	
	}	
	
	// flag for pvt page usage
	//if(isset($GLOBALS['pc_pvt_page_is_displaying'])) {return $content;} // be sure contents are affected only once
	//$GLOBALS['pc_pvt_page_is_displaying'] = true;
	
	// private page contents
	$page_data = get_post( $user_data['page_id']);
	$content = $page_data->post_content;

	
	//////	
						
	// is managed through Elementor?
	if(defined('ELEMENTOR_URL') && get_post_meta($user_data['page_id'], '_elementor_edit_mode', true) == 'builder') {
		$elem_front = new Elementor\Frontend();
		$content = $elem_front->get_builder_content($user_data['page_id'], true); 
		
		// JS to add class to body
		$content .= '<script type="text/javascript">document.body.className += " elementor-page-'. $user_data['page_id'] .'";</script>';
		
		// be sure JS is added
		$elem_front->enqueue_scripts();
	}
	
	
	// if there's WP [embed] shortcode, execute it
	if(strpos($content, '[/embed]') !== -1) {
		global $wp_embed;
		$content = $wp_embed->run_shortcode($content);
	}
	
	//////
		
		
	// PC-FILTER - private page contents - useful to customize what is returned
	$content = apply_filters('pc_pvt_page_contents', $content);
	$content = do_shortcode(wpautop($content));
		
	// PC-ACTION - private page is being displayed - triggered in the_content hook
	do_action('pc_pvt_page_display');
	
	
	//// COMMENTS
	// disable comments if not synced
	if(!$pc_users->wp_user_sync || !get_option('pg_pvtpage_wps_comments') || !$user_data['wp_user_id'] || $page_data->comment_status != 'open') {
		add_filter('comments_template', 'pc_comments_template', 500);
	}
	else {
		// override query
		$GLOBALS['pc_custom_comments_template'] = 'original';
		$GLOBALS['pc_pvt_page_id'] = $user_data['page_id'];
		$GLOBALS['pc_pvt_page_obj'] = $page_data;
		$GLOBALS['pc_pvt_page_container_id'] = $curr_page_id;
		
		// override $post
		global $post;
		$post = get_post($user_data['page_id']);
		
		// PC-ACTION - give the opportunity to override comments template	
		$custom_template = do_action('pc_pvt_page_comments_template');  
		if(!empty($custom_template)) {
			$GLOBALS['pc_custom_comments_template'] = $custom_template;	
		}
		
		add_filter('comments_template', 'pc_comments_template',500);
	}
	
	// remove session for admin preview
	if(isset($admin_is_previewing)) {
		unset($_SESSION['pc_user_id']);
		unset($GLOBALS['pc_user_id']);	
	}
			
	return $content;
}
add_filter('the_content', 'pc_pvt_page_management', 500); // use 500 - before comments restriction and PC hide



// preset contents - used through hooks
function pc_pvt_page_preset_texts($content) {
	if(get_option('pg_pvtpage_enable_preset')) {$preset = do_shortcode( wpautop(get_option('pg_pvtpage_preset_txt')));}
	else {return $content;}
	
	if(get_option('pg_pvtpage_preset_pos') == 'before') {$content = $preset . $content;}
	else {$content = $content . $preset;}	
	
	return $content;
}
add_filter('pc_pvt_page_contents', 'pc_pvt_page_preset_texts', 50);



// override default comment template - by default returns an empty template
function pc_comments_template($template){
	if (!isset($GLOBALS['pc_custom_comments_template']) || empty($GLOBALS['pc_custom_comments_template'])) {
		$url = PC_DIR . "/restrictions/comment_hack.php";	
	} 
	else {		
		// override current WP_query parameters to show pvt page contents
		global $post;
		$post = get_post($GLOBALS['pc_pvt_page_id']);
		
		global $wp_query;
		
		$wp_query->queried_object->ID	= $GLOBALS['pc_pvt_page_id'];
		$wp_query->posts[0]->ID 		= $GLOBALS['pc_pvt_page_id'];
		$wp_query->post->ID				= $GLOBALS['pc_pvt_page_id'];
		
		$wp_query->queried_object->comment_status 	= 'open';
		$wp_query->posts[0]->comment_status 		= 'open';
		$wp_query->post->comment_status 			= 'open';
		
		$wp_query->queried_object->comment_count	= $GLOBALS['pc_pvt_page_obj']->comment_count;
		$wp_query->posts[0]->comment_count 			= $GLOBALS['pc_pvt_page_obj']->comment_count;
		$wp_query->post->comment_count 				= $GLOBALS['pc_pvt_page_obj']->comment_count;
		$wp_query->comment_count 					= $GLOBALS['pc_pvt_page_obj']->comment_count;
		
		$wp_query->comments = get_comments( array('post_id' => $GLOBALS['pc_pvt_page_id']) );

		$url = ($GLOBALS['pc_custom_comments_template'] == 'original') ? $template : $GLOBALS['pc_custom_comments_template'];
	}

	return $url;
}



//if private page and override comments - reset post
function pc_restore_after_comments_override() {
	if(isset($GLOBALS['pc_pvt_page_container_id'])) {
		global $post;
		$post = get_post($GLOBALS['pc_pvt_page_container_id']);
	}
}
do_action('comment_form_after', 'pc_restore_after_comments_override', 1);




// remove user pages from WP link suggestions
function pc_upp_remove_in_links_suggest($query) {

	if(isset($_POST['action']) && $_POST['action'] == 'wp-link-ajax'){
			
		if(isset($query->query['post_type']) && is_array($query->query['post_type']) && in_array('pg_user_page', $query->query['post_type'])) {
			
			if (($key = array_search('pg_user_page', $query->query['post_type'])) !== false) {
				unset($query->query['post_type'][$key]);
			}
			
			$query->set('post_type', $query->query['post_type']);
		}
	}
	return $query;
}
add_filter('pre_get_posts', 'pc_upp_remove_in_links_suggest', 9999);


