<?php
////////// LIST OF SHORCODES

// [pc-login-form] 
// get the login form
function pc_login_form_shortcode( $atts, $content = null ) {
	extract( shortcode_atts( array(
		'redirect' 	=> '',
		'align'		=> 'center'
	), $atts ));
	
	return str_replace(array("\r", "\n", "\t", "\v"), '', pc_login_form($redirect, $align));
}
add_shortcode('pc-login-form', 'pc_login_form_shortcode');
add_shortcode('pg-login-form', 'pc_login_form_shortcode');




// [pc-logout-box] 
// get the logout box
function pc_logout_box_shortcode( $atts, $content = null ) {	
	extract( shortcode_atts( array(
		'redirect' 	=> ''
	), $atts ));
	
	return str_replace(array("\r", "\n", "\t", "\v"), '', pc_logout_btn($redirect));
}
add_shortcode('pc-logout-box', 'pc_logout_box_shortcode');
add_shortcode('pg-logout-box', 'pc_logout_box_shortcode');




// [pc-registration-form] 
// get the registration form
function pc_registration_form_shortcode( $atts, $content = null ) {
	extract( shortcode_atts( array(
		'id'				=> '',
		'layout' 			=> '',
		'custom_categories' => '',
		'redirect' 			=> '',
		'align'				=> 'center'
	), $atts ));

	return str_replace(array("\r", "\n", "\t", "\v"), '', pc_registration_form($id, $layout, $custom_categories, $redirect, $align));	
}
add_shortcode('pc-registration-form', 'pc_registration_form_shortcode');
add_shortcode('pg-registration-form', 'pc_registration_form_shortcode');




// [pc-pvt-content] 
// hide shortcode content if user is not logged and is not of the specified category or also if is logged
function pc_pvt_content_shortcode( $atts, $content = null ) {
	extract( shortcode_atts( array(
		'allow' 	=> 'all',
		'block'		=> '',
		'warning'	=> '1',
		'message'	=> '',
		'login_lb'	=> '',
		'registr_lb'=> ''
	), $atts ) );
	
	$custom_message = $message;
	
	// if nothing is specified, return the content
	if(trim($allow) == '') {return do_shortcode($content);}
	include_once(PC_DIR.'/functions.php');	
	
	// MESSAGES
	// print something only if warning is active
	if($warning == '1') {
		
		// check login lightbox association
		$final_login_lb = get_option('pg_warn_box_login');
		if($login_lb) {$final_login_lb = ($login_lb == 'none') ? '' : $login_lb;}
		if($final_login_lb && !get_term_by('id', $final_login_lb, 'pc_lightboxes')) {$final_login_lb = '';}
		$login_icon = ($final_login_lb && get_option('pg_login_btn_icon')) ? '<i class="fa '. get_option('pg_login_btn_icon') .'"></i>' : '';
		
		// check login lightbox association
		$final_registr_lb = get_option('pg_warn_box_registr');
		if($registr_lb) {$final_registr_lb = ($registr_lb == 'none') ? '' : $registr_lb;}
		if($final_registr_lb && !get_term_by('id', $final_registr_lb, 'pc_lightboxes')) {$final_registr_lb = '';}
		$registr_icon = ($final_registr_lb && get_option('pg_register_btn_icon')) ? '<i class="fa '. get_option('pg_register_btn_icon') .'"></i>' : '';
		
		// buttons code
		if($final_login_lb && pc_user_logged(false) === false) {
			$login = '<span class="pc_warn_box_btn pc_login_trig pc_lb_trig_'. $final_login_lb .'">'. $login_icon . __('Login', 'pc_ml') .'</span>';
			pc_enqueue_lb($final_login_lb);
		} else {
			$login = '';
		}
		
		if($final_registr_lb && pc_user_logged(false) === false) {
			$registration = '<span class="pc_warn_box_btn pc_registr_trig pc_lb_trig_'. $final_registr_lb .'">'. $registr_icon . __('Register', 'pc_ml') .'</span>';
			pc_enqueue_lb($final_registr_lb);
		} else {
			$registration = '';
		}
		$buttons = ($login || $registration) ? '<div class="pc_warn_box_btn_wrap">'. $login . $registration .'</div>' : '';
		
		
		// prepare the message if user is not logged
		$message = '<div class="pc_warn_box">'. pc_get_message('pc_default_nl_mex', $custom_message) . $buttons .'</div>';
		
		// prepare message if user has not the right category
		$not_has_level_err = '<div class="pc_warn_box">'. pc_get_message('pc_default_uca_mex', $custom_message)  .'</div>';
	} 
	else {
		$message = '';	
		$not_has_level_err = '';
	}
	
	
	// check user allowance
	$response = pc_user_check($allow, $block, $wp_user_pass = true); 	
					  
	if($response === 1) {
		return do_shortcode($content);
	}
	elseif($response === 2) {
		return $not_has_level_err;
	}
	else {
		// if contents have to be shown to unlogged users -> returns text only if custom message exists
		if($allow == 'unlogged') {
			return (!empty($custom_message)) ? '<div class="pc_login_block"><p>'. $custom_message .'</p></div>' : '';
		}

		return $message;
	}
}
add_shortcode('pc-pvt-content', 'pc_pvt_content_shortcode');
add_shortcode('pg-pvt-content', 'pc_pvt_content_shortcode');