<?php
// Elementor integration
include_once( ABSPATH . 'wp-admin/includes/plugin.php');
if(is_plugin_active('elementor/elementor.php') ) {
if(!defined('ABSPATH')) exit;



class pc_on_elementor {
	private $widgets_basepath = '';

	
	public function __construct() {
		
		/*** enqueue ***/
		$this->widgets_basepath = PC_DIR .'/builders_integration/elementor_elements';
		
		add_action('elementor/widgets/widgets_registered', array( $this, 'register_pc_login'));
		add_action('elementor/widgets/widgets_registered', array( $this, 'register_pc_logout'));
		add_action('elementor/widgets/widgets_registered', array( $this, 'register_pc_pvt_content'));
		add_action('elementor/widgets/widgets_registered', array( $this, 'register_pc_reg_form'));
	}
		 
		 
	
	// login
	public function register_pc_login() {
		include_once($this->widgets_basepath .'/login.php');
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new pc_login_on_elementor() );
	}
	
	// logout
	public function register_pc_logout() {
		include_once($this->widgets_basepath .'/logout.php');
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new pc_logout_on_elementor() );
	}
	
	// pvt content
	public function register_pc_pvt_content() {
		include_once($this->widgets_basepath .'/pvt_content.php');
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new pc_pvt_content_on_elementor() );
	}
	
	// reg form
	public function register_pc_reg_form() {
		include_once($this->widgets_basepath .'/reg_form.php');
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new pc_reg_form_on_elementor() );
	}

}
add_action('wp_loaded', function() {
	new pc_on_elementor();
}, 1);




// add Global Gallery section
add_action('elementor/init', function() {
   \Elementor\Plugin::$instance->elements_manager->add_category( 
   	'privatecontent',
   	array(
   		'title' => 'PrivateContent',
   		'icon' => 'fa fa-plug',
   	),
	3
   );
});



// style needed for LCweb icons
add_action('elementor/editor/after_enqueue_styles', function() {
	wp_enqueue_style('lcweb-elementor-icon', PC_URL .'/builders_integration/elementor_elements/lcweb_icon.css');	
});




////
} // end elementor's existence check